# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SimulationArgs', 'Simulation']

@pulumi.input_type
class SimulationArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 schema_s3_location: Optional[pulumi.Input['SimulationS3LocationArgs']] = None):
        """
        The set of arguments for constructing a Simulation resource.
        :param pulumi.Input[str] name: The name of the simulation.
        :param pulumi.Input[str] role_arn: Role ARN.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)
        if schema_s3_location is not None:
            pulumi.set(__self__, "schema_s3_location", schema_s3_location)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the simulation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Role ARN.
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_arn", value)

    @property
    @pulumi.getter(name="schemaS3Location")
    def schema_s3_location(self) -> Optional[pulumi.Input['SimulationS3LocationArgs']]:
        return pulumi.get(self, "schema_s3_location")

    @schema_s3_location.setter
    def schema_s3_location(self, value: Optional[pulumi.Input['SimulationS3LocationArgs']]):
        pulumi.set(self, "schema_s3_location", value)


class Simulation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 schema_s3_location: Optional[pulumi.Input[pulumi.InputType['SimulationS3LocationArgs']]] = None,
                 __props__=None):
        """
        AWS::SimSpaceWeaver::Simulation resource creates an AWS Simulation.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the simulation.
        :param pulumi.Input[str] role_arn: Role ARN.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SimulationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        AWS::SimSpaceWeaver::Simulation resource creates an AWS Simulation.

        :param str resource_name: The name of the resource.
        :param SimulationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SimulationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role_arn: Optional[pulumi.Input[str]] = None,
                 schema_s3_location: Optional[pulumi.Input[pulumi.InputType['SimulationS3LocationArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SimulationArgs.__new__(SimulationArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["schema_s3_location"] = schema_s3_location
            __props__.__dict__["describe_payload"] = None
        super(Simulation, __self__).__init__(
            'aws-native:simspaceweaver:Simulation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Simulation':
        """
        Get an existing Simulation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SimulationArgs.__new__(SimulationArgs)

        __props__.__dict__["describe_payload"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["role_arn"] = None
        __props__.__dict__["schema_s3_location"] = None
        return Simulation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="describePayload")
    def describe_payload(self) -> pulumi.Output[str]:
        """
        Json object with all simulation details
        """
        return pulumi.get(self, "describe_payload")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the simulation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Role ARN.
        """
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="schemaS3Location")
    def schema_s3_location(self) -> pulumi.Output[Optional['outputs.SimulationS3Location']]:
        return pulumi.get(self, "schema_s3_location")

