# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetApplicationResult',
    'AwaitableGetApplicationResult',
    'get_application',
    'get_application_output',
]

@pulumi.output_type
class GetApplicationResult:
    def __init__(__self__, arn=None, description=None, executable_path=None, id=None, log_locations=None, save_configuration=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if executable_path and not isinstance(executable_path, str):
            raise TypeError("Expected argument 'executable_path' to be a str")
        pulumi.set(__self__, "executable_path", executable_path)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if log_locations and not isinstance(log_locations, list):
            raise TypeError("Expected argument 'log_locations' to be a list")
        pulumi.set(__self__, "log_locations", log_locations)
        if save_configuration and not isinstance(save_configuration, dict):
            raise TypeError("Expected argument 'save_configuration' to be a dict")
        pulumi.set(__self__, "save_configuration", save_configuration)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        ARN of the resource.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Descriptive label for the resource, not a unique ID.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executablePath")
    def executable_path(self) -> Optional[str]:
        """
        Executable path is a relative path to the game launcher executable.
        """
        return pulumi.get(self, "executable_path")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        GameCast resource ID, base62 encoded.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Optional[Sequence[str]]:
        """
        A list of save file, registry key or log paths that are absolute paths that store game save files when the games
        are running on a Windows environment.
        """
        return pulumi.get(self, "log_locations")

    @property
    @pulumi.getter(name="saveConfiguration")
    def save_configuration(self) -> Optional['outputs.ApplicationSaveConfiguration']:
        return pulumi.get(self, "save_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional['outputs.ApplicationTags']:
        return pulumi.get(self, "tags")


class AwaitableGetApplicationResult(GetApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetApplicationResult(
            arn=self.arn,
            description=self.description,
            executable_path=self.executable_path,
            id=self.id,
            log_locations=self.log_locations,
            save_configuration=self.save_configuration,
            tags=self.tags)


def get_application(arn: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetApplicationResult:
    """
    Definition of AWS::GameCast::Application Resource Type


    :param str arn: ARN of the resource.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:gamecast:getApplication', __args__, opts=opts, typ=GetApplicationResult).value

    return AwaitableGetApplicationResult(
        arn=__ret__.arn,
        description=__ret__.description,
        executable_path=__ret__.executable_path,
        id=__ret__.id,
        log_locations=__ret__.log_locations,
        save_configuration=__ret__.save_configuration,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_application)
def get_application_output(arn: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetApplicationResult]:
    """
    Definition of AWS::GameCast::Application Resource Type


    :param str arn: ARN of the resource.
    """
    ...
