from kiss_ai_stack_server.models import Session
from kiss_ai_stack_server.services.kiss_ai_agent_service import KissAIAgentService
from kiss_ai_stack_types.enums import SessionScope
from kiss_ai_stack_types.models import QueryRequestBody, GenericResponseBody

from kiss_ai_stack_server.events.event_handlers import on_init


@on_init
async def handle_init(data: QueryRequestBody, session: Session) -> GenericResponseBody:
    stack = KissAIAgentService()
    temporary = session.scope == SessionScope.TEMPORARY
    await stack.bootstrap_agent(agent_id=session.client_id, temporary=temporary)

    return GenericResponseBody(
        agent_id=session.client_id,
        result='Greetings!'
    )
