# -*- coding: utf-8 -*-
# Copyright 2021 Cohesity Inc.


class DeleteProtectionJobParam(object):

    """Implementation of the 'DeleteProtectionJobParam' model.

    DeleteProtectionJobParam is the struct for deleting a protection job.

    Attributes:
        delete_snapshots (bool): Specifies if Snapshots generated by the
            Protection Job should also be deleted when the Job is deleted.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "delete_snapshots":'deleteSnapshots'
    }

    def __init__(self,
                 delete_snapshots=None):
        """Constructor for the DeleteProtectionJobParam class"""

        # Initialize members of the class
        self.delete_snapshots = delete_snapshots


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        delete_snapshots = dictionary.get('deleteSnapshots')

        # Return an object of this model
        return cls(delete_snapshots)


