"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceDiscovery = exports.DnsResponseType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Enum of DNS service discovery response type.
 *
 * @stability stable
 */
var DnsResponseType;
(function (DnsResponseType) {
    DnsResponseType["LOAD_BALANCER"] = "LOADBALANCER";
    DnsResponseType["ENDPOINTS"] = "ENDPOINTS";
})(DnsResponseType = exports.DnsResponseType || (exports.DnsResponseType = {}));
/**
 * Provides the Service Discovery method a VirtualNode uses.
 *
 * @stability stable
 */
class ServiceDiscovery {
    /**
     * Returns DNS based service discovery.
     *
     * @param responseType Specifies the DNS response type for the virtual node.
     * @stability stable
     */
    static dns(hostname, responseType) {
        return new DnsServiceDiscovery(hostname, responseType);
    }
    /**
     * Returns Cloud Map based service discovery.
     *
     * @param service The AWS Cloud Map Service to use for service discovery.
     * @param instanceAttributes A string map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance.
     * @stability stable
     */
    static cloudMap(service, instanceAttributes) {
        return new CloudMapServiceDiscovery(service, instanceAttributes);
    }
}
exports.ServiceDiscovery = ServiceDiscovery;
_a = JSII_RTTI_SYMBOL_1;
ServiceDiscovery[_a] = { fqn: "@aws-cdk/aws-appmesh.ServiceDiscovery", version: "1.119.0" };
class DnsServiceDiscovery extends ServiceDiscovery {
    constructor(hostname, responseType) {
        super();
        this.hostname = hostname;
        this.responseType = responseType;
    }
    bind(_scope) {
        return {
            dns: {
                hostname: this.hostname,
                responseType: this.responseType,
            },
        };
    }
}
class CloudMapServiceDiscovery extends ServiceDiscovery {
    constructor(service, instanceAttributes) {
        super();
        this.service = service;
        this.instanceAttributes = instanceAttributes;
    }
    bind(_scope) {
        return {
            cloudmap: {
                namespaceName: this.service.namespace.namespaceName,
                serviceName: this.service.serviceName,
                attributes: renderAttributes(this.instanceAttributes),
            },
        };
    }
}
function renderAttributes(attrs) {
    if (attrs === undefined) {
        return undefined;
    }
    return Object.entries(attrs).map(([key, value]) => ({ key, value }));
}
//# sourceMappingURL=data:application/json;base64,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