      SUBROUTINE UNPKPO(KFILDO,IPACK,ND5,LOC,IPOS,MISSP,
     1                  MINA,JMIN,LBIT,NOV,LX,IWORK,L3264B,IER)
C
C        JUNE 1997   GLAHN   TDL   MOS-2000
C        APRIL 2000   DALLAVALLE   MODIFIED FORMAT STATEMENTS TO
C                                  CONFORM TO FORTRAN 90 STANDARDS
C                                  ON THE IBM SP
C        NOVEMBER 2002        SU   REMOVED ONE REDUNDANT PORTION IN 
C                                  FORMAT NO. 104.
C
C        PURPOSE 
C            UNPACKS DATA IN TDLPACK FORMAT WHEN THERE CAN BE PRIMARY
C            MISSING VALUES.  SCALING IS NOT DONE IN THIS ROUTINE,
C            BUT THE REFERENCE VALUE IS USED.  CALLED FROM UNPACK
C            TO ELIMINATE MULTIPLE CALLS TO UNPKBG.  THE WORD
C            POINTER LOC AND BIT POSITION POINTER IPOS ARE UPDATED
C            AS NECESSARY.
C
C        DATA SET USE 
C           KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE. (OUTPUT) 
C
C        VARIABLES 
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT)
C            IPACK(J) = ARRAY TO UNPACK FROM (J=1,ND5).  (INPUT)
C                 ND5 = DIMENSION OF IPACK( ).  (INPUT)
C                 LOC = WORD IN IPACK( ) TO START UNPACKING.  UPDATED
C                       AS NECESSARY AFTER UNPACKING IS COMPLETED.
C                       (INPUT-OUTPUT)
C                IPOS = BIT POSITION (COUNTING LEFTMOST BIT IN WORD
C                       AS 1) TO START UNPACKING.  MUST BE GE 1 AND
C                       LE L3264B.  UPDATED AS NECESSARY
C                       AFTER PACKING IS COMPLETED.  (INPUT-OUTPUT)
C               MISSP = THE PRIMARY MISSING VALUE TO RETURN IN IWORK( )
C                       WHEN THE PACKED DATA INDICATE A MISSING VALUE.
C                       (INPUT)
C                MINA = THE REFERENCE VALUE.  (INPUT)
C             JMIN(L) = THE MINIMUM VALUE SUBTRACTED FROM EACH GROUP
C                       L BEFORE PACKING (L=1,LX).  (INPUT)
C             LBIT(L) = THE NUMBER OF BITS NECESSARY TO HOLD THE
C                       PACKED VALUES FOR EACH GROUP L (L=1,LX). 
C                       (INPUT)
C              NOV(L) = THE NUMBER OF VALUES IN GROUP L (L=1,LX).
C                       (INPUT)
C                  LX = THE NUMBER OF VALUES IN LBIT( ), JMIN( ), AND
C                       NOV( ).  ALSO USED AS THEIR DIMENSIONS.  (INPUT)
C            IWORK(J) = THE UNPACKED DATA ARE RETURNED (J=1,MAX OF ND5).
C                       THE NUMBER OF VALUES IS NXY IN SOME ROUTINES
C                       BUT IS DETERMINED HERE BY THE LX VALUES IN
C                       NOV( ).  (OUTPUT)
C              L3264B = INTEGER WORD LENGTH OF MACHINE BEING USED.
C                       (INPUT)
C                 IER = STATUS RETURN:
C                       0 = GOOD RETURN.
C                       6 = NOT ENOUGH ROOM IN IPACK( ) OR IWORK( ) TO
C                           ACCOMMODATE THE DATA INDICATED BY LBIT( )
C                           AND NOV( ).
C                       7 = IPOS NOT IN RANGE 1 TO L3264B.
C                       8 = LBIT(L) NOT IN RANGE 0 TO 30.
C        NON SYSTEM SUBROUTINES CALLED
C            NONE
C
      DIMENSION IPACK(ND5),IWORK(ND5)
      DIMENSION JMIN(LX),LBIT(LX),NOV(LX)
C
      DIMENSION LB2M1(0:30)
C
      SAVE LB2M1
C
      DATA IFIRST/0/
C
C         CALCULATE THE POWERS OF 2 THE FIRST TIME ENTERED.
C
      IF(IFIRST.EQ.0)THEN
         IFIRST=1
         LB2M1(0)=0
C
         DO 100 J=1,30
         LB2M1(J)=(LB2M1(J-1)+1)*2-1
 100     CONTINUE
C
      ENDIF
C
C        CHECK CORRECTNESS OF INPUT AND SET STATUS RETURN.
C
      IER=0
C
      IF(IPOS.LE.0.OR.IPOS.GT.L3264B)THEN
         IER=7
         WRITE(KFILDO,101)IPOS,IER
 101     FORMAT(/,' IPOS = ',I6,' NOT IN THE RANGE 1 TO L3264B.',
     1            '  RETURN FROM UNPKPO WITH IER = ',I4)
         GO TO 900 
      ENDIF
C
      K=0
C
      DO 350 L=1,LX
      IF(LBIT(L).LT.0.OR.LBIT(L).GT.30)THEN
         IER=8
         WRITE(KFILDO,102)LBIT(L),L,IER
 102     FORMAT(/,' ****LBIT(L) = ',I6,' FOR L =',I6,
     1          ' NOT IN THE RANGE',
     2          ' 0 TO 30.  RETURN FROM UNPKPO WITH IER = ',I4)
         GO TO 900
      ENDIF
C
      IF(LBIT(L)*NOV(L).GT.(L3264B+1-IPOS)+(ND5-LOC)*L3264B)THEN
         IER=6
         WRITE(KFILDO,103)NOV(L),LBIT(L),L,LOC,IPOS,ND5,IER
 103     FORMAT(/,' ****NOV(L) = ',I9,' AND LBIT(L) = ',I6,
     1            ' FOR L =',I6,' REQUIRE MORE BITS',
     2            ' THAN ARE AVAILABLE IN IPACK( ),',/,
     3            '     WITH LOC =',I8,', IPOS =',I4,
     4            ', AND ND5 =',I8,'.',
     5            '  RETURN FROM UNPKPO WITH IER =',I4)
         GO TO 900
      ENDIF
C
      IF(NOV(L)+K.GT.ND5)THEN
         IER=6
         WRITE(KFILDO,104)NOV(L),L,ND5,IER
 104     FORMAT(/,' ****NOV(L) = ',I9,' FOR L =',I6,
     1            ' INDICATES MORE VALUES THAN CAN BE PUT INTO',
     2            ' IWORK( ),',/,'     WITH ND5 =',I8,'.',/,
     3            '  RETURN FROM UNPKPO WITH IER =',I4)
         GO TO 900
      ENDIF
C
      JMINLA=JMIN(L)+MINA
      MISSPK=LB2M1(LBIT(L))
C        THE ABOVE DEFINITIONS MAY IMPROVE EFFICIENCY.
C
C        TEST FOR LBIT(L) = 0 OUT OF LOOP.
C
      IF(LBIT(L).NE.0)GO TO 330
C
      DO 249 M=1,NOV(L)
      K=K+1
C
      IF(JMIN(L).EQ.MISSPK)THEN
         IWORK(K)=MISSP
      ELSE
         IWORK(K)=JMINLA
      ENDIF
C
 249  CONTINUE
C
      GO TO 350
C
C        NORMAL PROCESSING WHEN LBIT(L) NE 0.
C
 330  DO 349 M=1,NOV(L)
      K=K+1
C
C        SHIFT WORD IPACK(LOC) TO LEFT TO ELIMINATE BITS TO LEFT OF THOSE
C        WANTED, THEN BACK TO THE RIGHT TO THE PORTION OF THE WORD
C        WANTED.
C
      NVALUE=ISHFT(ISHFT(IPACK(LOC),IPOS-1),LBIT(L)-L3264B)
C
C        UPDATE IPOS AND LOC AS NEEDED.
C
      IPOS=IPOS+LBIT(L)
      IF(IPOS.LE.L3264B)GO TO 340
      LOC=LOC+1
      IPOS=IPOS-L3264B
      IF(IPOS.EQ.1)GO TO 340
C
C        FINISH UNPACKING.
C
      NVALUE=IOR(NVALUE,ISHFT(IPACK(LOC),IPOS-(L3264B+1))) 
C
 340  IF(NVALUE.EQ.MISSPK)THEN
         IWORK(K)=MISSP
      ELSE
         IWORK(K)=JMINLA+NVALUE
C
         IF(IWORK(K).EQ.MISSP)THEN
            IWORK(K)=IWORK(K)-1
         ENDIF
C           THE ABOVE STATEMENTS ARE NECESSARY TO GUARD AGAINST A 
C           LEGITIMATE VALUE BEING INTERPRETED AS A MISSING.
C           SINCE MISSP IS SCALED * 10000, THIS SHOULD BE
C           EXTREMELY RARE.
C
      ENDIF
C
 349  CONTINUE
C
 350  CONTINUE
C
 900  RETURN
      END
