      SUBROUTINE UNPACK(KFILDO,IPACK,IWORK,DATA,ND5,
     1                 IS0,IS1,IS2,IS4,ND7,MISSPX,MISSSX,
     2                 IGIVE,L3264B,IER)
C
C        JANUARY   1995   GLAHN   TDL   MOS-2000
C        JULY      1996   GLAHN   ADDED MISSS AND GRIDLENGTH WORD SIZE
C        FEBRUARY  1997   GLAHN   ELIMINATED /D PRINT OF IS2( ) WHEN 
C                                 VECTOR DATA
C        APRIL     1997   GLAHN   MODIFIED TO HANDLE PRIMARY MISSING
C                                 VALUES WITH 2ND ORDER DIFFERENCES.
C        MAY       1997   GLAHN   DECREASED USE OF MOD FUNCTION IN LOOP
C                                 ENDING AT STATEMENTS 395 AND 398.
C        APRIL     2000   DALLAVALLE   MODIFIED FORMAT STATEMENTS TO
C                                 CONFORM TO FORTRAN 90 STANDARDS
C                                 ON THE IBM SP
C        SEPTEMBER 2001   GLAHN   INCREASED NDG TO 4500
C        MAY       2003   GLAHN   COMMENT ABOUT DATA( )
C        JULY      2003   GLAHN   CHANGED I6 TO I10 IN FORMAT 339
C        DECEMBER  2004   GLAHN   CHANGED DIAGNOSTIC FORMATS
C        JANUARY   2005   GLAHN   INSERTED EXTRA /D DIAGNOSTIC
C        JULY      2012   ENGLE   MODIFIED TO BYTE SWAP THE FIRST
C                                 WORD IN IPACK( ) WHICH HOLDS THE
C                                 INTEGER REPRESENTATION OF 'TDLP';
C                                 INCREASED NDG=65535 
C        OCTOBER   2012   ENGLE   ADDED MORE LOGIC TO CHECK IPACK(1)
C                                 WHICH SHOULD HOLD 'TDLP'.
C        FEBRUARY  2018   ENGLE   REPLACED .AND. USED IN EXPRESSIONS WITH
C                                 INTRINSIC FUNCTION IAND(). THE USE OF
C                                 .AND. IN EXPRESSIONS IS NOT STANDARD
C                                 FORTRAN.
C 
C        PURPOSE 
C            SUBROUTINE TO UNPACK DATA THAT WERE PACKED BY ROUTINE
C            PACK FOR MOS-2000.  IT HANDLES (1) 2ND ORDER DIFFERENCE
C            REMOVAL CALLED COMPLEX PACKING BY GRIB, (2) 2ND ORDER
C            SPATIAL DIFFERENCES AND ALTERNATE ROW REVERSAL FOR
C            GRIDPOINT DATA, AND (3) PRIMARY AND SECONDARY MISSING
C            VALUES.
C
C        DATA SET USE 
C           KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE. (OUTPUT) 
C
C        VARIABLES 
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT) 
C            IPACK(J) = THE ARRAY HOLDING THE ACTUAL PACKED MESSAGE
C                       (J=1,MAX OF ND5).  (INPUT)
C            IWORK(K) = WORK ARRAY (K=1,ND5).  (INTERNAL)
C             DATA(K) = UNPACKED DATA RETURNED (K=1,ND5).  THE DATA ARE
C                       IN THIS LINEAR ARRAY, IN THE ORDER PACKED.
C                       (OUTPUT)
C                       11/29/00, GLAHN, EVIDENTLY DATA( ) CAN BE THE
C                       SAME ARRAY AS IPACK( ).
C                       5/19/03, GLAHN, HOWEVER UNLESS IGIVE = 1,
C                       IPACK( ) WOULD BE MODIFIED AND NO LONGER
C                       CONTAIN THE PACKED DATA.  THIS IS OK FOR
C                       IGIVE =1.
C                 ND5 = DIMENSION OF IPACK( ), IWORK( ), AND DATA( ).
C                       (INPUT)
C              IS0(L) = HOLDS THE BYTES DECODED FROM SECTION 0 (L=1,3).
C                       (OUTPUT)
C              IS1(L) = HOLDS THE BYTES DECODED FROM SECTION 1 
C                       (L=1,MAX OF ND7).  (OUTPUT)
C              IS2(L) = HOLDS THE OCTETS DECODED FROM SECTION 2
C                       (L=1,12).  SECTION 2 IS NOT PRESENT WHEN 
C                       DATA ARE NOT GRIDPOINT.  (OUTPUT)
C              IS4(L) = HOLDS THE BYTES DECODED FROM SECTION 4 (L=1,4),
C                       EXCEPT FOR THE DATA THEMSELVES.  (OUTPUT)
C                 ND7 = DIMENSION OF IS0( ), IS1( ), IS2( ), AND IS4( ).
C                       THIS MUST BE GE 22 TO HOLD SECTION 1.  IT MUST
C                       BE LARGER IF THERE IS PLAIN LANGUAGE IN 
C                       SECTION 1.  ND7=54 IS RECOMMENDED, WHICH
C                       ALLOWS FOR 32 CHARACTERS, ONE CHARACTER PER
C                       WORD.  (INPUT)
C              MISSPX = PRIMARY MISSING VALUE INDICATOR.  RETURNED AS
C                       ZERO WHEN A VALUE IS NOT PACKED.  THIS IS THE
C                       UNSCALED VALUE AND SHOULD BE THE NEAREST
C                       INTEGER TO XMISSP WHEN PACKING.  (OUTPUT)
C              MISSSX = SECONDARY MISSING VALUE INDICATOR.  THIS IS THE
C                       UNSCALED VALUE AND SHOULD BE THE NEAREST
C                       INTEGER TO XMISSS WHEN PACKING.  RETURNED AS
C                       ZERO WHEN A VALUE IS NOT PACKED.  (OUTPUT)
C               IGIVE = INDICATES HOW MUCH OUTPUT IS WANTED.
C                       1 = ID'S ONLY--FILLS IS0( ), IS1( ), IS2( ),
C                           AND MOST OF IS4( ).
C                       OTHERWISE, BOTH ID'S AND DATA (SEE ABOVE).
C              L3264B = INTEGER WORD LENGTH OF MACHINE BEING USED.
C                       (INPUT)
C                 IER = ERROR RETURN.  MOST ERROR RETURNS NE 0 ARE
C                       FROM SUBROUTINE UNPKBG.  OTHERS USED ARE:
C                       10--CAN'T FIND BEGINNING OF MESSAGE.
C                       11--CAN'T FIND END OF MESSAGE. 
C                       12--EDITION NUMBER NOT WHAT'S EXPECTED.
C                       13--BIT MAP INDICATED IN RECORD, BUT 
C                           NOT SUPPORTED IN THIS EDITION.
C                       14--TOO MANY GROUPS INDICATED.
C                       15--GRIDPOINT DATA AND MISSING VALUES
C                           INDICATED.  THIS IS NOT SUPPORTED
C                           FOR CONVENIENCE AND EFFICIENCY, BUT
C                           ALSO BECAUSE MISSING VALUES IN
C                           GRIDPOINT DATA ARE NOT, IN GENERAL,
C                           CHECKED AND ALLOWING THEM HERE WOULD
C                           LIKELY RESULT IN ERRORS DOWNSTREAM THAT
C                           MIGHT NOT BE DETECTED.
C                       16--ND7 LT 22 OR IS1( ) ABOUT TO BE OVERFLOWED.
C                           THE LATTER PROBABLY INDICATES AN ERROR IN 
C                           SECTION 1 DATA.
C                       17--DIMENSION ND5 NOT LARGE ENOUGH TO
C                           ACCOMMODATE DATA.
C                       22--IS4(2) INDICATES SIMPLE PACKING,
C                           WHICH IS NOT SUPPORTED.
C                       23--MORE GROUPS INDICATED THAN PACKED VALUES.
C                           MUST BE A PACKING OR UNPACKING ERROR.
C             LBIT(L) = THE NUMBER OF BITS NECESSARY TO HOLD THE
C                       PACKED VALUES FOR EACH GROUP L (L=1,LX). 
C                       (INTERNAL)
C             JMIN(L) = THE MINIMUM VALUE SUBTRACTED FOR EACH GROUP
C                       L BEFORE PACKING (L=1,LX).  (INTERNAL)
C              NOV(L) = THE NUMBER OF VALUES IN GROUP L (L=1,LX).
C                       (INTERNAL)
C                 NDG = THE SIZE OF THE ARRAYS LBIT( ), NOV( ), AND
C                       JMIN( ).  SET BY PARAMETER.  A PARAMETER IS
C                       USED HERE SO THAT THE USER WILL NOT HAVE TO 
C                       DEFINE AND CARRY THIS VALUE AND ALL THE
C                       ASSOCIATED ARRAYS.  THE AMOUNT OF STORAGE
C                       IS NOT LARGE, AND IF THE VALUE USED IS NOT
C                       LARGE ENOUGH, IT CAN BE INCREASED WITHOUT 
C                       AFFECTING PREVIOUS PACKING.  (INTERNAL)  
C                  LX = THE NUMBER OF VALUES IN LBIT( ), JMIN( ), AND
C                       NOV( ).  (INTERNAL)
C                MINA = THE MINIMUM VALUE THAT WAS SUBTRACTED BEFORE
C                       PACKING.  THIS IS ADDED BACK IN BEFORE RETURNING
C                       THE DATA IN IWORK( ).  (INTERNAL)
C              NVALUE = AN UNPACKED VALUE RETURNED FROM SUBROUTINE
C                       UNPKBG.  (INTERNAL)
C               C7777 = EQUIVALENCED TO I7777 FOR TESTING.  (INTERNAL)
C                       (CHARACTER*4)
C               I7777 = EQUIVALENCED TO C7777 FOR TESTING.  (INTERNAL) 
C              MOCTET = HOLDS THE NUMBER OF OCTETS AT VARIOUS STEPS OF
C                       UNPACKING FROM WHICH LOC AND IPOS ARE
C                       DETERMINED.  (INTERNAL)
C                 LOC = HOLDS WORD POSITION IN IPACK( ) OF NEXT VALUE TO
C                       UNPACK.  (INTERNAL)
C                IPOS = HOLDS BIT POSITION IN IPACK(LOC) OF THE FIRST
C                       BIT OF THE NEXT VALUE TO UNPACK.  (INTERNAL)
C                IBIT = THE NUMBER OF BITS REQUIRED TO PACK THE GROUP
C                       MINIMUM VALUES IN JMIN( ).  (INTERMAL)   
C                KBIT = THE NUMBER OF BITS REQUIRED TO HOLD THE NUMBER
C                       OF VALUES IN EACH GROUP.  (INTERNAL)
C                MBIT = THE NUMBER OF BITS REQUIRED TO PACK THE
C                       GROUP SIZES.  (INTERNAL)   
C                JBIT = THE NUMBER OF BITS REQUIRED TO HOLD THE NUMBER
C                       OF BITS REQUIRED FOR EACH GROUP'S VALUES.
C                       (INTERNAL)
C                MBIT = THE NUMBER OF BITS REQUIRED TO PACK THE
C                       ABSOLUTE VALUE OF THE FIRST FIRST ORDER  
C                       DIFFERENCE.  USED ONLY WHEN PACKING SECOND ORDER
C                       DIFFERENCES.  (INTERNAL)
C                NBIT = THE NUMBER OF BITS REQUIRED TO HOLD THE ABSOLUTE
C                       VALUE OF THE OVERALL MINIMUM, MINA.  (INTERNAL)
C              IFIRST = THE FIRST VALUE IN THE FIELD.  USED ONLY WHEN
C                       PACKING SECOND ORDER DIFFERENCES.  (INTERNAL)
C                IFOD = THE FIRST FIRST ORDER DIFFERENCE.  USED ONLY
C                       WHEN PACKING SECOND ORDER DIFFERENCES.
C                       (INTERNAL)
C               STATE = HOLD 4 CHARACTERS FOR PRINTOUT IN CASE OF
C                       ERROR.  (INTERNAL)  (CHARACTER*4) 
C                   N = WORKING COPY OF L3264B.  (INTERNAL)
C              LBYPWD = BYTES PER WORD FOR EITHER A 32- OR 64-BIT
C                       MACHINE.  (INTERNAL)
C               SCALE = THE COMBINATION OF DECIMAL AND BINARY SCALING
C                       FACTOR = (10.**(-IS1(17)))*(2.**(-IS1(18))).
C                       (INTERNAL)
C                IB10 =  1000 BINARY = 10 OCTAL = 8 DECIMAL.
C                IB20 = 10000 BINARY = 20 OCTAL = 16 DECIMAL.
C
C        NON SYSTEM SUBROUTINES CALLED 
C           UNPKBG, UNPKLX, UNPKOO, UNPKPO, UNPKPS, BSWAP
C
      PARAMETER (NDG=65535)
C
      CHARACTER*4 C7777,TDLP,STATE,PLDT
C
      DIMENSION IPACK(ND5),IWORK(ND5),DATA(ND5)
      DIMENSION JMIN(NDG),NOV(NDG),LBIT(NDG)
      DIMENSION IS0(ND7),IS1(ND7),IS2(ND7),IS4(ND7)
C 
C***D     LOGICAL*1 IOCT(4000)
C***D     DIMENSION IDUP(1000)
C***D     EQUIVALENCE (IDUP,IOCT)
      EQUIVALENCE (C7777,I7777),(TDLP,ITDLP)
C
      DATA IB10/8/
      DATA IB20/16/
      DATA TDLP/'TDLP'/
      DATA C7777/'7777'/
C
CINTEL
      DATA PLDT/'PLDT'/
      EQUIVALENCE(PLDT,IPLDT)
      INTEGER ITEMP
CINTEL
      SAVE LOC,IPOS
C
C***D     DO 100 J=1,200
C***D     IDUP(J)=IPACK(J)
C***D100  CONTINUE
C
C***D     WRITE(KFILDO,101)(IOCT(J),J=1,500)
C***D101  FORMAT(/' PACKED RECORD IN UNPACK'/(' '30(1XO3.3)))
C
C        SET ERROR RETURN AND ZERO ARRAYS.
C
      IER=0
      MISSPX=0
      MISSSX=0
      LBYPWD=L3264B/8
C        LBYPWD IS THE BYTES PER WORD FOR EITHER A 32- OR 64-BIT MACHINE.
      N=L3264B
C        THIS ASSIGNMENT IS MADE MAINLY TO KEEP MOST CALLS TO UNPKBG
C        TO ONE LINE.  IT MAY HELP THE COMPILER TO BE MORE EFFICIENT.
C
      DO 105 K=1,ND7
      IS0(K)=0
      IS1(K)=0
      IS2(K)=0
      IS4(K)=0
 105  CONTINUE
C
      IF(ND7.GE.22)GO TO 108
C        THE CONSTANT 22 IS LARGE ENOUGH FOR ALL SECTIONS EXCEPT
C        SECTION 1 WHEN THERE IS PLAIN LANGUAGE.  THIS IS CHECKED
C        LATER.
      IER=16
      WRITE(KFILDO,107)ND7
 107  FORMAT(/,' ****ND7 =',I3,' NOT LARGE ENOUGH IN UNPACK.',
     1         '  INCREASE TO 52.')
      GO TO 910
C
C        *************************************
C
C        UNPACK SECTION 0.
C
C        *************************************
C
 108  STATE='0   '
      LOC=1
      IPOS=1
CINTEL
C
C        SINCE ALL TDLPACK FILES ARE DEFINED TO BE BIG-ENDIAN,
C        WE SHOULD EXPECT IPACK(1)='PLDT' WHEN RUNNING ON A
C        LITTLE-ENDIAN SYSTEM (ISYSEND=-1).
C
      ISYSEND=0
      CALL CKSYSEND(KFILDO,'NOPRINT',ISYSEND,IER)
      IF(ISYSEND.EQ.-1)THEN
         ITEMP=IPACK(1)
         IF(ITEMP.EQ.IPLDT)THEN
            CALL BSWAP(ITEMP)
            IPACK(1)=ITEMP
         ENDIF
      ENDIF
CINTEL
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS0(1),32,N,IER,*900)
      IS01=IS0(1)
      IF(L3264B.EQ.64)IS01=ISHFT(IS0(1),32)
C        THE ABOVE STATEMENT IS TO ACCOMMODATE THE 64-BIT WORD, BY
C        MOVING THE 4 CHARACTERS TO THE LEFT HALF OF THE WORD FOR 
C        TESTING WITH ITDLP.
      IF(ITDLP.EQ.IS01)GO TO 112
      WRITE(KFILDO,111)IS0(1)
 111  FORMAT(/,' ****BEGINNING OF GRIB MESSAGE NOT FOUND IN UNPACK.',
     1        '  FIRST 4 CHARACTERS = ',A4)
      IER=10
      GO TO 910
C
 112  CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS0(2),24,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS0(3),8,N,IER,*900)  
      IF(IS0(3).EQ.0)GO TO 120
      WRITE(KFILDO,113)IS0(3)
 113  FORMAT(/,' ****GRIB EDITION NUMBER =',I3,
     1         ' IN UNPACK NOT EXPECTED.')
      IER=12
      GO TO 910     
C
C        *************************************
C
C        UNPACK SECTION 1.
C
C        *************************************
C
 120  STATE='1   '
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(1),8,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(2),8,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(3),16,N,IER,*900)  
C
      DO 210 K=4,7
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(K),8,N,IER,*900)  
 210  CONTINUE
C
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(8),32,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(9),32,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(10),32,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(11),32,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(12),32,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(13),16,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(14),8,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(15),8,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(16),8,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,ISIGN,1,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(17),7,N,IER,*900)
      IF(ISIGN.EQ.1)IS1(17)=-IS1(17)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,ISIGN,1,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(18),7,N,IER,*900)
      IF(ISIGN.EQ.1)IS1(18)=-IS1(18)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(19),8,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(20),8,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(21),8,N,IER,*900)
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(22),8,N,IER,*900)
      IF(IS1(22).EQ.0)GO TO 221
C        SOME PLAIN LANGUAGE IS PRESENT.
C 
      IF(22+IS1(22).LE.ND7)GO TO 216
C        IS1( ) ABOUT TO BE OVERFLOWED.  THIS PROBABLY INDICATES
C        AN ERROR IN WORD IS1(22).      
      WRITE(KFILDO,217)IS1(22)
 217  FORMAT(/,' ****IS1( ) IN UNPACK ABOUT TO BE OVERFLOWED.',
     1         '  IS1(22) =',I4,'  INCREASE ND7 TO 54.')
      IER=16
      GO TO 910
C
 216  DO 220 K=23,22+IS1(22)
C        NOTE THAT THIS PUTS ONE CHARACTER PER IS1( ) WORD.
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS1(K),8,N,IER,*900)
 220  CONTINUE
C
C        *************************************
C       
C        UNPACK SECTION 2.
C
C        *************************************
C
C        START ACCORDING TO LENGTH OF SECTION 0 = 8 BYTES AND
C        SECTION 1 = IS1(1) BYTES.
C
  221 STATE='2   '
      MOCTET=8+IS1(1)
      IB=IAND(IS1(2),1)
C        BIT 8 IN IS1(2) = 0 INDICATES THE DATA ARE NOT GRIDPOINT
C        AND SECTION 2 IS NOT PRESENT.
      IF(IB.EQ.0)GO TO 300
C
      LOC=MOCTET/LBYPWD+1
      IPOS=(MOCTET-(LOC-1)*LBYPWD)*8+1
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS2(1),8,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS2(2),8,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS2(3),16,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS2(4),16,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,ISIGN,1,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS2(5),23,N,IER,*900)  
      IF(ISIGN.EQ.1)IS2(5)=-IS2(5)     
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,ISIGN,1,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS2(6),23,N,IER,*900)  
      IF(ISIGN.EQ.1)IS2(6)=-IS2(6)
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,ISIGN,1,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS2(7),23,N,IER,*900)  
      IF(ISIGN.EQ.1)IS2(7)=-IS2(7)
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS2(8),32,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS2(9),24,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS2(10),16,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS2(11),16,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS2(12),16,N,IER,*900)  
      NX=IS2(3)
      NY=IS2(4)
C
C        *************************************
C
C        UNPACK SECTION 3.  NOT SUPPORTED IN THIS EDITION.
C
C        *************************************
C
 300  IS3=0
      IB=IAND(IS1(2),2)
      IF(IB.EQ.0)GO TO 303
C        A BIT MAP IS INDICATED, BUT NOT SUPPORTED IN THIS EDITION.
      WRITE(KFILDO,301)IS1(2)
 301  FORMAT(/,' ****IS1(2) =',O6,' OCTAL INDICATES BIT MAP,',
     1         ' WHICH IS NOT SUPPORTED IN UNPACK.')
      IER=13
      GO TO 910
C
C        *************************************
C
C        UNPACK SECTION 4.
C
C        *************************************
C
C        START ACCORDING TO LENGTH OF SECTION 0 = 12 BYTES PLUS
C        SECTION 1 = IS2(1) BYTES PLUS SECTION 2 = IS2(1) BYTES.
C
 303  STATE='4   '
      MOCTET=MOCTET+IS2(1)+IS3
C        MOCTET = THE BYTES BEFORE SECTION 4.
      LOC=MOCTET/LBYPWD+1
      IPOS=(MOCTET-(LOC-1)*LBYPWD)*8+1
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS4(1),24,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS4(2),8,N,IER,*900)
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IS4(3),32,N,IER,*900)
      IB=IAND(IS4(2),IB10)
      IF(IB.NE.0)GO TO 3035
      WRITE(KFILDO,3033)IS4(2)
 3033 FORMAT(/,' ****IS4(2) =',O6,' OCTAL INDICATES SIMPLE PACKING,',
     1         ' WHICH IS NOT SUPPORTED IN UNPACK.')
      IER=22
      GO TO 910
C
 3035 MISSP=0
      IB=IAND(IS4(2),2)
      IF(IB.EQ.0)GO TO 304
C        A PRIMARY MISSING VALUE IS PRESENT.  UNPACK IT.
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,MISSP,32,N,IER,*900)
      MISSPX=NINT(MISSP/10000.)
C        MISSP HAS BEEN PACKED SCALED * 10000 TO MINIMIZE
C        THE CHANCE THAT A SCALED VALUE WILL EQUAL MISSP
C        IN THE PACKING AND UNPACKING PROCESSES.
      IS4(4)=MISSPX
C
      MISSS=0
      IB=IAND(IS4(2),1)
      IF(IB.EQ.0)GO TO 304
C        A SECONDARY MISSING VALUE IS PRESENT.  UNPACK IT.
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,MISSS,32,N,IER,*900)
      MISSSX=NINT(MISSS/10000.)
C        MISSS HAS BEEN PACKED SCALED * 10000 TO MINIMIZE
C        THE CHANCE THAT A SCALED VALUE WILL EQUAL MISSS
C        IN THE PACKING AND UNPACKING PROCESSES.
      IS4(5)=MISSSX
 304  CONTINUE
C
D     WRITE(KFILDO,3040)(IS0(K),K=1,3)
D3040 FORMAT(/,' IS0',2X,A4,2I10)
D     WRITE(KFILDO,3041)(IS1(K),K=1,22+IS1(22))
D3041 FORMAT(/,' IS1',10I11,/,'    ',10I11,/,'    ',2I11,4X,32R1)
D     IF(IS2(1).NE.0)WRITE(KFILDO,3042)(IS2(K),K=1,12)
C        WHEN THE DATA ARE VECTOR, IS2( ) WILL NOT BE PRESENT.
D3042 FORMAT(/,' IS2',10I11,/,('    ',10I11))
D     WRITE(KFILDO,3043)(IS4(K),K=1,5)
D3043 FORMAT(/,' IS4',10I11,/,('    ',10I11))
C
      IF(IGIVE.EQ.1)GO TO 430
C
C        UNPACK DATA.
C
      STATE='4   '
      IB=IAND(IS4(2),4)
      IF(IB.EQ.0)GO TO 310
C
C        2ND ORDER DIFFERENCES ARE PACKED.  UNPACK THE FIRST VALUE IN
C        THE FIELD AND THE FIRST FIRST ORDER DIFFERENCE.
C
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,ISIGN,1,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IFIRST,31,N,IER,*900)
      IF(ISIGN.EQ.1)IFIRST=-IFIRST 
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,MBIT,5,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,ISIGN,1,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IFOD,MBIT,N,IER,*900)  
      IF(ISIGN.EQ.1)IFOD=-IFOD
 310  CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,NBIT,5,N,IER,*900)
      IS4(6)=NBIT  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,ISIGN,1,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,MINA,NBIT,N,IER,*900)  
      IF(ISIGN.EQ.1)MINA=-MINA 
C***D     WRITE(KFILDO,312)MINA
C***D312  FORMAT(/,' THE OVERALL MINIMUM IS',I10)    
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,LX,16,N,IER,*900)
      IS4(7)=LX
      IF(LX.LE.NDG)GO TO 315
      WRITE(KFILDO,314)LX
 314  FORMAT(/,' ****MORE GROUPS (LX =',I5,') INDICATED IN THE RECORD',
     1         ' THAN CAN BE HANDLED.',/,'     INCREASE NDG IN UNPACK.')
      IER=14
      GO TO 910
C
 315  IF(LX.LE.IS4(3))GO TO 320
C        THE ABOVE IS A SAFETY CHECK.  ON PROPERLY PACKED DATA,
C        THIS ERROR SHOULD NOT OCCUR.
      WRITE(KFILDO,316)LX
 316  FORMAT(/,' ****MORE GROUPS (LX =',I5,') INDICATED IN THE RECORD',
     1         ' THAN PACKED VALUES.',/,
     2         '     EVIDENTLY AN ERROR IN PACKING OR UNPACKING.')
      IER=23
      GO TO 910
C 
 320  CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,IBIT,5,N,IER,*900)  
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,JBIT,5,N,IER,*900)
      CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,KBIT,5,N,IER,*900)
C
C        UNPACK THE GROUP MINIMA.
C
      CALL UNPKLX(KFILDO,IPACK,ND5,LOC,IPOS,JMIN,LX,IBIT,L3264B,IER)
      IF(IER.NE.0)GO TO 900
C        
C        UNPACK THE NUMBER OF BITS REQUIRED FOR EACH VALUE IN EACH
C        GROUP.
C
      CALL UNPKLX(KFILDO,IPACK,ND5,LOC,IPOS,LBIT,LX,JBIT,L3264B,IER)
      IF(IER.NE.0)GO TO 900
C
C        UNPACK THE GROUP SIZES.
C
      CALL UNPKLX(KFILDO,IPACK,ND5,LOC,IPOS,NOV,LX,KBIT,L3264B,IER)
      IF(IER.NE.0)GO TO 900
C
D     WRITE(KFILDO,331)LX
D331  FORMAT(/,' ',I7,' GROUPS')
D     WRITE(KFILDO,332)(JMIN(K),K=1,LX)
D332  FORMAT(/,' JMIN( ) =',/,(' ',15I6))
D     WRITE(KFILDO,333)(LBIT(K),K=1,LX)
D333  FORMAT(/,' LBIT( ) =',/,(' ',15I6))
D     WRITE(KFILDO,334)(NOV(K),K=1,LX)
D334  FORMAT(/,' NOV( ) =',/,(' ',15I6))
C
      IF(ND5.GE.IS4(3))GO TO 340
      WRITE(KFILDO,339)ND5,IS4(3)
 339  FORMAT(/,' ****DIMENSION ND5 =',I10,' NOT LARGE ENOUGH',
     1         ' IN UNPACK.  INCREASE TO',I10)
      IER=17
      GO TO 910
C
C        UNPACK THE DATA VALUES THEMSELVES.  THE ROUTINES
C        UNPKOO, UNPKPO, AND UNPKPS HANDLE THE CASE WHEN
C        THERE ARE NO MISSING VALUES, THERE CAN BE
C        PRIMARY MISSING VALUES, AND THERE CAN BE BOTH
C        PRIMARY AND SECONDARY MISSING VALUES, RESPECTIVELY.
C
 340  IF(MISSP.EQ.0)THEN
         CALL UNPKOO(KFILDO,IPACK,ND5,LOC,IPOS,
     1               MINA,JMIN,LBIT,NOV,LX,IWORK,L3264B,IER)
      ELSEIF(MISSS.EQ.0)THEN
         CALL UNPKPO(KFILDO,IPACK,ND5,LOC,IPOS,MISSP,
     1               MINA,JMIN,LBIT,NOV,LX,IWORK,L3264B,IER)
      ELSE
         CALL UNPKPS(KFILDO,IPACK,ND5,LOC,IPOS,MISSP,MISSS,
     1               MINA,JMIN,LBIT,NOV,LX,IWORK,L3264B,IER)
      ENDIF
C
      IF(IER.NE.0)GO TO 910
C
C        *************************************
C
C        UNPACK END OF RECORD.  IT STARTS ON A BYTE.
C
C        *************************************
C
      IPOS=((IPOS+6)/8)*8+1
      IF(IPOS.LE.L3264B)GO TO 377
      LOC=LOC+1
      IPOS=1 
 377  CALL UNPKBG(KFILDO,IPACK,ND5,LOC,IPOS,NVALUE,32,N,IER,*900)
      IF(L3264B.EQ.64)NVALUE=ISHFT(NVALUE,32)
C        THE ABOVE STATEMENT IS TO ACCOMMODATE THE 64-BIT WORD, BY
C        MOVING THE 4 CHARACTERS TO THE LEFT HALF OF THE WORD FOR 
C        TESTING WITH I7777.
      IF(NVALUE.EQ.I7777)GO TO 380
      WRITE(KFILDO,379)
 379  FORMAT(/,' ****DID NOT FIND GRIB END OF RECORD MARK IN UNPACK.')
      IER=11
      GO TO 910
C
C        DEAL WITH 2ND ORDER DIFFERENCES WHEN NECESSARY.
C
 380  IB=IAND(IS4(2),4)
      IF(IB.EQ.0)GO TO 391
C
C        RECOVER FIELD FROM 2ND ORDER DIFFERENCES.
C
C        THIS LOOP FOR NO MISSING VALUES AND 2ND ORDER DIFFERENCES.
C
      IF(MISSP.EQ.0)THEN
         IWORK(1)=IFIRST
         IWORK(2)=IWORK(1)+IFOD
         ISUM=IFOD
C
         DO 385 K=3,IS4(3)
         ISUM=IWORK(K)+ISUM
         IWORK(K)=IWORK(K-1)+ISUM
C***D        WRITE(KFILDO,389)IFIRST,IFOD,ISUM,IWORK(K-1),IWORK(K)
 385     CONTINUE
C
C        THIS LOOP FOR MISSING VALUES AND 2ND ORDER DIFFERENCES.
C
      ELSE
C
         KOUNT=0
         KSTART=1
C           THE ABOVE STATEMENT SHOULD NOT BE NEEDED.
C
         DO 387 K=1,IS4(3)
         IF(IWORK(K).EQ.MISSP)GO TO 387
         KOUNT=KOUNT+1
C
         IF(KOUNT.EQ.1)THEN
            IWORK(K)=IFIRST
         ELSEIF(KOUNT.EQ.2)THEN
            IWORK(K)=IFIRST+IFOD
            ISUM=IFOD
            IWKEEP=IWORK(K)
            KSTART=K+1
            GO TO 388
         ENDIF
C 
C***D        WRITE(KFILDO,386)K,KOUNT,KSTART,IWORK(K),ISUM,IWKEEP
C***D386     FORMAT(' ',6I10)
 387     CONTINUE        
C   
         GO TO 391
C           THIS EXIT SHOULD NOT OCCUR, BECAUSE THIS WOULD 
C           INDICATE ALL VALUES WERE MISSING, AND ALL MISSING
C           VALUES SHOULD NOT HAVE BEEN PACKED WITH SECOND
C           ORDER DIFFERENCES.
 388     IF(KSTART.GT.IS4(3))GO TO 391
C           THE ABOVE TEST WOULD BE MET ONLY WHEN EXACTLY
C           TWO NON-MISSING VALUES WERE PACKED.
C
         DO 390 K=KSTART,IS4(3)
         IF(IWORK(K).EQ.MISSP)GO TO 3880
         ISUM=IWORK(K)+ISUM
         IWORK(K)=IWKEEP+ISUM
         IWKEEP=IWORK(K)
C
 3880    CONTINUE
C***D        IF(K.LE.100)WRITE(KFILDO,389)K,IFIRST,IFOD,ISUM,IWKEEP,
C***D    1                     IWORK(K-2),IWORK(K-1),IWORK(K)
C***D389     FORMAT(' 2ND ORD DIFF',I6,9I10)
 390     CONTINUE
C
      ENDIF
C
C        SET SCALE SO THAT WHEN MULTIPLIED BY IWORK( ) WILL GIVE DATA( )
C        IN THE ORIGINAL UNITS.
C
 391  SCALE=(10.**(-IS1(17)))*(2.**(-IS1(18)))
C
      IB=IAND(IS4(2),IB20)
      IF(IB.NE.0)GO TO 400
C
C        THESE ARE GRIDPOINT DATA.
C        REVERSE ALTERNATE ROWS FOR GRIDPOINT DATA.  USE SEPARATE
C        LOOP FOR POSSIBLE MISSING DATA FOR EFFICIENCY.
C
      K=0
C
C           THIS LOOP USED WHEN THERE ARE NO MISSING VALUES.
C
      IF(MISSP.EQ.0)THEN
C
         DO 395 JY=1,NY
C
         IF(MOD(JY,2).EQ.0)THEN
            M=JY*NX+1
C
            DO 393 IX=1,NX
            K=K+1
            DATA(K)=IWORK(M-IX)*SCALE
 393        CONTINUE
C
         ELSE
            M=(JY-1)*NX
C
            DO 394 IX=1,NX
            K=K+1
            DATA(K)=IWORK(M+IX)*SCALE
 394        CONTINUE
C
         ENDIF
C
 395     CONTINUE
C
      ELSEIF(MISSS.EQ.0)THEN
C
         DO 398 JY=1,NY
C
         IF(MOD(JY,2).EQ.0)THEN
            M=JY*NX+1
C
            DO 396 IX=1,NX
            K=K+1
C
            IF(IWORK(M-IX).EQ.MISSP)THEN
               DATA(K)=MISSPX
            ELSE
               DATA(K)=IWORK(M-IX)*SCALE
            ENDIF       
C
 396        CONTINUE
C
         ELSE
            M=(JY-1)*NX
C
            DO 397 IX=1,NX
            K=K+1
C
            IF(IWORK(M+IX).EQ.MISSP)THEN
               DATA(K)=MISSPX
            ELSE
               DATA(K)=IWORK(M+IX)*SCALE
            ENDIF       
C
 397        CONTINUE
C
         ENDIF
C
 398     CONTINUE
C
      ELSE
C
         DO 399 JY=1,NY
C
         IF(MOD(JY,2).EQ.0)THEN
            M=JY*NX+1
C
            DO 3980 IX=1,NX
            K=K+1
C
            IF(IWORK(M-IX).EQ.MISSP)THEN
               DATA(K)=MISSPX
            ELSEIF(IWORK(M-IX).EQ.MISSS)THEN
               DATA(K)=MISSSX
            ELSE
               DATA(K)=IWORK(M-IX)*SCALE
            ENDIF       
C
 3980       CONTINUE
C
         ELSE
            M=(JY-1)*NX
C
            DO 3985 IX=1,NX
            K=K+1
C
            IF(IWORK(M+IX).EQ.MISSP)THEN
               DATA(K)=MISSPX
            ELSEIF(IWORK(M+IX).EQ.MISSS)THEN
               DATA(K)=MISSSX
            ELSE
               DATA(K)=IWORK(M+IX)*SCALE
            ENDIF       
C
 3985       CONTINUE
C
         ENDIF
C
 399     CONTINUE
      ENDIF
C
      GO TO 420
C
C        THESE ARE VECTOR DATA.
C
 400  IF(MISSP.EQ.0)THEN
C
C           THIS LOOP USED WHEN THERE ARE NO MISSING VALUES.
C
         DO 405 K=1,IS4(3)
         DATA(K)=IWORK(K)*SCALE
 405     CONTINUE
C
      ELSEIF(MISSS.EQ.0)THEN
C
C           THIS LOOP USED WHEN THERE CAN BE ONLY PRIMARY MISSING
C           VALUES.
C 
         DO 410 K=1,IS4(3)
C
         IF(IWORK(K).EQ.MISSP)THEN
            DATA(K)=MISSPX
         ELSE
            DATA(K)=IWORK(K)*SCALE
         ENDIF
C
 410     CONTINUE
C
      ELSE
C
C           THIS LOOP USED WHEN BOTH PRIMARY AND SECONDARY VALUES
C           CAN BE PRESENT.
C
         DO 415 K=1,IS4(3)
C
         IF(IWORK(K).EQ.MISSP)THEN
            DATA(K)=MISSPX
         ELSEIF(IWORK(K).EQ.MISSS)THEN
            DATA(K)=MISSSX
         ELSE
            DATA(K)=IWORK(K)*SCALE
         ENDIF       
C
 415     CONTINUE
C
      ENDIF
C
 420  CONTINUE
C
C***D     DO 450 JY=1,IS2(4)
C***D     ISTART=(JY-1)*IS2(3)+1
C***D     IEND=ISTART+IS2(3)-1
C***D     WRITE(KFILDO,449)JY,ISTART,IEND,(DATA(IX),IX=ISTART,IEND)
C***D449  FORMAT(' IN UNPACK, ROW,ISTART,IEND',3I10,/,(' ',15F8.0))
C***D450  CONTINUE
C
 430  CONTINUE
      RETURN
C
C        ERROR RETURN SECTION.
C
 900  WRITE(KFILDO,901)STATE,IER
 901  FORMAT(/,' ****ERROR IN UNPACK SECTION ',A4,'  IER =',I4)
C
C        SET ALL VALUES TO MISSING INDICATOR.
C
 910  DO 920 K=1,ND5
      DATA(K)=9999.
 920  CONTINUE
C
      WRITE(KFILDO,921)
 921  FORMAT(' ****ALL DATA VALUES SET = 9999 IN UNPACK.',/,
     1       '     IDENTIFICATION ARRAYS IS0( ), IS1( ), IS2( )',
     2       ' AND IS4( ) MAY BE INCORRECT.')  
      RETURN
      END
