      SUBROUTINE RDKEYM(KFILDO,KFILX,JREC,NOPREC,KEYREC,NWDS,NW,
     1                  KSIZE,CFROM,IER)
C 
C        NOVEMBER 1996   GLAHN      TDL   MOS-2000
C        JANUARY  1997   GLAHN      ADDED NW TO CALL TO CHECK RECORD SIZE
C        AUGUST   1998   GLAHN      CHANGED LOOP AT STATEMENT 136;
C                                   COMMENTS IN PURPOSE REMOVED 
C        APRIL    2000   DALLAVALLE MODIFIED FORMAT STATEMENTS TO
C                                   CONFORM TO FORTRAN 90 STANDARDS
C                                   ON THE IBM SP
C        DECEMBER 2006   GLAHN      COMMENT CHANGE  
C 
C        PURPOSE 
C            TO READ A KEY RECORD FROM MOS-2000 EXTERNAL DIRECT ACCESS
C            FILE SYSTEM.  THE LOGICAL RECORD CAN SPAN MORE THAN ONE
C            PHYSICAL RECORD.  CALLED BY FLOPNM, WRTDLM, AND RDTDLM.
C 
C        DATA SET USE 
C            KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (OUTPUT) 
C            KFILX  - UNIT NUMBER FOR MOS-2000 FILE.  (INPUT) 
C 
C        VARIABLES 
C 
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT) 
C               KFILX = UNIT NUMBER FOR MOS-2000 FILE.  (INPUT) 
C                JREC = RECORD NUMBER OF 1ST PHYSICAL RECORD
C                       TO READ FROM FILE NUMBER KFILX.  (INPUT) 
C           NOPREC(J) = 6 WORDS (J=1,6) USED BY THE FILE SYSTEM.  WORDS
C                       3, 5, AND 6 ARE WRITTEN AS PART OF THE KEY RECORD.
C                       THE WORDS ARE:
C                       1 = IS THE KEY RECORD IN KEYREC( , , )?  IF NOT,
C                           THIS VALUE IS ZERO.  OTHERWISE, LOCATION 
C                           IN KEYREC( , ,N) OF THE KEY RECORD, RANGE OF
C                           1 TO MAXOPN.
C                       2 = LOCATION OF THIS KEY RECORD IN THE FILE.
C                           SET = JREC.
C                       3 = NUMBER OF SLOTS FILLED IN THIS KEY.
C                       4 = INDICATES WHETHER (1) OR NOT (0) THE KEY
C                           RECORD HAS BEEN MODIFIED AND NEEDS TO BE
C                           WRITTEN.  ZERO INITIALLY.
C                       5 = NUMBER OF PHYSICAL RECORDS IT TAKES TO HOLD
C                           THIS LOGICAL KEY RECORD.  THIS IS FILLED BY
C                           WRKEYM.
C                       6 = THE RECORD NUMBER OF THE NEXT KEY RECORD IN
C                           THE FILE.  EQUALS 99999999 WHEN THIS IS THE
C                           LAST KEY RECORD IN THE FILE.
C                       (INPUT-OUTPUT)
C           KEYREC(J) = NWDS WILL BE READ INTO KEYREC(J), (J=1,NWDS).
c                       (OUTPUT) 
C                NWDS = SIZE OF KEY RECORD, SANS THE LEADING 3 WORDS.
C                       SEE KEYREC( ).  (INPUT) 
C                  NW = THE MAXIMUM NUMBER OF ENTRIES IN ANY KEY RECORD
C                       BEING USED IN THIS RUN.  (INPUT)
C               KSIZE = SIZE OF PHYSICAL RECORD IN WORDS OF THIS FILE.
C                       ASSUMED TO BE GE 3.  (INPUT)
C               CFROM = 6 CHARACTERS TO IDENTIFY CALLING PROGRAM. 
C                       (CHARACTER*6)  (INPUT)
C                 IER = STATUS RETURN.
C                         0 = GOOD RETURN.
C                       152 = RECORD NUMBER OF PHYSICAL RECORD SIZE
C                             INCORRECT.
C                       154 = SPACE FOR KEY RECORD NOT LARGE ENOUGH
C                             TO ACCOMMODATE FULL RECORDS FROM THE
C                            DIRECT ACCESS FILE SYSTEM.
C                       OTHER VALUES FROM SYSTEM.
C                       (OUTPUT)
C                 IOS = STATUS OF FILE ACCESS.  (INTERNAL)
C               STATE = VARIABLE USED IN DIAGNOSTIC TO TELL WHICH
C                       READ STATEMENT CAUSED AN ERROR.  (CHARACTER*4)
C                       (INTERNAL) 
C                 NWW = THE VALUE NW NEEDS TO BE TO READ THIS KEY RECORD,
C                       WHEN NW IS TOO SMALL.  (INTERNAL)
C
C        NONSYSTEM SUBROUTINES CALLED 
C            TDLPRM (/D ONLY) 
C 
      CHARACTER*4 STATE
      CHARACTER*6 CFROM
C
      DIMENSION NOPREC(6),KEYREC(NWDS)
C 
CD     WRITE(KFILDO,120)CFROM,KFILX,JREC,NWDS,KSIZE 
CD120  FORMAT(' ENTER RDKEYM FROM'2XA6,'   KFILX ='I3,'  JREC ='I5,
CD    1       '   NWDS ='I5,'   KSIZE ='I5) 
C
      IER=0 
C
      IF(JREC.LE.0.OR.
     1   KSIZE.LE.0)THEN
         WRITE(KFILDO,110)JREC,KSIZE,KFILX,CFROM
 110     FORMAT(/,' ****EITHER THE RECORD NUMBER = ',I4,
     1            ' OR THE PHYSICAL RECORD SIZE =',I7,
     2            ' IS IN ERROR IN RDKDYM FOR UNIT NO.',I3,'.',/,
     3            '     RDKEYM CALLED FROM ',A6)
         IER=152
         GO TO 902
C
      ENDIF
C
C        CHECK TO SEE WHETHER THERE IS ROOM IN KEYREC( ) FOR THE
C        VALUES TO BE READ.
C
      IF(NWDS.GT.NW*6)THEN
         NWW=(NWDS+5)/6
         WRITE(KFILDO,112)NW,NWW
 112     FORMAT(/' ****INSUFFICIENT SPACE IN KEYREC( ,NW, ) FOR',
     1           ' MAXIMUM NUMBER OF KEYS IN THE KEY RECORD',
     2           ' TO READ.'/
     3           '     INCREASE NW FROM',I4,' TO',I4,
     4           ' IN FLOPNM, RDTDLM, WRTDLM, CLFILM, AND TDLPRM.')
         IER=154
         GO TO 902
      ENDIF
C      
 125  NOPREC(2)=JREC
C
C        READ THE LOGICAL RECORD IN PHYSICAL RECORDS
C        OF NWDS OR LESS.
C
      NREMIN=NWDS
      NEND=MIN(KSIZE-3,NWDS)
      STATE='130 '
      READ(KFILX,REC=JREC,IOSTAT=IOS,ERR=900)
     1     NOPREC(3),NOPREC(5),NOPREC(6),(KEYREC(J),J=1,NEND)
      NREMIN=NREMIN-NEND
CD     WRITE(KFILDO,129)NWDS,KSIZE,NREMIN,NEND
CD129  FORMAT(/' AT 130 IN RDKEYM,NWDS,KSIZE,NREMIN,NEND'4I7)
      IF(NOPREC(5).EQ.1)GO TO 150
C
 136  DO 140 K=1,NOPREC(5)-1
C        ABOVE STATEMENT CHANGED FROM [K=2,NOPRED(5)]
C        AUGUST 28, 1998.
      NSTART=K*KSIZE-3+1
      NEND=NSTART-1+MIN(KSIZE,NREMIN)
      STATE='140 '
      READ(KFILX,REC=JREC+K,IOSTAT=IOS,ERR=900)
     1     (KEYREC(J),J=NSTART,NEND)
      NREMIN=NREMIN-KSIZE
CD     WRITE(KFILDO,139)NWDS,KSIZE,NREMIN,NEND
CD139  FORMAT(/' AT 140 IN RDKEYM,NWDS,KSIZE,NREMIN,NEND'4I7)
 140  CONTINUE
C      
 150  CONTINUE 
CD     CALL TDLPRM(KFILDO,'RDKEYM  ')
CD     WRITE(KFILDO,155)CFROM,NOPREC,KEYREC    
CD155  FORMAT(' EXIT  RDKEYM FROM'2XA6,'   NOPREC ='6I5/
CD    1       (1X6I10))
      GO TO 902 
C 
 900  WRITE(KFILDO,901)KFILX,STATE,CFROM,IOS
 901  FORMAT(/,' ****TROUBLE READING KEY RECORD ON UNIT NO. ',I3,
     1         ' AT STATEMENT ',A4,' IN RDKEYM FROM ',A6,
     2        '.  IOSTAT = ',I4)
      IER=IOS
C
 902  RETURN 
C
      END 
