      SUBROUTINE PKMS97(KFILDO,IS1,ND7,IC,NXY,MINPK,INC,MISSP,MISSS,
     1                  JMAX,JMIN,LBIT,NOV,NDG,LX,IBIT,JBIT,KBIT,
     2                  MINA,IER)
C
C        SEPTEMBER 1994   GLAHN   TDL   MOS-2000
C        MARCH     1997   GLAHN   ADDED DIAGNOSTIC
C        MARCH     1997   GLAHN   CHANGED CALCULATING NUMBER OF BITS 
C                                 THROUGH EXPONENTS TO AN ARRAY
C        JUNE      1997   GLAHN   MAXA ELIMINATED
C        APRIL     1998   GLAHN   ONE DIAGNOSTIC MADE OPTIONAL D
C        APRIL     2000   DALLAVALLE   MODIFIED FORMAT STATEMENTS TO
C                                      CONFORM TO FORTRAN 90 STANDARDS
C                                      ON THE IBM SP
C 
C        PURPOSE 
C            CALLED BY PKMS99 TO ASSIST IN PACKING DATA FOR MOS-2000.
C            IT IS USED WHEN THERE ARE (OR MAY BE) SECONDARY MISSING 
C            VALUES IN THE DATA.  THE SMALLEST VALUE IN IC( )
C            IS SUBTRACTED TO MAKE ALL VALUES POSITIVE, EXCEPT THE
C            MISSING VALUES ARE UNCHANGED.  DO NOT USE THIS ROUTINE
C            WITH MISSS = 0.
C
C        DATA SET USE 
C           KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE. (OUTPUT) 
C
C        VARIABLES 
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT) 
C              IS1(L) = HOLDS THE VALUES FOR GRIB SECTION 1 
C                       (L=1,MAX OF ND7).  CARRIED FOR PRINTING 
C                       IDENTIFICATION OF VARIABLE BEING DEALT WITH 
C                       AS NECESSARY.  (INPUT)
C                 ND7 = DIMENSION IF IS1( ).  (INPUT)
C               IC(K) = HOLDS VALUES TO PACK (K=NXY).  (INPUT)
C                 NXY = THE NUMBER OF VALUES IN IC( ).  ALSO USED AS
C                       THE DIMENSION OF IC( ).  (INPUT)
C               MINPK = VALUES ARE PACKED IN GROUPS OF MINIMUM SIZE
C                       MINPK.  ONLY WHEN THE NUMBER OF BITS TO HANDLE
C                       A GROUP CHANGES WILL A NEW GROUP BE FORMED.
C                       (INPUT)
C                 INC = THE NUMBER OF VALUES TO ADD AT A TIME TO A GROUP.
C                       (INPUT)
C               MISSP = WHEN MISSING POINTS CAN BE PRESENT IN THE DATA,
C                       THEY WILL HAVE THE VALUE MISSP OR MISSS.  MISSP
C                       IS THE PRIMARY MISSING VALUE AND IS USUALLY 9999,
C                       AND 9999 IS HARDCODED IN SOME SOFTWARE.  MISSS
C                       IS THE SECONDARY MISSING VALUE AND ACCOMMODATES
C                       THE 9997 PRODUCED BY SOME EQUATIONS FOR MOS
C                       FORECASTS.  MISSP = 0 INDICATES THAT NO MISSING
C                       VALUES (EITHER PRIMARY OR SECONDARY) ARE PRESENT.
C                       MISSS = 0 INDICATES THAT NO SECONDARY MISSING
C                       VALUES ARE PRESENT.  (INPUT)
C               MISSS = SECONDARY MISSING VALUE INDICATOR (SEE MISSP).
C                       (INPUT)
C             JMAX(M) = THE MAXIMUM OF EACH GROUP M OF PACKED VALUES
C                       AFTER SUBTRACTING THE GROUP MINIMUM VALUE
C                       (M=1,LX).  (OUTPUT)
C             JMIN(M) = THE MINIMUM VALUE SUBTRACTED FOR EACH GROUP
C                       M (M=1,LX).  (OUTPUT)
C             LBIT(M) = THE NUMBER OF BITS NECESSARY TO HOLD THE
C                       PACKED VALUES FOR EACH GROUP M (M=1,LX). 
C                       (OUTPUT)
C              NOV(M) = THE NUMBER OF VALUES IN GROUP M (M=1,LX).
C                       (OUTPUT)
C                 NDG = DIMENSION OF JMAX( ), JMIN( ), LBIT( ), AND
C                       NOV( ).  (INPUT)
C                  LX = THE NUMBER OF GROUPS (THE NUMBER OF 2ND ORDER 
C                       MINIMA).  (OUTPUT)  
C                IBIT = THE NUMBER OF BITS NECESSARY TO PACK THE JMIN(J)
C                       VALUES, J=1,LX.  (OUTPUT)
C                JBIT = THE NUMBER OF BITS NECESSARY TO PACK THE LBIT(J),
C                       VALUES, J=1,LX.  (OUTPUT)
C                KBIT = THE NUMBER OF BITS NECESSARY TO PACK THE NOV(J),
C                       VALUES, J=1,LX.  (OUTPUT)
C                MINA = THE MINIMUM VALUES IN IC( ) BEFORE SUBTRACTING 
C                       THE MINIMUM VALUE.  (OUTPUT)
C                 IER = STATUS RETURN.  (OUTPUT)
C                         0 = GOOD RETURN.
C                       132 = MISSP = 0 OR LBIT( ) IS LT 2.
C              MINPKL = LOCAL VALUE OF MINPK.
C            LB2M1(J) = AN ARRAY THAT WHEN THIS ROUTINE IS FIRST ENTERED
C                       IS SET TO 2**J-1, J=0,30. LB2M1(30) = 2**30-1, WHICH
C                       IS THE LARGEST VALUE PACKABLE, BECAUSE 2**31
C                       IS LARGER THAN THE INTEGER WORD SIZE.  (INTERNAL)
C              IFIRST = SET BY DATA STATEMENT TO 0.  CHANGED TO 1 ON FIRST
C                       ENTRY WHEN LB2M1( ) IS FILLED.  (INTERNAL)
C
C        NON SYSTEM SUBROUTINES CALLED 
C           PACKGP
C
      DIMENSION IS1(ND7)
      DIMENSION IC(NXY)
      DIMENSION JMAX(NDG),JMIN(NDG),NOV(NDG),LBIT(NDG)
C
      DIMENSION LB2M1(0:30),LB2M2(0:30)
C
      SAVE LB2M1,LB2M2
C
      DATA IFIRST/0/
C
C         CALCULATE THE POWERS OF 2 THE FIRST TIME ENTERED.
C
      IER=0
C
      IF(IFIRST.EQ.0)THEN
         IFIRST=1
         LB2M1(0)=0
         LB2M2(0)=-1
C
         DO 100 J=1,30
         LB2M1(J)=(LB2M1(J-1)+1)*2-1
         LB2M2(J)=(LB2M2(J-1)+2)*2-2
 100     CONTINUE
C
      ENDIF
C
      IF(MISSS.NE.0)GO TO 105
C        THIS ROUTINE SHOULD NOT BE USED WHEN MISSS = 0, BECAUSE
C        THIS IS NOT CHECKED IN THE LOOPS FOR EFFICIENCY.
      WRITE(KFILDO,101)
 101  FORMAT(/' ****MISSP IN PKMS97 IS ZERO.')
      IER=132
      GO TO 200
C
C        FIND THE MAX AND MIN VALUES.  INITIALIZE MINA IN CASE
C        ALL VALUES ARE MISSING.
C
 105  MINA=MISSP
      MINPKL=MINPK
C
      DO 110 K=1,NXY
      IF(IC(K).EQ.MISSP.OR.IC(K).EQ.MISSS)GO TO 110
      MINA=IC(K)
      GO TO 120
 110  CONTINUE
C
C        DROP THROUGH HERE MEANS ALL VALUES ARE MISSING.  PRINT A
C        DIAGNOSTIC AND PACK AS SUCH.  IF THIS CAUSES TOO MUCH PRINT,
C        COMPILE WITHOUT THE DIAGNOSTIC (USE "C" OR "D" IN COLUMN 1).
C
D     WRITE(KFILDO,115)(IS1(J),J=9,12),(IS1(J),J=3,7),
D    1                 (IS1(J),J=23,22+IS1(22))
D 115 FORMAT(' ****ALL VALUES IN FIELD '1XI9.9,1XI9.9,1XI9.9,1XI10.3,
D    1       ' FOR DATE ',I5,2I2.2,1X2I2.2,'Z ARE MISSING IN PKMS97'/
D    2       ' '24X,32R1)
C       
C        SET LOCAL VALUE OF MINPK TO NXY SO THAT ONLY ONE GROUP 
C        WILL BE MADE IN PACKGP.  PACKGP WILL MAKE ONLY ONE
C        GROUP ANYWAY, BUT THIS IS MUCH MORE EFFICIENT.
C
      MINPKL=NXY
C
      GO TO 140
C
 120  DO 125 K=2,NXY
      IF(IC(K).EQ.MISSP.OR.IC(K).EQ.MISSS)GO TO 125
      IF(IC(K).LT.MINA)MINA=IC(K)
 125  CONTINUE
C
      DO 130 K=1,NXY
      IF(IC(K).EQ.MISSP.OR.IC(K).EQ.MISSS)GO TO 130
      IC(K)=IC(K)-MINA
C
C        MUST GUARD AGAINST VALUES TO PACK BEING MISSING
C        AFTER SUBTRACTING THE MINIMUM.  THIS COMPROMISES
C        THE VALUE BY 1 UNIT.  BY ADDING 1, THE VALUES IN
C        IC( ) ARE STILL POSITIVE.
C
      IF(IC(K).EQ.MISSP.OR.IC(K).EQ.MISSS)
     1    IC(K)=IC(K)+1
C      
 130  CONTINUE
C
C        CALL PACKGP TO CALCULATE LX, JMIN( ), JMAX( ), LBIT( ),
C        AND NOV( ).
C
 140  CALL PACKGP(KFILDO,IC,NXY,MINPKL,INC,MISSP,MISSS,
     1           JMIN,JMAX,LBIT,NOV,NDG,LX,IBIT,JBIT,KBIT)
C
      K=0
C
      DO 153 L=1,LX
      LB2M1L=LB2M1(LBIT(L))
      LB2M2L=LB2M2(LBIT(L))
C
      IF(LBIT(L).LT.2)THEN
         WRITE(KFILDO,150)LBIT(L),MISSS
 150     FORMAT(/,' ****LBIT(L) =',I2,' IS LT 2 IN PKMS97 FOR MISSS =',
     1          I5)
         IER=132
         GO TO 200
      ENDIF
C
      DO 152 M=1,NOV(L)
      K=K+1
C
      IF(IC(K).EQ.MISSP)THEN
         IC(K)=LB2M1L
      ELSEIF(IC(K).EQ.MISSS)THEN
         IC(K)=LB2M2L
      ELSE
         IC(K)=IC(K)-JMIN(L)
      ENDIF
C
 152  CONTINUE
 153  CONTINUE
C
 200  RETURN
      END
