      SUBROUTINE PKC4LX(KFILDO,IPACK,NDX,LOC,IPOS,
     1                  IC,NXY,NOV,LBIT,LX,L3264B,IER)
C
C        MAY   1997   GLAHN   TDL   HP
C        APRIL 2000   DALLAVALLE   MODIFIED FORMAT STATEMENTS TO
C                                  CONFORM TO FORTRAN 90 STANDARDS
C                                  ON THE IBM SP
C
C        PURPOSE 
C            TO PACK UP TO NXY VALUES INTO IPACK( ).  THE PACKED VALUES
C            ARE TAKEN FROM IC( ) WITH NO REFERENCE VALUE OR 
C            SCALING CONSIDERED.  PKC4LX ELIMINATES THE CALLING OF
C            PKBG, AND RATHER INCORPORATES IT INTO THE LOOP.
C            SINCE THIS IS A HIGHLY USED ROUTINE, ALL REASONABLE
C            ATTEMPTS AT EFFICIENCY MUST BE PURSUED.  THIS IS
C            FOR COMPLEX PACKING, THE COUNTERPART OF PKS4LX FOR
C            SIMPLE PACKING.
C
C        DATA SET USE 
C           KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE. (OUTPUT) 
C
C        VARIABLES 
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT) 
C            IPACK(J) = THE ARRAY HOLDING THE ACTUAL PACKED MESSAGE
C                       (J=1,MAX OF NDX).  (INPUT/OUTPUT)
C                 NDX = DIMENSION OF IPACK( ).  (INPUT)
C                 LOC = HOLDS WORD POSITION IN IPACK OF NEXT VALUE TO
C                       PACK.  (INPUT/OUTPUT)
C                IPOS = HOLDS BIT POSITION IN IPACK(LOC) OF THE FIRST
C                       BIT OF THE NEXT VALUE TO PACK.  (INPUT/OUTPUT)
C               IC(K) = DATA TO PACK (K=1,NXY).  (INPUT)
C                 NXY = DIMENSION OF IC( ).  ALSO, THE NUMBER OF VALUES 
C                       TO BE PACKED UNLESS ALL MEMBERS OF A GROUP
C                       HAVE THE SAME VALUE.  (INPUT)
C              NOV(K) = THE NUMBER OF VALUES PER GROUP (K=1,LX).  (INPUT)
C             LBIT(K) = THE NUMBER OF BITS TO PACK FOR EACH GROUP
C                       (K=1,LX).  (INPUT)
C                  LX = THE NUMBER OF VALUES IN NOV( ) AND LBIT( ).
C                       (INPUT)
C              L3264B = INTEGER WORD LENGTH OF MACHINE BEING USED.
C                       (INPUT)
C                 IER = ERROR RETURN.  (OUTPUT)
C                       1 = NDX IS NOT LARGE ENOUGH TO ACCOMMODATE THE BITS
C                           NECESSARY TO PACK THE VALUES STARTING
C                           AT THE VALUES LOC AND IPOS.
C                       2 = IPOS NOT IN THE RANGE 1-L3264B.
C                       3 = IBIT NOT IN THE RANGE 0-32.
C
C        NON SYSTEM SUBROUTINES CALLED 
C           NONE
C
      DIMENSION IPACK(NDX)
      DIMENSION IC(NXY)
      DIMENSION NOV(LX),LBIT(LX)
C
C        SET ERROR RETURN.
C
      IER=0
C
C        CHECK LEGITIMATE VALUES OF LOC AND IPOS.
C
      IF(IPOS.LE.0.OR.IPOS.GT.L3264B)THEN
         IER=2
         WRITE(KFILDO,101)IPOS,IER
 101     FORMAT(/,' IPOS = ',I6,
     1            ' NOT IN THE RANGE 1 TO L3264B IN PKC4LX.',
     2            ' RETURN FROM PKC4LX WITH IER = ',I4)
         GO TO 900 
      ENDIF
C
      K=0
C
      DO 300 L=1,LX
C
      LBITL=LBIT(L)
C
C        CHECK LEGITIMATE VALUES OF LBIT(L) AND WHETHER
C        NDX IS SUFFICIENT FOR ALL NOV(L) VALUES.
C
      IF(LBITL.LT.0.OR.LBITL.GT.32)THEN
         IER=3
         WRITE(KFILDO,102)LBITL,L,IER
 102     FORMAT(/,' LBIT(L) = ',I6,' FOR L =',I5,'NOT IN THE RANGE',
     1            ' 0 TO 32 IN PKC4LX.',
     2            ' RETURN FROM PKC4LX WITH IER = ',I4)
         GO TO 900
      ENDIF
C
      IF(LBITL*NOV(L).GT.(L3264B+1-IPOS)+(NDX-LOC)*L3264B)THEN
         IER=1
         WRITE(KFILDO,103)NOV(L),LBITL,L,LOC,IPOS,NDX,IER
 103     FORMAT(/,' NOV(L) = ',I9,' AND LBIT(L) = ',I6,' FOR L =',I5,
     1            ' REQUIRE MORE BITS THAN ARE AVAILABLE IN IPACK( ),',
     2            ' WITH LOC =',I8,', IPOS =',I4,', AND NDX =',I8,'.',
     3          /,' RETURN FROM PKC4LX WITH IER =',I4)
         GO TO 900
      ENDIF
C
      DO 290 M=1,NOV(L)
      K=K+1
      IF(LBITL.EQ.0)GO TO 290
C        A GROUP WITH ALL VALUES THE SAME IS OMITTED.
C
      NEWIPOS=IPOS+LBITL
C
      IF(NEWIPOS.LE.L3264B+1)THEN
         CALL MVBITS(IC(K),0,LBITL,IPACK(LOC),L3264B+1-NEWIPOS)
C
         IF(NEWIPOS.LE.L3264B)THEN
            IPOS=NEWIPOS
         ELSE
            IPOS=1
            LOC=LOC+1
         ENDIF
C
      ELSE
         LBITL1=L3264B+1-IPOS
         LBITL2=LBITL-LBITL1
         CALL MVBITS(IC(K),LBITL2,LBITL1,IPACK(LOC),0)
         LOC=LOC+1
         CALL MVBITS(IC(K),0,LBITL2,IPACK(LOC),L3264B-LBITL2)
         IPOS=LBITL2+1
      ENDIF
C
 290  CONTINUE
C
 300  CONTINUE
C
 900  RETURN
      END
