      SUBROUTINE PACKYY(KFILDO,IC,IA,IPACK,NXY,MISSP,MINPK,
     1                  IFIRST,IFOD,SECOND)
C
C        APRIL 1997   GLAHN   MODIFIED PACKXX TO HANDLE PRIMARY MISSING
C                             VALUES.
C 
C        PURPOSE 
C            USED TO DETERMINE WHETHER TO USE SECOND ORDER
C            DIFFERENCES OR ORIGINAL VALUES TO PACK.  ORIGINAL VALUES
C            ARE INDICATED WHEN THE AVERAGE RANGE OF CONSECUTIVE GROUPS
C            OF SIZE MINPK OF THE SECOND ORDER DIFFERENCES IS
C            LARGER THAN THE AVERAGE RANGE OF CONSECUTIVE GROUPS OF
C            SIZE MINPK OF THE ORIGINAL VALUES.  NOTE THAT THIS 
C            PROCEDURE DOES NOT IN GENERAL USE THE SAME GROUPS AS ARE
C            USED IN THE ACTUAL PACKING BECAUSE IT DOES NOT EMPLOY THE
C            LOOKBACK PROCEDURE.  THIS ALGORITHM IS RELATIVELY CHEAP
C            AND GIVES A RESULT GOOD ENOUGH FOR THE PURPOSE.  THIS
C            ROUTINE IS USED WHEN THERE CAN BE MISSING PRIMARY
C            VALUES (I.E., A MISSING VALUE INDICATOR, MISSP, CAN BE
C            IN THE DATA).
C
C        DATA SET USE 
C           KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE. (OUTPUT) 
C
C        VARIABLES 
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT) 
C               IC(K) = HOLDS THE NXY ORIGINAL VALUES ON INPUT (K=1,NXY).
C                       HOLDS THE NXY SECOND ORDER DIFFERENCES ON
C                       OUTPUT WHEN SECOND ORDER DIFFERENCES ARE TO BE
C                       USED.  IN THAT CASE, SECOND IS .TRUE.  SINCE
C                       THERE ARE ONLY NXY-2 VALUES, THE FIRST 2 NON-MISSING
C                       VALUES ARE DUMMY.  (INPUT-OUTPUT)
C               IA(K) = WORK ARRAY (K=1,NXY).  (INTERNAL)
C            IPACK(K) = WORK ARRAY (K=1,NXY).  (INTERNAL)
C                 NXY = NUMBER OF VALUES IN IC( ) ON INPUT.  ON RETURN,
C                       NXY WILL ALSO BE THE NUMBER OF VALUES IN IC( ).
C                       USED AS DEMENSION OF IC( ) AND IA( ).  (INPUT-OUTPUT)
C               MISSP = PRIMARY MISSING VALUE INDICATOR.  (INPUT)
C               MINPK = INCREMENT IN WHICH RANGES WILL BE COMPUTED.  (INPUT)
C              IFIRST = IFIRST IS THE FIRST ORIGINAL VALUE.  (OUTPUT)
C                IFOD = IFOD IS THE FIRST FIRST ORDER DIFFERENCE.  (OUPUT)
C              SECOND = TRUE (FALSE) WHEN SECOND ORDER DIFFERENCES
C                       ARE (ARE NOT) TO BE USED.  (OUTPUT)
C
C        NON SYSTEM SUBROUTINES CALLED 
C           NONE
C
      LOGICAL SECOND,KFIRST
C
      DIMENSION IC(NXY),IA(NXY),IPACK(NXY)
C 
C        INITIALIZE IFIRST, IFOD, IA(1), AND ICKEEP.
C
      IFIRST=IC(1)
      IA(1)=0
      IF(IC(1).EQ.MISSP)IA(1)=MISSP
      IFOD=MISSP
      ICKEEP=IC(1)
C
C        COMPUTE FIRST ORDER DIFFERENCES.
C
      DO 120 K=2,NXY
      IF(ICKEEP.EQ.MISSP)THEN
         IA(K)=MISSP
         ICKEEP=IC(K)
      ELSE
C
         IF(IC(K).EQ.MISSP)THEN
            IA(K)=MISSP
         ELSE
            IA(K)=IC(K)-ICKEEP
            ICKEEP=IC(K)
         ENDIF
C
      ENDIF         
C
      IF(IFIRST.EQ.MISSP)THEN
         IF(IC(K).NE.MISSP)THEN
            IFIRST=IC(K)
            IA(K)=0
         ENDIF
      ELSE
         IF(IFOD.EQ.MISSP)IFOD=IA(K)
      ENDIF
C
C
 120  CONTINUE
C
C***D     WRITE(KFILDO,121)(IC(K),K=1,10000)
C***D121  FORMAT(/' ORIGINAL SCALED VALUES'/(' '10I11))
C
C***D     WRITE(KFILDO,1210)IFIRST,IFOD
C***D1210 FORMAT(/' IFIRST ='I11,'     IFOD ='I11)
C***D     WRITE(KFILDO,122)(IA(K),K=1,100)
C***D122  FORMAT(/ 'FIRST ORDER DIFFERENCES'/(' '10I11))
C
C        COMPUTE SECOND ORDER DIFFERENCES.
C
      IAKEEP=MISSP
      KFIRST=.TRUE.
C
      DO 130 K=1,NXY
      IF(KFIRST)THEN
         IPACK(K)=IA(K)
         IF(IA(K).NE.MISSP)KFIRST=.FALSE.
      ELSE
C
         IF(IAKEEP.EQ.MISSP)THEN
C
            IF(IA(K).NE.MISSP)THEN
               IPACK(K)=IA(K)
               IF(IA(K).NE.MISSP)IAKEEP=IA(K)
            ELSE
               IPACK(K)=MISSP
            ENDIF
C
         ELSE
C
            IF(IA(K).EQ.MISSP)THEN
               IPACK(K)=MISSP
            ELSE
               IPACK(K)=IA(K)-IAKEEP
               IAKEEP=IA(K)
            ENDIF
C
         ENDIF
C
      ENDIF
 130  CONTINUE
C
C***D     WRITE(KFILDO,131)(IPACK(K),K=1,10000)
C***D131  FORMAT(/' SECOND ORDER DIFFERENCES'/(' '10I11))
C
C        COMPUTE AVERAGE RANGE OF NXY ORIGINAL VALUES IN INCREMENTS OF 
C        MINPK.
C
      SUMR=0
      KOUNT=0
C 
      DO 140 K=1,NXY,MINPK
      JMIN=999999
      JMAX=-999999
      IF(K+MINPK-1.GT.NXY)GO TO 140
C        THE LAST GROUP MAY BE VERY SMALL AND NOT BE REPRESENTATIVE OF
C        THE RANGE.
C
      DO 135 J=K,K+MINPK-1
      IF(IC(J).EQ.MISSP)GO TO 135
      IF(IC(J).GT.JMAX)JMAX=IC(J)
      IF(IC(J).LT.JMIN)JMIN=IC(J)
 135  CONTINUE
C
      KOUNT=KOUNT+1
      IF(JMIN.EQ.999999)THEN
         IRANGE=0
      ELSE
         IRANGE=JMAX-JMIN
         SUMR=SUMR+IRANGE 
      ENDIF   
C
 140  CONTINUE
C
      AVGR=99999.
      IF(KOUNT.NE.0)AVGR=SUMR/KOUNT
C
C        COMPUTE AVERAGE RANGE OF NXY-4 2ND ORDER VALUES IN 
C        INCREMENTS OF MINPK.   DON'T USE THE FIRST 2 VALUES,
C        BECAUSE THEY COULD BE BASED ON MISSING VALUES.
C
      SUMR=0
      KOUNT=0
C 
      DO 150 K=3,NXY-2,MINPK
      JMIN=999999
      JMAX=-999999
      IF(K+MINPK-1.GT.NXY-2)GO TO 150
C        THE LAST GROUP MAY BE VERY SMALL AND NOT BE REPRESENTATIVE OF
C        THE RANGE.
C
      DO 145 J=K,K+MINPK-1
      IF(IA(J).EQ.MISSP)GO TO 145
      IF(IA(J).GT.JMAX)JMAX=IA(J)
      IF(IA(J).LT.JMIN)JMIN=IA(J)
 145  CONTINUE
C
      KOUNT=KOUNT+1
      IF(JMIN.EQ.999999)THEN
         IRANGE=0
      ELSE
         IRANGE=JMAX-JMIN
         SUMR=SUMR+IRANGE 
      ENDIF   
 
  150  CONTINUE
C
      AVGR2=99999.
      IF(KOUNT.NE.0)AVGR2=SUMR/KOUNT
C
      SECOND=.FALSE.
C***D     WRITE(KFILDO,155)AVGR,AVGR2
C***D155  FORMAT(/' AVERAGE RANGE OF ORIGINAL SCALED VALUES =  'F10.2/
C***D    1        ' AVERAGE RANGE OF SECOND ORDER DIFFERENCES ='F10.2)
      IF(AVGR2.GE.AVGR)GO TO 300
C        ON TRANSFER, SECOND ORDER DIFFERENCES WILL NOT BE PACKED
C
C        SECOND ORDER DIFFERENCES WILL BE PACKED.
C
C***D     WRITE(KFILDO,160)
C***D160  FORMAT(' SECOND ORDER DIFFERENCES WILL BE PACKED')
C
C        TRANSFER IPACK( ) TO IC( ).
C
      KOUNT=0
C
      DO 180 K=1,NXY
      IC(K)=IPACK(K)
 180  CONTINUE
C
C***D     WRITE(KFILDO,201)(IC(K),K=1,100)
C***D201  FORMAT(/' SECOND ORDER DIFFERENCES TO BE PACKED'/(' '10I11))
C
      SECOND=.TRUE.
 300  CONTINUE
      RETURN
      END

