      SUBROUTINE PACKXX(KFILDO,IC,IA,NXY,MINPK,
     1                  IFIRST,IFOD,SECOND)
C
C        FEBRUARY 1994   GLAHN   TDL   MOS-2000
C        MARCH    1997   GLAHN   SLIGHT DIAGNOSTIC CHANGE.
C 
C        PURPOSE 
C            USED TO DETERMINE WHETHER TO USE SECOND ORDER
C            DIFFERENCES OR ORIGINAL VALUES TO PACK.  ORIGINAL VALUES
C            ARE INDICATED WHEN THE AVERAGE RANGE OF CONSECUTIVE GROUPS
C            OF SIZE MINPK OF THE SECOND ORDER DIFFERENCES IS
C            LARGER THAN THE AVERAGE RANGE OF CONSECUTIVE GROUPS OF
C            SIZE MINPK OF THE ORIGINAL VALUES.  NOTE THAT THIS 
C            PROCEDURE DOES NOT IN GENERAL USE THE SAME GROUPS AS ARE
C            USED IN THE ACTUAL PACKING BECAUSE IT DOES NOT EMPLOY THE
C            LOOKBACK PROCEDURE.  THIS ALGORITHM IS RELATIVELY CHEAP
C            AND GIVES A RESULT GOOD ENOUGH FOR THE PURPOSE.  THIS
C            ROUTINE IS NOT NORMALLY USED WHEN THERE ARE MISSING
C            VALUES (I.E., A MISSING VALUE INDICATOR IS IN THE DATA).
C
C        DATA SET USE 
C           KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE. (OUTPUT) 
C
C        VARIABLES 
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT) 
C               IC(K) = HOLDS THE NXY ORIGINAL VALUES ON INPUT (K=1,NXY).
C                       HOLDS THE NXY SECOND ORDER DIFFERENCES ON
C                       OUTPUT WHEN SECOND ORDER DIFFERENCES ARE TO BE
C                       USED.  IN THAT CASE, SECOND IS .TRUE.  SINCE
C                       THERE ARE ONLY NXY-2 VALUES, THE FIRST 2 ARE
C                       DUMMY.  THAT IS, THE FIRST SECOND ORDER 
C                       DIFFERENCE IN IS IC(3).  IC(1)=IC(2)=IC(3).
C                       THIS MAKES FOR EASE OF CODING WHEN UNPACKING.
C                       (INPUT-OUTPUT)
C               IA(K) = WORK ARRAY (K=1,NXY).  (INTERNAL)
C                 NXY = NUMBER OF VALUES IN IC( ) ON INPUT.  ON RETURN,
C                       NXY WILL ALSO BE THE NUMBER OF VALUES IN IC( ).
C                       USED AS DEMENSION OF IC( ) AND IA( ).  (INPUT-OUTPUT)
C               MINPK = INCREMENT IN WHICH RANGES WILL BE COMPUTED.  (INPUT)
C              IFIRST = IFIRST IS THE FIRST ORIGINAL VALUE.  (OUTPUT)
C                IFOD = IFOD IS THE FIRST FIRST ORDER DIFFERENCE.  (OUPUT)
C              SECOND = TRUE (FALSE) WHEN SECOND ORDER DIFFERENCES
C                       ARE (ARE NOT) TO BE USED.  (OUTPUT)
C
C        NON SYSTEM SUBROUTINES CALLED 
C           NONE
C
      LOGICAL SECOND
C
      DIMENSION IC(NXY),IA(NXY)
C 
C        COMPUTE FIRST ORDER DIFFERENCES AND INITIALIZE IFIRST AND IFOD.
C
      IFIRST=IC(1)
      IFOD=IC(2)-IC(1)
C
      DO 120 K=1,NXY-1
      IA(K)=IC(K+1)-IC(K)
 120  CONTINUE
C
C***D     WRITE(KFILDO,121)(IC(K),K=1,NXY)
C***D121  FORMAT(/' ORIGINAL SCALED VALUES'/(' '20I6))
C
C***D     WRITE(KFILDO,122)(IA(K),K=1,NXY-1)
C***D122  FORMAT(/ 'FIRST ORDER DIFFERENCES'/(' '20I6))
C
C        COMPUTE SECOND ORDER DIFFERENCES
C
      DO 130 K=1,NXY-2
      IA(K)=IA(K+1)-IA(K)
 130  CONTINUE
C
C***D     WRITE(KFILDO,131)(IA(K),K=1,NXY-2)
C***D131  FORMAT(/' SECOND ORDER DIFFERENCES'/(' '20I6))
C
C        COMPUTE AVERAGE RANGE OF NXY ORIGINAL VALUES IN INCREMENTS OF 
C        MINPK.
C
      SUMR=0
      KOUNT=0
C 
      DO 140 K=1,NXY,MINPK
      JMIN=999999
      JMAX=-999999
      IF(K+MINPK-1.GT.NXY)GO TO 140
C        THE LAST GROUP MAY BE VERY SMALL AND NOT BE REPRESENTATIVE OF
C        THE RANGE.
C
      DO 135 J=K,K+MINPK-1
      IF(IC(J).GT.JMAX)JMAX=IC(J)
      IF(IC(J).LT.JMIN)JMIN=IC(J)
 135  CONTINUE
C
      KOUNT=KOUNT+1
      IRANGE=JMAX-JMIN
      SUMR=SUMR+IRANGE    
 140  CONTINUE
C
      AVGR=99999.
      IF(KOUNT.NE.0)AVGR=SUMR/KOUNT
C
C        COMPUTE AVERAGE RANGE OF NXY-2 2ND ORDER VALUES IN INCREMENTS OF 
C        MINPK.
C
      SUMR=0
      KOUNT=0
C 
      DO 150 K=1,NXY-2,MINPK
      JMIN=999999
      JMAX=-999999
      IF(K+MINPK-1.GT.NXY-2)GO TO 150
C        THE LAST GROUP MAY BE VERY SMALL AND NOT BE REPRESENTATIVE OF
C        THE RANGE.
C
      DO 145 J=K,K+MINPK-1
      IF(IA(J).GT.JMAX)JMAX=IA(J)
      IF(IA(J).LT.JMIN)JMIN=IA(J)
 145  CONTINUE
C
      KOUNT=KOUNT+1
      IRANGE=JMAX-JMIN
      SUMR=SUMR+IRANGE    
 150  CONTINUE
C
      AVGR2=99999.
      IF(KOUNT.NE.0)AVGR2=SUMR/KOUNT
C
      SECOND=.FALSE.
C***D     WRITE(KFILDO,155)AVGR,AVGR2
C***D155  FORMAT(/' AVERAGE RANGE OF ORIGINAL SCALED VALUES =  'F10.2/
C***D    1        ' AVERAGE RANGE OF SECOND ORDER DIFFERENCES ='F10.2)
      IF(AVGR2.GE.AVGR)GO TO 300
C        SECOND ORDER DIFFERENCES WILL BE PACKED.
C
C***D     WRITE(KFILDO,160)
C***D160  FORMAT(' SECOND ORDER DIFFERENCES WILL BE PACKED')
C
      IC(1)=IA(1)
      IC(2)=IA(1)
C
      DO 200 K=1,NXY-2
      IC(K+2)=IA(K)
 200  CONTINUE
C
C***D     WRITE(KFILDO,201)(IC(K),K=1,200)
C***D201  FORMAT(/' SECOND ORDER DIFFERENCES TO BE PACKED'/(' '20I6))
C
      SECOND=.TRUE.
 300  CONTINUE
      RETURN
      END

