      SUBROUTINE LMIJLL(KFILDO,XI,YJ,XMESHL,ORIENT,XLAT,
     1                  XLATLL,XLONLL,ALAT,ALON,IER)
C
C        FEBRUARY 1995   GLAHN   TDL   HP9000
C        APRIL    2000   DALLAVALLE    MODIFIED FORMAT STATEMENTS TO
C                                CONFORM TO FORTRAN 90 STANDARDS
C                                ON THE IBM SP
C        MAY      2002   GLAHN   COMMENT INSERTED ABOVE TEST FOR 
C                                OLDRML TO INDICATE A MINOR
C                                PROBLEM WITH THE ORIGINAL W3FB12.
C        JULY     2002   GLAHN   ADDED DIAGNOSTIC PRINT 100
C        AUGUST   2002   WIEDENFELD, GLAHN  ADDED OLDXLONLL AND
C                                OLDORIENT
C
C        PURPOSE
C            CONVERTS THE COORDINATES OF A LOCATION ON EARTH GIVEN IN A
C            GRID COORDINATE SYSTEM OVERLAID ON A LAMBERT CONFORMAL TANGENT
C            CONE PROJECTION TRUE AT A GIVEN N LATITUDE TO THE
C            LATITUDE/LONGITUDE.  LMIJLL IS THE REVERSE OF LMLLIJ.
C            USES GRIB SPECIFICATION OF THE LOCATION OF THE GRID.
C            BASED ON NMC W3FB12 WITH SLIGHT MODIFICATION OF INPUT
C            AND OUTPUT.  LONGITUDES IN THIS ROUTINE ARE INPUT AS 
C            (POSITIVE) W AND MESH LENGTH IS IN M.  EXCEPT FOR INPUT
C            XLONLL AND ORIENT, CODE IS BASED ON EAST LONGITUDE, AS IS
C            W3FB12.  ORIGINAL AUTHOR WAS STACKPOLE 11/25/88.
C            FORMULAE AND NOTATION LOOSELY BASED ON HOKE, HAYES,
C            AND RENNINGER'S "MAP PROJECTIONS AND GRID SYSTEMS...",
C            MARCH 1981, AFGWC/TN-79/003.  A SAVE STATEMENT WAS ADDED 
C            TO RETAIN THE VALUES OF VARIABLES FROM CALL TO CALL.
C
C
C        DATA SET USE
C            KFILDO - UNIT NUMBER OF OUTPUT (PRINT) FILE.  (OUTPUT)
C
C        VARIABLES
C            INPUT
C              KFILDO = UNIT NUMBER OF OUTPUT (PRINT) FILE.
C                  XI = IX (LEFT TO RIGHT) GRIDPOINT FOR WHICH THE
C                       LATITUDE AND LONGITUDE ARE WANTED.
C                  YJ = JY (BOTTON TO TOP) GRIDPOINT FOR WHICH THE
C                       LATITUDE AND LONGITUDE ARE WANTED.
C              XMESHL = MESH LENGTH IN METERS AT XLAT DEGREES N LATITUDE.
C              ORIENT = ORIENTATION IN DEGREES WEST LONGITUDE.  DON'T
C                       USE NEGATIVE.
C                XLAT = NORTH LATITUDE IN DEGREES AT WHICH XMESHL APPLIES.
C                       ALSO, THE LATITUDE OF TANGENCY OF THE LAMBERT MAP.
C                       DON'T USE NEGATIVE.
C              XLATLL = LATITUDE OF LOWER LEFT (1,1) CORNER POINT OF 
C                       THE GRID.
C              XLONLL = LONGITUDE OF LOWER LEFT (1,1) CORNER POINT OF
C                       THE GRID.  DON'T USE NEGATIVE.
C
C            OUTPUT
C                ALAT = NORTH LATITUDE IN DEGREES OF THE POINT CORRESPONDING
C                       TO XI, YJ.
C                ALON = WEST LONGITUDE IN DEGREES OF THE POINT CORRESPONDING
C                       TO XI, YJ.
C                 IER = ERROR RETURN.
C                         0 = GOOD RETURN.
C                       105 = THE REQUESTED XI,YJ POINT IS IN THE
C                             FORBIDDEN ZONE, I.E. OFF THE LAMBERT MAP
C                             IN THE OPEN SPACE WHERE THE CONE IS CUT.
C                             IN THIS CASE, ALAT=9999. AND ELON=9999.
C
C            INTERNAL
C                  PI = PI.  (SET BY PARAMETER)
C               RERTH = RADIUS OF THE EARTH IN METERS.  (SET BY PARAMETER)
C              RADPDG = NUMBER OF RADIANS PER DEGREE.  (SET BY PARAMETER)
C               RXLAT = XLAT CONVERTED TO RADIANS.
C              REBYDX = RADIUS OF THE EARTH DIVIDED BY MESH LENGTH.
C              RLATLL = XLATLL CONVERTED TO RADIANS.
C              RLONLL = LONGITUDE IN RADIANS.
C                RLAT = ALAT CONVERTED TO RADIANS.
C                RLON = LONGITUDE IN RADIANS.
C               POLEI = IX N POLE POSITION, RELATIVE TO LL CORNER.
C               POLEJ = JY N POLE POSITION, RELATIVE TO LL CORNER.
C
C        NONSYSTEM SUBROUTINES CALLED
C            NONE.
C
      PARAMETER (PI=3.14159,
     1           RERTH=6371200.,
     2           RADPDG=PI/180.)
C
      LOGICAL NEWMAP
C
      DATA OLDRML/99999./,
     1     OLDXLONLL/99999./,
     2     OLDORIENT/99999./
C
      SAVE ELO1,ARG,POLEI,POLEJ,THING,ANINV2
C
      IER = 0
C
      IF(XMESHL.LE.0..OR.ORIENT.LT.0..OR.XLAT.LT.0..OR.XLONLL.LT.0.)THEN
         WRITE(KFILDO,100)XMESHL,ORIENT,XLAT,XLONLL
 100     FORMAT(/' ****PROBLEM WITH EITHER'/
     1           '     XMESHL =',F12.4,','/
     2           '     ORIENT =',F12.4,','/
     3           '     XLAT   =',F12.4,', OR'/
     4           '     XLONLL =',F12.4,'.'/
     5           '     STOP IN LMIJLL AT 100.')
         STOP 100
      ENDIF
C
      ELON1=360.-XLONLL
      ELONV=360.-ORIENT
C
C        PRELIMINARY VARIABLES AND REDEFINITIONS
C
      PIBY2 = PI/2.
      DEGPRD = 1./RADPDG
      REBYDX = RERTH/XMESHL
      ALATN1 = XLAT * RADPDG
      AN = SIN(ALATN1)
      COSLTN = COS(ALATN1)
C
C        MAKE SURE THAT INPUT LONGITUDE DOES NOT PASS THROUGH
C        THE CUT ZONE (FORBIDDEN TERRITORY) OF THE FLAT MAP
C        AS MEASURED FROM THE VERTICAL (REFERENCE) LONGITUDE
C
      ELON1L = ELON1
      IF((ELON1-ELONV).GT. 180.)ELON1L = ELON1 - 360.
      IF((ELON1-ELONV).LT.-180.)ELON1L = ELON1 + 360.
C
      ELONVR = ELONV * RADPDG
C
C        RADIUS TO LOWER LEFT (LL) CORNER
C
      ALA1 = XLATLL * RADPDG
      RMLL = REBYDX * ((COSLTN**(1.-AN))*(1.+AN)**AN) *
     1        (((COS(ALA1))/(1.+SIN(ALA1)))**AN)/AN
C
C        USE RMLL TO TEST IF MAP AND GRID UNCHANGED FROM PREVIOUS
C        CALL TO THIS CODE.  THUS AVOID UNNEEDED RECOMPUTATIONS.
C
C*****************************************************************
C        IT WAS NOTED BY GLAHN IN USING WEFB12 11/28/98 THAT A
C        SMALL DIFFERENCE IN THE INPUT LONGITUDE OF THE (1,1)
C        POINT MIGHT NOT CAUSE A CHANGE IN RMLL, WITH THE RESULT
C        THAT THE OUTPUT WOULD BE EXACTLY THE SAME.  W3FB12 WAS
C        MODIFIED TO ELIMINATE THE SAVING OF OLDRML AND THE TEST
C        BELOW.  THIS SHOULD HAVE NO EFFECT ON USE OF THIS
C        ROUTINE IN MOS-2000.  A REVISED VERSION OF WEFB12 EXISTS
C        IN HOME22/TDL/GLAHN/AWIPSCORNERS.
C*****************************************************************
C        TESTING IN AUGUST 2002 REVEALED THAT THE ADDITIONAL
C        CHECKS ON XLONLL AND ORIENT WERE NECESSARY.
C*****************************************************************
      IF(RMLL.EQ.OLDRML.AND.XLONLL.EQ.OLDXLONLL.AND.
     1   ORIENT.EQ.OLDORIENT) THEN
        NEWMAP = .FALSE.
      ELSE
        NEWMAP = .TRUE.
        OLDRML = RMLL
        OLDXLONLL = XLONLL
        OLDORIENT = ORIENT
C
C          USE LL POINT INFO TO LOCATE POLE POINT
C
        ELO1 = ELON1L * RADPDG
        ARG = AN * (ELO1-ELONVR)
        POLEI = 1. - RMLL * SIN(ARG)
        POLEJ = 1. + RMLL * COS(ARG)
      ENDIF
C
C        RADIUS TO THE I,J POINT (IN GRID UNITS)
C        YY REVERSED SO POSITIVE IS DOWN
C
      XX = XI - POLEI
      YY = POLEJ - YJ
      R2 = XX**2 + YY**2
C
C        CHECK THAT THE REQUESTED I,J IS NOT IN THE FORBIDDEN ZONE
C        YY MUST BE POSITIVE UP FOR THIS TEST
C
      THETA = PI*(1.-AN)
      BETA = ABS(ATAN2(XX,-YY))
      IF(BETA.LE.THETA) THEN
        IER = 105
        ALAT = 9999.
        ALON = 9999.
        WRITE(KFILDO,150)XI,YJ,XMESHL,ORIENT,XLAT
 150    FORMAT(/,' ****PROBLEM IN LMIJLL IN COMPUTING LAT/LON FOR',
     1           ' XI =',I4,'  YJ =',I4,'  XMESHL =',F10.0,
     2           '  ORIENT =',F6.0,'  XLAT =',F6.0)
        IF(.NOT.NEWMAP) GO TO 200
      ENDIF
C
C        NOW THE MAGIC FORMULAE
C
      IF(R2.EQ.0.) THEN
        ALAT = 90.
        ELON = ELONV
      ELSE
C
C          FIRST THE LONGITUDE
C
        ELON = ELONV + DEGPRD * ATAN2(XX,YY)/AN
        ELON = AMOD(ELON+360., 360.)
C
C          NOW THE LATITUDE
C          RECALCULATE THE THING ONLY IF MAP IS NEW SINCE LAST TIME
C
        IF(NEWMAP) THEN
           ANINV = 1./AN
           ANINV2 = ANINV/2.
           THING = ((AN/REBYDX) ** ANINV)/
     1      ((COSLTN**((1.-AN)*ANINV))*(1.+ AN))
        ENDIF
        ALAT = (PIBY2 - 2.*ATAN(THING*(R2**ANINV2)))*DEGPRD
      ENDIF
C
      ALON=360.-ELON
C
C        FOLLOWING TO ASSURE ERROR VALUES IF FIRST TIME THRU
C        IS OFF THE MAP
C
      IF(IER.NE.0) THEN
         ALAT = 9999.
         ALON = 9999.
         IER = 105
         WRITE(KFILDO,150)XI,YJ,XMESHL,ORIENT,XLAT
      ENDIF
C
CD     WRITE(KFILDO,199)XI,YJ,XMESHL,ORIENT,XLAT,
CD    1                 XLATLL,XLONLL,ALAT,ALON,IER
CD199  FORMAT(/' IN LLIJLL--XI,YJ,XMESHL,ORIENT,XLAT,',
CD    1                 'XLATLL,XLONLL,ALAT,ALON,IER'/
CD    2                 10F10.1)

 200  RETURN
      END
