      SUBROUTINE CKFILEND(KFILDO,FUNIT,FNAME,ISYSEND,IFILEND,
     1                    CONVERTX,IER)
C
C        MAY       2012 ENGLE        MDL   MOS-2000 CREATED
C
C        PURPOSE
C            TO CHECK THE ENDIAN OF A TDLPACK SEQUENTIAL FILE.
C            THE FILE CAN BE EITHER VECTOR OR GRIDDED.
C
C        DATA SET USE
C           KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE. (OUTPUT)
C            FUNIT - UNIT NUMBER FOR INPUT TDLPACK FILE. (INPUT)
C
C        VARIABLES
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT)
C               FUNIT = UNIT NUMBER FOR INPUT TDLPACK FILE. (INPUT)
C               FNAME = CHARACTER VARAIBLE HOLDING THE TDLPACK
C                       FILE NAME. CHARACTER*1024) (INPUT)
C             ISYSEND = HOLD THE VALUE THAT REPRESENTS THE SYSTEM
C                       ENDIAN. (INPUT/OUTPUT)
C                       THIS IS SET BY CALLING CKSYSEND
C                        -1 = SYSTEM IS LITLE-ENDIAN.
C                         1 = SYSTEM IS BIG-ENDIAN.
C             IFILEND = HOLD THE VALUE THAT REPRESENTS THE ENDIAN OF THE
C                       INPUT TDLPACK FILE. (INPUT/OUTPUT)
C            CONVERTX = HOLDS THE STRING THAT WILL TELL THE AN OPEN
C                       STATEMENT HOW TO CONVERT THE FILE.
C                       (CHARACTER*20) (OUTPUT)
C                 IER = STATUS RETURN FROM SUBROUTINE. (OUTPUT)
C                         0 = GOOD VALUE.
C
C        NONSYSTEM SUBROUTINES CALLED
C           NONE
C
C
      IMPLICIT NONE
C
C        I/O VARIABLES
C
      CHARACTER*20 :: CONVERTX
      CHARACTER*1024 :: FNAME
      INTEGER :: KFILDO,FUNIT,ISYSEND,IFILEND,IOS,IER
C
C        INTERNAL VARIABLES
C
      INTEGER :: I,IDRL,IFRL,IPAD,ITDLP,IPLDT
      INTEGER(KIND=1) :: IPACK1(12)
      LOGICAL :: OPENX
C
      IER=0
      IFILEND=0
C
C        DETERMINE SYSTEM ENDIAN.
C
      CALL CKSYSEND(KFILDO,'NOPRINT',ISYSEND,IER)
C
C
C        CHECK IF THE UNIT IS OPEN. STOP IF IT IS.
C
      INQUIRE(UNIT=FUNIT,OPENED=OPENX)
      IF(OPENX.EQV..TRUE.)THEN
          WRITE(KFILDO,100)FUNIT,FNAME
 100      FORMAT(/,' ****CHECKING ENDIAN OF FILE ON UNIT NO. ',I3,
     1             ' ',A60,'. FILE NEEDS TO BE CLOSED.')
          STOP 100
      ENDIF
C
C        OPEN THE TDLPACK WITH STREAM ACCESS. THIS ALLOWS US
C        TO MANUALLY READ THE FORTRAN RECORD LENGTH INFORMATION.
C
COPER
C        FOR OPERATIONS, THE FILE= SPECIFIER IS OMITTED.
C      OPEN(UNIT=FUNIT,FORM='UNFORMATTED',ACCESS='STREAM',
C     1     IOSTAT=IOS,ERR=900,STATUS='OLD')
COPER
CDEV
      OPEN(UNIT=FUNIT,FILE=FNAME,FORM='UNFORMATTED',
     1     ACCESS='STREAM',IOSTAT=IOS,ERR=900,STATUS='OLD')
CDEV
C
C        READ THE FIRST 12 BYTES OF THE FILE. THIS SHOULD
C        BE SUFFICIENT FOR DETERMINING THE FILE ENDIAN.
C        TRANSFER BYTES INTO THEIR RESPECTIVE VARIABLES
C        FOR TESTING.
C
      READ(FUNIT,END=900)(IPACK1(I),I=1,12)
      IFRL=TRANSFER(IPACK1(1:4),IFRL)
      IPAD=TRANSFER(IPACK1(5:8),IPAD)
      IDRL=TRANSFER(IPACK1(9:12),IDRL)
C
C        DETERMINE THE FILE ENDIAN.
C
      IF(IFRL.LE.0)THEN
C        THE FORTRAN RECORD LENGTH APPEARS IS ZERO
C        OR NEGATIVE. THIS SHOULD NOT EXIST.
C        THEREFORE, THE FILE ENDIAN IS OPPOSITE
C        THE SYSTEM. SET IFILEND ACCORDINGLY.
        IFILEND=-ISYSEND
        GO TO 905
      ENDIF
C
C        THE FORTRAN RECORD LENGTH IS POSTIVE. AT THIS POINT,
C        WE CANNOT DETERMINE THE ENDIAN OF THE FILE. WE NEED
C        TO LOOK FURTHER INTO THE FILE.
C
      IF(IDRL.LE.0)THEN
C          DATA RECORD LENGTH IS NEGATIVE. SET IFILEND.
        IFILEND=-ISYSEND
        GO TO 905
      ELSE
C          AT THIS POINT, THE FORTRAN RECORD LENGTH AND
C          DATA RECORD LENGTH ARE POSITIVE. THIS DOES NOT
C          MEAN WE HAVE THE CORRECT ENDIAN
        IF(IDRL.EQ.IFRL-8)THEN
C          THIS IS TRUE SO THE FILE IS THE SAME ENDIAN AS THE SYSTEM.
          IFILEND=ISYSEND
          GO TO 900       
        ELSE
          IFILEND=-ISYSEND
          GO TO 905
        ENDIF
      ENDIF
C
C        SET CONVERTX.
C
 900  CONVERTX='NATIVE'
      GO TO 910
 905  IF(IFILEND.EQ.-1)THEN
        CONVERTX='LITTLE_ENDIAN'
      ELSEIF(IFILEND.EQ.1)THEN
        CONVERTX='BIG_ENDIAN'
      ENDIF
 910  CLOSE(FUNIT)
      RETURN
      END SUBROUTINE CKFILEND
