/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef PYBULLET_VISUALIZER_API_H
#define PYBULLET_VISUALIZER_API_H

#include <string>

#include <SharedMemory/b3RobotSimulatorClientAPI_NoGUI.h>

/// The PyBulletVisualizerAPI is pretty much the C++ version of pybullet
/// as documented in the pybullet Quickstart Guide
/// https://docs.google.com/document/d/10sXEhzFRSnvFcl3XxNGhnD4N2SedqwdAvK3dsihxVUA
class PyBulletVisualizerAPI : public b3RobotSimulatorClientAPI_NoGUI {
 public:
  PyBulletVisualizerAPI();

  virtual ~PyBulletVisualizerAPI();

  bool connect(int mode, const std::string &hostName = "localhost",
               int portOrKey = -1);
};

#endif  // PYBULLET_VISUALIZER_API_H
