from typing import Any, Optional, List, TextIO, Union

class CronValue(object):
    def __init__(self, value: str, enums: List[str]) -> None: ...

class CronRange(object):
    def __init__(self, vslice, *vrange):  # type: (CronSlice, Union[int, CronValue]) -> None
        ...

class CronSlice(object):
    def __init__(self, info: int, value: Optional[str] = None) -> None: ...
    def on(self, *n_value: Union[int, str], **opts: bool) -> List[Union[int, CronRange]]: ...
    def every(self, n_value: Union[int, str], also: bool = False) -> List[Union[int, CronRange]]: ...

class CronTab:
    def __init__(
        self,
        user: Optional[Union[str, bool]] = None,
        tab: Optional[str] = None,
        tabfile: Optional[TextIO] = None,
        log: Optional[str] = None,
    ) -> None: ...
    def __enter__(self):  # type: () -> CronTab
        ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...
    def find_comment(self, comment):  # type: (str) -> List[CronItem]
        ...
    def remove(self, *items):  # type: (*CronItem) -> int
        ...
    def new(self, command='', comment='', user=None, pre_comment=False):  # type: (str, str, Optional[Union[str, bool]], bool) -> CronItem
        ...

class CronItem(object):
    def __init__(
        self,
        command: str = "",
        comment: str = "",
        user: Optional[bool] = None,
        cron: Optional[CronTab] = None,
        pre_comment: bool = False,
    ) -> None: ...

    @property
    def day(self) -> CronSlice: ...
    @property
    def hour(self) -> CronSlice: ...
    @property
    def month(self) -> CronSlice: ...
    @property
    def minute(self) -> CronSlice: ...
