# Lidia

_Lightweight Instrument Display Interface for Aircraft_

lidia is a Python package for serving an aircraft instruments panel as a web page.

<!-- TODO: https://www.makeareadme.com/
- Badges: pypi version https://badge.fury.io/for/py
- Visuals: demo GIF
- Installation
 -->

## Usage

```bash
lidia demo

# if your Scripts folder isn't in Path:
python3 -m lidia demo

# use other source
lidia rpctask

# show general help
lidia --help

# show help for a specific source
lidia demo --help

# pass the main server arguments before the source name
lidia -P 5556 demo
```

Then open the served page in a browser, by default [localhost:5555](http://localhost:5555).
The controls for showing and hiding elements of the GUI are shown when hovering the mouse in the bottom left region of the page.

## Support

Report problems in [GitLab Issues](https://gitlab.com/Maarrk/lidia/-/issues)

## Roadmap

- Handling values out of range (limit translation, change `stroke` to red)
- USB HID joystick source
- Configurable error margins (currently always yellow at 3%, red at 5%)

## Contributing

- Contributions should be made to the [GitLab repository](https://gitlab.com/Maarrk/lidia)
- Python code should be formatted with autopep8
- Other source files should be formatted with Prettier
- To properly run as a module without building and installing, **cd into `src/`** and run `python3 -m lidia`

## Acknowledgements

This software was developed in [Dipartimento di Scienze e Tecnologie Aerospaziali (DAER)](https://www.aero.polimi.it/) of Politecnico di Milano

## License

[MIT](https://choosealicense.com/licenses/mit/)
