"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HostedRotationType = exports.HostedRotation = exports.RotationSchedule = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const kms = require("@aws-cdk/aws-kms");
const core_1 = require("@aws-cdk/core");
const secretsmanager_generated_1 = require("./secretsmanager.generated");
/**
 * A rotation schedule.
 */
class RotationSchedule extends core_1.Resource {
    constructor(scope, id, props) {
        var _d, _e, _f, _g, _h;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_RotationScheduleProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if ((!props.rotationLambda && !props.hostedRotation) || (props.rotationLambda && props.hostedRotation)) {
            throw new Error('One of `rotationLambda` or `hostedRotation` must be specified.');
        }
        if ((_d = props.rotationLambda) === null || _d === void 0 ? void 0 : _d.permissionsNode.defaultChild) {
            if (props.secret.encryptionKey) {
                props.secret.encryptionKey.grantEncryptDecrypt(new kms.ViaServicePrincipal(`secretsmanager.${core_1.Stack.of(this).region}.amazonaws.com`, props.rotationLambda.grantPrincipal));
            }
            props.rotationLambda.grantInvoke(new iam.ServicePrincipal('secretsmanager.amazonaws.com'));
            props.rotationLambda.addToRolePolicy(new iam.PolicyStatement({
                actions: [
                    'secretsmanager:DescribeSecret',
                    'secretsmanager:GetSecretValue',
                    'secretsmanager:PutSecretValue',
                    'secretsmanager:UpdateSecretVersionStage',
                ],
                resources: [props.secret.secretFullArn ? props.secret.secretFullArn : `${props.secret.secretArn}-??????`],
            }));
            props.rotationLambda.addToRolePolicy(new iam.PolicyStatement({
                actions: [
                    'secretsmanager:GetRandomPassword',
                ],
                resources: ['*'],
            }));
        }
        let automaticallyAfterDays = undefined;
        if (((_e = props.automaticallyAfter) === null || _e === void 0 ? void 0 : _e.toMilliseconds()) !== 0) {
            automaticallyAfterDays = ((_f = props.automaticallyAfter) === null || _f === void 0 ? void 0 : _f.toDays()) || 30;
        }
        let rotationRules = undefined;
        if (automaticallyAfterDays !== undefined) {
            rotationRules = {
                automaticallyAfterDays,
            };
        }
        new secretsmanager_generated_1.CfnRotationSchedule(this, 'Resource', {
            secretId: props.secret.secretArn,
            rotationLambdaArn: (_g = props.rotationLambda) === null || _g === void 0 ? void 0 : _g.functionArn,
            hostedRotationLambda: (_h = props.hostedRotation) === null || _h === void 0 ? void 0 : _h.bind(props.secret, this),
            rotationRules,
        });
        // Prevent secrets deletions when rotation is in place
        props.secret.denyAccountRootDelete();
    }
}
exports.RotationSchedule = RotationSchedule;
_a = JSII_RTTI_SYMBOL_1;
RotationSchedule[_a] = { fqn: "@aws-cdk/aws-secretsmanager.RotationSchedule", version: "1.159.0" };
/**
 * A hosted rotation
 */
class HostedRotation {
    constructor(type, props, masterSecret) {
        this.type = type;
        this.props = props;
        this.masterSecret = masterSecret;
        if (type.isMultiUser && !masterSecret) {
            throw new Error('The `masterSecret` must be specified when using the multi user scheme.');
        }
    }
    /** MySQL Single User */
    static mysqlSingleUser(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mysqlSingleUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.MYSQL_SINGLE_USER, options);
    }
    /** MySQL Multi User */
    static mysqlMultiUser(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mysqlMultiUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.MYSQL_MULTI_USER, options, options.masterSecret);
    }
    /** PostgreSQL Single User */
    static postgreSqlSingleUser(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.postgreSqlSingleUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.POSTGRESQL_SINGLE_USER, options);
    }
    /** PostgreSQL Multi User */
    static postgreSqlMultiUser(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.postgreSqlMultiUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.POSTGRESQL_MULTI_USER, options, options.masterSecret);
    }
    /** Oracle Single User */
    static oracleSingleUser(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.oracleSingleUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.ORACLE_SINGLE_USER, options);
    }
    /** Oracle Multi User */
    static oracleMultiUser(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.oracleMultiUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.ORACLE_MULTI_USER, options, options.masterSecret);
    }
    /** MariaDB Single User */
    static mariaDbSingleUser(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mariaDbSingleUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.MARIADB_SINGLE_USER, options);
    }
    /** MariaDB Multi User */
    static mariaDbMultiUser(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mariaDbMultiUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.MARIADB_MULTI_USER, options, options.masterSecret);
    }
    /** SQL Server Single User */
    static sqlServerSingleUser(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.sqlServerSingleUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.SQLSERVER_SINGLE_USER, options);
    }
    /** SQL Server Multi User */
    static sqlServerMultiUser(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.sqlServerMultiUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.SQLSERVER_MULTI_USER, options, options.masterSecret);
    }
    /** Redshift Single User */
    static redshiftSingleUser(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.redshiftSingleUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.REDSHIFT_SINGLE_USER, options);
    }
    /** Redshift Multi User */
    static redshiftMultiUser(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.redshiftMultiUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.REDSHIFT_MULTI_USER, options, options.masterSecret);
    }
    /** MongoDB Single User */
    static mongoDbSingleUser(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_SingleUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mongoDbSingleUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.MONGODB_SINGLE_USER, options);
    }
    /** MongoDB Multi User */
    static mongoDbMultiUser(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_MultiUserHostedRotationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.mongoDbMultiUser);
            }
            throw error;
        }
        return new HostedRotation(HostedRotationType.MONGODB_MULTI_USER, options, options.masterSecret);
    }
    /**
     * Binds this hosted rotation to a secret
     */
    bind(secret, scope) {
        var _d, _e, _f, _g, _h, _j, _k;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_secretsmanager_ISecret(secret);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.bind);
            }
            throw error;
        }
        // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-secretsmanager-rotationschedule-hostedrotationlambda.html
        core_1.Stack.of(scope).addTransform('AWS::SecretsManager-2020-07-23');
        if (!this.props.vpc && this.props.securityGroups) {
            throw new Error('`vpc` must be specified when specifying `securityGroups`.');
        }
        if (this.props.vpc) {
            this._connections = new ec2.Connections({
                securityGroups: this.props.securityGroups || [new ec2.SecurityGroup(scope, 'SecurityGroup', {
                        vpc: this.props.vpc,
                    })],
            });
        }
        // Prevent master secret deletion when rotation is in place
        if (this.masterSecret) {
            this.masterSecret.denyAccountRootDelete();
        }
        return {
            rotationType: this.type.name,
            kmsKeyArn: (_d = secret.encryptionKey) === null || _d === void 0 ? void 0 : _d.keyArn,
            masterSecretArn: (_e = this.masterSecret) === null || _e === void 0 ? void 0 : _e.secretArn,
            masterSecretKmsKeyArn: (_g = (_f = this.masterSecret) === null || _f === void 0 ? void 0 : _f.encryptionKey) === null || _g === void 0 ? void 0 : _g.keyArn,
            rotationLambdaName: this.props.functionName,
            vpcSecurityGroupIds: (_j = (_h = this._connections) === null || _h === void 0 ? void 0 : _h.securityGroups) === null || _j === void 0 ? void 0 : _j.map(s => s.securityGroupId).join(','),
            vpcSubnetIds: (_k = this.props.vpc) === null || _k === void 0 ? void 0 : _k.selectSubnets(this.props.vpcSubnets).subnetIds.join(','),
        };
    }
    /**
     * Security group connections for this hosted rotation
     */
    get connections() {
        if (!this.props.vpc) {
            throw new Error('Cannot use connections for a hosted rotation that is not deployed in a VPC');
        }
        // If we are in a vpc and bind() has been called _connections should be defined
        if (!this._connections) {
            throw new Error('Cannot use connections for a hosted rotation that has not been bound to a secret');
        }
        return this._connections;
    }
}
exports.HostedRotation = HostedRotation;
_b = JSII_RTTI_SYMBOL_1;
HostedRotation[_b] = { fqn: "@aws-cdk/aws-secretsmanager.HostedRotation", version: "1.159.0" };
/**
 * Hosted rotation type
 */
class HostedRotationType {
    /**
     * @param name The type of rotation
     * @param isMultiUser Whether the rotation uses the mutli user scheme
     */
    constructor(name, isMultiUser) {
        this.name = name;
        this.isMultiUser = isMultiUser;
    }
}
exports.HostedRotationType = HostedRotationType;
_c = JSII_RTTI_SYMBOL_1;
HostedRotationType[_c] = { fqn: "@aws-cdk/aws-secretsmanager.HostedRotationType", version: "1.159.0" };
/** MySQL Single User */
HostedRotationType.MYSQL_SINGLE_USER = new HostedRotationType('MySQLSingleUser');
/** MySQL Multi User */
HostedRotationType.MYSQL_MULTI_USER = new HostedRotationType('MySQLMultiUser', true);
/** PostgreSQL Single User */
HostedRotationType.POSTGRESQL_SINGLE_USER = new HostedRotationType('PostgreSQLSingleUser');
/** PostgreSQL Multi User */
HostedRotationType.POSTGRESQL_MULTI_USER = new HostedRotationType('PostgreSQLMultiUser', true);
/** Oracle Single User */
HostedRotationType.ORACLE_SINGLE_USER = new HostedRotationType('OracleSingleUser');
/** Oracle Multi User */
HostedRotationType.ORACLE_MULTI_USER = new HostedRotationType('OracleMultiUser', true);
/** MariaDB Single User */
HostedRotationType.MARIADB_SINGLE_USER = new HostedRotationType('MariaDBSingleUser');
/** MariaDB Multi User */
HostedRotationType.MARIADB_MULTI_USER = new HostedRotationType('MariaDBMultiUser', true);
/** SQL Server Single User */
HostedRotationType.SQLSERVER_SINGLE_USER = new HostedRotationType('SQLServerSingleUser');
/** SQL Server Multi User */
HostedRotationType.SQLSERVER_MULTI_USER = new HostedRotationType('SQLServerMultiUser', true);
/** Redshift Single User */
HostedRotationType.REDSHIFT_SINGLE_USER = new HostedRotationType('RedshiftSingleUser');
/** Redshift Multi User */
HostedRotationType.REDSHIFT_MULTI_USER = new HostedRotationType('RedshiftMultiUser', true);
/** MongoDB Single User */
HostedRotationType.MONGODB_SINGLE_USER = new HostedRotationType('MongoDBSingleUser');
/** MongoDB Multi User */
HostedRotationType.MONGODB_MULTI_USER = new HostedRotationType('MongoDBMultiUser', true);
//# sourceMappingURL=data:application/json;base64,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