/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.Value;

public class ValueUtil {
    private ValueUtil() {
    }

    public static <V extends Number> Value<V> sum(Iterable<Value<V>> values) {
        Value<V> sum = null;
        for (Value<V> value : values) {
            if (sum == null) {
                sum = value.copy();
                continue;
            }
            sum.add(value);
        }
        return sum;
    }

    public static <V extends Number> void normalizeSimpleMax(Iterable<Value<V>> values) {
        Value<V> sum = ValueUtil.sum(values);
        if (sum == null || sum.isOne()) {
            return;
        }
        if (sum.isZero()) {
            throw new UndefinedResultException();
        }
        for (Value<V> value : values) {
            value.divide(sum);
        }
    }

    public static <V extends Number> void normalizeSoftMax(Iterable<Value<V>> values) {
        Value max = null;
        for (Value<V> value : values) {
            if (max != null && max.compareTo(value) >= 0) continue;
            max = value;
        }
        if (max == null) {
            return;
        }
        max = max.copy();
        Value<V> sum = null;
        for (Value<V> value : values) {
            value.subtract(max).exp();
            if (sum == null) {
                sum = value.copy();
                continue;
            }
            sum.add(value);
        }
        if (sum == null || sum.isOne()) {
            return;
        }
        if (sum.isZero()) {
            throw new UndefinedResultException();
        }
        for (Value<V> value : values) {
            value.divide(sum);
        }
    }
}

