/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.math.DoubleMath;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.DaysSinceDate;
import org.jpmml.evaluator.Epochs;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.NotImplementedException;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.SecondsSinceDate;
import org.jpmml.evaluator.SecondsSinceMidnight;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.model.ValueUtil;

public class TypeUtil {
    private TypeUtil() {
    }

    public static String format(Object value) {
        value = ValueUtil.toSimpleValue((Object)value);
        return TypeUtil.toString(value);
    }

    public static Object parseOrCast(DataType dataType, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return TypeUtil.parse(dataType, string);
        }
        return TypeUtil.cast(dataType, value);
    }

    public static Object parse(DataType dataType, String value) {
        switch (dataType) {
            case STRING: {
                return value;
            }
            case INTEGER: {
                return TypeUtil.parseInteger(value);
            }
            case FLOAT: {
                return TypeUtil.parseFloat(value);
            }
            case DOUBLE: {
                return TypeUtil.parseDouble(value);
            }
            case BOOLEAN: {
                return TypeUtil.parseBoolean(value);
            }
            case DATE: {
                return TypeUtil.parseDate(value);
            }
            case TIME: {
                return TypeUtil.parseTime(value);
            }
            case DATE_TIME: {
                return TypeUtil.parseDateTime(value);
            }
            case DATE_DAYS_SINCE_0: {
                throw new NotImplementedException();
            }
            case DATE_DAYS_SINCE_1960: {
                return TypeUtil.parseDaysSinceDate(Epochs.YEAR_1960, value);
            }
            case DATE_DAYS_SINCE_1970: {
                return TypeUtil.parseDaysSinceDate(Epochs.YEAR_1970, value);
            }
            case DATE_DAYS_SINCE_1980: {
                return TypeUtil.parseDaysSinceDate(Epochs.YEAR_1980, value);
            }
            case TIME_SECONDS: {
                return TypeUtil.parseSecondsSinceMidnight(value);
            }
            case DATE_TIME_SECONDS_SINCE_0: {
                throw new NotImplementedException();
            }
            case DATE_TIME_SECONDS_SINCE_1960: {
                return TypeUtil.parseSecondsSinceDate(Epochs.YEAR_1960, value);
            }
            case DATE_TIME_SECONDS_SINCE_1970: {
                return TypeUtil.parseSecondsSinceDate(Epochs.YEAR_1970, value);
            }
            case DATE_TIME_SECONDS_SINCE_1980: {
                return TypeUtil.parseSecondsSinceDate(Epochs.YEAR_1980, value);
            }
        }
        throw new IllegalArgumentException();
    }

    private static Integer parseInteger(String value) {
        try {
            long result = Long.parseLong(value);
            return TypeUtil.parseInteger(value, result);
        }
        catch (NumberFormatException nfeInteger) {
            try {
                double result = Double.parseDouble(value);
                if (DoubleMath.isMathematicalInteger((double)result)) {
                    return TypeUtil.parseInteger(value, (long)result);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                return TypeUtil.toInteger(TypeUtil.parseFlag(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw nfeInteger;
            }
        }
    }

    private static Integer parseInteger(String value, long parsedValue) {
        try {
            return Math.toIntExact(parsedValue);
        }
        catch (ArithmeticException ae) {
            throw new IllegalArgumentException(value, ae);
        }
    }

    private static Float parseFloat(String value) {
        if (value.length() <= 4) {
            switch (value) {
                case "-1": 
                case "-1.0": {
                    return Numbers.FLOAT_MINUS_ONE;
                }
                case "0": 
                case "0.0": {
                    return Numbers.FLOAT_ZERO;
                }
                case "1": 
                case "1.0": {
                    return Numbers.FLOAT_ONE;
                }
            }
        }
        try {
            return Float.valueOf(Float.parseFloat(value) + 0.0f);
        }
        catch (NumberFormatException nfe) {
            try {
                return TypeUtil.toFloat(TypeUtil.parseFlag(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw nfe;
            }
        }
    }

    private static Double parseDouble(String value) {
        if (value.length() <= 4) {
            switch (value) {
                case "-1": 
                case "-1.0": {
                    return Numbers.DOUBLE_MINUS_ONE;
                }
                case "0": 
                case "0.0": {
                    return Numbers.DOUBLE_ZERO;
                }
                case "0.5": {
                    return Numbers.DOUBLE_ONE_HALF;
                }
                case "1": 
                case "1.0": {
                    return Numbers.DOUBLE_ONE;
                }
                case "2": 
                case "2.0": {
                    return Numbers.DOUBLE_TWO;
                }
            }
        }
        try {
            return Double.parseDouble(value) + 0.0;
        }
        catch (NumberFormatException nfe) {
            try {
                return TypeUtil.toDouble(TypeUtil.parseFlag(value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw nfe;
            }
        }
    }

    private static Boolean parseBoolean(String value) {
        try {
            return TypeUtil.parseFlag(value);
        }
        catch (IllegalArgumentException iae) {
            try {
                return TypeUtil.toBoolean(TypeUtil.parseDouble(value));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (TypeCheckException typeCheckException) {
                // empty catch block
            }
            throw iae;
        }
    }

    private static boolean parseFlag(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new IllegalArgumentException(value);
    }

    private static LocalDate parseDate(String value) {
        try {
            return LocalDate.parse(value);
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(value, dte);
        }
    }

    private static LocalTime parseTime(String value) {
        try {
            return LocalTime.parse(value);
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(value, dte);
        }
    }

    private static LocalDateTime parseDateTime(String value) {
        try {
            return LocalDateTime.parse(value);
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(value, dte);
        }
    }

    public static DaysSinceDate parseDaysSinceDate(LocalDate epoch, String value) {
        return new DaysSinceDate(epoch, TypeUtil.parseDate(value));
    }

    private static SecondsSinceMidnight parseSecondsSinceMidnight(String value) {
        try {
            return SecondsSinceMidnight.parse(value);
        }
        catch (DateTimeException dte) {
            throw new IllegalArgumentException(value, dte);
        }
    }

    private static SecondsSinceDate parseSecondsSinceDate(LocalDate epoch, String value) {
        return new SecondsSinceDate(epoch, TypeUtil.parseDateTime(value));
    }

    public static boolean equals(DataType dataType, Object value, Object referenceValue) {
        try {
            return TypeUtil.parseOrCast(dataType, value).equals(TypeUtil.parseOrCast(dataType, referenceValue));
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            try {
                return TypeUtil.format(value).equals(TypeUtil.format(referenceValue));
            }
            catch (TypeCheckException typeCheckException) {
                throw e;
            }
        }
    }

    public static DataType getDataType(Object value) {
        if (value instanceof String) {
            return DataType.STRING;
        }
        if (value instanceof Integer) {
            return DataType.INTEGER;
        }
        if (value instanceof Float) {
            return DataType.FLOAT;
        }
        if (value instanceof Double) {
            return DataType.DOUBLE;
        }
        if (value instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        if (value instanceof LocalDate) {
            return DataType.DATE;
        }
        if (value instanceof LocalTime) {
            return DataType.TIME;
        }
        if (value instanceof LocalDateTime) {
            return DataType.DATE_TIME;
        }
        if (value instanceof DaysSinceDate) {
            DaysSinceDate period = (DaysSinceDate)value;
            return TypeUtil.getDaysDataType(period.getEpoch());
        }
        if (value instanceof SecondsSinceMidnight) {
            return DataType.TIME_SECONDS;
        }
        if (value instanceof SecondsSinceDate) {
            SecondsSinceDate period = (SecondsSinceDate)value;
            return TypeUtil.getSecondsDataType(period.getEpoch());
        }
        throw new EvaluationException("No PMML data type for Java data type " + (value != null ? value.getClass().getName() : null));
    }

    public static DataType getDataType(Collection<?> values) {
        DataType result = null;
        for (Object value : values) {
            if (value == null) continue;
            DataType dataType = TypeUtil.getDataType(value);
            if (result == null) {
                result = dataType;
                continue;
            }
            if (result.equals((Object)dataType)) continue;
            throw new TypeCheckException(result, value);
        }
        if (result == null) {
            result = DataType.STRING;
        }
        return result;
    }

    public static DataType getCommonDataType(DataType left, DataType right) {
        if (left.equals((Object)right)) {
            switch (left) {
                case INTEGER: 
                case FLOAT: 
                case DOUBLE: {
                    return left;
                }
            }
        } else if (DataType.DOUBLE.equals((Object)left)) {
            if (DataType.FLOAT.equals((Object)right) || DataType.INTEGER.equals((Object)right)) {
                return left;
            }
        } else if (DataType.FLOAT.equals((Object)left)) {
            if (DataType.DOUBLE.equals((Object)right)) {
                return right;
            }
            if (DataType.INTEGER.equals((Object)right)) {
                return left;
            }
        } else if (DataType.INTEGER.equals((Object)left) && (DataType.DOUBLE.equals((Object)right) || DataType.FLOAT.equals((Object)right))) {
            return right;
        }
        throw new EvaluationException("No PMML data type for the intersection of PMML data types " + left.value() + " and " + right.value());
    }

    public static OpType getOpType(DataType dataType) {
        switch (dataType) {
            case STRING: {
                return OpType.CATEGORICAL;
            }
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                return OpType.CONTINUOUS;
            }
            case BOOLEAN: {
                return OpType.CATEGORICAL;
            }
            case DATE: 
            case TIME: 
            case DATE_TIME: {
                return OpType.ORDINAL;
            }
            case DATE_DAYS_SINCE_0: 
            case DATE_DAYS_SINCE_1960: 
            case DATE_DAYS_SINCE_1970: 
            case DATE_DAYS_SINCE_1980: 
            case TIME_SECONDS: 
            case DATE_TIME_SECONDS_SINCE_0: 
            case DATE_TIME_SECONDS_SINCE_1960: 
            case DATE_TIME_SECONDS_SINCE_1970: 
            case DATE_TIME_SECONDS_SINCE_1980: {
                return OpType.CONTINUOUS;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Object cast(DataType dataType, Object value) {
        switch (dataType) {
            case STRING: {
                return TypeUtil.toString(value);
            }
            case INTEGER: {
                return TypeUtil.toInteger(value);
            }
            case FLOAT: {
                return TypeUtil.toFloat(value);
            }
            case DOUBLE: {
                return TypeUtil.toDouble(value);
            }
            case BOOLEAN: {
                return TypeUtil.toBoolean(value);
            }
            case DATE: {
                return TypeUtil.toDate(value);
            }
            case TIME: {
                return TypeUtil.toTime(value);
            }
            case DATE_TIME: {
                return TypeUtil.toDateTime(value);
            }
            case DATE_DAYS_SINCE_0: {
                throw new NotImplementedException();
            }
            case DATE_DAYS_SINCE_1960: {
                return TypeUtil.toDaysSinceDate(Epochs.YEAR_1960, value);
            }
            case DATE_DAYS_SINCE_1970: {
                return TypeUtil.toDaysSinceDate(Epochs.YEAR_1970, value);
            }
            case DATE_DAYS_SINCE_1980: {
                return TypeUtil.toDaysSinceDate(Epochs.YEAR_1980, value);
            }
            case TIME_SECONDS: {
                return TypeUtil.toSecondsSinceMidnight(value);
            }
            case DATE_TIME_SECONDS_SINCE_0: {
                throw new NotImplementedException();
            }
            case DATE_TIME_SECONDS_SINCE_1960: {
                return TypeUtil.toSecondsSinceDate(Epochs.YEAR_1960, value);
            }
            case DATE_TIME_SECONDS_SINCE_1970: {
                return TypeUtil.toSecondsSinceDate(Epochs.YEAR_1970, value);
            }
            case DATE_TIME_SECONDS_SINCE_1980: {
                return TypeUtil.toSecondsSinceDate(Epochs.YEAR_1980, value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static <V> V cast(Class<? extends V> clazz, Object value) {
        if (!clazz.isInstance(value)) {
            throw new TypeCheckException(clazz, value);
        }
        return clazz.cast(value);
    }

    private static String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            Number number = (Number)value;
            return number.toString();
        }
        if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            return flag != false ? "true" : "false";
        }
        throw new TypeCheckException(DataType.STRING, value);
    }

    private static Integer toInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Double || value instanceof Float) {
            Number number = (Number)value;
            if (DoubleMath.isMathematicalInteger((double)number.doubleValue())) {
                return TypeUtil.toInteger(number);
            }
        } else {
            if (value instanceof Long) {
                Long number = (Long)value;
                return TypeUtil.toInteger(number);
            }
            if (value instanceof Short || value instanceof Byte) {
                Number number = (Number)value;
                return number.intValue();
            }
            if (value instanceof Boolean) {
                Boolean flag = (Boolean)value;
                return flag != false ? Numbers.INTEGER_ONE : Numbers.INTEGER_ZERO;
            }
            if (value instanceof DaysSinceDate || value instanceof SecondsSinceDate || value instanceof SecondsSinceMidnight) {
                Number number = (Number)value;
                return TypeUtil.toInteger(number);
            }
        }
        throw new TypeCheckException(DataType.INTEGER, value);
    }

    private static Integer toInteger(Number value) {
        try {
            return Math.toIntExact(value.longValue());
        }
        catch (ArithmeticException ae) {
            throw new TypeCheckException(DataType.INTEGER, (Object)value).initCause(ae);
        }
    }

    private static Float toFloat(Object value) {
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Double) {
            Number number = (Number)value;
            return TypeUtil.toFloat(number.floatValue());
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            Number number = (Number)value;
            return TypeUtil.toFloat(number.floatValue());
        }
        if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            return flag != false ? Numbers.FLOAT_ONE : Numbers.FLOAT_ZERO;
        }
        if (value instanceof DaysSinceDate || value instanceof SecondsSinceDate || value instanceof SecondsSinceMidnight) {
            Number number = (Number)value;
            return TypeUtil.toFloat(number.floatValue());
        }
        throw new TypeCheckException(DataType.FLOAT, value);
    }

    private static Float toFloat(float value) {
        if (value == -1.0f) {
            return Numbers.FLOAT_MINUS_ONE;
        }
        if (value == 0.0f) {
            return Numbers.FLOAT_ZERO;
        }
        if (value == 1.0f) {
            return Numbers.FLOAT_ONE;
        }
        return Float.valueOf(value);
    }

    private static Double toDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float || value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            Number number = (Number)value;
            return TypeUtil.toDouble(number.doubleValue());
        }
        if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            return flag != false ? Numbers.DOUBLE_ONE : Numbers.DOUBLE_ZERO;
        }
        if (value instanceof DaysSinceDate || value instanceof SecondsSinceDate || value instanceof SecondsSinceMidnight) {
            Number number = (Number)value;
            return TypeUtil.toDouble(number.doubleValue());
        }
        throw new TypeCheckException(DataType.DOUBLE, value);
    }

    private static Double toDouble(double value) {
        if (value == -1.0) {
            return Numbers.DOUBLE_MINUS_ONE;
        }
        if (value == 0.0) {
            return Numbers.DOUBLE_ZERO;
        }
        if (value == 0.5) {
            return Numbers.DOUBLE_ONE_HALF;
        }
        if (value == 1.0) {
            return Numbers.DOUBLE_ONE;
        }
        if (value == 2.0) {
            return Numbers.DOUBLE_TWO;
        }
        return value;
    }

    private static Boolean toBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            Number number = (Number)value;
            if (number.doubleValue() == 0.0) {
                return Boolean.FALSE;
            }
            if (number.doubleValue() == 1.0) {
                return Boolean.TRUE;
            }
        }
        throw new TypeCheckException(DataType.BOOLEAN, value);
    }

    private static LocalDate toDate(Object value) {
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime instant = (LocalDateTime)value;
            return instant.toLocalDate();
        }
        throw new TypeCheckException(DataType.DATE, value);
    }

    private static LocalTime toTime(Object value) {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime instant = (LocalDateTime)value;
            return instant.toLocalTime();
        }
        throw new TypeCheckException(DataType.TIME, value);
    }

    private static LocalDateTime toDateTime(Object value) {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        throw new TypeCheckException(DataType.DATE_TIME, value);
    }

    private static DaysSinceDate toDaysSinceDate(LocalDate epoch, Object value) {
        if (value instanceof DaysSinceDate) {
            DaysSinceDate period = (DaysSinceDate)value;
            if (epoch.equals(period.getEpoch())) {
                return period;
            }
            long days = ChronoUnit.DAYS.between(epoch, period.getEpoch()) + period.getDays();
            return new DaysSinceDate(epoch, days);
        }
        throw new TypeCheckException(TypeUtil.getDaysDataType(epoch), value);
    }

    private static SecondsSinceMidnight toSecondsSinceMidnight(Object value) {
        if (value instanceof SecondsSinceMidnight) {
            return (SecondsSinceMidnight)value;
        }
        throw new TypeCheckException(DataType.TIME_SECONDS, value);
    }

    private static SecondsSinceDate toSecondsSinceDate(LocalDate epoch, Object value) {
        if (value instanceof SecondsSinceDate) {
            SecondsSinceDate period = (SecondsSinceDate)value;
            if (epoch.equals(period.getEpoch())) {
                return period;
            }
            long seconds = ChronoUnit.SECONDS.between(epoch.atStartOfDay(), period.getEpoch().atStartOfDay()) + period.getSeconds();
            return new SecondsSinceDate(epoch, seconds);
        }
        throw new TypeCheckException(TypeUtil.getSecondsDataType(epoch), value);
    }

    public static DataType getConstantDataType(Object value) {
        if (value instanceof String) {
            String string = (String)value;
            return TypeUtil.getConstantDataType(string);
        }
        return TypeUtil.getDataType(value);
    }

    public static DataType getConstantDataType(String string) {
        try {
            if (string.indexOf(46) > -1) {
                Double.parseDouble(string);
                return DataType.FLOAT;
            }
            Long.parseLong(string);
            return DataType.INTEGER;
        }
        catch (NumberFormatException nfe) {
            return DataType.STRING;
        }
    }

    private static DataType getDaysDataType(LocalDate epoch) {
        if (Epochs.YEAR_1960.equals(epoch)) {
            return DataType.DATE_DAYS_SINCE_1960;
        }
        if (Epochs.YEAR_1970.equals(epoch)) {
            return DataType.DATE_DAYS_SINCE_1970;
        }
        if (Epochs.YEAR_1980.equals(epoch)) {
            return DataType.DATE_DAYS_SINCE_1980;
        }
        throw new EvaluationException("Non-standard epoch " + epoch);
    }

    private static DataType getSecondsDataType(LocalDate epoch) {
        if (Epochs.YEAR_1960.equals(epoch)) {
            return DataType.DATE_TIME_SECONDS_SINCE_1960;
        }
        if (Epochs.YEAR_1970.equals(epoch)) {
            return DataType.DATE_TIME_SECONDS_SINCE_1970;
        }
        if (Epochs.YEAR_1980.equals(epoch)) {
            return DataType.DATE_TIME_SECONDS_SINCE_1980;
        }
        throw new EvaluationException("Non-standard epoch " + epoch);
    }
}

