/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasContinuousDomain;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.Interval;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.DiscretizationUtil;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.model.XPathUtil;

public class FieldUtil {
    private static final LoadingCache<DataField, List<String>> categoryCache = CacheUtil.buildLoadingCache(new CacheLoader<DataField, List<String>>(){

        public List<String> load(DataField dataField) {
            return ImmutableList.copyOf((Collection)FieldUtil.parseCategories(dataField));
        }
    });
    private static final LoadingCache<Field<?>, List<Object>> validValueCache = CacheUtil.buildLoadingCache(new CacheLoader<Field<?>, List<Object>>(){

        public List<Object> load(Field<?> field) {
            return ImmutableList.copyOf((Collection)FieldUtil.parseValidValues((Field)((HasDiscreteDomain)field)));
        }
    });
    private static final LoadingCache<Field<?>, RangeSet<Double>> validRangeCache = CacheUtil.buildLoadingCache(new CacheLoader<Field<?>, RangeSet<Double>>(){

        public RangeSet<Double> load(Field<?> field) {
            return ImmutableRangeSet.copyOf((RangeSet)FieldUtil.parseValidRanges((Field)((HasContinuousDomain)field)));
        }
    });

    private FieldUtil() {
    }

    public static List<String> getCategories(DataField dataField) {
        return CacheUtil.getValue(dataField, categoryCache);
    }

    public static <F extends Field<F>> List<?> getValidValues(F field) {
        return CacheUtil.getValue(field, validValueCache);
    }

    public static <F extends Field<F>> RangeSet<Double> getValidRanges(F field) {
        return CacheUtil.getValue(field, validRangeCache);
    }

    public static DataType getDataType(Field<?> field) {
        return field.getDataType();
    }

    public static OpType getOpType(Field<?> field, MiningField miningField) {
        OpType opType = field.getOpType();
        if (miningField != null) {
            opType = miningField.getOpType(opType);
        }
        return opType;
    }

    public static OpType getOpType(Field<?> field, MiningField miningField, Target target) {
        OpType opType = field.getOpType();
        if (miningField != null) {
            opType = miningField.getOpType(opType);
            if (target != null) {
                opType = target.getOpType(opType);
            }
        }
        return opType;
    }

    public static TypeInfo getTypeInfo(final Field<?> field, final MiningField miningField) {
        TypeInfo typeInfo = new TypeInfo(){

            @Override
            public DataType getDataType() {
                DataType dataType = FieldUtil.getDataType(field);
                if (dataType == null) {
                    throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(field.getClass()) + "@dataType"), (PMMLObject)field);
                }
                return dataType;
            }

            @Override
            public OpType getOpType() {
                OpType opType = FieldUtil.getOpType(field, miningField);
                if (opType == null) {
                    throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(field.getClass()) + "@optype"), (PMMLObject)field);
                }
                return opType;
            }

            @Override
            public List<?> getOrdering() {
                List<?> ordering = null;
                if (field instanceof HasDiscreteDomain) {
                    ordering = FieldUtil.getValidValues((Field)((HasDiscreteDomain)field));
                }
                return ordering;
            }
        };
        return typeInfo;
    }

    private static List<String> parseCategories(DataField dataField) {
        ArrayList<String> result = new ArrayList<String>();
        if (dataField.hasValues()) {
            List pmmlValues = dataField.getValues();
            for (Value pmmlValue : pmmlValues) {
                Object simpleValue = pmmlValue.getValue();
                if (simpleValue == null) {
                    throw new MissingAttributeException((PMMLObject)pmmlValue, PMMLAttributes.VALUE_VALUE);
                }
                Value.Property property = pmmlValue.getProperty();
                switch (property) {
                    case VALID: {
                        result.add(TypeUtil.format(simpleValue));
                        break;
                    }
                }
            }
        }
        return result;
    }

    private static <F extends Field<F>> List<Object> parseValidValues(F field) {
        ArrayList<Object> result = new ArrayList<Object>();
        DataType dataType = field.getDataType();
        if (dataType == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(field.getClass()) + "@dataType"), (PMMLObject)field);
        }
        if (((HasDiscreteDomain)field).hasValues()) {
            List pmmlValues = ((HasDiscreteDomain)field).getValues();
            for (Value pmmlValue : pmmlValues) {
                Object simpleValue = pmmlValue.getValue();
                if (simpleValue == null) {
                    throw new MissingAttributeException((PMMLObject)pmmlValue, PMMLAttributes.VALUE_VALUE);
                }
                Value.Property property = pmmlValue.getProperty();
                switch (property) {
                    case VALID: {
                        result.add(TypeUtil.parseOrCast(dataType, simpleValue));
                        break;
                    }
                }
            }
        }
        return result;
    }

    private static <F extends Field<F>> RangeSet<Double> parseValidRanges(F field) {
        TreeRangeSet result = TreeRangeSet.create();
        if (((HasContinuousDomain)field).hasIntervals()) {
            List intervals = ((HasContinuousDomain)field).getIntervals();
            for (Interval interval : intervals) {
                Range<Double> range = DiscretizationUtil.toRange(interval);
                result.add(range);
            }
        }
        return result;
    }
}

