/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.Computable;
import org.jpmml.evaluator.HasGroupFields;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.ModelEvaluator;

public class EvaluatorUtil {
    private EvaluatorUtil() {
    }

    public static Map<FieldName, ?> encodeKeys(Map<String, ?> map) {
        LinkedHashMap result = new LinkedHashMap(2 * map.size());
        Set<Map.Entry<String, ?>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            result.put(name != null ? FieldName.create((String)name) : null, value);
        }
        return result;
    }

    public static Object decode(Object object) {
        if (object instanceof Computable) {
            Computable computable = (Computable)object;
            return computable.getResult();
        }
        if (object instanceof Collection) {
            Collection rawValues = (Collection)object;
            AbstractCollection decodedValues = rawValues instanceof Set ? new LinkedHashSet(rawValues.size()) : new ArrayList(rawValues.size());
            for (Object rawValue : rawValues) {
                decodedValues.add(EvaluatorUtil.decode(rawValue));
            }
            return decodedValues;
        }
        return object;
    }

    public static Map<String, ?> decodeAll(Map<FieldName, ?> map) {
        LinkedHashMap result = new LinkedHashMap(2 * map.size());
        Set<Map.Entry<FieldName, ?>> entries = map.entrySet();
        for (Map.Entry entry : entries) {
            FieldName name = (FieldName)entry.getKey();
            Object value = entry.getValue();
            try {
                value = EvaluatorUtil.decode(value);
            }
            catch (UnsupportedOperationException uoe) {
                continue;
            }
            result.put(name != null ? name.getValue() : null, value);
        }
        return result;
    }

    public static List<? extends Map<FieldName, ?>> groupRows(HasGroupFields hasGroupFields, List<? extends Map<FieldName, ?>> table) {
        List<InputField> groupFields = hasGroupFields.getGroupFields();
        if (groupFields.size() == 1) {
            InputField groupField = groupFields.get(0);
            table = EvaluatorUtil.groupRows(groupField.getName(), table);
        } else if (groupFields.size() > 1) {
            ModelEvaluator modelEvaluator = (ModelEvaluator)((Object)hasGroupFields);
            throw modelEvaluator.createMiningSchemaException("Expected 0 or 1 group field(s), got " + groupFields.size() + " group fields");
        }
        return table;
    }

    /*
     * WARNING - void declaration
     */
    public static <K> List<Map<K, Object>> groupRows(K groupKey, List<? extends Map<K, ?>> table) {
        LinkedHashMap groupedRows = new LinkedHashMap();
        for (int i = 0; i < table.size(); ++i) {
            Map<K, ?> row = table.get(i);
            Object groupValue = row.get(groupKey);
            ListMultimap listMultimap = (ListMultimap)groupedRows.get(groupValue);
            if (listMultimap == null) {
                ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
                groupedRows.put(groupValue, arrayListMultimap);
            }
            Set<Map.Entry<K, ?>> entries = row.entrySet();
            for (Map.Entry entry : entries) {
                void var6_7;
                Object key = entry.getKey();
                Object value = entry.getValue();
                var6_7.put(key, value);
            }
        }
        ArrayList<Map<K, Object>> resultTable = new ArrayList<Map<K, Object>>(groupedRows.size());
        Set entries = groupedRows.entrySet();
        for (Map.Entry entry : entries) {
            LinkedHashMap resultRow = new LinkedHashMap();
            resultRow.putAll(((ListMultimap)entry.getValue()).asMap());
            resultRow.put(groupKey, entry.getKey());
            resultTable.add(resultRow);
        }
        return resultTable;
    }
}

