# pure_safetensors

[Safetensors](https://github.com/huggingface/safetensors) library but in pure clean Python. Run it on PyPy or IronPython or wherever.

# Dependencies

We try to keep dependencies light:

- [attrs](https://pypi.org/project/attrs/) dataclass library (2881 LoC)
- [marshmallow](https://pypi.org/project/marshmallow/) serialization and validation library (2647 LoC)
- [sortedcollections](https://pypi.org/project/sortedcollections/) tiny sorted collections library (339 LoC) built on top of [sortedcontainers](https://pypi.org/project/sortedcontainers/) (1493 LoC)
- (optional) [sparsefile](https://pypi.org/project/sparsefile/) sparse file library (191 LoC)

Optionally, this library integrates with NumPy (if available). PyTorch integration is planned.

To run the tests, you'll need `pytest`, `numpy`, and optionally `hypothesis`.

# Examples

TODO

# Bugs

The space allocator is a greedy algorithm based on first-fit-decreasing bin packing. So if you add/remove tensors to an existing file, it may leave too much empty space behind.

# Alternatives

- [safetensors](https://github.com/huggingface/safetensors/)
- [Narsil/pure_torch.py](https://gist.github.com/Narsil/3edeec2669a5e94e4707aa0f901d2282)
- [Narsil/safetensors.cpp](https://gist.github.com/Narsil/5d6bf307995158ad2c4994f323967284)

|                                                | pure_safetensors | safetensors | pure_torch.py | safetensors.cpp |
|------------------------------------------------|------------------|-------------|---------------|-----------------|
| Written in pure Python?                        | ✅ | ❌ | ✅ | — |
| Supports NumPy directly (no PyTorch)?          | ✅ | ✅ | ❌ | — |
| Can write safetensors files?                   | ✅ | ✅ | ❌ | ❌ |
| Can add/delete tensors in-place (no copying)?  | ✅ | ❌ | ❌ | ❌ |
| Has unit tests?                                | ✅ | ✅ | ❌ | ❌ |
| Stable API?                                    | 🤷 | ✅ | ❔ | ❔ |
| Automatically make files sparse to save space? | ✅ | ❌ | ❌ | ❌ |
