# mypy-boto3-appsync

[![PyPI - mypy-boto3-appsync](https://img.shields.io/pypi/v/mypy-boto3-appsync.svg?color=blue)](https://pypi.org/project/mypy-boto3-appsync)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-appsync.svg?color=blue)](https://pypi.org/project/mypy-boto3-appsync)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-appsync](#mypy-boto3-appsync)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)

Type annotations for
[boto3.AppSync 1.13.26](https://boto3.amazonaws.com/v1/documentation/api/1.13.26/reference/services/appsync.html#AppSync) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `AppSync` service.

```bash
python -m pip install boto3-stubs[appsync]
```

Use `boto3` with `mypy_boto3_appsync` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_appsync import AppSyncClient

# Now mypy can check if your code is valid.
client: AppSyncClient = boto3.client("appsync")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: AppSyncClient = session.client("appsync")



# Annotated paginators are included as well

import mypy_boto3_appsync.paginator as appsync_paginators

list_api_keys_paginator: appsync_paginators.ListApiKeysPaginator = client.get_paginator("list_api_keys")
list_data_sources_paginator: appsync_paginators.ListDataSourcesPaginator = client.get_paginator("list_data_sources")
list_functions_paginator: appsync_paginators.ListFunctionsPaginator = client.get_paginator("list_functions")
list_graphql_apis_paginator: appsync_paginators.ListGraphqlApisPaginator = client.get_paginator("list_graphql_apis")
list_resolvers_paginator: appsync_paginators.ListResolversPaginator = client.get_paginator("list_resolvers")
list_resolvers_by_function_paginator: appsync_paginators.ListResolversByFunctionPaginator = client.get_paginator("list_resolvers_by_function")
list_types_paginator: appsync_paginators.ListTypesPaginator = client.get_paginator("list_types")
```

## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_appsync` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python
import boto3

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("appsync")

session_client = boto3.Session().client("appsync")
```