from .context import gpytoolbox as gpy
from .context import numpy as np
from .context import unittest

class TestHalffaces(unittest.TestCase):
    # There is not much to test here that goes beyond just inputting the
    # definition of the function, but we can make sure that a few conditions
    # are fulfilled.

    def test_regular_cube_mesh(self):
        _,t = gpy.regular_cube_mesh(3)
        hf = gpy.halffaces(t)
        hf_groundtruth = np.array([[[ 9, 10, 13],
        [13, 10,  0],
        [13,  0,  9],
        [ 9,  0, 10]],

       [[18, 19, 22],
        [22, 19,  9],
        [22,  9, 18],
        [18,  9, 19]],

       [[12, 13, 16],
        [16, 13,  3],
        [16,  3, 12],
        [12,  3, 13]],

       [[21, 22, 25],
        [25, 22, 12],
        [25, 12, 21],
        [21, 12, 22]],

       [[10, 11, 14],
        [14, 11,  1],
        [14,  1, 10],
        [10,  1, 11]],

       [[19, 20, 23],
        [23, 20, 10],
        [23, 10, 19],
        [19, 10, 20]],

       [[13, 14, 17],
        [17, 14,  4],
        [17,  4, 13],
        [13,  4, 14]],

       [[22, 23, 26],
        [26, 23, 13],
        [26, 13, 22],
        [22, 13, 23]],

       [[13, 10,  1],
        [ 1, 10,  0],
        [ 1,  0, 13],
        [13,  0, 10]],

       [[22, 19, 10],
        [10, 19,  9],
        [10,  9, 22],
        [22,  9, 19]],

       [[16, 13,  4],
        [ 4, 13,  3],
        [ 4,  3, 16],
        [16,  3, 13]],

       [[25, 22, 13],
        [13, 22, 12],
        [13, 12, 25],
        [25, 12, 22]],

       [[14, 11,  2],
        [ 2, 11,  1],
        [ 2,  1, 14],
        [14,  1, 11]],

       [[23, 20, 11],
        [11, 20, 10],
        [11, 10, 23],
        [23, 10, 20]],

       [[17, 14,  5],
        [ 5, 14,  4],
        [ 5,  4, 17],
        [17,  4, 14]],

       [[26, 23, 14],
        [14, 23, 13],
        [14, 13, 26],
        [26, 13, 23]],

       [[ 9, 13, 12],
        [12, 13,  0],
        [12,  0,  9],
        [ 9,  0, 13]],

       [[18, 22, 21],
        [21, 22,  9],
        [21,  9, 18],
        [18,  9, 22]],

       [[12, 16, 15],
        [15, 16,  3],
        [15,  3, 12],
        [12,  3, 16]],

       [[21, 25, 24],
        [24, 25, 12],
        [24, 12, 21],
        [21, 12, 25]],

       [[10, 14, 13],
        [13, 14,  1],
        [13,  1, 10],
        [10,  1, 14]],

       [[19, 23, 22],
        [22, 23, 10],
        [22, 10, 19],
        [19, 10, 23]],

       [[13, 17, 16],
        [16, 17,  4],
        [16,  4, 13],
        [13,  4, 17]],

       [[22, 26, 25],
        [25, 26, 13],
        [25, 13, 22],
        [22, 13, 26]],

       [[12, 13,  3],
        [ 3, 13,  0],
        [ 3,  0, 12],
        [12,  0, 13]],

       [[21, 22, 12],
        [12, 22,  9],
        [12,  9, 21],
        [21,  9, 22]],

       [[15, 16,  6],
        [ 6, 16,  3],
        [ 6,  3, 15],
        [15,  3, 16]],

       [[24, 25, 15],
        [15, 25, 12],
        [15, 12, 24],
        [24, 12, 25]],

       [[13, 14,  4],
        [ 4, 14,  1],
        [ 4,  1, 13],
        [13,  1, 14]],

       [[22, 23, 13],
        [13, 23, 10],
        [13, 10, 22],
        [22, 10, 23]],

       [[16, 17,  7],
        [ 7, 17,  4],
        [ 7,  4, 16],
        [16,  4, 17]],

       [[25, 26, 16],
        [16, 26, 13],
        [16, 13, 25],
        [25, 13, 26]],

       [[ 4, 13,  1],
        [ 1, 13,  0],
        [ 1,  0,  4],
        [ 4,  0, 13]],

       [[13, 22, 10],
        [10, 22,  9],
        [10,  9, 13],
        [13,  9, 22]],

       [[ 7, 16,  4],
        [ 4, 16,  3],
        [ 4,  3,  7],
        [ 7,  3, 16]],

       [[16, 25, 13],
        [13, 25, 12],
        [13, 12, 16],
        [16, 12, 25]],

       [[ 5, 14,  2],
        [ 2, 14,  1],
        [ 2,  1,  5],
        [ 5,  1, 14]],

       [[14, 23, 11],
        [11, 23, 10],
        [11, 10, 14],
        [14, 10, 23]],

       [[ 8, 17,  5],
        [ 5, 17,  4],
        [ 5,  4,  8],
        [ 8,  4, 17]],

       [[17, 26, 14],
        [14, 26, 13],
        [14, 13, 17],
        [17, 13, 26]],

       [[ 3, 13,  4],
        [ 4, 13,  0],
        [ 4,  0,  3],
        [ 3,  0, 13]],

       [[12, 22, 13],
        [13, 22,  9],
        [13,  9, 12],
        [12,  9, 22]],

       [[ 6, 16,  7],
        [ 7, 16,  3],
        [ 7,  3,  6],
        [ 6,  3, 16]],

       [[15, 25, 16],
        [16, 25, 12],
        [16, 12, 15],
        [15, 12, 25]],

       [[ 4, 14,  5],
        [ 5, 14,  1],
        [ 5,  1,  4],
        [ 4,  1, 14]],

       [[13, 23, 14],
        [14, 23, 10],
        [14, 10, 13],
        [13, 10, 23]],

       [[ 7, 17,  8],
        [ 8, 17,  4],
        [ 8,  4,  7],
        [ 7,  4, 17]],

       [[16, 26, 17],
        [17, 26, 13],
        [17, 13, 16],
        [16, 13, 26]]])
        self.assertTrue(np.all(hf == hf_groundtruth))


if __name__ == '__main__':
    unittest.main()