"""Add EMS objects in common to both ExistingHVAC and VRFsystem."""


def addEMSProgramsBase(self, ScriptType: str = None, verboseMode: bool = True):
    """
    Add EMS programs for Base accim.

    Checks if some programs objects are already
    in the model, and otherwise adds them.
    :param verboseMode:
    """
    programlist = ([program.Name
                    for program
                    in self.idf1.idfobjects['EnergyManagementSystem:Program']])

    if 'SetComfTemp' in programlist:
        if verboseMode:
            print('Not added - SetComfTemp Program')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Program',
            Name='SetComfTemp',
            Program_Line_1='if ComfStand == 1',
            Program_Line_2='set ComfTemp = RMOT*0.33+18.8',
            Program_Line_3='elseif ComfStand == 2',
            Program_Line_4='set ComfTemp = PMOT*0.31+17.8',
            Program_Line_5='elseif ComfStand == 3',
            Program_Line_6='set ComfTemp = PMOT*0.48+14.4',
            Program_Line_7='elseif ComfStand == 4',
            Program_Line_8='set ComfTemp = 0',
            Program_Line_9='elseif ComfStand == 5',
            Program_Line_10='set ComfTemp = 0',
            Program_Line_11='elseif ComfStand == 6',
            Program_Line_12='set ComfTemp = 0',
            Program_Line_13='elseif ComfStand == 7',
            Program_Line_14='set ComfTemp = PMOT*0.54+12.83',
            Program_Line_15='elseif ComfStand == 8',
            Program_Line_16='set ComfTemp = PMOT*0.28+17.87',
            Program_Line_17='elseif ComfStand == 9',
            Program_Line_18='set ComfTemp = PMOT*0.39+18.42',
            Program_Line_19='elseif ComfStand == 10',
            Program_Line_20='set ComfTemp = PMOT*0.42+17.6',
            Program_Line_21='elseif ComfStand == 11',
            Program_Line_22='set ComfTemp = PMOT*0.75+5.37',
            Program_Line_23='elseif ComfStand == 12',
            Program_Line_24='set ComfTemp = PMOT*0.25+19.7',
            Program_Line_25='elseif ComfStand == 13',
            Program_Line_26='set ComfTemp = PMOT*0.26+15.9',
            Program_Line_27='elseif ComfStand == 14',
            Program_Line_28='set ComfTemp = PMOT*0.26+16.75',
            Program_Line_29='elseif ComfStand == 15',
            Program_Line_30='set ComfTemp = PMOT*0.56+12.74',
            Program_Line_31='elseif ComfStand == 16',
            Program_Line_32='set ComfTemp = PMOT*0.09+22.32',
            Program_Line_33='elseif ComfStand == 17',
            Program_Line_34='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_35='set ComfTemp = PMOT*0.48+13.9',
            Program_Line_36='else',
            Program_Line_37='set ComfTemp = PMOT*0.59+9.6',
            Program_Line_38='endif',
            Program_Line_39='elseif ComfStand == 18',
            Program_Line_40='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_41='set ComfTemp = PMOT*0.84+5.3',
            Program_Line_42='else',
            Program_Line_43='set ComfTemp = PMOT*0.96-3.6',
            Program_Line_44='endif',
            Program_Line_45='elseif ComfStand == 19',
            Program_Line_46='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_47='set ComfTemp = PMOT*0.27+17.9',
            Program_Line_48='else',
            Program_Line_49='set ComfTemp = PMOT*0.53+10.3',
            Program_Line_50='endif',
            Program_Line_51='elseif ComfStand == 20',
            Program_Line_52='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_53='set ComfTemp = PMOT*0.38+15.7',
            Program_Line_54='else',
            Program_Line_55='set ComfTemp = PMOT*0.47+9.07',
            Program_Line_56='endif',
            Program_Line_57='elseif ComfStand == 21',
            Program_Line_58='set ComfTemp = PMOT*0.678+13.51',
            Program_Line_59='endif',
        )
        if verboseMode:
            print('Added - SetComfTemp Program')
    #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetComfTemp'])

    for zonename in self.occupiedZones:
        if 'CountHours_'+zonename in programlist:
            if verboseMode:
                print('Not added - CountHours_'+zonename+' Program')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Program',
                Name='CountHours_'+zonename,
                Program_Line_1='if (ComfStand == 1) || (ComfStand == 10)',
                Program_Line_2='if (RMOT >= AHSTall) && (RMOT <= ACSTaul)',
                Program_Line_3='if (' + zonename + '_OpT <= ACSTnoTol)',
                Program_Line_4='if (' + zonename + '_OpT >= AHSTnoTol)',
                Program_Line_5='set ComfHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_6='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_7='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_8='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_9='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_10='endif',
                Program_Line_11='elseif (' + zonename + '_OpT > ACSTnoTol)',
                Program_Line_12='set ComfHours_' + zonename + ' = 0',
                Program_Line_13='set DiscomfAppHotHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_14='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_15='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_16='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_17='elseif (' + zonename + '_OpT < AHSTnoTol)',
                Program_Line_18='set ComfHours_' + zonename + ' = 0',
                Program_Line_19='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_20='set DiscomfAppColdHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_21='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_22='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_23='endif',
                Program_Line_24='elseif (RMOT > ACSTaul)',
                Program_Line_25='set ComfHours_' + zonename + ' = 0',
                Program_Line_26='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_27='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_28='set DiscomfNonAppHotHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_29='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_30='elseif (RMOT < AHSTall)',
                Program_Line_31='set ComfHours_' + zonename + ' = 0',
                Program_Line_32='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_33='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_34='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_35='set DiscomfNonAppColdHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_36='endif',
                Program_Line_37='else',
                Program_Line_38='if (PMOT >= AHSTall) && (PMOT <= ACSTaul)',
                Program_Line_39='if (' + zonename + '_OpT <= ACSTnoTol)',
                Program_Line_40='if (' + zonename + '_OpT >= AHSTnoTol)',
                Program_Line_41='set ComfHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_42='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_43='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_44='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_45='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_46='endif',
                Program_Line_47='elseif (' + zonename + '_OpT > ACSTnoTol)',
                Program_Line_48='set ComfHours_' + zonename + ' = 0',
                Program_Line_49='set DiscomfAppHotHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_50='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_51='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_52='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_53='elseif (' + zonename + '_OpT < AHSTnoTol)',
                Program_Line_54='set ComfHours_' + zonename + ' = 0',
                Program_Line_55='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_56='set DiscomfAppColdHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_57='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_58='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_59='endif',
                Program_Line_60='elseif (PMOT > ACSTaul)',
                Program_Line_61='set ComfHours_' + zonename + ' = 0',
                Program_Line_62='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_63='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_64='set DiscomfNonAppHotHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_65='set DiscomfNonAppColdHours_' + zonename + ' = 0',
                Program_Line_66='elseif (PMOT < AHSTall)',
                Program_Line_67='set ComfHours_' + zonename + ' = 0',
                Program_Line_68='set DiscomfAppHotHours_' + zonename + ' = 0',
                Program_Line_69='set DiscomfAppColdHours_' + zonename + ' = 0',
                Program_Line_70='set DiscomfNonAppHotHours_' + zonename + ' = 0',
                Program_Line_71='set DiscomfNonAppColdHours_' + zonename + ' = 1*ZoneTimeStep',
                Program_Line_72='endif',
                Program_Line_73='endif',
            )
            if verboseMode:
                print('Added - CountHours_'+zonename+' Program')
    #        print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'CountHours_'+zonename])

    if 'SetAppLimits' in programlist:
        if verboseMode:
            print('Not added - SetAppLimits Program')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Program',
            Name='SetAppLimits',
            Program_Line_1='If ComfStand == 1',
            Program_Line_2='set ACSTaul = 30',
            Program_Line_3='set ACSTall = 10',
            Program_Line_4='set AHSTaul = 30',
            Program_Line_5='set AHSTall = 10',
            Program_Line_6='elseif ComfStand == 2 || ComfStand == 12',
            Program_Line_7='set ACSTaul = 33.5',
            Program_Line_8='set ACSTall = 10',
            Program_Line_9='set AHSTaul = 33.5',
            Program_Line_10='set AHSTall = 10',
            Program_Line_11='elseif ComfStand == 3',
            Program_Line_12='set ACSTaul = 30',
            Program_Line_13='set ACSTall = 5',
            Program_Line_14='set AHSTaul = 30',
            Program_Line_15='set AHSTall = 5',
            Program_Line_16='elseif (ComfStand == 4) || (ComfStand == 5)',
            Program_Line_17='if CAT == 1',
            Program_Line_18='set ACSTaul = 28',
            Program_Line_19='set ACSTall = 18',
            Program_Line_20='set AHSTaul = 28',
            Program_Line_21='set AHSTall = 18',
            Program_Line_22='elseif CAT == 2',
            Program_Line_23='set ACSTaul = 30',
            Program_Line_24='set ACSTall = 18',
            Program_Line_25='set AHSTaul = 28',
            Program_Line_26='set AHSTall = 16',
            Program_Line_27='else',
            Program_Line_28='set ACSTaul = 50',
            Program_Line_29='set ACSTall = 50',
            Program_Line_30='set AHSTaul = 50',
            Program_Line_31='set AHSTall = 50',
            Program_Line_32='endif',
            Program_Line_33='elseif ComfStand == 6',
            Program_Line_34='set ACSTaul = 30',
            Program_Line_35='set ACSTall = -7',
            Program_Line_36='set AHSTaul = 30',
            Program_Line_37='set AHSTall = -7',
            Program_Line_38='elseif ComfStand == 7',
            Program_Line_39='set ACSTaul = 31',
            Program_Line_40='set ACSTall = 12.5',
            Program_Line_41='set AHSTaul = 31',
            Program_Line_42='set AHSTall = 12.5',
            Program_Line_43='elseif ComfStand == 8',
            Program_Line_44='set ACSTaul = 38.5',
            Program_Line_45='set ACSTall = 13',
            Program_Line_46='set AHSTaul = 38.5',
            Program_Line_47='set AHSTall = 13',
            Program_Line_48='elseif ComfStand == 9 || ComfStand == 10 || ComfStand == 11',
            Program_Line_49='set ACSTaul = 33',
            Program_Line_50='set ACSTall = 5.5',
            Program_Line_51='set AHSTaul = 33',
            Program_Line_52='set AHSTall = 5.5',
            Program_Line_53='elseif ComfStand == 13',
            Program_Line_54='set ACSTaul = 25',
            Program_Line_55='set ACSTall = 10',
            Program_Line_56='set AHSTaul = 25',
            Program_Line_57='set AHSTall = 10',
            Program_Line_58='elseif ComfStand == 14',
            Program_Line_59='set ACSTaul = 27',
            Program_Line_60='set ACSTall = 8',
            Program_Line_61='set AHSTaul = 27',
            Program_Line_62='set AHSTall = 8',
            Program_Line_63='elseif ComfStand == 15',
            Program_Line_64='set ACSTaul = 24.8',
            Program_Line_65='set ACSTall = 16.9',
            Program_Line_66='set AHSTaul = 24.8',
            Program_Line_67='set AHSTall = 16.9',
            Program_Line_68='elseif ComfStand == 16',
            Program_Line_69='set ACSTaul = 25.7',
            Program_Line_70='set ACSTall = 16.4',
            Program_Line_71='set AHSTaul = 25.7',
            Program_Line_72='set AHSTall = 16.4',
            Program_Line_73='elseif ComfStand == 17',
            Program_Line_74='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_75='set ACSTaul = 25.25',
            Program_Line_76='set ACSTall = 11.25',
            Program_Line_77='set AHSTaul = 25.25',
            Program_Line_78='set AHSTall = 11.25',
            Program_Line_79='else',
            Program_Line_80='set ACSTaul = 45',
            Program_Line_81='set ACSTall = 23',
            Program_Line_82='set AHSTaul = 45',
            Program_Line_83='set AHSTall = 23',
            Program_Line_84='endif',
            Program_Line_85='elseif ComfStand == 18',
            Program_Line_86='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_87='set ACSTaul = 27.5',
            Program_Line_88='set ACSTall = 15.5',
            Program_Line_89='set AHSTaul = 27.5',
            Program_Line_90='set AHSTall = 15.5',
            Program_Line_91='else',
            Program_Line_92='set ACSTaul = 34',
            Program_Line_93='set ACSTall = 23',
            Program_Line_94='set AHSTaul = 34',
            Program_Line_95='set AHSTall = 23',
            Program_Line_96='endif',
            Program_Line_97='elseif ComfStand == 19',
            Program_Line_98='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_99='set ACSTaul = 25.25',
            Program_Line_100='set ACSTall = 5',
            Program_Line_101='set AHSTaul = 25.25',
            Program_Line_102='set AHSTall = 5',
            Program_Line_103='else',
            Program_Line_104='set ACSTaul = 25.25',
            Program_Line_105='set ACSTall = 11.75',
            Program_Line_106='set AHSTaul = 25.25',
            Program_Line_107='set AHSTall = 11.75',
            Program_Line_108='endif',
            Program_Line_109='elseif ComfStand == 20',
            Program_Line_110='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_111='set ACSTaul = 29.75',
            Program_Line_112='set ACSTall = 13',
            Program_Line_113='set AHSTaul = 29.75',
            Program_Line_114='set AHSTall = 13',
            Program_Line_115='else',
            Program_Line_116='set ACSTaul = 45',
            Program_Line_117='set ACSTall = 23',
            Program_Line_118='set AHSTaul = 45',
            Program_Line_119='set AHSTall = 23',
            Program_Line_120='endif',
            Program_Line_121='elseif ComfStand == 21',
            Program_Line_122='set ACSTaul = 20',
            Program_Line_123='set ACSTall = 6.5',
            Program_Line_124='set AHSTaul = 20',
            Program_Line_125='set AHSTall = 6.5',
            Program_Line_126='else',
            Program_Line_127='set ACSTaul = 50',
            Program_Line_128='set ACSTall = 50',
            Program_Line_129='set AHSTaul = 50',
            Program_Line_130='set AHSTall = 50',
            Program_Line_131='endif',
        )
        if verboseMode:
            print('Added - SetAppLimits Program')
    #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetAppLimits'])

    if 'ApplyCAT' in programlist:
        if verboseMode:
            print('Not added - ApplyCAT Program')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Program',
            Name='ApplyCAT',
            Program_Line_1='if (ComfStand == 1 )',
            Program_Line_2='if (CAT == 1)',
            Program_Line_3='set ACSToffset = 2',
            Program_Line_4='set AHSToffset = -3',
            Program_Line_5='elseif (CAT == 2)',
            Program_Line_6='set ACSToffset = 3',
            Program_Line_7='set AHSToffset = -4',
            Program_Line_8='elseif (CAT == 3)',
            Program_Line_9='set ACSToffset = 4',
            Program_Line_10='set AHSToffset = -5',
            Program_Line_11='endif',
            Program_Line_12='elseif ComfStand == 2 || ComfStand == 3 || ComfStand == 11',
            Program_Line_13='if (CAT == 90)',
            Program_Line_14='set ACSToffset = 2.5',
            Program_Line_15='set AHSToffset = -2.5',
            Program_Line_16='elseif (CAT == 80)',
            Program_Line_17='set ACSToffset = 3.5',
            Program_Line_18='set AHSToffset = -3.5',
            Program_Line_19='endif',
            Program_Line_20='elseif (ComfStand == 4 ) || (ComfStand == 5) || (ComfStand == 6)',
            Program_Line_21='set ACSToffset = 0',
            Program_Line_22='set AHSToffset = 0',
            Program_Line_23='elseif (ComfStand == 7)',
            Program_Line_24='if (CAT == 90)',
            Program_Line_25='set ACSToffset = 2.4',
            Program_Line_26='set AHSToffset = -2.4',
            Program_Line_27='elseif (CAT == 85)',
            Program_Line_28='set ACSToffset = 3.3',
            Program_Line_29='set AHSToffset = -3.3',
            Program_Line_30='elseif (CAT == 80)',
            Program_Line_31='set ACSToffset = 4.1',
            Program_Line_32='set AHSToffset = -4.1',
            Program_Line_33='endif',
            Program_Line_34='elseif (ComfStand == 8)',
            Program_Line_35='if (CAT == 90)',
            Program_Line_36='set ACSToffset = 3.5',
            Program_Line_37='set AHSToffset = -3.5',
            Program_Line_38='elseif (CAT == 85)',
            Program_Line_39='set ACSToffset = 4.8',
            Program_Line_40='set AHSToffset = -4.8',
            Program_Line_41='elseif (CAT == 80)',
            Program_Line_42='set ACSToffset = 5.9',
            Program_Line_43='set AHSToffset = -5.9',
            Program_Line_44='endif',
            Program_Line_45='elseif ComfStand == 9 || ComfStand == 10',
            Program_Line_46='if (CAT == 90)',
            Program_Line_47='set ACSToffset = 2.15',
            Program_Line_48='set AHSToffset = -2.15',
            Program_Line_49='elseif (CAT == 80)',
            Program_Line_50='set ACSToffset = 3.6',
            Program_Line_51='set AHSToffset = -3.6',
            Program_Line_52='endif',
            Program_Line_53='elseif ComfStand == 12',
            Program_Line_54='if (CAT == 90)',
            Program_Line_55='set ACSToffset = 1.7',
            Program_Line_56='set AHSToffset = -1.7',
            Program_Line_57='elseif (CAT == 80)',
            Program_Line_58='set ACSToffset = 2.89',
            Program_Line_59='set AHSToffset = -2.89',
            Program_Line_60='endif',
            Program_Line_61='elseif ComfStand == 13',
            Program_Line_62='if (CAT == 90)',
            Program_Line_63='set ACSToffset = 3.45',
            Program_Line_64='set AHSToffset = -3.45',
            Program_Line_65='elseif (CAT == 80)',
            Program_Line_66='set ACSToffset = 4.55',
            Program_Line_67='set AHSToffset = -4.55',
            Program_Line_68='endif',
            Program_Line_69='elseif ComfStand == 14',
            Program_Line_70='if (CAT == 90)',
            Program_Line_71='set ACSToffset = 3.5',
            Program_Line_72='set AHSToffset = -3.5',
            Program_Line_73='elseif (CAT == 80)',
            Program_Line_74='set ACSToffset = 4.5',
            Program_Line_75='set AHSToffset = -4.5',
            Program_Line_76='endif',
            Program_Line_77='elseif ComfStand == 15',
            Program_Line_78='if (CAT == 90)',
            Program_Line_79='set ACSToffset = 2.8',
            Program_Line_80='set AHSToffset = -2.8',
            Program_Line_81='elseif (CAT == 80)',
            Program_Line_82='set ACSToffset = 3.8',
            Program_Line_83='set AHSToffset = -3.8',
            Program_Line_84='endif',
            Program_Line_85='elseif ComfStand == 16',
            Program_Line_86='if (CAT == 90)',
            Program_Line_87='set ACSToffset = 1.1',
            Program_Line_88='set AHSToffset = -1.1',
            Program_Line_89='elseif (CAT == 80)',
            Program_Line_90='set ACSToffset = 2.1',
            Program_Line_91='set AHSToffset = -2.1',
            Program_Line_92='endif',
            Program_Line_93='elseif (ComfStand == 17) || (ComfStand == 18)',
            Program_Line_94='if CAT == 90',
            Program_Line_95='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_96='set ACSToffset = 2',
            Program_Line_97='set AHSToffset = -2',
            Program_Line_98='else',
            Program_Line_99='set ACSToffset = 2',
            Program_Line_100='set AHSToffset = -2',
            Program_Line_101='endif',
            Program_Line_102='elseif CAT == 80',
            Program_Line_103='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_104='set ACSToffset = 3',
            Program_Line_105='set AHSToffset = -3',
            Program_Line_106='else',
            Program_Line_107='set ACSToffset = 3',
            Program_Line_108='set AHSToffset = -3',
            Program_Line_109='endif',
            Program_Line_110='endif',
            Program_Line_111='elseif ComfStand == 19',
            Program_Line_112='if CAT == 90',
            Program_Line_113='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_114='set ACSToffset = 2',
            Program_Line_115='set AHSToffset = -2',
            Program_Line_116='else',
            Program_Line_117='set ACSToffset = 1',
            Program_Line_118='set AHSToffset = -1',
            Program_Line_119='endif',
            Program_Line_120='elseif CAT == 80',
            Program_Line_121='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_122='set ACSToffset = 3',
            Program_Line_123='set AHSToffset = -3',
            Program_Line_124='else',
            Program_Line_125='set ACSToffset = 2',
            Program_Line_126='set AHSToffset = -2',
            Program_Line_127='endif',
            Program_Line_128='endif',
            Program_Line_129='elseif ComfStand == 20',
            Program_Line_130='if CAT == 90',
            Program_Line_131='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_132='set ACSToffset = 2',
            Program_Line_133='set AHSToffset = -2',
            Program_Line_134='else',
            Program_Line_135='set ACSToffset = 5',
            Program_Line_136='set AHSToffset = -5',
            Program_Line_137='endif',
            Program_Line_138='elseif CAT == 80',
            Program_Line_139='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_140='set ACSToffset = 3',
            Program_Line_141='set AHSToffset = -3',
            Program_Line_142='else',
            Program_Line_143='set ACSToffset = 6',
            Program_Line_144='set AHSToffset = -6',
            Program_Line_145='endif',
            Program_Line_146='endif',
            Program_Line_147='elseif ComfStand == 21',
            Program_Line_148='if (CAT == 90)',
            Program_Line_149='set ACSToffset = 2.5',
            Program_Line_150='set AHSToffset = -2.5',
            Program_Line_151='elseif (CAT == 80)',
            Program_Line_152='set ACSToffset = 4',
            Program_Line_153='set AHSToffset = -4',
            Program_Line_154='endif',
            Program_Line_155='endif',
        )
        if verboseMode:
            print('Added - ApplyCAT Program')
    #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'ApplyCAT'])

    if 'SetAST' in programlist:
        if verboseMode:
            print('Not added - SetAST Program')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Program',
            Name='SetAST',
            Program_Line_1='if (ComfStand == 0) && (CurrentTime < 8)',
            Program_Line_2='set ACST = 27+ACSTtol',
            Program_Line_3='set AHST = 17+AHSTtol',
            Program_Line_4='elseif (ComfStand == 0) && (CurrentTime < 16)',
            Program_Line_5='set ACST = 25+ACSTtol',
            Program_Line_6='set AHST = 20+AHSTtol',
            Program_Line_7='elseif (ComfStand == 0) && (CurrentTime < 23)',
            Program_Line_8='set ACST = 25+ACSTtol',
            Program_Line_9='set AHST = 20+AHSTtol',
            Program_Line_10='elseif (ComfStand == 0) && (CurrentTime < 24)',
            Program_Line_11='set ACST = 27+ACSTtol',
            Program_Line_12='set AHST = 17+AHSTtol',
            Program_Line_13='endif',
            Program_Line_14='if (ComfStand == 1) && (ComfMod == 0)',
            Program_Line_15='if (DayOfYear >= 121) && (DayOfYear < 274)',
            Program_Line_16='if (CAT==1)',
            Program_Line_17='set ACST = 25.5+ACSTtol',
            Program_Line_18='elseif (CAT==2)',
            Program_Line_19='set ACST = 26+ACSTtol',
            Program_Line_20='elseif (CAT==3)',
            Program_Line_21='set ACST = 27+ACSTtol',
            Program_Line_22='endif',
            Program_Line_23='else',
            Program_Line_24='if (CAT==1)',
            Program_Line_25='set ACST = 25+ACSTtol',
            Program_Line_26='elseif (CAT==2)',
            Program_Line_27='set ACST = 25+ACSTtol',
            Program_Line_28='elseif (CAT==3)',
            Program_Line_29='set ACST = 25+ACSTtol',
            Program_Line_30='endif',
            Program_Line_31='endif',
            Program_Line_32='endif',
            Program_Line_33='if (ComfStand == 1) && (ComfMod == 0)',
            Program_Line_34='if (DayOfYear >= 121) && (DayOfYear < 274)',
            Program_Line_35='if (CAT==1)',
            Program_Line_36='set AHST = 23.5+AHSTtol',
            Program_Line_37='elseif (CAT==2)',
            Program_Line_38='set AHST = 23+AHSTtol',
            Program_Line_39='elseif (CAT==3)',
            Program_Line_40='set AHST = 22+AHSTtol',
            Program_Line_41='endif',
            Program_Line_42='else',
            Program_Line_43='if (CAT==1)',
            Program_Line_44='set AHST = 21+AHSTtol',
            Program_Line_45='elseif (CAT==2)',
            Program_Line_46='set AHST = 20+AHSTtol',
            Program_Line_47='elseif (CAT==3)',
            Program_Line_48='set AHST = 18+AHSTtol',
            Program_Line_49='endif',
            Program_Line_50='endif',
            Program_Line_51='endif',
            Program_Line_52='if (ComfStand == 1) && (ComfMod == 1)',
            Program_Line_53='if (RMOT >= ACSTall) && (RMOT <= ACSTaul)',
            Program_Line_54='set ACST = RMOT*0.33+18.8+ACSToffset+ACSTtol',
            Program_Line_55='elseif CurrentTime < 7',
            Program_Line_56='set ACST = 27+ACSTtol',
            Program_Line_57='elseif CurrentTime < 15',
            Program_Line_58='set ACST = 50',
            Program_Line_59='elseif CurrentTime < 23',
            Program_Line_60='set ACST = 25+ACSTtol',
            Program_Line_61='elseif CurrentTime < 24',
            Program_Line_62='set ACST = 27+ACSTtol',
            Program_Line_63='endif',
            Program_Line_64='endif',
            Program_Line_65='if (ComfStand == 1) && (ComfMod == 1)',
            Program_Line_66='if (RMOT >= AHSTall) && (RMOT <= AHSTaul)',
            Program_Line_67='set AHST = RMOT*0.33+18.8+AHSToffset+AHSTtol',
            Program_Line_68='elseif CurrentTime < 7',
            Program_Line_69='set AHST = 17+AHSTtol',
            Program_Line_70='elseif CurrentTime < 23',
            Program_Line_71='set AHST = 20+AHSTtol',
            Program_Line_72='elseif CurrentTime < 24',
            Program_Line_73='set AHST = 17+AHSTtol',
            Program_Line_74='endif',
            Program_Line_75='endif',
            Program_Line_76='if (ComfStand == 1) && (ComfMod == 2)',
            Program_Line_77='if (RMOT >= ACSTall) && (RMOT <= ACSTaul)',
            Program_Line_78='set ACST = RMOT*0.33+18.8+ACSToffset+ACSTtol',
            Program_Line_79='elseif (RMOT < ACSTall) && (CAT==1)',
            Program_Line_80='set ACST = 25+ACSTtol',
            Program_Line_81='elseif (RMOT > ACSTaul) && (CAT==1)',
            Program_Line_82='set ACST = 25.5+ACSTtol',
            Program_Line_83='elseif (RMOT < ACSTall) && (CAT==2)',
            Program_Line_84='set ACST = 25+ACSTtol',
            Program_Line_85='elseif (RMOT > ACSTaul) && (CAT==2)',
            Program_Line_86='set ACST = 26+ACSTtol',
            Program_Line_87='elseif (RMOT < ACSTall) && (CAT==3)',
            Program_Line_88='set ACST = 25+ACSTtol',
            Program_Line_89='elseif (RMOT > ACSTaul) && (CAT==3)',
            Program_Line_90='set ACST = 27+ACSTtol',
            Program_Line_91='endif',
            Program_Line_92='endif',
            Program_Line_93='if (ComfStand == 1) && (ComfMod == 2)',
            Program_Line_94='if (RMOT >= AHSTall) && (RMOT <= AHSTaul)',
            Program_Line_95='set AHST = RMOT*0.33+18.8+AHSToffset+AHSTtol',
            Program_Line_96='elseif (RMOT < AHSTall) && (CAT==1)',
            Program_Line_97='set AHST = 21+AHSTtol',
            Program_Line_98='elseif (RMOT > AHSTaul) && (CAT==1)',
            Program_Line_99='set AHST = 23.5+AHSTtol',
            Program_Line_100='elseif (RMOT < AHSTall) && (CAT==2)',
            Program_Line_101='set AHST = 20+AHSTtol',
            Program_Line_102='elseif (RMOT > AHSTaul) && (CAT==2)',
            Program_Line_103='set AHST = 23+AHSTtol',
            Program_Line_104='elseif (RMOT < AHSTall) && (CAT==3)',
            Program_Line_105='set AHST = 18+AHSTtol',
            Program_Line_106='elseif (RMOT > AHSTaul) && (CAT==3)',
            Program_Line_107='set AHST = 22+AHSTtol',
            Program_Line_108='endif',
            Program_Line_109='endif',
            Program_Line_110='if (ComfStand == 1) && (ComfMod == 3)',
            Program_Line_111='if (RMOT >= ACSTall) && (RMOT <= ACSTaul)',
            Program_Line_112='set ACST = RMOT*0.33+18.8+ACSToffset+ACSTtol',
            Program_Line_113='elseif RMOT < ACSTall',
            Program_Line_114='set ACST = ACSTall*0.33+18.8+ACSToffset+ACSTtol',
            Program_Line_115='elseif RMOT > ACSTaul',
            Program_Line_116='set ACST = ACSTaul*0.33+18.8+ACSToffset+ACSTtol',
            Program_Line_117='endif',
            Program_Line_118='endif',
            Program_Line_119='if (ComfStand == 1) && (ComfMod == 3)',
            Program_Line_120='if (RMOT >= AHSTall) && (RMOT <= AHSTaul)',
            Program_Line_121='set AHST = RMOT*0.33+18.8+AHSToffset+AHSTtol',
            Program_Line_122='elseif RMOT < AHSTall',
            Program_Line_123='set AHST = AHSTall*0.33+18.8+AHSToffset+AHSTtol',
            Program_Line_124='elseif RMOT > AHSTaul',
            Program_Line_125='set AHST = AHSTaul*0.33+18.8+AHSToffset+AHSTtol',
            Program_Line_126='endif',
            Program_Line_127='endif',
            Program_Line_128='if (ComfStand == 2) && (ComfMod == 0)',
            Program_Line_129='if (DayOfYear >= 121) && (DayOfYear < 274)',
            Program_Line_130='if (CAT==80)',
            Program_Line_131='set ACST = 27+ACSTtol',
            Program_Line_132='elseif (CAT==90)',
            Program_Line_133='set ACST = 26+ACSTtol',
            Program_Line_134='endif',
            Program_Line_135='else',
            Program_Line_136='if (CAT==80)',
            Program_Line_137='set ACST = 25+ACSTtol',
            Program_Line_138='elseif (CAT==90)',
            Program_Line_139='set ACST = 24+ACSTtol',
            Program_Line_140='endif',
            Program_Line_141='endif',
            Program_Line_142='endif',
            Program_Line_143='if (ComfStand == 2) && (ComfMod == 0)',
            Program_Line_144='if (DayOfYear >= 121) && (DayOfYear < 274)',
            Program_Line_145='if (CAT==80)',
            Program_Line_146='set AHST = 22+AHSTtol',
            Program_Line_147='elseif (CAT==90)',
            Program_Line_148='set AHST = 23+AHSTtol',
            Program_Line_149='endif',
            Program_Line_150='else',
            Program_Line_151='if (CAT==80)',
            Program_Line_152='set AHST = 19+AHSTtol',
            Program_Line_153='elseif (CAT==90)',
            Program_Line_154='set AHST = 20+AHSTtol',
            Program_Line_155='endif',
            Program_Line_156='endif',
            Program_Line_157='endif',
            Program_Line_158='if (ComfStand == 2) && (ComfMod == 1)',
            Program_Line_159='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_160='set ACST = PMOT*0.31+17.8+ACSToffset+ACSTtol',
            Program_Line_161='elseif CurrentTime < 7',
            Program_Line_162='set ACST = 27+ACSTtol',
            Program_Line_163='elseif CurrentTime < 15',
            Program_Line_164='set ACST = 50',
            Program_Line_165='elseif CurrentTime < 23',
            Program_Line_166='set ACST = 25+ACSTtol',
            Program_Line_167='elseif CurrentTime < 24',
            Program_Line_168='set ACST = 27+ACSTtol',
            Program_Line_169='endif',
            Program_Line_170='endif',
            Program_Line_171='if (ComfStand == 2) && (ComfMod == 1)',
            Program_Line_172='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_173='set AHST = PMOT*0.31+17.8+AHSToffset+AHSTtol',
            Program_Line_174='elseif CurrentTime < 7',
            Program_Line_175='set AHST = 17+AHSTtol',
            Program_Line_176='elseif CurrentTime < 23',
            Program_Line_177='set AHST = 20+AHSTtol',
            Program_Line_178='elseif CurrentTime < 24',
            Program_Line_179='set AHST = 17+AHSTtol',
            Program_Line_180='endif',
            Program_Line_181='endif',
            Program_Line_182='if (ComfStand == 2) && (ComfMod == 2)',
            Program_Line_183='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_184='set ACST = PMOT*0.31+17.8+ACSToffset+ACSTtol',
            Program_Line_185='elseif CAT==80',
            Program_Line_186='if PMOT < ACSTall',
            Program_Line_187='set ACST = 25+ACSTtol',
            Program_Line_188='elseif PMOT > ACSTaul',
            Program_Line_189='set ACST = 27+ACSTtol',
            Program_Line_190='endif',
            Program_Line_191='elseif CAT==90',
            Program_Line_192='if PMOT < ACSTall',
            Program_Line_193='set ACST = 24+ACSTtol',
            Program_Line_194='elseif PMOT > ACSTaul',
            Program_Line_195='set ACST = 26+ACSTtol',
            Program_Line_196='endif',
            Program_Line_197='endif',
            Program_Line_198='endif',
            Program_Line_199='if (ComfStand == 2) && (ComfMod == 2)',
            Program_Line_200='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_201='set AHST = PMOT*0.31+17.8+AHSToffset+AHSTtol',
            Program_Line_202='elseif CAT==80',
            Program_Line_203='if PMOT < AHSTall',
            Program_Line_204='set AHST = 19+AHSTtol',
            Program_Line_205='elseif PMOT > AHSTaul',
            Program_Line_206='set AHST = 22+AHSTtol',
            Program_Line_207='endif',
            Program_Line_208='elseif CAT==90',
            Program_Line_209='if PMOT < AHSTall',
            Program_Line_210='set AHST = 20+AHSTtol',
            Program_Line_211='elseif PMOT > AHSTaul',
            Program_Line_212='set AHST = 23+AHSTtol',
            Program_Line_213='endif',
            Program_Line_214='endif',
            Program_Line_215='endif',
            Program_Line_216='if (ComfStand == 2) && (ComfMod == 3)',
            Program_Line_217='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_218='set ACST = PMOT*0.31+17.8+ACSToffset+ACSTtol',
            Program_Line_219='elseif PMOT < ACSTall',
            Program_Line_220='set ACST = ACSTall*0.31+17.8+ACSToffset+ACSTtol',
            Program_Line_221='elseif PMOT > ACSTaul',
            Program_Line_222='set ACST = ACSTaul*0.31+17.8+ACSToffset+ACSTtol',
            Program_Line_223='endif',
            Program_Line_224='endif',
            Program_Line_225='if (ComfStand == 2) && (ComfMod == 3)',
            Program_Line_226='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_227='set AHST = PMOT*0.31+17.8+AHSToffset+AHSTtol',
            Program_Line_228='elseif PMOT < AHSTall',
            Program_Line_229='set AHST = AHSTall*0.31+17.8+AHSToffset+AHSTtol',
            Program_Line_230='elseif PMOT > AHSTaul',
            Program_Line_231='set AHST = AHSTaul*0.31+17.8+AHSToffset+AHSTtol',
            Program_Line_232='endif',
            Program_Line_233='endif',
            Program_Line_234='if (ComfStand == 3) && (ComfMod == 0)',
            Program_Line_235='if (CAT==80)',
            Program_Line_236='set ACST = 28+ACSTtol',
            Program_Line_237='elseif (CAT==90)',
            Program_Line_238='set ACST = 27+ACSTtol',
            Program_Line_239='endif',
            Program_Line_240='endif',
            Program_Line_241='if (ComfStand == 3) && (ComfMod == 0)',
            Program_Line_242='if (CAT==80)',
            Program_Line_243='set AHST = 18+AHSTtol',
            Program_Line_244='elseif (CAT==90)',
            Program_Line_245='set AHST = 19+AHSTtol',
            Program_Line_246='endif',
            Program_Line_247='endif',
            Program_Line_248='if (ComfStand == 3) && (ComfMod == 1)',
            Program_Line_249='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_250='set ACST = PMOT*0.48+14.4+ACSToffset+ACSTtol',
            Program_Line_251='elseif CAT==80',
            Program_Line_252='if PMOT < ACSTall',
            Program_Line_253='set ACST = 28+ACSTtol',
            Program_Line_254='elseif PMOT > ACSTaul',
            Program_Line_255='set ACST = 28+ACSTtol',
            Program_Line_256='endif',
            Program_Line_257='elseif CAT==90',
            Program_Line_258='if PMOT < ACSTall',
            Program_Line_259='set ACST = 27+ACSTtol',
            Program_Line_260='elseif PMOT > ACSTaul',
            Program_Line_261='set ACST = 27+ACSTtol',
            Program_Line_262='endif',
            Program_Line_263='endif',
            Program_Line_264='endif',
            Program_Line_265='if (ComfStand == 3) && (ComfMod == 1)',
            Program_Line_266='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_267='set AHST = PMOT*0.48+14.4+AHSToffset+AHSTtol',
            Program_Line_268='elseif CAT==80',
            Program_Line_269='if PMOT < AHSTall',
            Program_Line_270='set AHST = 18+AHSTtol',
            Program_Line_271='elseif PMOT > AHSTaul',
            Program_Line_272='set AHST = 18+AHSTtol',
            Program_Line_273='endif',
            Program_Line_274='elseif CAT==90',
            Program_Line_275='if PMOT < AHSTall',
            Program_Line_276='set AHST = 19+AHSTtol',
            Program_Line_277='elseif PMOT > AHSTaul',
            Program_Line_278='set AHST = 19+AHSTtol',
            Program_Line_279='endif',
            Program_Line_280='endif',
            Program_Line_281='endif',
            Program_Line_282='if (ComfStand == 3) && (ComfMod == 2)',
            Program_Line_283='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_284='set ACST = PMOT*0.48+14.4+ACSToffset+ACSTtol',
            Program_Line_285='elseif CAT==80',
            Program_Line_286='if PMOT < ACSTall',
            Program_Line_287='set ACST = 25+ACSTtol',
            Program_Line_288='elseif PMOT > ACSTaul',
            Program_Line_289='set ACST = 27+ACSTtol',
            Program_Line_290='endif',
            Program_Line_291='elseif CAT==90',
            Program_Line_292='if PMOT < ACSTall',
            Program_Line_293='set ACST = 24+ACSTtol',
            Program_Line_294='elseif PMOT > ACSTaul',
            Program_Line_295='set ACST = 26+ACSTtol',
            Program_Line_296='endif',
            Program_Line_297='endif',
            Program_Line_298='endif',
            Program_Line_299='if (ComfStand == 3) && (ComfMod == 2)',
            Program_Line_300='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_301='set AHST = PMOT*0.48+14.4+AHSToffset+AHSTtol',
            Program_Line_302='elseif CAT==80',
            Program_Line_303='if PMOT < AHSTall',
            Program_Line_304='set AHST = 19+AHSTtol',
            Program_Line_305='elseif PMOT > AHSTaul',
            Program_Line_306='set AHST = 22+AHSTtol',
            Program_Line_307='endif',
            Program_Line_308='elseif CAT==90',
            Program_Line_309='if PMOT < AHSTall',
            Program_Line_310='set AHST = 20+AHSTtol',
            Program_Line_311='elseif PMOT > AHSTaul',
            Program_Line_312='set AHST = 23+AHSTtol',
            Program_Line_313='endif',
            Program_Line_314='endif',
            Program_Line_315='endif',
            Program_Line_316='if (ComfStand == 3) && (ComfMod == 3)',
            Program_Line_317='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_318='set ACST = PMOT*0.48+14.4+ACSToffset+ACSTtol',
            Program_Line_319='elseif PMOT < ACSTall',
            Program_Line_320='set ACST = ACSTall*0.48+14.4+ACSToffset+ACSTtol',
            Program_Line_321='elseif PMOT > ACSTaul',
            Program_Line_322='set ACST = ACSTaul*0.48+14.4+ACSToffset+ACSTtol',
            Program_Line_323='endif',
            Program_Line_324='endif',
            Program_Line_325='if (ComfStand == 3) && (ComfMod == 3)',
            Program_Line_326='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_327='set AHST = PMOT*0.48+14.4+AHSToffset+AHSTtol',
            Program_Line_328='elseif PMOT < AHSTall',
            Program_Line_329='set AHST = AHSTall*0.48+14.4+AHSToffset+AHSTtol',
            Program_Line_330='elseif PMOT > AHSTaul',
            Program_Line_331='set AHST = AHSTaul*0.48+14.4+AHSToffset+AHSTtol',
            Program_Line_332='endif',
            Program_Line_333='endif',
            Program_Line_334='if (ComfStand == 4) && (ComfMod == 3)',
            Program_Line_335='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_336='if CAT == 1',
            Program_Line_337='set ACST = PMOT*0.77+12.04+ACSTtol',
            Program_Line_338='elseif CAT == 2',
            Program_Line_339='set ACST = PMOT*0.73+15.28+ACSTtol',
            Program_Line_340='endif',
            Program_Line_341='elseif PMOT < ACSTall',
            Program_Line_342='if CAT == 1',
            Program_Line_343='set ACST = ACSTall*0.77+12.04+ACSTtol',
            Program_Line_344='elseif CAT == 2',
            Program_Line_345='set ACST = ACSTall*0.73+15.28+ACSTtol',
            Program_Line_346='endif',
            Program_Line_347='elseif PMOT > ACSTaul',
            Program_Line_348='if CAT == 1',
            Program_Line_349='set ACST = ACSTaul*0.77+12.04+ACSTtol',
            Program_Line_350='elseif CAT == 2',
            Program_Line_351='set ACST = ACSTaul*0.73+15.28+ACSTtol',
            Program_Line_352='endif',
            Program_Line_353='endif',
            Program_Line_354='endif',
            Program_Line_355='if (ComfStand == 4) && (ComfMod == 3)',
            Program_Line_356='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_357='if CAT == 1',
            Program_Line_358='set AHST = PMOT*0.87+2.76+AHSTtol',
            Program_Line_359='elseif CAT == 2',
            Program_Line_360='set AHST = PMOT*0.91-0.48+AHSTtol',
            Program_Line_361='endif',
            Program_Line_362='elseif PMOT < AHSTall',
            Program_Line_363='if CAT == 1',
            Program_Line_364='set AHST = AHSTall*0.87+2.76+AHSTtol',
            Program_Line_365='elseif CAT == 2',
            Program_Line_366='set AHST = AHSTall*0.91-0.48+AHSTtol',
            Program_Line_367='endif',
            Program_Line_368='elseif PMOT > AHSTaul',
            Program_Line_369='if CAT == 1',
            Program_Line_370='set AHST = AHSTaul*0.87+2.76+AHSTtol',
            Program_Line_371='elseif CAT == 2',
            Program_Line_372='set AHST = AHSTaul*0.91-0.48+AHSTtol',
            Program_Line_373='endif',
            Program_Line_374='endif',
            Program_Line_375='endif',
            Program_Line_376='if (ComfStand == 5) && (ComfMod == 3)',
            Program_Line_377='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_378='if CAT == 1',
            Program_Line_379='set ACST = PMOT*0.77+9.34+ACSTtol',
            Program_Line_380='elseif CAT == 2',
            Program_Line_381='set ACST = PMOT*0.73+12.72+ACSTtol',
            Program_Line_382='endif',
            Program_Line_383='elseif PMOT < ACSTall',
            Program_Line_384='if CAT == 1',
            Program_Line_385='set ACST = ACSTall*0.77+9.34+ACSTtol',
            Program_Line_386='elseif CAT == 2',
            Program_Line_387='set ACST = ACSTall*0.73+12.72+ACSTtol',
            Program_Line_388='endif',
            Program_Line_389='elseif PMOT > ACSTaul',
            Program_Line_390='if CAT == 1',
            Program_Line_391='set ACST = ACSTaul*0.77+9.34+ACSTtol',
            Program_Line_392='elseif CAT == 2',
            Program_Line_393='set ACST = ACSTaul*0.73+12.72+ACSTtol',
            Program_Line_394='endif',
            Program_Line_395='endif',
            Program_Line_396='endif',
            Program_Line_397='if (ComfStand == 5) && (ComfMod == 3)',
            Program_Line_398='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_399='if CAT == 1',
            Program_Line_400='set AHST = PMOT*0.87-0.31+AHSTtol',
            Program_Line_401='elseif CAT == 2',
            Program_Line_402='set AHST = PMOT*0.91-3.69+AHSTtol',
            Program_Line_403='endif',
            Program_Line_404='elseif PMOT < AHSTall',
            Program_Line_405='if CAT == 1',
            Program_Line_406='set AHST = AHSTall*0.87-0.31+AHSTtol',
            Program_Line_407='elseif CAT == 2',
            Program_Line_408='set AHST = AHSTall*0.91-3.69+AHSTtol',
            Program_Line_409='endif',
            Program_Line_410='elseif PMOT > AHSTaul',
            Program_Line_411='if CAT == 1',
            Program_Line_412='set AHST = AHSTaul*0.87-0.31+AHSTtol',
            Program_Line_413='elseif CAT == 2',
            Program_Line_414='set AHST = AHSTaul*0.91-3.69+AHSTtol',
            Program_Line_415='endif',
            Program_Line_416='endif',
            Program_Line_417='endif',
            Program_Line_418='if (ComfStand == 6) && (ComfMod == 2)',
            Program_Line_419='if CAT==80',
            Program_Line_420='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_421='set ACST = PMOT*0.30+25.9+ACSTtol',
            Program_Line_422='elseif PMOT < ACSTall',
            Program_Line_423='set ACST = 25+ACSTtol',
            Program_Line_424='elseif PMOT > ACSTaul',
            Program_Line_425='set ACST = 27+ACSTtol',
            Program_Line_426='endif',
            Program_Line_427='elseif CAT==90',
            Program_Line_428='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_429='set ACST = PMOT*0.30+23.6+ACSTtol',
            Program_Line_430='elseif PMOT < ACSTall',
            Program_Line_431='set ACST = 24+ACSTtol',
            Program_Line_432='elseif PMOT > ACSTaul',
            Program_Line_433='set ACST = 26+ACSTtol',
            Program_Line_434='endif',
            Program_Line_435='endif',
            Program_Line_436='endif',
            Program_Line_437='if (ComfStand == 6) && (ComfMod == 2)',
            Program_Line_438='if CAT==80',
            Program_Line_439='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_440='set AHST = PMOT*0.30+25.9+AHSTtol',
            Program_Line_441='elseif PMOT < AHSTall',
            Program_Line_442='set AHST = 19+AHSTtol',
            Program_Line_443='elseif PMOT > AHSTaul',
            Program_Line_444='set AHST = 22+AHSTtol',
            Program_Line_445='endif',
            Program_Line_446='elseif CAT==90',
            Program_Line_447='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_448='set AHST = PMOT*0.30+23.6+AHSTtol',
            Program_Line_449='elseif PMOT < AHSTall',
            Program_Line_450='set AHST = 20+AHSTtol',
            Program_Line_451='elseif PMOT > AHSTaul',
            Program_Line_452='set AHST = 23+AHSTtol',
            Program_Line_453='endif',
            Program_Line_454='endif',
            Program_Line_455='endif',
            Program_Line_456='if (ComfStand == 6) && (ComfMod == 3)',
            Program_Line_457='if CAT == 80',
            Program_Line_458='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_459='set ACST = PMOT*0.30+25.9+ACSTtol',
            Program_Line_460='elseif (PMOT < ACSTall)',
            Program_Line_461='set ACST = ACSTall*0.30+25.9+ACSTtol',
            Program_Line_462='elseif (PMOT > ACSTaul)',
            Program_Line_463='set ACST = ACSTaul*0.30+25.9+ACSTtol',
            Program_Line_464='endif',
            Program_Line_465='elseif CAT == 90',
            Program_Line_466='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_467='set ACST = PMOT*0.30+23.6+ACSTtol',
            Program_Line_468='elseif (PMOT < ACSTall)',
            Program_Line_469='set ACST = ACSTall*0.30+23.6+ACSTtol',
            Program_Line_470='elseif (PMOT > ACSTaul)',
            Program_Line_471='set ACST = ACSTaul*0.30+23.6+ACSTtol',
            Program_Line_472='endif',
            Program_Line_473='endif',
            Program_Line_474='endif',
            Program_Line_475='if (ComfStand == 6) && (ComfMod == 3)',
            Program_Line_476='if CAT == 80',
            Program_Line_477='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_478='set AHST = PMOT*0.32+14.88+AHSTtol',
            Program_Line_479='elseif (PMOT < AHSTall)',
            Program_Line_480='set AHST = AHSTall*0.32+14.88+AHSTtol',
            Program_Line_481='elseif (PMOT > AHSTaul)',
            Program_Line_482='set AHST = AHSTaul*0.32+14.88+AHSTtol',
            Program_Line_483='endif',
            Program_Line_484='elseif CAT == 90',
            Program_Line_485='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_486='set AHST = PMOT*0.31+17.14+AHSTtol',
            Program_Line_487='elseif (PMOT < AHSTall)',
            Program_Line_488='set AHST = AHSTall*0.31+17.14+AHSTtol',
            Program_Line_489='elseif (PMOT > AHSTaul)',
            Program_Line_490='set AHST = AHSTaul*0.31+17.14+AHSTtol',
            Program_Line_491='endif',
            Program_Line_492='endif',
            Program_Line_493='endif',
            Program_Line_494='if ComfStand == 7 || ComfStand == 8 || ComfStand == 9 || ComfStand == 10',
            Program_Line_495='if (ComfMod == 0)',
            Program_Line_496='if CAT==80',
            Program_Line_497='set ACST = PMOT*0.078+23.25+2.72+ACSTtol',
            Program_Line_498='elseif CAT==85',
            Program_Line_499='set ACST = PMOT*0.078+23.25+2.11+ACSTtol',
            Program_Line_500='elseif CAT==90',
            Program_Line_501='set ACST = PMOT*0.078+23.25+1.5+ACSTtol',
            Program_Line_502='endif',
            Program_Line_503='endif',
            Program_Line_504='endif',
            Program_Line_505='if ComfStand == 7 || ComfStand == 8 || ComfStand == 9 || ComfStand == 10',
            Program_Line_506='if (ComfMod == 0)',
            Program_Line_507='if CAT==80',
            Program_Line_508='set AHST = PMOT*0.078+23.25-2.72+AHSTtol',
            Program_Line_509='elseif CAT==85',
            Program_Line_510='set AHST = PMOT*0.078+23.25-2.11+AHSTtol',
            Program_Line_511='elseif CAT==90',
            Program_Line_512='set AHST = PMOT*0.078+23.25-1.5+AHSTtol',
            Program_Line_513='endif',
            Program_Line_514='endif',
            Program_Line_515='endif',
            Program_Line_516='if (ComfStand == 7) && (ComfMod == 1)',
            Program_Line_517='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_518='set ACST = PMOT*0.54+12.83+ACSToffset+ACSTtol',
            Program_Line_519='else',
            Program_Line_520='if CAT==80',
            Program_Line_521='set ACST = PMOT*0.078+23.25+2.72+ACSTtol',
            Program_Line_522='elseif CAT==85',
            Program_Line_523='set ACST = PMOT*0.078+23.25+2.11+ACSTtol',
            Program_Line_524='elseif CAT==90',
            Program_Line_525='set ACST = PMOT*0.078+23.25+1.5+ACSTtol',
            Program_Line_526='endif',
            Program_Line_527='endif',
            Program_Line_528='endif',
            Program_Line_529='if (ComfStand == 7) && (ComfMod == 1)',
            Program_Line_530='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_531='set AHST = PMOT*0.54+12.83+AHSToffset+AHSTtol',
            Program_Line_532='else',
            Program_Line_533='if CAT==80',
            Program_Line_534='set AHST = PMOT*0.078+23.25-2.72+AHSTtol',
            Program_Line_535='elseif CAT==85',
            Program_Line_536='set AHST = PMOT*0.078+23.25-2.11+AHSTtol',
            Program_Line_537='elseif CAT==90',
            Program_Line_538='set AHST = PMOT*0.078+23.25-1.5+AHSTtol',
            Program_Line_539='endif',
            Program_Line_540='endif',
            Program_Line_541='endif',
            Program_Line_542='if (ComfStand == 7) && (ComfMod == 2)',
            Program_Line_543='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_544='set ACST = PMOT*0.54+12.83+ACSToffset+ACSTtol',
            Program_Line_545='elseif CAT==80',
            Program_Line_546='if PMOT < ACSTall',
            Program_Line_547='set ACST = 25+ACSTtol',
            Program_Line_548='elseif PMOT > ACSTaul',
            Program_Line_549='set ACST = 27+ACSTtol',
            Program_Line_550='endif',
            Program_Line_551='elseif CAT==85',
            Program_Line_552='if PMOT < ACSTall',
            Program_Line_553='set ACST = 25.72+ACSTtol',
            Program_Line_554='elseif PMOT > ACSTaul',
            Program_Line_555='set ACST = 27.89+ACSTtol',
            Program_Line_556='endif',
            Program_Line_557='elseif CAT==90',
            Program_Line_558='if PMOT < ACSTall',
            Program_Line_559='set ACST = 24+ACSTtol',
            Program_Line_560='elseif PMOT > ACSTaul',
            Program_Line_561='set ACST = 26+ACSTtol',
            Program_Line_562='endif',
            Program_Line_563='endif',
            Program_Line_564='endif',
            Program_Line_565='if (ComfStand == 7) && (ComfMod == 2)',
            Program_Line_566='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_567='set AHST = PMOT*0.54+12.83+AHSToffset+AHSTtol',
            Program_Line_568='elseif CAT==80',
            Program_Line_569='if PMOT < AHSTall',
            Program_Line_570='set AHST = 19+AHSTtol',
            Program_Line_571='elseif PMOT > AHSTaul',
            Program_Line_572='set AHST = 22+AHSTtol',
            Program_Line_573='endif',
            Program_Line_574='elseif CAT==85',
            Program_Line_575='if PMOT < AHSTall',
            Program_Line_576='set AHST = 20.77+AHSTtol',
            Program_Line_577='elseif PMOT > AHSTaul',
            Program_Line_578='set AHST = 24.26+AHSTtol',
            Program_Line_579='endif',
            Program_Line_580='elseif CAT==90',
            Program_Line_581='if PMOT < AHSTall',
            Program_Line_582='set AHST = 20+AHSTtol',
            Program_Line_583='elseif PMOT > AHSTaul',
            Program_Line_584='set AHST = 23+AHSTtol',
            Program_Line_585='endif',
            Program_Line_586='endif',
            Program_Line_587='endif',
            Program_Line_588='if (ComfStand == 7) && (ComfMod == 3)',
            Program_Line_589='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_590='set ACST = PMOT*0.54+12.83+ACSToffset+ACSTtol',
            Program_Line_591='elseif PMOT < ACSTall',
            Program_Line_592='set ACST = ACSTall*0.54+12.83+ACSToffset+ACSTtol',
            Program_Line_593='elseif PMOT > ACSTaul',
            Program_Line_594='set ACST = ACSTaul*0.54+12.83+ACSToffset+ACSTtol',
            Program_Line_595='endif',
            Program_Line_596='endif',
            Program_Line_597='if (ComfStand == 7) && (ComfMod == 3)',
            Program_Line_598='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_599='set AHST = PMOT*0.54+12.83+AHSToffset+AHSTtol',
            Program_Line_600='elseif PMOT < AHSTall',
            Program_Line_601='set AHST = AHSTall*0.54+12.83+AHSToffset+AHSTtol',
            Program_Line_602='elseif PMOT > AHSTaul',
            Program_Line_603='set AHST = AHSTaul*0.54+12.83+AHSToffset+AHSTtol',
            Program_Line_604='endif',
            Program_Line_605='endif',
            Program_Line_606='if (ComfStand == 8) && (ComfMod == 1)',
            Program_Line_607='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_608='set ACST = PMOT*0.28+17.87+ACSToffset+ACSTtol',
            Program_Line_609='else',
            Program_Line_610='if CAT==80',
            Program_Line_611='set ACST = PMOT*0.078+23.25+2.72+ACSTtol',
            Program_Line_612='elseif CAT==85',
            Program_Line_613='set ACST = PMOT*0.078+23.25+2.11+ACSTtol',
            Program_Line_614='elseif CAT==90',
            Program_Line_615='set ACST = PMOT*0.078+23.25+1.5+ACSTtol',
            Program_Line_616='endif',
            Program_Line_617='endif',
            Program_Line_618='endif',
            Program_Line_619='if (ComfStand == 8) && (ComfMod == 1)',
            Program_Line_620='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_621='set AHST = PMOT*0.28+17.87+AHSToffset+AHSTtol',
            Program_Line_622='else',
            Program_Line_623='if CAT==80',
            Program_Line_624='set AHST = PMOT*0.078+23.25-2.72+AHSTtol',
            Program_Line_625='elseif CAT==85',
            Program_Line_626='set AHST = PMOT*0.078+23.25-2.11+AHSTtol',
            Program_Line_627='elseif CAT==90',
            Program_Line_628='set AHST = PMOT*0.078+23.25-1.5+AHSTtol',
            Program_Line_629='endif',
            Program_Line_630='endif',
            Program_Line_631='endif',
            Program_Line_632='if (ComfStand == 8) && (ComfMod == 2)',
            Program_Line_633='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_634='set ACST = PMOT*0.28+17.87+ACSToffset+ACSTtol',
            Program_Line_635='elseif CAT==80',
            Program_Line_636='if PMOT < ACSTall',
            Program_Line_637='set ACST = 25+ACSTtol',
            Program_Line_638='elseif PMOT > ACSTaul',
            Program_Line_639='set ACST = 27+ACSTtol',
            Program_Line_640='endif',
            Program_Line_641='elseif CAT==85',
            Program_Line_642='if PMOT < ACSTall',
            Program_Line_643='set ACST = 25.72+ACSTtol',
            Program_Line_644='elseif PMOT > ACSTaul',
            Program_Line_645='set ACST = 27.89+ACSTtol',
            Program_Line_646='endif',
            Program_Line_647='elseif CAT==90',
            Program_Line_648='if PMOT < ACSTall',
            Program_Line_649='set ACST = 24+ACSTtol',
            Program_Line_650='elseif PMOT > ACSTaul',
            Program_Line_651='set ACST = 26+ACSTtol',
            Program_Line_652='endif',
            Program_Line_653='endif',
            Program_Line_654='endif',
            Program_Line_655='if (ComfStand == 8) && (ComfMod == 2)',
            Program_Line_656='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_657='set AHST = PMOT*0.28+17.87+AHSToffset+AHSTtol',
            Program_Line_658='elseif CAT==80',
            Program_Line_659='if PMOT < AHSTall',
            Program_Line_660='set AHST = 19+AHSTtol',
            Program_Line_661='elseif PMOT > AHSTaul',
            Program_Line_662='set AHST = 22+AHSTtol',
            Program_Line_663='endif',
            Program_Line_664='elseif CAT==85',
            Program_Line_665='if PMOT < AHSTall',
            Program_Line_666='set AHST = 20.77+AHSTtol',
            Program_Line_667='elseif PMOT > AHSTaul',
            Program_Line_668='set AHST = 24.26+AHSTtol',
            Program_Line_669='endif',
            Program_Line_670='elseif CAT==90',
            Program_Line_671='if PMOT < AHSTall',
            Program_Line_672='set AHST = 20+AHSTtol',
            Program_Line_673='elseif PMOT > AHSTaul',
            Program_Line_674='set AHST = 23+AHSTtol',
            Program_Line_675='endif',
            Program_Line_676='endif',
            Program_Line_677='endif',
            Program_Line_678='if (ComfStand == 8) && (ComfMod == 3)',
            Program_Line_679='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_680='set ACST = PMOT*0.28+17.87+ACSToffset+ACSTtol',
            Program_Line_681='elseif PMOT < ACSTall',
            Program_Line_682='set ACST = ACSTall*0.28+17.87+ACSToffset+ACSTtol',
            Program_Line_683='elseif PMOT > ACSTaul',
            Program_Line_684='set ACST = ACSTaul*0.28+17.87+ACSToffset+ACSTtol',
            Program_Line_685='endif',
            Program_Line_686='endif',
            Program_Line_687='if (ComfStand == 8) && (ComfMod == 3)',
            Program_Line_688='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_689='set AHST = PMOT*0.28+17.87+AHSToffset+AHSTtol',
            Program_Line_690='elseif PMOT < AHSTall',
            Program_Line_691='set AHST = AHSTall*0.28+17.87+AHSToffset+AHSTtol',
            Program_Line_692='elseif PMOT > AHSTaul',
            Program_Line_693='set AHST = AHSTaul*0.28+17.87+AHSToffset+AHSTtol',
            Program_Line_694='endif',
            Program_Line_695='endif',
            Program_Line_696='if (ComfStand == 9) && (ComfMod == 1)',
            Program_Line_697='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_698='set ACST = PMOT*0.39+18.42+ACSToffset+ACSTtol',
            Program_Line_699='else',
            Program_Line_700='if CAT==80',
            Program_Line_701='set ACST = PMOT*0.078+23.25+2.72+ACSTtol',
            Program_Line_702='elseif CAT==90',
            Program_Line_703='set ACST = PMOT*0.078+23.25+1.5+ACSTtol',
            Program_Line_704='endif',
            Program_Line_705='endif',
            Program_Line_706='endif',
            Program_Line_707='if (ComfStand == 9) && (ComfMod == 1)',
            Program_Line_708='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_709='set AHST = PMOT*0.39+18.42+AHSToffset+AHSTtol',
            Program_Line_710='else',
            Program_Line_711='if CAT==80',
            Program_Line_712='set AHST = PMOT*0.078+23.25+2.72+AHSTtol',
            Program_Line_713='elseif CAT==90',
            Program_Line_714='set AHST = PMOT*0.078+23.25+1.5+AHSTtol',
            Program_Line_715='endif',
            Program_Line_716='endif',
            Program_Line_717='endif',
            Program_Line_718='if (ComfStand == 9) && (ComfMod == 2)',
            Program_Line_719='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_720='set ACST = PMOT*0.39+18.42+ACSToffset+ACSTtol',
            Program_Line_721='elseif CAT==80',
            Program_Line_722='if PMOT < ACSTall',
            Program_Line_723='set ACST = 25+ACSTtol',
            Program_Line_724='elseif PMOT > ACSTaul',
            Program_Line_725='set ACST = 27+ACSTtol',
            Program_Line_726='endif',
            Program_Line_727='elseif CAT==90',
            Program_Line_728='if PMOT < ACSTall',
            Program_Line_729='set ACST = 24+ACSTtol',
            Program_Line_730='elseif PMOT > ACSTaul',
            Program_Line_731='set ACST = 26+ACSTtol',
            Program_Line_732='endif',
            Program_Line_733='endif',
            Program_Line_734='endif',
            Program_Line_735='if (ComfStand == 9) && (ComfMod == 2)',
            Program_Line_736='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_737='set AHST = PMOT*0.39+18.42+AHSToffset+AHSTtol',
            Program_Line_738='elseif CAT==80',
            Program_Line_739='if PMOT < AHSTall',
            Program_Line_740='set AHST = 19+AHSTtol',
            Program_Line_741='elseif PMOT > AHSTaul',
            Program_Line_742='set AHST = 22+AHSTtol',
            Program_Line_743='endif',
            Program_Line_744='elseif CAT==90',
            Program_Line_745='if PMOT < AHSTall',
            Program_Line_746='set AHST = 20+AHSTtol',
            Program_Line_747='elseif PMOT > AHSTaul',
            Program_Line_748='set AHST = 23+AHSTtol',
            Program_Line_749='endif',
            Program_Line_750='endif',
            Program_Line_751='endif',
            Program_Line_752='if (ComfStand == 9) && (ComfMod == 3)',
            Program_Line_753='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_754='set ACST = PMOT*0.39+18.42+ACSToffset+ACSTtol',
            Program_Line_755='elseif PMOT < ACSTall',
            Program_Line_756='set ACST = ACSTall*0.39+18.42+ACSToffset+ACSTtol',
            Program_Line_757='elseif PMOT > ACSTaul',
            Program_Line_758='set ACST = ACSTaul*0.39+18.42+ACSToffset+ACSTtol',
            Program_Line_759='endif',
            Program_Line_760='endif',
            Program_Line_761='if (ComfStand == 9) && (ComfMod == 3)',
            Program_Line_762='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_763='set AHST = PMOT*0.39+18.42+AHSToffset+AHSTtol',
            Program_Line_764='elseif PMOT < AHSTall',
            Program_Line_765='set AHST = AHSTall*0.39+18.42+AHSToffset+AHSTtol',
            Program_Line_766='elseif PMOT > AHSTaul',
            Program_Line_767='set AHST = AHSTaul*0.39+18.42+AHSToffset+AHSTtol',
            Program_Line_768='endif',
            Program_Line_769='endif',
            Program_Line_770='!when the model is not applicable, PMOT should be used instead of RMO',
            Program_Line_771='if (ComfStand == 10) && (ComfMod == 1)',
            Program_Line_772='if (RMOT >= ACSTall) && (RMOT <= ACSTaul)',
            Program_Line_773='set ACST = RMOT*0.42+17.6+ACSToffset+ACSTtol',
            Program_Line_774='else',
            Program_Line_775='if CAT==80',
            Program_Line_776='set ACST = RMOT*0.078+23.25+2.72+ACSTtol',
            Program_Line_777='elseif CAT==90',
            Program_Line_778='set ACST = RMOT*0.078+23.25+1.5+ACSTtol',
            Program_Line_779='endif',
            Program_Line_780='endif',
            Program_Line_781='endif',
            Program_Line_782='if (ComfStand == 10) && (ComfMod == 1)',
            Program_Line_783='if (RMOT >= AHSTall) && (RMOT <= AHSTaul)',
            Program_Line_784='set AHST = RMOT*0.42+17.6+AHSToffset+AHSTtol',
            Program_Line_785='else',
            Program_Line_786='if CAT==80',
            Program_Line_787='set AHST = RMOT*0.078+23.25-2.72+AHSTtol',
            Program_Line_788='elseif CAT==90',
            Program_Line_789='set AHST = RMOT*0.078+23.25-1.5+AHSTtol',
            Program_Line_790='endif',
            Program_Line_791='endif',
            Program_Line_792='endif',
            Program_Line_793='if (ComfStand == 10) && (ComfMod == 2)',
            Program_Line_794='if (RMOT >= ACSTall) && (RMOT <= ACSTaul)',
            Program_Line_795='set ACST = RMOT*0.42+17.6+ACSToffset+ACSTtol',
            Program_Line_796='elseif CAT==80',
            Program_Line_797='if RMOT < ACSTall',
            Program_Line_798='set ACST = 25+ACSTtol',
            Program_Line_799='elseif RMOT > ACSTaul',
            Program_Line_800='set ACST = 27+ACSTtol',
            Program_Line_801='endif',
            Program_Line_802='elseif CAT==90',
            Program_Line_803='if RMOT < ACSTall',
            Program_Line_804='set ACST = 24+ACSTtol',
            Program_Line_805='elseif RMOT > ACSTaul',
            Program_Line_806='set ACST = 26+ACSTtol',
            Program_Line_807='endif',
            Program_Line_808='endif',
            Program_Line_809='endif',
            Program_Line_810='if (ComfStand == 10) && (ComfMod == 2)',
            Program_Line_811='if (RMOT >= AHSTall) && (RMOT <= AHSTaul)',
            Program_Line_812='set AHST = RMOT*0.42+17.6+AHSToffset+AHSTtol',
            Program_Line_813='elseif CAT==80',
            Program_Line_814='if RMOT < AHSTall',
            Program_Line_815='set AHST = 19+AHSTtol',
            Program_Line_816='elseif RMOT > AHSTaul',
            Program_Line_817='set AHST = 22+AHSTtol',
            Program_Line_818='endif',
            Program_Line_819='elseif CAT==90',
            Program_Line_820='if RMOT < AHSTall',
            Program_Line_821='set AHST = 20+AHSTtol',
            Program_Line_822='elseif RMOT > AHSTaul',
            Program_Line_823='set AHST = 23+AHSTtol',
            Program_Line_824='endif',
            Program_Line_825='endif',
            Program_Line_826='endif',
            Program_Line_827='if (ComfStand == 10) && (ComfMod == 3)',
            Program_Line_828='if (RMOT >= ACSTall) && (RMOT <= ACSTaul)',
            Program_Line_829='set ACST = RMOT*0.42+17.6+ACSToffset+ACSTtol',
            Program_Line_830='elseif RMOT < ACSTall',
            Program_Line_831='set ACST = ACSTall*0.42+17.6+ACSToffset+ACSTtol',
            Program_Line_832='elseif RMOT > ACSTaul',
            Program_Line_833='set ACST = ACSTaul*0.42+17.6+ACSToffset+ACSTtol',
            Program_Line_834='endif',
            Program_Line_835='endif',
            Program_Line_836='if (ComfStand == 10) && (ComfMod == 3)',
            Program_Line_837='if (RMOT >= AHSTall) && (RMOT <= AHSTaul)',
            Program_Line_838='set AHST = RMOT*0.42+17.6+AHSToffset+AHSTtol',
            Program_Line_839='elseif RMOT < AHSTall',
            Program_Line_840='set AHST = AHSTall*0.42+17.6+AHSToffset+AHSTtol',
            Program_Line_841='elseif RMOT > AHSTaul',
            Program_Line_842='set AHST = AHSTaul*0.42+17.6+AHSToffset+AHSTtol',
            Program_Line_843='endif',
            Program_Line_844='endif',
            Program_Line_845='if (ComfStand == 11) && (ComfMod == 1)',
            Program_Line_846='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_847='set ACST = PMOT*0.75+5.37+ACSToffset+ACSTtol',
            Program_Line_848='else',
            Program_Line_849='if CAT==80',
            Program_Line_850='set ACST = PMOT*0.078+23.25+2.72+ACSTtol',
            Program_Line_851='elseif CAT==90',
            Program_Line_852='set ACST = PMOT*0.078+23.25+1.5+ACSTtol',
            Program_Line_853='endif',
            Program_Line_854='endif',
            Program_Line_855='endif',
            Program_Line_856='if (ComfStand == 11) && (ComfMod == 1)',
            Program_Line_857='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_858='set AHST = PMOT*0.75+5.37+AHSToffset+AHSTtol',
            Program_Line_859='else',
            Program_Line_860='if CAT==80',
            Program_Line_861='set AHST = PMOT*0.078+23.25-2.72+AHSTtol',
            Program_Line_862='elseif CAT==90',
            Program_Line_863='set AHST = PMOT*0.078+23.25-1.5+AHSTtol',
            Program_Line_864='endif',
            Program_Line_865='endif',
            Program_Line_866='endif',
            Program_Line_867='if (ComfStand == 11) && (ComfMod == 2)',
            Program_Line_868='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_869='set ACST = PMOT*0.75+5.37+ACSToffset+ACSTtol',
            Program_Line_870='elseif CAT==80',
            Program_Line_871='if PMOT < ACSTall',
            Program_Line_872='set ACST = 25+ACSTtol',
            Program_Line_873='elseif PMOT > ACSTaul',
            Program_Line_874='set ACST = 27+ACSTtol',
            Program_Line_875='endif',
            Program_Line_876='elseif CAT==90',
            Program_Line_877='if PMOT < ACSTall',
            Program_Line_878='set ACST = 24+ACSTtol',
            Program_Line_879='elseif PMOT > ACSTaul',
            Program_Line_880='set ACST = 26+ACSTtol',
            Program_Line_881='endif',
            Program_Line_882='endif',
            Program_Line_883='endif',
            Program_Line_884='if (ComfStand == 11) && (ComfMod == 2)',
            Program_Line_885='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_886='set AHST = PMOT*0.75+5.37+AHSToffset+AHSTtol',
            Program_Line_887='elseif CAT==80',
            Program_Line_888='if PMOT < AHSTall',
            Program_Line_889='set AHST = 19+AHSTtol',
            Program_Line_890='elseif PMOT > AHSTaul',
            Program_Line_891='set AHST = 22+AHSTtol',
            Program_Line_892='endif',
            Program_Line_893='elseif CAT==90',
            Program_Line_894='if PMOT < AHSTall',
            Program_Line_895='set AHST = 20+AHSTtol',
            Program_Line_896='elseif PMOT > AHSTaul',
            Program_Line_897='set AHST = 23+AHSTtol',
            Program_Line_898='endif',
            Program_Line_899='endif',
            Program_Line_900='endif',
            Program_Line_901='if (ComfStand == 11) && (ComfMod == 3)',
            Program_Line_902='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_903='set ACST = PMOT*0.75+5.37+ACSToffset+ACSTtol',
            Program_Line_904='elseif PMOT < ACSTall',
            Program_Line_905='set ACST = ACSTall*0.75+5.37+ACSToffset+ACSTtol',
            Program_Line_906='elseif PMOT > ACSTaul',
            Program_Line_907='set ACST = ACSTaul*0.75+5.37+ACSToffset+ACSTtol',
            Program_Line_908='endif',
            Program_Line_909='endif',
            Program_Line_910='if (ComfStand == 11) && (ComfMod == 3)',
            Program_Line_911='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_912='set AHST = PMOT*0.75+5.37+AHSToffset+AHSTtol',
            Program_Line_913='elseif PMOT < AHSTall',
            Program_Line_914='set AHST = AHSTall*0.75+5.37+AHSToffset+AHSTtol',
            Program_Line_915='elseif PMOT > AHSTaul',
            Program_Line_916='set AHST = AHSTaul*0.75+5.37+AHSToffset+AHSTtol',
            Program_Line_917='endif',
            Program_Line_918='endif',
            Program_Line_919='if (ComfStand == 12) && (ComfMod == 0)',
            Program_Line_920='if (CAT==80)',
            Program_Line_921='set ACST = 27+ACSTtol',
            Program_Line_922='elseif (CAT==90)',
            Program_Line_923='set ACST = 25.5+ACSTtol',
            Program_Line_924='endif',
            Program_Line_925='endif',
            Program_Line_926='if (ComfStand == 12) && (ComfMod == 0)',
            Program_Line_927='if (CAT==80)',
            Program_Line_928='set AHST = 20+AHSTtol',
            Program_Line_929='elseif (CAT==90)',
            Program_Line_930='set AHST = 21.5+AHSTtol',
            Program_Line_931='endif',
            Program_Line_932='endif',
            Program_Line_933='if (ComfStand == 12) && (ComfMod == 1)',
            Program_Line_934='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_935='set ACST = PMOT*0.25+19.7+ACSToffset+ACSTtol',
            Program_Line_936='elseif CAT==80',
            Program_Line_937='if PMOT < ACSTall',
            Program_Line_938='set ACST = 27+ACSTtol',
            Program_Line_939='elseif PMOT > ACSTaul',
            Program_Line_940='set ACST = 27+ACSTtol',
            Program_Line_941='endif',
            Program_Line_942='elseif CAT==90',
            Program_Line_943='if PMOT < ACSTall',
            Program_Line_944='set ACST = 25.5+ACSTtol',
            Program_Line_945='elseif PMOT > ACSTaul',
            Program_Line_946='set ACST = 25.5+ACSTtol',
            Program_Line_947='endif',
            Program_Line_948='endif',
            Program_Line_949='endif',
            Program_Line_950='if (ComfStand == 12) && (ComfMod == 1)',
            Program_Line_951='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_952='set AHST = PMOT*0.25+19.7+AHSToffset+AHSTtol',
            Program_Line_953='elseif CAT==80',
            Program_Line_954='if PMOT < AHSTall',
            Program_Line_955='set AHST = 20+AHSTtol',
            Program_Line_956='elseif PMOT > AHSTaul',
            Program_Line_957='set AHST = 20+AHSTtol',
            Program_Line_958='endif',
            Program_Line_959='elseif CAT==90',
            Program_Line_960='if PMOT < AHSTall',
            Program_Line_961='set AHST = 21.5+AHSTtol',
            Program_Line_962='elseif PMOT > AHSTaul',
            Program_Line_963='set AHST = 21.5+AHSTtol',
            Program_Line_964='endif',
            Program_Line_965='endif',
            Program_Line_966='endif',
            Program_Line_967='if (ComfStand == 12) && (ComfMod == 2)',
            Program_Line_968='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_969='set ACST = PMOT*0.25+19.7+ACSToffset+ACSTtol',
            Program_Line_970='elseif CAT==80',
            Program_Line_971='if PMOT < ACSTall',
            Program_Line_972='set ACST = 25+ACSTtol',
            Program_Line_973='elseif PMOT > ACSTaul',
            Program_Line_974='set ACST = 27+ACSTtol',
            Program_Line_975='endif',
            Program_Line_976='elseif CAT==90',
            Program_Line_977='if PMOT < ACSTall',
            Program_Line_978='set ACST = 24+ACSTtol',
            Program_Line_979='elseif PMOT > ACSTaul',
            Program_Line_980='set ACST = 26+ACSTtol',
            Program_Line_981='endif',
            Program_Line_982='endif',
            Program_Line_983='endif',
            Program_Line_984='if (ComfStand == 12) && (ComfMod == 2)',
            Program_Line_985='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_986='set AHST = PMOT*0.25+19.7+AHSToffset+AHSTtol',
            Program_Line_987='elseif CAT==80',
            Program_Line_988='if PMOT < AHSTall',
            Program_Line_989='set AHST = 19+AHSTtol',
            Program_Line_990='elseif PMOT > AHSTaul',
            Program_Line_991='set AHST = 22+AHSTtol',
            Program_Line_992='endif',
            Program_Line_993='elseif CAT==90',
            Program_Line_994='if PMOT < AHSTall',
            Program_Line_995='set AHST = 20+AHSTtol',
            Program_Line_996='elseif PMOT > AHSTaul',
            Program_Line_997='set AHST = 23+AHSTtol',
            Program_Line_998='endif',
            Program_Line_999='endif',
            Program_Line_1000='endif',
            Program_Line_1001='if (ComfStand == 12) && (ComfMod == 3)',
            Program_Line_1002='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1003='set ACST = PMOT*0.25+19.7+ACSToffset+ACSTtol',
            Program_Line_1004='elseif PMOT < ACSTall',
            Program_Line_1005='set ACST = ACSTall*0.25+19.7+ACSToffset+ACSTtol',
            Program_Line_1006='elseif PMOT > ACSTaul',
            Program_Line_1007='set ACST = ACSTaul*0.25+19.7+ACSToffset+ACSTtol',
            Program_Line_1008='endif',
            Program_Line_1009='endif',
            Program_Line_1010='if (ComfStand == 12) && (ComfMod == 3)',
            Program_Line_1011='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1012='set AHST = PMOT*0.25+19.7+AHSToffset+AHSTtol',
            Program_Line_1013='elseif PMOT < AHSTall',
            Program_Line_1014='set AHST = AHSTall*0.25+19.7+AHSToffset+AHSTtol',
            Program_Line_1015='elseif PMOT > AHSTaul',
            Program_Line_1016='set AHST = AHSTaul*0.25+19.7+AHSToffset+AHSTtol',
            Program_Line_1017='endif',
            Program_Line_1018='endif',
            Program_Line_1019='if (ComfStand == 13) || (ComfStand == 14)',
            Program_Line_1020='if (CAT==80)',
            Program_Line_1021='if (CurrentTime > 6) && (CurrentTime < 23)',
            Program_Line_1022='if (ComfMod == 0.1)',
            Program_Line_1023='set ACST = 27+ACSTtol',
            Program_Line_1024='elseif (ComfMod == 0.2)',
            Program_Line_1025='set ACST = 26+ACSTtol',
            Program_Line_1026='elseif (ComfMod == 0.3)',
            Program_Line_1027='set ACST = 25+ACSTtol',
            Program_Line_1028='elseif (ComfMod == 0.4)',
            Program_Line_1029='set ACST = 24+ACSTtol',
            Program_Line_1030='elseif (ComfMod == 0.5)',
            Program_Line_1031='set ACST = 23+ACSTtol',
            Program_Line_1032='endif',
            Program_Line_1033='else',
            Program_Line_1034='set ACST = 24+ACSTtol',
            Program_Line_1035='endif',
            Program_Line_1036='elseif (CAT==90)',
            Program_Line_1037='if (CurrentTime > 6) && (CurrentTime < 23)',
            Program_Line_1038='if (ComfMod == 0.1)',
            Program_Line_1039='set ACST = 26+ACSTtol',
            Program_Line_1040='elseif (ComfMod == 0.2)',
            Program_Line_1041='set ACST = 25+ACSTtol',
            Program_Line_1042='elseif (ComfMod == 0.3)',
            Program_Line_1043='set ACST = 24+ACSTtol',
            Program_Line_1044='elseif (ComfMod == 0.4)',
            Program_Line_1045='set ACST = 23+ACSTtol',
            Program_Line_1046='elseif (ComfMod == 0.5)',
            Program_Line_1047='set ACST = 22+ACSTtol',
            Program_Line_1048='endif',
            Program_Line_1049='else',
            Program_Line_1050='set ACST = 23+ACSTtol',
            Program_Line_1051='endif',
            Program_Line_1052='endif',
            Program_Line_1053='endif',
            Program_Line_1054='if (ComfStand == 13) || (ComfStand == 14)',
            Program_Line_1055='if (ComfMod == 0.1) || (ComfMod == 0.2) || (ComfMod == 0.3) || (ComfMod == 0.4) || (ComfMod == 0.5)',
            Program_Line_1056='if (CAT==80)',
            Program_Line_1057='if (CurrentTime >6) && (CurrentTime < 12)',
            Program_Line_1058='set AHST = 20+AHSTtol',
            Program_Line_1059='else',
            Program_Line_1060='set AHST = 18+AHSTtol',
            Program_Line_1061='endif',
            Program_Line_1062='elseif (CAT==90)',
            Program_Line_1063='if (CurrentTime >6) && (CurrentTime < 12)',
            Program_Line_1064='set AHST = 21+AHSTtol',
            Program_Line_1065='else',
            Program_Line_1066='set AHST = 19+AHSTtol',
            Program_Line_1067='endif',
            Program_Line_1068='endif',
            Program_Line_1069='endif',
            Program_Line_1070='endif',
            Program_Line_1071='if (ComfStand == 13)',
            Program_Line_1072='if (ComfMod == 1.1) || (ComfMod == 1.2) || (ComfMod == 1.3) || (ComfMod == 1.4) || (ComfMod == 1.5)',
            Program_Line_1073='if CAT == 80',
            Program_Line_1074='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1075='set ACST = PMOT*0.26+15.9+ACSToffset+ACSTtol',
            Program_Line_1076='elseif (PMOT < ACSTall) || (PMOT > ACSTaul)',
            Program_Line_1077='if (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.1)',
            Program_Line_1078='set ACST = 27+ACSTtol',
            Program_Line_1079='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.2)',
            Program_Line_1080='set ACST = 26+ACSTtol',
            Program_Line_1081='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.3)',
            Program_Line_1082='set ACST = 25+ACSTtol',
            Program_Line_1083='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.4)',
            Program_Line_1084='set ACST = 24+ACSTtol',
            Program_Line_1085='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.5)',
            Program_Line_1086='set ACST = 23+ACSTtol',
            Program_Line_1087='else',
            Program_Line_1088='set ACST = 24+ACSTtol',
            Program_Line_1089='endif',
            Program_Line_1090='endif',
            Program_Line_1091='elseif CAT==90',
            Program_Line_1092='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1093='set ACST = PMOT*0.26+15.9+ACSToffset+ACSTtol',
            Program_Line_1094='elseif (PMOT < ACSTall) || (PMOT > ACSTaul)',
            Program_Line_1095='if (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.1)',
            Program_Line_1096='set ACST = 26+ACSTtol',
            Program_Line_1097='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.2)',
            Program_Line_1098='set ACST = 25+ACSTtol',
            Program_Line_1099='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.3)',
            Program_Line_1100='set ACST = 24+ACSTtol',
            Program_Line_1101='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.4)',
            Program_Line_1102='set ACST = 23+ACSTtol',
            Program_Line_1103='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.5)',
            Program_Line_1104='set ACST = 22+ACSTtol',
            Program_Line_1105='else',
            Program_Line_1106='set ACST = 23+ACSTtol',
            Program_Line_1107='endif',
            Program_Line_1108='endif',
            Program_Line_1109='endif',
            Program_Line_1110='endif',
            Program_Line_1111='endif',
            Program_Line_1112='if (ComfStand == 13)',
            Program_Line_1113='if (ComfMod == 1.1) || (ComfMod == 1.2) || (ComfMod == 1.3) || (ComfMod == 1.4) || (ComfMod == 1.5)',
            Program_Line_1114='if CAT == 80',
            Program_Line_1115='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1116='set AHST = PMOT*0.26+15.9+AHSToffset+AHSTtol',
            Program_Line_1117='elseif (PMOT < AHSTall) || (PMOT > AHSTaul)',
            Program_Line_1118='if (CurrentTime >6) && (CurrentTime < 12)',
            Program_Line_1119='set AHST = 20+AHSTtol',
            Program_Line_1120='else',
            Program_Line_1121='set AHST = 18+AHSTtol',
            Program_Line_1122='endif',
            Program_Line_1123='endif',
            Program_Line_1124='elseif CAT==90',
            Program_Line_1125='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1126='set AHST = PMOT*0.26+15.9+AHSToffset+AHSTtol',
            Program_Line_1127='elseif (PMOT < AHSTall) || (PMOT > AHSTaul)',
            Program_Line_1128='if (CurrentTime >6) && (CurrentTime < 12)',
            Program_Line_1129='set AHST = 21+AHSTtol',
            Program_Line_1130='else',
            Program_Line_1131='set AHST = 19+AHSTtol',
            Program_Line_1132='endif',
            Program_Line_1133='endif',
            Program_Line_1134='endif',
            Program_Line_1135='endif',
            Program_Line_1136='endif',
            Program_Line_1137='if (ComfStand == 13) && (ComfMod == 2)',
            Program_Line_1138='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1139='set ACST = PMOT*0.26+15.9+ACSToffset+ACSTtol',
            Program_Line_1140='elseif CAT==80',
            Program_Line_1141='if PMOT < ACSTall',
            Program_Line_1142='set ACST = 25+ACSTtol',
            Program_Line_1143='elseif PMOT > ACSTaul',
            Program_Line_1144='set ACST = 27+ACSTtol',
            Program_Line_1145='endif',
            Program_Line_1146='elseif CAT==90',
            Program_Line_1147='if PMOT < ACSTall',
            Program_Line_1148='set ACST = 24+ACSTtol',
            Program_Line_1149='elseif PMOT > ACSTaul',
            Program_Line_1150='set ACST = 26+ACSTtol',
            Program_Line_1151='endif',
            Program_Line_1152='endif',
            Program_Line_1153='endif',
            Program_Line_1154='if (ComfStand == 13) && (ComfMod == 2)',
            Program_Line_1155='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1156='set AHST = PMOT*0.26+15.9+AHSToffset+AHSTtol',
            Program_Line_1157='elseif CAT==80',
            Program_Line_1158='if PMOT < AHSTall',
            Program_Line_1159='set AHST = 19+AHSTtol',
            Program_Line_1160='elseif PMOT > AHSTaul',
            Program_Line_1161='set AHST = 22+AHSTtol',
            Program_Line_1162='endif',
            Program_Line_1163='elseif CAT==90',
            Program_Line_1164='if PMOT < AHSTall',
            Program_Line_1165='set AHST = 20+AHSTtol',
            Program_Line_1166='elseif PMOT > AHSTaul',
            Program_Line_1167='set AHST = 23+AHSTtol',
            Program_Line_1168='endif',
            Program_Line_1169='endif',
            Program_Line_1170='endif',
            Program_Line_1171='if (ComfStand == 13) && (ComfMod == 3)',
            Program_Line_1172='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1173='set ACST = PMOT*0.26+15.9+ACSToffset+ACSTtol',
            Program_Line_1174='elseif PMOT < ACSTall',
            Program_Line_1175='set ACST = ACSTall*0.26+15.9+ACSToffset+ACSTtol',
            Program_Line_1176='elseif PMOT > ACSTaul',
            Program_Line_1177='set ACST = ACSTaul*0.26+15.9+ACSToffset+ACSTtol',
            Program_Line_1178='endif',
            Program_Line_1179='endif',
            Program_Line_1180='if (ComfStand == 13) && (ComfMod == 3)',
            Program_Line_1181='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1182='set AHST = PMOT*0.26+15.9+AHSToffset+AHSTtol',
            Program_Line_1183='elseif PMOT < AHSTall',
            Program_Line_1184='set AHST = AHSTall*0.26+15.9+AHSToffset+AHSTtol',
            Program_Line_1185='elseif PMOT > AHSTaul',
            Program_Line_1186='set AHST = AHSTaul*0.26+15.9+AHSToffset+AHSTtol',
            Program_Line_1187='endif',
            Program_Line_1188='endif',
            Program_Line_1189='if (ComfStand == 14)',
            Program_Line_1190='if (ComfMod == 1.1) || (ComfMod == 1.2) || (ComfMod == 1.3) || (ComfMod == 1.4) || (ComfMod == 1.5)',
            Program_Line_1191='if CAT == 80',
            Program_Line_1192='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1193='set ACST = PMOT*0.26+16.75+ACSToffset+ACSTtol',
            Program_Line_1194='elseif (PMOT < ACSTall) || (PMOT > ACSTaul)',
            Program_Line_1195='if (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.1)',
            Program_Line_1196='set ACST = 27+ACSTtol',
            Program_Line_1197='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.2)',
            Program_Line_1198='set ACST = 26+ACSTtol',
            Program_Line_1199='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.3)',
            Program_Line_1200='set ACST = 25+ACSTtol',
            Program_Line_1201='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.4)',
            Program_Line_1202='set ACST = 24+ACSTtol',
            Program_Line_1203='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.5)',
            Program_Line_1204='set ACST = 23+ACSTtol',
            Program_Line_1205='else',
            Program_Line_1206='set ACST = 24+ACSTtol',
            Program_Line_1207='endif',
            Program_Line_1208='endif',
            Program_Line_1209='elseif CAT==90',
            Program_Line_1210='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1211='set ACST = PMOT*0.26+16.75+ACSToffset+ACSTtol',
            Program_Line_1212='elseif (PMOT < ACSTall) || (PMOT > ACSTaul)',
            Program_Line_1213='if (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.1)',
            Program_Line_1214='set ACST = 26+ACSTtol',
            Program_Line_1215='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.2)',
            Program_Line_1216='set ACST = 25+ACSTtol',
            Program_Line_1217='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.3)',
            Program_Line_1218='set ACST = 24+ACSTtol',
            Program_Line_1219='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.4)',
            Program_Line_1220='set ACST = 23+ACSTtol',
            Program_Line_1221='elseif (CurrentTime > 6) && (CurrentTime < 23) && (ComfMod == 1.5)',
            Program_Line_1222='set ACST = 22+ACSTtol',
            Program_Line_1223='else',
            Program_Line_1224='set ACST = 23+ACSTtol',
            Program_Line_1225='endif',
            Program_Line_1226='endif',
            Program_Line_1227='endif',
            Program_Line_1228='endif',
            Program_Line_1229='endif',
            Program_Line_1230='if (ComfStand == 14)',
            Program_Line_1231='if (ComfMod == 1.1) || (ComfMod == 1.2) || (ComfMod == 1.3) || (ComfMod == 1.4) || (ComfMod == 1.5)',
            Program_Line_1232='if CAT == 80',
            Program_Line_1233='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1234='set AHST = PMOT*0.26+16.75+AHSToffset+AHSTtol',
            Program_Line_1235='elseif (PMOT < AHSTall) || (PMOT > AHSTaul)',
            Program_Line_1236='if (CurrentTime >6) && (CurrentTime < 12)',
            Program_Line_1237='set AHST = 20+AHSTtol',
            Program_Line_1238='else',
            Program_Line_1239='set AHST = 18+AHSTtol',
            Program_Line_1240='endif',
            Program_Line_1241='endif',
            Program_Line_1242='elseif CAT==90',
            Program_Line_1243='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1244='set AHST = PMOT*0.26+16.75+AHSToffset+AHSTtol',
            Program_Line_1245='elseif (PMOT < AHSTall) || (PMOT > AHSTaul)',
            Program_Line_1246='if (CurrentTime >6) && (CurrentTime < 12)',
            Program_Line_1247='set AHST = 21+AHSTtol',
            Program_Line_1248='else',
            Program_Line_1249='set AHST = 19+AHSTtol',
            Program_Line_1250='endif',
            Program_Line_1251='endif',
            Program_Line_1252='endif',
            Program_Line_1253='endif',
            Program_Line_1254='endif',
            Program_Line_1255='if (ComfStand == 14) && (ComfMod == 2)',
            Program_Line_1256='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1257='set ACST = PMOT*0.26+16.75+ACSToffset+ACSTtol',
            Program_Line_1258='elseif CAT==80',
            Program_Line_1259='if PMOT < ACSTall',
            Program_Line_1260='set ACST = 25+ACSTtol',
            Program_Line_1261='elseif PMOT > ACSTaul',
            Program_Line_1262='set ACST = 27+ACSTtol',
            Program_Line_1263='endif',
            Program_Line_1264='elseif CAT==90',
            Program_Line_1265='if PMOT < ACSTall',
            Program_Line_1266='set ACST = 24+ACSTtol',
            Program_Line_1267='elseif PMOT > ACSTaul',
            Program_Line_1268='set ACST = 26+ACSTtol',
            Program_Line_1269='endif',
            Program_Line_1270='endif',
            Program_Line_1271='endif',
            Program_Line_1272='if (ComfStand == 14) && (ComfMod == 2)',
            Program_Line_1273='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1274='set AHST = PMOT*0.26+16.75+AHSToffset+AHSTtol',
            Program_Line_1275='elseif CAT==80',
            Program_Line_1276='if PMOT < AHSTall',
            Program_Line_1277='set AHST = 19+AHSTtol',
            Program_Line_1278='elseif PMOT > AHSTaul',
            Program_Line_1279='set AHST = 22+AHSTtol',
            Program_Line_1280='endif',
            Program_Line_1281='elseif CAT==90',
            Program_Line_1282='if PMOT < AHSTall',
            Program_Line_1283='set AHST = 20+AHSTtol',
            Program_Line_1284='elseif PMOT > AHSTaul',
            Program_Line_1285='set AHST = 23+AHSTtol',
            Program_Line_1286='endif',
            Program_Line_1287='endif',
            Program_Line_1288='endif',
            Program_Line_1289='if (ComfStand == 14) && (ComfMod == 3)',
            Program_Line_1290='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1291='set ACST = PMOT*0.26+16.75+ACSToffset+ACSTtol',
            Program_Line_1292='elseif PMOT < ACSTall',
            Program_Line_1293='set ACST = ACSTall*0.26+16.75+ACSToffset+ACSTtol',
            Program_Line_1294='elseif PMOT > ACSTaul',
            Program_Line_1295='set ACST = ACSTaul*0.26+16.75+ACSToffset+ACSTtol',
            Program_Line_1296='endif',
            Program_Line_1297='endif',
            Program_Line_1298='if (ComfStand == 14) && (ComfMod == 3)',
            Program_Line_1299='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1300='set AHST = PMOT*0.26+16.75+AHSToffset+AHSTtol',
            Program_Line_1301='elseif PMOT < AHSTall',
            Program_Line_1302='set AHST = AHSTall*0.26+16.75+AHSToffset+AHSTtol',
            Program_Line_1303='elseif PMOT > AHSTaul',
            Program_Line_1304='set AHST = AHSTaul*0.26+16.75+AHSToffset+AHSTtol',
            Program_Line_1305='endif',
            Program_Line_1306='endif',
            Program_Line_1307='if (ComfStand == 15) || (ComfStand == 16)',
            Program_Line_1308='if (ComfMod == 0)',
            Program_Line_1309='if (CAT==80)',
            Program_Line_1310='if PMOT < 20',
            Program_Line_1311='set ACST = 23.5+ACSTtol',
            Program_Line_1312='set AHST = 21+ACSTtol',
            Program_Line_1313='else',
            Program_Line_1314='set ACST = 25.5+ACSTtol',
            Program_Line_1315='set AHST = 22.5+ACSTtol',
            Program_Line_1316='endif',
            Program_Line_1317='elseif (CAT==90)',
            Program_Line_1318='if PMOT < 20',
            Program_Line_1319='set ACST = 23+ACSTtol',
            Program_Line_1320='set AHST = 21.5+ACSTtol',
            Program_Line_1321='else',
            Program_Line_1322='set ACST = 25+ACSTtol',
            Program_Line_1323='set AHST = 23+ACSTtol',
            Program_Line_1324='endif',
            Program_Line_1325='endif',
            Program_Line_1326='endif',
            Program_Line_1327='endif',
            Program_Line_1328='if (ComfStand == 15) && (ComfMod == 1)',
            Program_Line_1329='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1330='set ACST = PMOT*0.56+12.74+ACSToffset+ACSTtol',
            Program_Line_1331='elseif CAT==80',
            Program_Line_1332='if PMOT < ACSTall',
            Program_Line_1333='set ACST = 23.5+ACSTtol',
            Program_Line_1334='elseif PMOT > ACSTaul',
            Program_Line_1335='set ACST = 25.5+ACSTtol',
            Program_Line_1336='endif',
            Program_Line_1337='elseif CAT==90',
            Program_Line_1338='if PMOT < ACSTall',
            Program_Line_1339='set ACST = 23+ACSTtol',
            Program_Line_1340='elseif PMOT > ACSTaul',
            Program_Line_1341='set ACST = 25+ACSTtol',
            Program_Line_1342='endif',
            Program_Line_1343='endif',
            Program_Line_1344='endif',
            Program_Line_1345='if (ComfStand == 15) && (ComfMod == 1)',
            Program_Line_1346='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1347='set AHST = PMOT*0.56+12.74+AHSToffset+AHSTtol',
            Program_Line_1348='elseif CAT==80',
            Program_Line_1349='if PMOT < AHSTall',
            Program_Line_1350='set AHST = 21+AHSTtol',
            Program_Line_1351='elseif PMOT > AHSTaul',
            Program_Line_1352='set AHST = 22.5+AHSTtol',
            Program_Line_1353='endif',
            Program_Line_1354='elseif CAT==90',
            Program_Line_1355='if PMOT < AHSTall',
            Program_Line_1356='set AHST = 23+AHSTtol',
            Program_Line_1357='elseif PMOT > AHSTaul',
            Program_Line_1358='set AHST = 23+AHSTtol',
            Program_Line_1359='endif',
            Program_Line_1360='endif',
            Program_Line_1361='endif',
            Program_Line_1362='if (ComfStand == 15) && (ComfMod == 2)',
            Program_Line_1363='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1364='set ACST = PMOT*0.56+12.74+ACSToffset+ACSTtol',
            Program_Line_1365='elseif CAT==80',
            Program_Line_1366='if PMOT < ACSTall',
            Program_Line_1367='set ACST = 25+ACSTtol',
            Program_Line_1368='elseif PMOT > ACSTaul',
            Program_Line_1369='set ACST = 27+ACSTtol',
            Program_Line_1370='endif',
            Program_Line_1371='elseif CAT==90',
            Program_Line_1372='if PMOT < ACSTall',
            Program_Line_1373='set ACST = 24+ACSTtol',
            Program_Line_1374='elseif PMOT > ACSTaul',
            Program_Line_1375='set ACST = 26+ACSTtol',
            Program_Line_1376='endif',
            Program_Line_1377='endif',
            Program_Line_1378='endif',
            Program_Line_1379='if (ComfStand == 15) && (ComfMod == 2)',
            Program_Line_1380='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1381='set AHST = PMOT*0.56+12.74+AHSToffset+AHSTtol',
            Program_Line_1382='elseif CAT==80',
            Program_Line_1383='if PMOT < AHSTall',
            Program_Line_1384='set AHST = 19+AHSTtol',
            Program_Line_1385='elseif PMOT > AHSTaul',
            Program_Line_1386='set AHST = 22+AHSTtol',
            Program_Line_1387='endif',
            Program_Line_1388='elseif CAT==90',
            Program_Line_1389='if PMOT < AHSTall',
            Program_Line_1390='set AHST = 20+AHSTtol',
            Program_Line_1391='elseif PMOT > AHSTaul',
            Program_Line_1392='set AHST = 23+AHSTtol',
            Program_Line_1393='endif',
            Program_Line_1394='endif',
            Program_Line_1395='endif',
            Program_Line_1396='if (ComfStand == 15) && (ComfMod == 3)',
            Program_Line_1397='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1398='set ACST = PMOT*0.56+12.74+ACSToffset+ACSTtol',
            Program_Line_1399='elseif PMOT < ACSTall',
            Program_Line_1400='set ACST = ACSTall*0.56+12.74+ACSToffset+ACSTtol',
            Program_Line_1401='elseif PMOT > ACSTaul',
            Program_Line_1402='set ACST = ACSTaul*0.56+12.74+ACSToffset+ACSTtol',
            Program_Line_1403='endif',
            Program_Line_1404='endif',
            Program_Line_1405='if (ComfStand == 15) && (ComfMod == 3)',
            Program_Line_1406='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1407='set AHST = PMOT*0.56+12.74+AHSToffset+AHSTtol',
            Program_Line_1408='elseif PMOT < AHSTall',
            Program_Line_1409='set AHST = AHSTall*0.56+12.74+AHSToffset+AHSTtol',
            Program_Line_1410='elseif PMOT > AHSTaul',
            Program_Line_1411='set AHST = AHSTaul*0.56+12.74+AHSToffset+AHSTtol',
            Program_Line_1412='endif',
            Program_Line_1413='endif',
            Program_Line_1414='if (ComfStand == 16) && (ComfMod == 1)',
            Program_Line_1415='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1416='set ACST = PMOT*0.09+22.32+ACSToffset+ACSTtol',
            Program_Line_1417='elseif CAT==80',
            Program_Line_1418='if PMOT < ACSTall',
            Program_Line_1419='set ACST = 23.5+ACSTtol',
            Program_Line_1420='elseif PMOT > ACSTaul',
            Program_Line_1421='set ACST = 25.5+ACSTtol',
            Program_Line_1422='endif',
            Program_Line_1423='elseif CAT==90',
            Program_Line_1424='if PMOT < ACSTall',
            Program_Line_1425='set ACST = 23+ACSTtol',
            Program_Line_1426='elseif PMOT > ACSTaul',
            Program_Line_1427='set ACST = 25+ACSTtol',
            Program_Line_1428='endif',
            Program_Line_1429='endif',
            Program_Line_1430='endif',
            Program_Line_1431='if (ComfStand == 16) && (ComfMod == 1)',
            Program_Line_1432='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1433='set AHST = PMOT*0.09+22.32+AHSToffset+AHSTtol',
            Program_Line_1434='elseif CAT==80',
            Program_Line_1435='if PMOT < AHSTall',
            Program_Line_1436='set AHST = 21+AHSTtol',
            Program_Line_1437='elseif PMOT > AHSTaul',
            Program_Line_1438='set AHST = 22.5+AHSTtol',
            Program_Line_1439='endif',
            Program_Line_1440='elseif CAT==90',
            Program_Line_1441='if PMOT < AHSTall',
            Program_Line_1442='set AHST = 23+AHSTtol',
            Program_Line_1443='elseif PMOT > AHSTaul',
            Program_Line_1444='set AHST = 23+AHSTtol',
            Program_Line_1445='endif',
            Program_Line_1446='endif',
            Program_Line_1447='endif',
            Program_Line_1448='if (ComfStand == 16) && (ComfMod == 2)',
            Program_Line_1449='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1450='set ACST = PMOT*0.09+22.32+ACSToffset+ACSTtol',
            Program_Line_1451='elseif CAT==80',
            Program_Line_1452='if PMOT < ACSTall',
            Program_Line_1453='set ACST = 25+ACSTtol',
            Program_Line_1454='elseif PMOT > ACSTaul',
            Program_Line_1455='set ACST = 27+ACSTtol',
            Program_Line_1456='endif',
            Program_Line_1457='elseif CAT==90',
            Program_Line_1458='if PMOT < ACSTall',
            Program_Line_1459='set ACST = 24+ACSTtol',
            Program_Line_1460='elseif PMOT > ACSTaul',
            Program_Line_1461='set ACST = 26+ACSTtol',
            Program_Line_1462='endif',
            Program_Line_1463='endif',
            Program_Line_1464='endif',
            Program_Line_1465='if (ComfStand == 16) && (ComfMod == 2)',
            Program_Line_1466='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1467='set AHST = PMOT*0.09+22.32+AHSToffset+AHSTtol',
            Program_Line_1468='elseif CAT==80',
            Program_Line_1469='if PMOT < AHSTall',
            Program_Line_1470='set AHST = 19+AHSTtol',
            Program_Line_1471='elseif PMOT > AHSTaul',
            Program_Line_1472='set AHST = 22+AHSTtol',
            Program_Line_1473='endif',
            Program_Line_1474='elseif CAT==90',
            Program_Line_1475='if PMOT < AHSTall',
            Program_Line_1476='set AHST = 20+AHSTtol',
            Program_Line_1477='elseif PMOT > AHSTaul',
            Program_Line_1478='set AHST = 23+AHSTtol',
            Program_Line_1479='endif',
            Program_Line_1480='endif',
            Program_Line_1481='endif',
            Program_Line_1482='if (ComfStand == 16) && (ComfMod == 3)',
            Program_Line_1483='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1484='set ACST = PMOT*0.09+22.32+ACSToffset+ACSTtol',
            Program_Line_1485='elseif PMOT < ACSTall',
            Program_Line_1486='set ACST = ACSTall*0.09+22.32+ACSToffset+ACSTtol',
            Program_Line_1487='elseif PMOT > ACSTaul',
            Program_Line_1488='set ACST = ACSTaul*0.09+22.32+ACSToffset+ACSTtol',
            Program_Line_1489='endif',
            Program_Line_1490='endif',
            Program_Line_1491='if (ComfStand == 16) && (ComfMod == 3)',
            Program_Line_1492='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1493='set AHST = PMOT*0.09+22.32+AHSToffset+AHSTtol',
            Program_Line_1494='elseif PMOT < AHSTall',
            Program_Line_1495='set AHST = AHSTall*0.09+22.32+AHSToffset+AHSTtol',
            Program_Line_1496='elseif PMOT > AHSTaul',
            Program_Line_1497='set AHST = AHSTaul*0.09+22.32+AHSToffset+AHSTtol',
            Program_Line_1498='endif',
            Program_Line_1499='endif',
            Program_Line_1500='if (ComfStand == 17) || (ComfStand == 18) || (ComfStand == 19) || (ComfStand == 20)',
            Program_Line_1501='if ComfMod == 0',
            Program_Line_1502='set ACST = 25+ACSTtol',
            Program_Line_1503='set AHST = 20+AHSTtol',
            Program_Line_1504='endif',
            Program_Line_1505='endif',
            Program_Line_1506='if (ComfStand == 17) && (ComfMod == 1)',
            Program_Line_1507='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1508='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1509='set ACST = PMOT*0.48+13.9+ACSToffset+ACSTtol',
            Program_Line_1510='else',
            Program_Line_1511='set ACST = 25+ACSTtol',
            Program_Line_1512='endif',
            Program_Line_1513='else',
            Program_Line_1514='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1515='set ACST = PMOT*0.59+9.6+ACSToffset+ACSTtol',
            Program_Line_1516='else',
            Program_Line_1517='set ACST = 25+ACSTtol',
            Program_Line_1518='endif',
            Program_Line_1519='endif',
            Program_Line_1520='endif',
            Program_Line_1521='if (ComfStand == 17) && (ComfMod == 1)',
            Program_Line_1522='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1523='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1524='set AHST = PMOT*0.48+13.9+AHSToffset+AHSTtol',
            Program_Line_1525='else',
            Program_Line_1526='set AHST = 20+AHSTtol',
            Program_Line_1527='endif',
            Program_Line_1528='else',
            Program_Line_1529='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1530='set AHST = PMOT*0.59+9.6+AHSToffset+AHSTtol',
            Program_Line_1531='else',
            Program_Line_1532='set AHST = 20+AHSTtol',
            Program_Line_1533='endif',
            Program_Line_1534='endif',
            Program_Line_1535='endif',
            Program_Line_1536='if (ComfStand == 17) && (ComfMod == 2)',
            Program_Line_1537='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1538='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1539='set ACST = PMOT*0.48+13.9+ACSToffset+ACSTtol',
            Program_Line_1540='elseif PMOT < ACSTall',
            Program_Line_1541='if CAT == 90',
            Program_Line_1542='set ACST = 24+ACSTtol',
            Program_Line_1543='elseif CAT == 80',
            Program_Line_1544='set ACST = 25+ACSTtol',
            Program_Line_1545='endif',
            Program_Line_1546='elseif PMOT > ACSTaul',
            Program_Line_1547='if CAT == 90',
            Program_Line_1548='set ACST = 26+ACSTtol',
            Program_Line_1549='elseif CAT == 80',
            Program_Line_1550='set ACST = 27+ACSTtol',
            Program_Line_1551='endif',
            Program_Line_1552='endif',
            Program_Line_1553='else',
            Program_Line_1554='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1555='set ACST = PMOT*0.59+9.6+ACSToffset+ACSTtol',
            Program_Line_1556='elseif PMOT < ACSTall',
            Program_Line_1557='if CAT == 90',
            Program_Line_1558='set ACST = 24+ACSTtol',
            Program_Line_1559='elseif CAT == 80',
            Program_Line_1560='set ACST = 25+ACSTtol',
            Program_Line_1561='endif',
            Program_Line_1562='elseif PMOT > ACSTaul',
            Program_Line_1563='if CAT == 90',
            Program_Line_1564='set ACST = 26+ACSTtol',
            Program_Line_1565='elseif CAT == 80',
            Program_Line_1566='set ACST = 27+ACSTtol',
            Program_Line_1567='endif',
            Program_Line_1568='endif',
            Program_Line_1569='endif',
            Program_Line_1570='endif',
            Program_Line_1571='if (ComfStand == 17) && (ComfMod == 2)',
            Program_Line_1572='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1573='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1574='set AHST = PMOT*0.48+13.9+AHSToffset+AHSTtol',
            Program_Line_1575='elseif PMOT < AHSTall',
            Program_Line_1576='if CAT == 90',
            Program_Line_1577='set AHST = 20+AHSTtol',
            Program_Line_1578='elseif CAT == 80',
            Program_Line_1579='set AHST = 19+AHSTtol',
            Program_Line_1580='endif',
            Program_Line_1581='elseif PMOT > AHSTaul',
            Program_Line_1582='if CAT == 90',
            Program_Line_1583='set AHST = 23+AHSTtol',
            Program_Line_1584='elseif CAT == 80',
            Program_Line_1585='set AHST = 22+AHSTtol',
            Program_Line_1586='endif',
            Program_Line_1587='endif',
            Program_Line_1588='else',
            Program_Line_1589='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1590='set AHST = PMOT*0.59+9.6+AHSToffset+AHSTtol',
            Program_Line_1591='elseif PMOT < AHSTall',
            Program_Line_1592='if CAT == 90',
            Program_Line_1593='set AHST = 20+AHSTtol',
            Program_Line_1594='elseif CAT == 80',
            Program_Line_1595='set AHST = 19+AHSTtol',
            Program_Line_1596='endif',
            Program_Line_1597='elseif PMOT > AHSTaul',
            Program_Line_1598='if CAT == 90',
            Program_Line_1599='set AHST = 23+AHSTtol',
            Program_Line_1600='elseif CAT == 80',
            Program_Line_1601='set AHST = 22+AHSTtol',
            Program_Line_1602='endif',
            Program_Line_1603='endif',
            Program_Line_1604='endif',
            Program_Line_1605='endif',
            Program_Line_1606='if (ComfStand == 17) && (ComfMod == 3)',
            Program_Line_1607='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1608='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1609='set ACST = PMOT*0.48+13.9+ACSToffset+ACSTtol',
            Program_Line_1610='elseif PMOT < ACSTall',
            Program_Line_1611='set ACST = ACSTall*0.48+13.9+ACSToffset+ACSTtol',
            Program_Line_1612='elseif PMOT > ACSTaul',
            Program_Line_1613='set ACST = ACSTaul*0.48+13.9+ACSToffset+ACSTtol',
            Program_Line_1614='endif',
            Program_Line_1615='else',
            Program_Line_1616='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1617='set ACST = PMOT*0.59+9.6+ACSToffset+ACSTtol',
            Program_Line_1618='elseif PMOT < ACSTall',
            Program_Line_1619='set ACST = ACSTall*0.59+9.6+ACSToffset+ACSTtol',
            Program_Line_1620='elseif PMOT > ACSTaul',
            Program_Line_1621='set ACST = ACSTaul*0.59+9.6+ACSToffset+ACSTtol',
            Program_Line_1622='endif',
            Program_Line_1623='endif',
            Program_Line_1624='endif',
            Program_Line_1625='if (ComfStand == 17) && (ComfMod == 3)',
            Program_Line_1626='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1627='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1628='set AHST = PMOT*0.48+13.9+AHSToffset+AHSTtol',
            Program_Line_1629='elseif PMOT < AHSTall',
            Program_Line_1630='set AHST = AHSTall*0.48+13.9+AHSToffset+AHSTtol',
            Program_Line_1631='elseif PMOT > AHSTaul',
            Program_Line_1632='set AHST = AHSTaul*0.48+13.9+AHSToffset+AHSTtol',
            Program_Line_1633='endif',
            Program_Line_1634='else',
            Program_Line_1635='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1636='set AHST = PMOT*0.59+9.6+AHSToffset+AHSTtol',
            Program_Line_1637='elseif PMOT < AHSTall',
            Program_Line_1638='set AHST = AHSTall*0.59+9.6+AHSToffset+AHSTtol',
            Program_Line_1639='elseif PMOT > AHSTaul',
            Program_Line_1640='set AHST = AHSTaul*0.59+9.6+AHSToffset+AHSTtol',
            Program_Line_1641='endif',
            Program_Line_1642='endif',
            Program_Line_1643='endif',
            Program_Line_1644='if (ComfStand == 18) && (ComfMod == 1)',
            Program_Line_1645='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1646='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1647='set ACST = PMOT*0.84+5.3+ACSToffset+ACSTtol',
            Program_Line_1648='else',
            Program_Line_1649='set ACST = 25+ACSTtol',
            Program_Line_1650='endif',
            Program_Line_1651='else',
            Program_Line_1652='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1653='set ACST = PMOT*0.96-3.6+ACSToffset+ACSTtol',
            Program_Line_1654='else',
            Program_Line_1655='set ACST = 25+ACSTtol',
            Program_Line_1656='endif',
            Program_Line_1657='endif',
            Program_Line_1658='endif',
            Program_Line_1659='if (ComfStand == 18) && (ComfMod == 1)',
            Program_Line_1660='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1661='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1662='set AHST = PMOT*0.84+5.3+AHSToffset+AHSTtol',
            Program_Line_1663='else',
            Program_Line_1664='set AHST = 20+AHSTtol',
            Program_Line_1665='endif',
            Program_Line_1666='else',
            Program_Line_1667='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1668='set AHST = PMOT*0.96-3.6+AHSToffset+AHSTtol',
            Program_Line_1669='else',
            Program_Line_1670='set AHST = 20+AHSTtol',
            Program_Line_1671='endif',
            Program_Line_1672='endif',
            Program_Line_1673='endif',
            Program_Line_1674='if (ComfStand == 18) && (ComfMod == 2)',
            Program_Line_1675='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1676='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1677='set ACST = PMOT*0.84+5.3+ACSToffset+ACSTtol',
            Program_Line_1678='elseif PMOT < ACSTall',
            Program_Line_1679='if CAT == 90',
            Program_Line_1680='set ACST = 24+ACSTtol',
            Program_Line_1681='elseif CAT == 80',
            Program_Line_1682='set ACST = 25+ACSTtol',
            Program_Line_1683='endif',
            Program_Line_1684='elseif PMOT > ACSTaul',
            Program_Line_1685='if CAT == 90',
            Program_Line_1686='set ACST = 26+ACSTtol',
            Program_Line_1687='elseif CAT == 80',
            Program_Line_1688='set ACST = 27+ACSTtol',
            Program_Line_1689='endif',
            Program_Line_1690='endif',
            Program_Line_1691='else',
            Program_Line_1692='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1693='set ACST = PMOT*0.96-3.6+ACSToffset+ACSTtol',
            Program_Line_1694='elseif PMOT < ACSTall',
            Program_Line_1695='if CAT == 90',
            Program_Line_1696='set ACST = 24+ACSTtol',
            Program_Line_1697='elseif CAT == 80',
            Program_Line_1698='set ACST = 25+ACSTtol',
            Program_Line_1699='endif',
            Program_Line_1700='elseif PMOT > ACSTaul',
            Program_Line_1701='if CAT == 90',
            Program_Line_1702='set ACST = 26+ACSTtol',
            Program_Line_1703='elseif CAT == 80',
            Program_Line_1704='set ACST = 27+ACSTtol',
            Program_Line_1705='endif',
            Program_Line_1706='endif',
            Program_Line_1707='endif',
            Program_Line_1708='endif',
            Program_Line_1709='if (ComfStand == 18) && (ComfMod == 2)',
            Program_Line_1710='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1711='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1712='set AHST = PMOT*0.84+5.3+AHSToffset+AHSTtol',
            Program_Line_1713='elseif PMOT < AHSTall',
            Program_Line_1714='if CAT == 90',
            Program_Line_1715='set AHST = 20+AHSTtol',
            Program_Line_1716='elseif CAT == 80',
            Program_Line_1717='set AHST = 19+AHSTtol',
            Program_Line_1718='endif',
            Program_Line_1719='elseif PMOT > AHSTaul',
            Program_Line_1720='if CAT == 90',
            Program_Line_1721='set AHST = 23+AHSTtol',
            Program_Line_1722='elseif CAT == 80',
            Program_Line_1723='set AHST = 22+AHSTtol',
            Program_Line_1724='endif',
            Program_Line_1725='endif',
            Program_Line_1726='else',
            Program_Line_1727='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1728='set AHST = PMOT*0.96-3.6+AHSToffset+AHSTtol',
            Program_Line_1729='elseif PMOT < AHSTall',
            Program_Line_1730='if CAT == 90',
            Program_Line_1731='set AHST = 20+AHSTtol',
            Program_Line_1732='elseif CAT == 80',
            Program_Line_1733='set AHST = 19+AHSTtol',
            Program_Line_1734='endif',
            Program_Line_1735='elseif PMOT > AHSTaul',
            Program_Line_1736='if CAT == 90',
            Program_Line_1737='set AHST = 23+AHSTtol',
            Program_Line_1738='elseif CAT == 80',
            Program_Line_1739='set AHST = 22+AHSTtol',
            Program_Line_1740='endif',
            Program_Line_1741='endif',
            Program_Line_1742='endif',
            Program_Line_1743='endif',
            Program_Line_1744='if (ComfStand == 18) && (ComfMod == 3)',
            Program_Line_1745='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1746='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1747='set ACST = PMOT*0.84+5.3+ACSToffset+ACSTtol',
            Program_Line_1748='elseif PMOT < ACSTall',
            Program_Line_1749='set ACST = ACSTall*0.84+5.3+ACSToffset+ACSTtol',
            Program_Line_1750='elseif PMOT > ACSTaul',
            Program_Line_1751='set ACST = ACSTaul*0.84+5.3+ACSToffset+ACSTtol',
            Program_Line_1752='endif',
            Program_Line_1753='else',
            Program_Line_1754='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1755='set ACST = PMOT*0.96-3.6+ACSToffset+ACSTtol',
            Program_Line_1756='elseif PMOT < ACSTall',
            Program_Line_1757='set ACST = ACSTall*0.96-3.6+ACSToffset+ACSTtol',
            Program_Line_1758='elseif PMOT > ACSTaul',
            Program_Line_1759='set ACST = ACSTaul*0.96-3.6+ACSToffset+ACSTtol',
            Program_Line_1760='endif',
            Program_Line_1761='endif',
            Program_Line_1762='endif',
            Program_Line_1763='if (ComfStand == 18) && (ComfMod == 3)',
            Program_Line_1764='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1765='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1766='set AHST = PMOT*0.84+5.3+AHSToffset+AHSTtol',
            Program_Line_1767='elseif PMOT < AHSTall',
            Program_Line_1768='set AHST = AHSTall*0.84+5.3+AHSToffset+AHSTtol',
            Program_Line_1769='elseif PMOT > AHSTaul',
            Program_Line_1770='set AHST = AHSTaul*0.84+5.3+AHSToffset+AHSTtol',
            Program_Line_1771='endif',
            Program_Line_1772='else',
            Program_Line_1773='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1774='set AHST = PMOT*0.96-3.6+AHSToffset+AHSTtol',
            Program_Line_1775='elseif PMOT < AHSTall',
            Program_Line_1776='set AHST = AHSTall*0.96-3.6+AHSToffset+AHSTtol',
            Program_Line_1777='elseif PMOT > AHSTaul',
            Program_Line_1778='set AHST = AHSTaul*0.96-3.6+AHSToffset+AHSTtol',
            Program_Line_1779='endif',
            Program_Line_1780='endif',
            Program_Line_1781='endif',
            Program_Line_1782='if (ComfStand == 19) && (ComfMod == 1)',
            Program_Line_1783='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1784='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1785='set ACST = PMOT*0.27+17.9+ACSToffset+ACSTtol',
            Program_Line_1786='else',
            Program_Line_1787='set ACST = 25+ACSTtol',
            Program_Line_1788='endif',
            Program_Line_1789='else',
            Program_Line_1790='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1791='set ACST = PMOT*0.53+10.3+ACSToffset+ACSTtol',
            Program_Line_1792='else',
            Program_Line_1793='set ACST = 25+ACSTtol',
            Program_Line_1794='endif',
            Program_Line_1795='endif',
            Program_Line_1796='endif',
            Program_Line_1797='if (ComfStand == 19) && (ComfMod == 1)',
            Program_Line_1798='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1799='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1800='set AHST = PMOT*0.27+17.9+AHSToffset+AHSTtol',
            Program_Line_1801='else',
            Program_Line_1802='set AHST = 20+AHSTtol',
            Program_Line_1803='endif',
            Program_Line_1804='else',
            Program_Line_1805='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1806='set AHST = PMOT*0.53+10.3+AHSToffset+AHSTtol',
            Program_Line_1807='else',
            Program_Line_1808='set AHST = 20+AHSTtol',
            Program_Line_1809='endif',
            Program_Line_1810='endif',
            Program_Line_1811='endif',
            Program_Line_1812='if (ComfStand == 19) && (ComfMod == 2)',
            Program_Line_1813='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1814='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1815='set ACST = PMOT*0.27+17.9+ACSToffset+ACSTtol',
            Program_Line_1816='elseif PMOT < ACSTall',
            Program_Line_1817='if CAT == 90',
            Program_Line_1818='set ACST = 24+ACSTtol',
            Program_Line_1819='elseif CAT == 80',
            Program_Line_1820='set ACST = 25+ACSTtol',
            Program_Line_1821='endif',
            Program_Line_1822='elseif PMOT > ACSTaul',
            Program_Line_1823='if CAT == 90',
            Program_Line_1824='set ACST = 26+ACSTtol',
            Program_Line_1825='elseif CAT == 80',
            Program_Line_1826='set ACST = 27+ACSTtol',
            Program_Line_1827='endif',
            Program_Line_1828='endif',
            Program_Line_1829='else',
            Program_Line_1830='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1831='set ACST = PMOT*0.53+10.3+ACSToffset+ACSTtol',
            Program_Line_1832='elseif PMOT < ACSTall',
            Program_Line_1833='if CAT == 90',
            Program_Line_1834='set ACST = 24+ACSTtol',
            Program_Line_1835='elseif CAT == 80',
            Program_Line_1836='set ACST = 25+ACSTtol',
            Program_Line_1837='endif',
            Program_Line_1838='elseif PMOT > ACSTaul',
            Program_Line_1839='if CAT == 90',
            Program_Line_1840='set ACST = 26+ACSTtol',
            Program_Line_1841='elseif CAT == 80',
            Program_Line_1842='set ACST = 27+ACSTtol',
            Program_Line_1843='endif',
            Program_Line_1844='endif',
            Program_Line_1845='endif',
            Program_Line_1846='endif',
            Program_Line_1847='if (ComfStand == 19) && (ComfMod == 2)',
            Program_Line_1848='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1849='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1850='set AHST = PMOT*0.27+17.9+AHSToffset+AHSTtol',
            Program_Line_1851='elseif PMOT < AHSTall',
            Program_Line_1852='if CAT == 90',
            Program_Line_1853='set AHST = 20+AHSTtol',
            Program_Line_1854='elseif CAT == 80',
            Program_Line_1855='set AHST = 19+AHSTtol',
            Program_Line_1856='endif',
            Program_Line_1857='elseif PMOT > AHSTaul',
            Program_Line_1858='if CAT == 90',
            Program_Line_1859='set AHST = 23+AHSTtol',
            Program_Line_1860='elseif CAT == 80',
            Program_Line_1861='set AHST = 22+AHSTtol',
            Program_Line_1862='endif',
            Program_Line_1863='endif',
            Program_Line_1864='else',
            Program_Line_1865='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1866='set AHST = PMOT*0.53+10.3+AHSToffset+AHSTtol',
            Program_Line_1867='elseif PMOT < AHSTall',
            Program_Line_1868='if CAT == 90',
            Program_Line_1869='set AHST = 20+AHSTtol',
            Program_Line_1870='elseif CAT == 80',
            Program_Line_1871='set AHST = 19+AHSTtol',
            Program_Line_1872='endif',
            Program_Line_1873='elseif PMOT > AHSTaul',
            Program_Line_1874='if CAT == 90',
            Program_Line_1875='set AHST = 23+AHSTtol',
            Program_Line_1876='elseif CAT == 80',
            Program_Line_1877='set AHST = 22+AHSTtol',
            Program_Line_1878='endif',
            Program_Line_1879='endif',
            Program_Line_1880='endif',
            Program_Line_1881='endif',
            Program_Line_1882='if (ComfStand == 19) && (ComfMod == 3)',
            Program_Line_1883='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1884='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1885='set ACST = PMOT*0.27+17.9+ACSToffset+ACSTtol',
            Program_Line_1886='elseif PMOT < ACSTall',
            Program_Line_1887='set ACST = ACSTall*0.27+17.9+ACSToffset+ACSTtol',
            Program_Line_1888='elseif PMOT > ACSTaul',
            Program_Line_1889='set ACST = ACSTaul*0.27+17.9+ACSToffset+ACSTtol',
            Program_Line_1890='endif',
            Program_Line_1891='else',
            Program_Line_1892='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1893='set ACST = PMOT*0.53+10.3+ACSToffset+ACSTtol',
            Program_Line_1894='elseif PMOT < ACSTall',
            Program_Line_1895='set ACST = ACSTall*0.53+10.3+ACSToffset+ACSTtol',
            Program_Line_1896='elseif PMOT > ACSTaul',
            Program_Line_1897='set ACST = ACSTaul*0.53+10.3+ACSToffset+ACSTtol',
            Program_Line_1898='endif',
            Program_Line_1899='endif',
            Program_Line_1900='endif',
            Program_Line_1901='if (ComfStand == 19) && (ComfMod == 3)',
            Program_Line_1902='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1903='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1904='set AHST = PMOT*0.27+17.9+AHSToffset+AHSTtol',
            Program_Line_1905='elseif PMOT < AHSTall',
            Program_Line_1906='set AHST = AHSTall*0.27+17.9+AHSToffset+AHSTtol',
            Program_Line_1907='elseif PMOT > AHSTaul',
            Program_Line_1908='set AHST = AHSTaul*0.27+17.9+AHSToffset+AHSTtol',
            Program_Line_1909='endif',
            Program_Line_1910='else',
            Program_Line_1911='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1912='set AHST = PMOT*0.53+10.3+AHSToffset+AHSTtol',
            Program_Line_1913='elseif PMOT < AHSTall',
            Program_Line_1914='set AHST = AHSTall*0.53+10.3+AHSToffset+AHSTtol',
            Program_Line_1915='elseif PMOT > AHSTaul',
            Program_Line_1916='set AHST = AHSTaul*0.53+10.3+AHSToffset+AHSTtol',
            Program_Line_1917='endif',
            Program_Line_1918='endif',
            Program_Line_1919='endif',
            Program_Line_1920='if (ComfStand == 20) && (ComfMod == 1)',
            Program_Line_1921='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1922='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1923='set ACST = PMOT*0.38+15.7+ACSToffset+ACSTtol',
            Program_Line_1924='else',
            Program_Line_1925='set ACST = 25+ACSTtol',
            Program_Line_1926='endif',
            Program_Line_1927='else',
            Program_Line_1928='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1929='set ACST = PMOT*0.47+9.07+ACSToffset+ACSTtol',
            Program_Line_1930='else',
            Program_Line_1931='set ACST = 25+ACSTtol',
            Program_Line_1932='endif',
            Program_Line_1933='endif',
            Program_Line_1934='endif',
            Program_Line_1935='if (ComfStand == 20) && (ComfMod == 1)',
            Program_Line_1936='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1937='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1938='set AHST = PMOT*0.38+15.7+AHSToffset+AHSTtol',
            Program_Line_1939='else',
            Program_Line_1940='set AHST = 20+AHSTtol',
            Program_Line_1941='endif',
            Program_Line_1942='else',
            Program_Line_1943='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1944='set AHST = PMOT*0.47+9.07+AHSToffset+AHSTtol',
            Program_Line_1945='else',
            Program_Line_1946='set AHST = 20+AHSTtol',
            Program_Line_1947='endif',
            Program_Line_1948='endif',
            Program_Line_1949='endif',
            Program_Line_1950='if (ComfStand == 20) && (ComfMod == 2)',
            Program_Line_1951='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1952='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1953='set ACST = PMOT*0.38+15.7+ACSToffset+ACSTtol',
            Program_Line_1954='elseif PMOT < ACSTall',
            Program_Line_1955='if CAT == 90',
            Program_Line_1956='set ACST = 24+ACSTtol',
            Program_Line_1957='elseif CAT == 80',
            Program_Line_1958='set ACST = 25+ACSTtol',
            Program_Line_1959='endif',
            Program_Line_1960='elseif PMOT > ACSTaul',
            Program_Line_1961='if CAT == 90',
            Program_Line_1962='set ACST = 26+ACSTtol',
            Program_Line_1963='elseif CAT == 80',
            Program_Line_1964='set ACST = 27+ACSTtol',
            Program_Line_1965='endif',
            Program_Line_1966='endif',
            Program_Line_1967='else',
            Program_Line_1968='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_1969='set ACST = PMOT*0.47+9.07+ACSToffset+ACSTtol',
            Program_Line_1970='elseif PMOT < ACSTall',
            Program_Line_1971='if CAT == 90',
            Program_Line_1972='set ACST = 24+ACSTtol',
            Program_Line_1973='elseif CAT == 80',
            Program_Line_1974='set ACST = 25+ACSTtol',
            Program_Line_1975='endif',
            Program_Line_1976='elseif PMOT > ACSTaul',
            Program_Line_1977='if CAT == 90',
            Program_Line_1978='set ACST = 26+ACSTtol',
            Program_Line_1979='elseif CAT == 80',
            Program_Line_1980='set ACST = 27+ACSTtol',
            Program_Line_1981='endif',
            Program_Line_1982='endif',
            Program_Line_1983='endif',
            Program_Line_1984='endif',
            Program_Line_1985='if (ComfStand == 20) && (ComfMod == 2)',
            Program_Line_1986='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_1987='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_1988='set AHST = PMOT*0.38+15.7+AHSToffset+AHSTtol',
            Program_Line_1989='elseif PMOT < AHSTall',
            Program_Line_1990='if CAT == 90',
            Program_Line_1991='set AHST = 20+AHSTtol',
            Program_Line_1992='elseif CAT == 80',
            Program_Line_1993='set AHST = 19+AHSTtol',
            Program_Line_1994='endif',
            Program_Line_1995='elseif PMOT > AHSTaul',
            Program_Line_1996='if CAT == 90',
            Program_Line_1997='set AHST = 23+AHSTtol',
            Program_Line_1998='elseif CAT == 80',
            Program_Line_1999='set AHST = 22+AHSTtol',
            Program_Line_2000='endif',
            Program_Line_2001='endif',
            Program_Line_2002='else',
            Program_Line_2003='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_2004='set AHST = PMOT*0.47+9.07+AHSToffset+AHSTtol',
            Program_Line_2005='elseif PMOT < AHSTall',
            Program_Line_2006='if CAT == 90',
            Program_Line_2007='set AHST = 20+AHSTtol',
            Program_Line_2008='elseif CAT == 80',
            Program_Line_2009='set AHST = 19+AHSTtol',
            Program_Line_2010='endif',
            Program_Line_2011='elseif PMOT > AHSTaul',
            Program_Line_2012='if CAT == 90',
            Program_Line_2013='set AHST = 23+AHSTtol',
            Program_Line_2014='elseif CAT == 80',
            Program_Line_2015='set AHST = 22+AHSTtol',
            Program_Line_2016='endif',
            Program_Line_2017='endif',
            Program_Line_2018='endif',
            Program_Line_2019='endif',
            Program_Line_2020='if (ComfStand == 20) && (ComfMod == 3)',
            Program_Line_2021='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_2022='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_2023='set ACST = PMOT*0.38+15.7+ACSToffset+ACSTtol',
            Program_Line_2024='elseif PMOT < ACSTall',
            Program_Line_2025='set ACST = ACSTall*0.38+15.7+ACSToffset+ACSTtol',
            Program_Line_2026='elseif PMOT > ACSTaul',
            Program_Line_2027='set ACST = ACSTaul*0.38+15.7+ACSToffset+ACSTtol',
            Program_Line_2028='endif',
            Program_Line_2029='else',
            Program_Line_2030='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_2031='set ACST = PMOT*0.47+9.07+ACSToffset+ACSTtol',
            Program_Line_2032='elseif PMOT < ACSTall',
            Program_Line_2033='set ACST = ACSTall*0.47+9.07+ACSToffset+ACSTtol',
            Program_Line_2034='elseif PMOT > ACSTaul',
            Program_Line_2035='set ACST = ACSTaul*0.47+9.07+ACSToffset+ACSTtol',
            Program_Line_2036='endif',
            Program_Line_2037='endif',
            Program_Line_2038='endif',
            Program_Line_2039='if (ComfStand == 20) && (ComfMod == 3)',
            Program_Line_2040='if (DayOfYear <= 121) || (DayOfYear > 295)',
            Program_Line_2041='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_2042='set AHST = PMOT*0.38+15.7+AHSToffset+AHSTtol',
            Program_Line_2043='elseif PMOT < AHSTall',
            Program_Line_2044='set AHST = AHSTall*0.38+15.7+AHSToffset+AHSTtol',
            Program_Line_2045='elseif PMOT > AHSTaul',
            Program_Line_2046='set AHST = AHSTaul*0.38+15.7+AHSToffset+AHSTtol',
            Program_Line_2047='endif',
            Program_Line_2048='else',
            Program_Line_2049='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_2050='set AHST = PMOT*0.47+9.07+AHSToffset+AHSTtol',
            Program_Line_2051='elseif PMOT < AHSTall',
            Program_Line_2052='set AHST = AHSTall*0.47+9.07+AHSToffset+AHSTtol',
            Program_Line_2053='elseif PMOT > AHSTaul',
            Program_Line_2054='set AHST = AHSTaul*0.47+9.07+AHSToffset+AHSTtol',
            Program_Line_2055='endif',
            Program_Line_2056='endif',
            Program_Line_2057='endif',
            Program_Line_2058='if (ComfStand == 21) && (ComfMod == 2)',
            Program_Line_2059='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_2060='set ACST = PMOT*0.678+13.51+ACSToffset+ACSTtol',
            Program_Line_2061='elseif CAT==80',
            Program_Line_2062='if PMOT < ACSTall',
            Program_Line_2063='set ACST = 25+ACSTtol',
            Program_Line_2064='elseif PMOT > ACSTaul',
            Program_Line_2065='set ACST = 27+ACSTtol',
            Program_Line_2066='endif',
            Program_Line_2067='elseif CAT==90',
            Program_Line_2068='if PMOT < ACSTall',
            Program_Line_2069='set ACST = 24+ACSTtol',
            Program_Line_2070='elseif PMOT > ACSTaul',
            Program_Line_2071='set ACST = 26+ACSTtol',
            Program_Line_2072='endif',
            Program_Line_2073='endif',
            Program_Line_2074='endif',
            Program_Line_2075='if (ComfStand == 21) && (ComfMod == 2)',
            Program_Line_2076='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_2077='set AHST = PMOT*0.678+13.51+AHSToffset+AHSTtol',
            Program_Line_2078='elseif CAT==80',
            Program_Line_2079='if PMOT < AHSTall',
            Program_Line_2080='set AHST = 19+AHSTtol',
            Program_Line_2081='elseif PMOT > AHSTaul',
            Program_Line_2082='set AHST = 22+AHSTtol',
            Program_Line_2083='endif',
            Program_Line_2084='elseif CAT==90',
            Program_Line_2085='if PMOT < AHSTall',
            Program_Line_2086='set AHST = 20+AHSTtol',
            Program_Line_2087='elseif PMOT > AHSTaul',
            Program_Line_2088='set AHST = 23+AHSTtol',
            Program_Line_2089='endif',
            Program_Line_2090='endif',
            Program_Line_2091='endif',
            Program_Line_2092='if (ComfStand == 21) && (ComfMod == 3)',
            Program_Line_2093='if (PMOT >= ACSTall) && (PMOT <= ACSTaul)',
            Program_Line_2094='set ACST = PMOT*0.678+13.51+ACSToffset+ACSTtol',
            Program_Line_2095='elseif PMOT < ACSTall',
            Program_Line_2096='set ACST = ACSTall*0.678+13.51+ACSToffset+ACSTtol',
            Program_Line_2097='elseif PMOT > ACSTaul',
            Program_Line_2098='set ACST = ACSTaul*0.678+13.51+ACSToffset+ACSTtol',
            Program_Line_2099='endif',
            Program_Line_2100='endif',
            Program_Line_2101='if (ComfStand == 21) && (ComfMod == 3)',
            Program_Line_2102='if (PMOT >= AHSTall) && (PMOT <= AHSTaul)',
            Program_Line_2103='set AHST = PMOT*0.678+13.51+AHSToffset+AHSTtol',
            Program_Line_2104='elseif PMOT < AHSTall',
            Program_Line_2105='set AHST = AHSTall*0.678+13.51+AHSToffset+AHSTtol',
            Program_Line_2106='elseif PMOT > AHSTaul',
            Program_Line_2107='set AHST = AHSTaul*0.678+13.51+AHSToffset+AHSTtol',
            Program_Line_2108='endif',
            Program_Line_2109='endif',
        )
        if verboseMode:
            print('Added - SetAST Program')
    #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetAST'])

    if 'SetASTnoTol' in programlist:
        if verboseMode:
            print('Not added - SetASTnoTol Program')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Program',
            Name='SetASTnoTol',
            Program_Line_1='set ACSTnoTol = ACST-ACSTtol',
            Program_Line_2='set AHSTnoTol = AHST-AHSTtol'
            )
        if verboseMode:
            print('Added - SetASTnoTol Program')
    #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetASTnoTol'])

    for zonename in self.occupiedZones:
        if 'CountHoursNoApp_'+zonename in programlist:
            if verboseMode:
                print('Not added - CountHoursNoApp_'+zonename+' Program')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Program',
                Name='CountHoursNoApp_'+zonename,
                Program_Line_1='if ('+zonename+'_OpT <= ACSTnoTol)',
                Program_Line_2='if ('+zonename+'_OpT >= AHSTnoTol)',
                Program_Line_3='set ComfHoursNoApp_'+zonename+'  = 1*ZoneTimeStep',
                Program_Line_4='else',
                Program_Line_5='set ComfHoursNoApp_'+zonename+' = 0',
                Program_Line_6='endif',
                Program_Line_7='else',
                Program_Line_8='set ComfHoursNoApp_'+zonename+' = 0',
                Program_Line_9='endif'
                )
            if verboseMode:
                print('Added - CountHoursNoApp_'+zonename+' Program')
    #        print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'CountHoursNoApp_'+zonename])

        if 'SetGeoVar'+zonename in programlist:
            if verboseMode:
                print('Not added - SetGeoVar'+zonename+' Program')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Program',
                Name='SetGeoVar'+zonename,
                Program_Line_1='set ZoneFloorArea_' + zonename + ' = ZFA_' + zonename + '/2',
                Program_Line_2='set ZoneAirVolume_' + zonename + ' = ZAV_' + zonename + '/2'
            )
            if verboseMode:
                print('Added - SetGeoVar'+zonename+' Program')
    #        print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetGeoVar'+zonename])

    if 'SetInputData' in programlist:
        if verboseMode:
            print('Not added - SetInputData Program')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Program',
            Name='SetInputData',
            Program_Line_1='set ComfStand = 1',
            Program_Line_2='set CAT = 1',
            Program_Line_3='set ComfMod = 2',
            Program_Line_4='set HVACmode = 2',
            Program_Line_5='set VentCtrl = 0',
            Program_Line_6='set VSToffset = 0',
            Program_Line_7='set MinOToffset = 7',
            Program_Line_8='set MaxWindSpeed = 6',
            Program_Line_9='set ACSTtol = -0.25',
            Program_Line_10='set AHSTtol = 0.25'
            )
        if verboseMode:
            print('Added - SetInputData Program')

    if (ScriptType.lower() == 'vrf_mm' or
        ScriptType.lower() == 'ex_mm'):

        if 'SetVOFinputData' in programlist:
            if verboseMode:
                print('Not added - SetVOFinputData Program')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Program',
                Name='SetVOFinputData',
                Program_Line_1='set MaxTempDiffVOF = 7.5',
                Program_Line_2='set MinTempDiffVOF = 0',
                Program_Line_3='set MultiplierVOF = 0.25',
            )
            if verboseMode:
                print('Added - SetVOFinputData Program')

        if 'SetVST' in programlist:
            if verboseMode:
                print('Not added - SetVST Program')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Program',
                Name='SetVST',
                Program_Line_1='set MinOutTemp = AHST - MinOToffset',
                Program_Line_2='if (VentCtrl == 0) || (VentCtrl==2)',
                Program_Line_3='if ComfStand == 0',
                Program_Line_4='if (CurrentTime < 7)',
                Program_Line_5='set VST = (ACST+AHST)/2+VSToffset',
                Program_Line_6='elseif (CurrentTime < 15)',
                Program_Line_7='set VST = 22.5+VSToffset',
                Program_Line_8='elseif (CurrentTime < 23)',
                Program_Line_9='set VST = (ACST+AHST)/2+VSToffset',
                Program_Line_10='elseif (CurrentTime < 24)',
                Program_Line_11='set VST = (ACST+AHST)/2+VSToffset',
                Program_Line_12='endif',
                Program_Line_13='elseif ComfStand == 1 || ComfStand == 10',
                Program_Line_14='if (RMOT >= AHSTall) && (RMOT <= ACSTaul)',
                Program_Line_15='set VST = ComfTemp+VSToffset',
                Program_Line_16='else',
                Program_Line_17='set VST = (ACST+AHST)/2+VSToffset',
                Program_Line_18='endif',
                Program_Line_19='elseif ComfStand == 4 || ComfStand == 5 || ComfStand == 6',
                Program_Line_20='if (PMOT >= AHSTall) && (PMOT <= ACSTaul)',
                Program_Line_21='set VST = (ACST+AHST)/2+VSToffset',
                Program_Line_22='else',
                Program_Line_23='set VST = 0',
                Program_Line_24='endif',
                Program_Line_25='else',
                Program_Line_26='if (PMOT >= AHSTall) && (PMOT <= ACSTaul)',
                Program_Line_27='set VST = ComfTemp+VSToffset',
                Program_Line_28='else',
                Program_Line_29='set VST = (ACST+AHST)/2+VSToffset',
                Program_Line_30='endif',
                Program_Line_31='endif',
                Program_Line_32='elseif (VentCtrl == 1) || (VentCtrl==3)',
                Program_Line_33='set VST = AHST+VSToffset',
                Program_Line_34='endif',
            )
            if verboseMode:
                print('Added - SetVST Program')
        #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetVST'])

        for zonename in self.zonenames:
            if 'ApplyAST_'+zonename in programlist:
                if verboseMode:
                    print('Not added - ApplyAST_'+zonename+' Program')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Program',
                    Name='ApplyAST_'+zonename,
                    # todo if there is no cooling coil, then zonename_COOLCOIL sensor won't be added
                    #  and therefore it should be omitted in all ExistingHVAC EMS programs; same for _HEATCOIL

                    Program_Line_1='if ' + zonename + '_CoolCoil==0',
                    Program_Line_2='if ' + zonename + '_HeatCoil==0',
                    Program_Line_3='set NoH_NoC_reqs = 1',
                    Program_Line_4='else',
                    Program_Line_5='set NoH_NoC_reqs = 0',
                    Program_Line_6='endif',
                    Program_Line_7='else',
                    Program_Line_8='set NoH_NoC_reqs = 0',
                    Program_Line_9='endif',
                    Program_Line_10='if ' + zonename + '_OpT<ACST',
                    Program_Line_11='if ' + zonename + '_WindSpeed <= MaxWindSpeed',
                    Program_Line_12='if ' + zonename + '_OutT>MinOutTemp',
                    Program_Line_13='if ' + zonename + '_OutT < ' + zonename + '_OpT',
                    Program_Line_14='set meets_base_reqs = 1',
                    Program_Line_15='else',
                    Program_Line_16='set meets_base_reqs = 0',
                    Program_Line_17='endif',
                    Program_Line_18='else',
                    Program_Line_19='set meets_base_reqs = 0',
                    Program_Line_20='endif',
                    Program_Line_21='else',
                    Program_Line_22='set meets_base_reqs = 0',
                    Program_Line_23='endif',
                    Program_Line_24='else',
                    Program_Line_25='set meets_base_reqs = 0',
                    Program_Line_26='endif',
                    Program_Line_27='if (NoH_NoC_reqs == 1) && (meets_base_reqs == 1)',
                    Program_Line_28='if ' + zonename + '_OpT>VST',
                    Program_Line_29='set Ventilates_HVACmode2_' + zonename + ' = 1',
                    Program_Line_30='else',
                    Program_Line_31='set Ventilates_HVACmode2_' + zonename + ' = 0',
                    Program_Line_32='endif',
                    Program_Line_33='else',
                    Program_Line_34='set Ventilates_HVACmode2_' + zonename + ' = 0',
                    Program_Line_35='endif',
                    Program_Line_36='if VentCtrl == 0',
                    Program_Line_37='if ' + zonename + '_OutT < ' + zonename + '_OpT',
                    Program_Line_38='if ' + zonename + '_OutT>MinOutTemp',
                    Program_Line_39='if ' + zonename + '_OpT > VST',
                    Program_Line_40='if ' + zonename + '_WindSpeed <= MaxWindSpeed',
                    Program_Line_41='set Ventilates_HVACmode1_' + zonename + ' = 1',
                    Program_Line_42='else',
                    Program_Line_43='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_44='endif',
                    Program_Line_45='else',
                    Program_Line_46='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_47='endif',
                    Program_Line_48='else',
                    Program_Line_49='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_50='endif',
                    Program_Line_51='else',
                    Program_Line_52='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_53='endif',
                    Program_Line_54='elseif VentCtrl == 1',
                    Program_Line_55='if ' + zonename + '_OutT<' + zonename + '_OpT',
                    Program_Line_56='if ' + zonename + '_OutT>MinOutTemp',
                    Program_Line_57='if ' + zonename + '_OpT > ACSTnoTol',
                    Program_Line_58='if ' + zonename + '_WindSpeed <= MaxWindSpeed',
                    Program_Line_59='set Ventilates_HVACmode1_' + zonename + ' = 1',
                    Program_Line_60='else',
                    Program_Line_61='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_62='endif',
                    Program_Line_63='else',
                    Program_Line_64='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_65='endif',
                    Program_Line_66='else',
                    Program_Line_67='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_68='endif',
                    Program_Line_69='else',
                    Program_Line_70='set Ventilates_HVACmode1_' + zonename + ' = 0',
                    Program_Line_71='endif',
                    Program_Line_72='endif',
                    Program_Line_73='if HVACmode == 0',
                    Program_Line_74='set ACST_Act_' + zonename + ' = ACST',
                    Program_Line_75='set AHST_Act_' + zonename + ' = AHST',
                    Program_Line_76='elseif HVACmode == 1',
                    Program_Line_77='Set ACST_Act_' + zonename + ' = 100',
                    Program_Line_78='Set AHST_Act_' + zonename + ' = -100',
                    Program_Line_79='if Ventilates_HVACmode1_' + zonename + ' == 1',
                    Program_Line_80='set VentHours_' + zonename + ' = 1*ZoneTimeStep',
                    Program_Line_81='else',
                    Program_Line_82='set VentHours_' + zonename + ' = 0',
                    Program_Line_83='endif',
                    Program_Line_84='elseif HVACmode == 2',
                    Program_Line_85='if Ventilates_HVACmode2_' + zonename + ' == 1',
                    Program_Line_86='set VentHours_' + zonename + ' = 1*ZoneTimeStep',
                    Program_Line_87='elseif Ventilates_HVACmode2_' + zonename + ' == 0',
                    Program_Line_88='set VentHours_' + zonename + ' = 0',
                    Program_Line_89='set ACST_Act_' + zonename + ' = ACST',
                    Program_Line_90='set AHST_Act_' + zonename + ' = AHST',
                    Program_Line_91='endif',
                    Program_Line_92='endif',
                )
                if verboseMode:
                    print('Added - ApplyAST_'+zonename+' Program')
            #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'ApplyAST_'+windowname])

        for windowname in self.windownamelist:
            if 'SetMyVOF_'+windowname in programlist:
                if verboseMode:
                    print('Not added - SetMyVOF_'+windowname+' Program')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Program',
                    Name='SetMyVOF_'+windowname,
                    Program_Line_1='set slope = (1 - MultiplierVOF) / (MinTempDiffVOF - MaxTempDiffVOF)',
                    Program_Line_2='if ' + windowname + '_OutT > 0',
                    Program_Line_3='set ' + windowname + '_TempDiffVOF = ' + windowname + '_OpT - ' + windowname + '_OutT',
                    Program_Line_4='else',
                    Program_Line_5='set ' + windowname + '_TempDiffVOF = ' + windowname + '_OpT + ' + windowname + '_OutT',
                    Program_Line_6='endif',
                    Program_Line_7='if ' + windowname + '_OutT > ' + windowname + '_OpT',
                    Program_Line_8='set ' + windowname + '_MyVOF = 0',
                    Program_Line_9='else',
                    Program_Line_10='if ' + windowname + '_TempDiffVOF > MaxTempDiffVOF',
                    Program_Line_11='set ' + windowname + '_MyVOF = MultiplierVOF',
                    Program_Line_12='elseif ' + windowname + '_TempDiffVOF < MinTempDiffVOF',
                    Program_Line_13='set ' + windowname + '_MyVOF = 1.0',
                    Program_Line_14='else',
                    Program_Line_15='set ' + windowname + '_MyVOF = slope*' + windowname + '_TempDiffVOF - slope*MinTempDiffVOF + 1',
                    Program_Line_16='endif',
                    Program_Line_17='endif',
                )
                if verboseMode:
                    print('Added - SetMyVOF_'+windowname+' Program')
            #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetMyVOF_'+windowname])

            if 'SetWindowOperation_'+windowname in programlist:
                if verboseMode:
                    print('Not added - SetWindowOperation_'+windowname+' Program')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Program',
                    Name='SetWindowOperation_'+windowname,
                    # todo if there is no cooling coil, then zonename_COOLCOIL sensor won't be added
                    #  and therefore it should be omitted in all ExistingHVAC EMS programs; same for _HEATCOIL

                    Program_Line_1='if ' + windowname + '_CoolCoil==0',
                    Program_Line_2='if ' + windowname + '_HeatCoil==0',
                    Program_Line_3='set NoH_NoC_reqs = 1',
                    Program_Line_4='else',
                    Program_Line_5='set NoH_NoC_reqs = 0',
                    Program_Line_6='endif',
                    Program_Line_7='else',
                    Program_Line_8='set NoH_NoC_reqs = 0',
                    Program_Line_9='endif',
                    Program_Line_10='if ' + windowname + '_OpT<ACST',
                    Program_Line_11='if ' + windowname + '_WindSpeed <= MaxWindSpeed',
                    Program_Line_12='if ' + windowname + '_OutT>MinOutTemp',
                    Program_Line_13='if ' + windowname + '_OutT < ' + windowname + '_OpT',
                    Program_Line_14='set meets_base_reqs = 1',
                    Program_Line_15='else',
                    Program_Line_16='set meets_base_reqs = 0',
                    Program_Line_17='endif',
                    Program_Line_18='else',
                    Program_Line_19='set meets_base_reqs = 0',
                    Program_Line_20='endif',
                    Program_Line_21='else',
                    Program_Line_22='set meets_base_reqs = 0',
                    Program_Line_23='endif',
                    Program_Line_24='else',
                    Program_Line_25='set meets_base_reqs = 0',
                    Program_Line_26='endif',
                    Program_Line_27='if (NoH_NoC_reqs == 1) && (meets_base_reqs == 1)',
                    Program_Line_28='if ' + windowname + '_OpT>VST',
                    Program_Line_29='set Ventilates_HVACmode2_' + windowname + ' = 1',
                    Program_Line_30='else',
                    Program_Line_31='set Ventilates_HVACmode2_' + windowname + ' = 0',
                    Program_Line_32='endif',
                    Program_Line_33='else',
                    Program_Line_34='set Ventilates_HVACmode2_' + windowname + ' = 0',
                    Program_Line_35='endif',
                    Program_Line_36='if VentCtrl == 0',
                    Program_Line_37='if ' + windowname + '_OutT < ' + windowname + '_OpT',
                    Program_Line_38='if ' + windowname + '_OutT>MinOutTemp',
                    Program_Line_39='if ' + windowname + '_OpT > VST',
                    Program_Line_40='if ' + windowname + '_WindSpeed <= MaxWindSpeed',
                    Program_Line_41='set Ventilates_HVACmode1_' + windowname + ' = 1',
                    Program_Line_42='else',
                    Program_Line_43='set Ventilates_HVACmode1_' + windowname + ' = 0',
                    Program_Line_44='endif',
                    Program_Line_45='else',
                    Program_Line_46='set Ventilates_HVACmode1_' + windowname + ' = 0',
                    Program_Line_47='endif',
                    Program_Line_48='else',
                    Program_Line_49='set Ventilates_HVACmode1_' + windowname + ' = 0',
                    Program_Line_50='endif',
                    Program_Line_51='else',
                    Program_Line_52='set Ventilates_HVACmode1_' + windowname + ' = 0',
                    Program_Line_53='endif',
                    Program_Line_54='elseif VentCtrl == 1',
                    Program_Line_55='if ' + windowname + '_OutT<' + windowname + '_OpT',
                    Program_Line_56='if ' + windowname + '_OutT>MinOutTemp',
                    Program_Line_57='if ' + windowname + '_OpT > ACSTnoTol',
                    Program_Line_58='if ' + windowname + '_WindSpeed <= MaxWindSpeed',
                    Program_Line_59='set Ventilates_HVACmode1_' + windowname + ' = 1',
                    Program_Line_60='else',
                    Program_Line_61='set Ventilates_HVACmode1_' + windowname + ' = 0',
                    Program_Line_62='endif',
                    Program_Line_63='else',
                    Program_Line_64='set Ventilates_HVACmode1_' + windowname + ' = 0',
                    Program_Line_65='endif',
                    Program_Line_66='else',
                    Program_Line_67='set Ventilates_HVACmode1_' + windowname + ' = 0',
                    Program_Line_68='endif',
                    Program_Line_69='else',
                    Program_Line_70='set Ventilates_HVACmode1_' + windowname + ' = 0',
                    Program_Line_71='endif',
                    Program_Line_72='endif',
                    Program_Line_73='if HVACmode == 0',
                    Program_Line_74='set ' + windowname + '_VentOpenFact = 0',
                    Program_Line_75='elseif HVACmode == 1',
                    Program_Line_76='if Ventilates_HVACmode1_' + windowname + ' == 1',
                    Program_Line_77='set ' + windowname + '_VentOpenFact = ' + windowname + '_MyVOF',
                    Program_Line_78='else',
                    Program_Line_79='set ' + windowname + '_VentOpenFact = 0',
                    Program_Line_80='endif',
                    Program_Line_81='elseif HVACmode == 2',
                    Program_Line_82='if Ventilates_HVACmode2_' + windowname + ' == 1',
                    Program_Line_83='if (VentCtrl==0) || (VentCtrl==1)',
                    Program_Line_84='set ' + windowname + '_VentOpenFact = 1',
                    Program_Line_85='elseif (VentCtrl==2) || (VentCtrl==3)',
                    Program_Line_86='set ' + windowname + '_VentOpenFact = ' + windowname + '_MyVOF',
                    Program_Line_87='endif',
                    Program_Line_88='else',
                    Program_Line_89='set ' + windowname + '_VentOpenFact = 0',
                    Program_Line_90='endif',
                    Program_Line_91='endif',
                )
                if verboseMode:
                    print('Added - SetWindowOperation_'+windowname+' Program')
            #    print([program for program in self.idf1.idfobjects['EnergyManagementSystem:Program'] if program.Name == 'SetWindowOperation_'+windowname])
    elif ScriptType.lower() == 'ex_ac' or ScriptType.lower() == 'vrf_ac':
        for zonename in self.zonenames:
            if 'ApplyAST_'+zonename in programlist:
                if verboseMode:
                    print('Not added - ApplyAST_'+zonename+' Program')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Program',
                    Name='ApplyAST_'+zonename,
                    Program_Line_1='set ACST_Act_' + zonename + ' = ACST',
                    Program_Line_2='set AHST_Act_' + zonename + ' = AHST'
                    )

    del programlist


def addEMSPCMBase(self, verboseMode: bool = True):
    """
    Add EMS program calling managers for Base accim.

    Checks if some EMS program calling manager objects are already
    in the model, and otherwise adds them.
    """
    programlist = ([program.Name
                    for program
                    in self.idf1.idfobjects['EnergyManagementSystem:Program']])
    pcmlist = ([pcm.Name
                for pcm
                in self.idf1.idfobjects['EnergyManagementSystem:ProgramCallingManager']])

    for i in programlist:
        if i in pcmlist:
            if verboseMode:
                print('Not added - '+i+' Program Calling Manager')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:ProgramCallingManager',
                Name=i,
                EnergyPlus_Model_Calling_Point="BeginTimestepBeforePredictor",
                Program_Name_1=i
                )
            if verboseMode:
                print('Added - '+i+' Program Calling Manager')
    #        print([program for program in self.idf1.idfobjects['EnergyManagementSystem:ProgramCallingManager'] if program.Name == i])

    del programlist, pcmlist

# todo add argument for mm outputvariables
def addEMSOutputVariableBase(self, ScriptType: str = None, verboseMode: bool = True):
    """Add EMS output variables for Base accim.

    Checks if some EMS output variables objects are already
    in the model, and otherwise adds them.
    """
    EMSOutputVariableAvg_dict = {
        'Comfort Temperature': ['ComfTemp', 'C'],
        'Adaptive Cooling Setpoint Temperature': ['ACST', 'C'],
        'Adaptive Heating Setpoint Temperature': ['AHST', 'C'],
        'Adaptive Cooling Setpoint Temperature_No Tolerance': ['ACSTnoTol', 'C'],
        'Adaptive Heating Setpoint Temperature_No Tolerance': ['AHSTnoTol', 'C'],
    }
    EMSOutputVariableAvgMM_dict = {
        'Ventilation Setpoint Temperature': ['VST', 'C'],
        'Minimum Outdoor Temperature for ventilation': ['MinOutTemp', 'C'],
        'Minimum Outdoor Temperature Difference for ventilation': ['MinTempDiffVOF', 'C'],
        'Maximum Outdoor Temperature Difference for ventilation': ['MaxTempDiffVOF', 'C'],
        'Multiplier for Ventilation Opening Factor': ['MultiplierVOF', ''],
    }
    if ScriptType.lower() == 'vrf_mm' or ScriptType.lower() == 'ex_mm':
        EMSOutputVariableAvg_dict.update(EMSOutputVariableAvgMM_dict)

    outputvariablelist = ([outvar.Name
                           for outvar
                           in self.idf1.idfobjects['EnergyManagementSystem:OutputVariable']])

    for i in EMSOutputVariableAvg_dict:
        if i in outputvariablelist:
            if verboseMode:
                print('Not added - '+i+' Output Variable')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:OutputVariable',
                Name=i,
                EMS_Variable_Name=EMSOutputVariableAvg_dict[i][0],
                Type_of_Data_in_Variable='Averaged',
                Update_Frequency='ZoneTimestep',
                EMS_Program_or_Subroutine_Name='',
                Units=EMSOutputVariableAvg_dict[i][1]
                )
            if verboseMode:
                print('Added - '+i+' Output Variable')
            # print([outputvariable for outputvariable in self.idf1.idfobjects['EnergyManagementSystem:OutputVariable'] if outputvariable.Name == i])

    EMSOutputVariableZone_dict = {
        'Comfortable Hours_No Applicability': ['ComfHoursNoApp', 'H', 'Summed'],
        'Comfortable Hours_Applicability': ['ComfHours', 'H', 'Summed'],
        'Discomfortable Applicable Hot Hours': ['DiscomfAppHotHours', 'H', 'Summed'],
        'Discomfortable Applicable Cold Hours': ['DiscomfAppColdHours', 'H', 'Summed'],
        'Discomfortable Non Applicable Hot Hours': ['DiscomfNonAppHotHours', 'H', 'Summed'],
        'Discomfortable Non Applicable Cold Hours': ['DiscomfNonAppColdHours', 'H', 'Summed'],
        'Zone Floor Area': ['ZoneFloorArea', 'm2', 'Averaged'],
        'Zone Air Volume': ['ZoneAirVolume', 'm3', 'Averaged'],
    }

    for i in EMSOutputVariableZone_dict:
        for zonename in self.occupiedZones:
            if i+'_'+zonename in outputvariablelist:
                if verboseMode:
                    print('Not added - '+i+'_'
                          + zonename + ' Output Variable')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:OutputVariable',
                    Name=i + '_' + zonename,
                    EMS_Variable_Name=EMSOutputVariableZone_dict[i][0]+'_'
                    + zonename,
                    Type_of_Data_in_Variable=EMSOutputVariableZone_dict[i][2],
                    Update_Frequency='ZoneTimestep',
                    EMS_Program_or_Subroutine_Name='',
                    Units=EMSOutputVariableZone_dict[i][1]
                    )
                if verboseMode:
                    print('Added - '+i+'_'
                          + zonename + ' Output Variable')
                # print([outputvariable for outputvariable in self.idf1.idfobjects['EnergyManagementSystem:OutputVariable'] if outputvariable.Name == i+'_'+zonename'])

    if ScriptType.lower() == 'vrf_mm' or ScriptType.lower() == 'ex_mm':
        EMSOutputVariableIDFzones_dict = {
            'Ventilation Hours': 'VentHours'
            }

        for i in EMSOutputVariableIDFzones_dict:
            for zonename in self.zonenames:
                if i+'_'+zonename in outputvariablelist:
                    if verboseMode:
                        print('Not added - '+i+'_'
                              + zonename + ' Output Variable')
                else:
                    self.idf1.newidfobject(
                        'EnergyManagementSystem:OutputVariable',
                        Name=i + '_' + zonename,
                        EMS_Variable_Name=EMSOutputVariableIDFzones_dict[i]+'_'
                        + zonename,
                        Type_of_Data_in_Variable='Summed',
                        Update_Frequency='ZoneTimestep',
                        EMS_Program_or_Subroutine_Name='',
                        Units='H'
                        )
                    if verboseMode:
                        print('Added - '+i+'_'
                              + zonename + ' Output Variable')
                    # print([outputvariable for outputvariable in self.idf1.idfobjects['EnergyManagementSystem:OutputVariable'] if outputvariable.Name == i+'_'+zonename'])

    del outputvariablelist


def addGlobVarList(self, ScriptType: str = None, verboseMode: bool = True):
    """Remove existing Global Variable objects and add correct Global Variable objects for accim."""
    globalvariablelist = ([program for program in self.idf1.idfobjects['ENERGYMANAGEMENTSYSTEM:GLOBALVARIABLE']])

    for i in range(len(globalvariablelist)):
        firstglobalvariablelist = self.idf1.idfobjects['ENERGYMANAGEMENTSYSTEM:GLOBALVARIABLE'][-1]
        self.idf1.removeidfobject(firstglobalvariablelist)

    del globalvariablelist

    self.idf1.newidfobject(
        'EnergyManagementSystem:GlobalVariable',
        Erl_Variable_1_Name='ACST',
        Erl_Variable_2_Name='AHST',
        Erl_Variable_3_Name='ACSTnoTol',
        Erl_Variable_4_Name='AHSTnoTol',
        Erl_Variable_5_Name='ComfStand',
        Erl_Variable_6_Name='ACSTaul',
        Erl_Variable_7_Name='ACSTall',
        Erl_Variable_8_Name='AHSTaul',
        Erl_Variable_9_Name='AHSTall',
        Erl_Variable_10_Name='CAT',
        Erl_Variable_11_Name='ACSToffset',
        Erl_Variable_12_Name='AHSToffset',
        Erl_Variable_13_Name='ComfMod',
        Erl_Variable_14_Name='ComfTemp',
        Erl_Variable_15_Name='ACSTtol',
        Erl_Variable_16_Name='AHSTtol',
    )
    for zonename in self.occupiedZones:
        self.idf1.newidfobject(
            'EnergyManagementSystem:GlobalVariable',
            Erl_Variable_1_Name='ComfHours_'+zonename,
            Erl_Variable_2_Name='DiscomfAppHotHours_'+zonename,
            Erl_Variable_3_Name='DiscomfAppColdHours_'+zonename,
            Erl_Variable_4_Name='DiscomfNonAppHotHours_'+zonename,
            Erl_Variable_5_Name='DiscomfNonAppColdHours_'+zonename,
            Erl_Variable_6_Name='ComfHoursNoApp_'+zonename,
            Erl_Variable_7_Name='ZoneFloorArea_' + zonename,
            Erl_Variable_8_Name='ZoneAirVolume_' + zonename

        )

    if ScriptType.lower() == 'vrf_mm' or ScriptType.lower() == 'ex_mm':
        self.idf1.newidfobject(
            'EnergyManagementSystem:GlobalVariable',
            Erl_Variable_1_Name='VST',
            Erl_Variable_2_Name='VSToffset',
            Erl_Variable_3_Name='MaxWindSpeed',
            Erl_Variable_4_Name='VentCtrl',
            Erl_Variable_5_Name='HVACmode',
            Erl_Variable_6_Name='MinOutTemp',
            Erl_Variable_7_Name='MinOToffset',
            Erl_Variable_8_Name='MaxTempDiffVOF',
            Erl_Variable_9_Name='MinTempDiffVOF',
            Erl_Variable_10_Name='MultiplierVOF',

            )
        for zonename in self.zonenames:
            self.idf1.newidfobject(
                'EnergyManagementSystem:GlobalVariable',
                Erl_Variable_1_Name='VentHours_' + zonename
            )
        for windowname in self.windownamelist:
            self.idf1.newidfobject(
                'EnergyManagementSystem:GlobalVariable',
                Erl_Variable_1_Name=windowname + '_MyVOF'
            )


    if verboseMode:
        print("Global variables objects have been added")

def addIntVarList(self, verboseMode: bool = True):
    """Add Internal variables objects for accim."""
    internalvariablelist = ([program for program in self.idf1.idfobjects['ENERGYMANAGEMENTSYSTEM:INTERNALVARIABLE']])

    for i in range(len(internalvariablelist)):
        firstinternalvariablelist = self.idf1.idfobjects['ENERGYMANAGEMENTSYSTEM:INTERNALVARIABLE'][-1]
        self.idf1.removeidfobject(firstinternalvariablelist)

    del internalvariablelist

    intvardict = {
        'ZFA_': 'Zone Floor Area',
        'ZAV_': 'Zone Air Volume'
    }

    for i in range(len(self.zonenames)):
        for j in intvardict:
            self.idf1.newidfobject(
                'EnergyManagementSystem:InternalVariable',
                Name=j+self.zonenames[i],
                Internal_Data_Index_Key_Name=self.zonenames_orig[i],
                Internal_Data_Type=intvardict[j]
            )
    if verboseMode:
        print("Internal variables objects have been added")

def removeExistingOutputVariables(
        self,
):
    """Remove existing Output:Variable objects for accim."""
    EnvironmentalImpactFactorslist = ([output for output in self.idf1.idfobjects['Output:EnvironmentalImpactFactors']])
    outputmeterlist = ([output for output in self.idf1.idfobjects['Output:Meter']])
    alloutputs = ([output for output in self.idf1.idfobjects['Output:Variable']])

    for i in range(len(EnvironmentalImpactFactorslist)):
        firstEnvironmentalImpactFactor = self.idf1.idfobjects['Output:EnvironmentalImpactFactors'][-1]
        self.idf1.removeidfobject(firstEnvironmentalImpactFactor)
    for i in range(len(outputmeterlist)):
        firstoutputmeter = self.idf1.idfobjects['Output:Meter'][-1]
        self.idf1.removeidfobject(firstoutputmeter)
    for i in range(len(alloutputs)):
        firstoutput = self.idf1.idfobjects['Output:Variable'][-1]
        self.idf1.removeidfobject(firstoutput)

    del EnvironmentalImpactFactorslist, outputmeterlist, alloutputs, \
        # firstEnvironmentalImpactFactor, firstoutputmeter, firstoutput

def removeDuplicatedOutputVariables(
        self,
):
    """Remove duplicated Output:Variable objects for accim."""
    for freq in ['Timestep', 'Hourly', 'Daily', 'Monthly', 'Runperiod']:
        alloutputs = (
            [
                output
                for output
                in self.idf1.idfobjects['Output:Variable']
                if freq == output.Reporting_Frequency
            ]
        )
        unique_list = []
        duplicated_list = []
        for i in alloutputs:
            if i.Variable_Name not in unique_list:
                unique_list.append(i)
            else:
                duplicated_list.append(i)
        for j in range(len(duplicated_list)):
            firstoutput = self.idf1.idfobjects['Output:Variable'][-1]
            self.idf1.removeidfobject(firstoutput)
    # del alloutputs, firstoutput, unique_list, duplicated_list


def addOutputVariablesSimplified(
        self,
        Outputs_freq: any = None,
        TempCtrl: str = None,
        verboseMode: bool = True
):
    """
    Add simplified Output:Variable objects for accim.

    Remove all outputs and add only VFR outdoor unit consumption
    and operative temperature.
    """

    additionaloutputs = [
        # 'Zone Thermostat Operative Temperature',
        'Zone Operative Temperature',
        'Cooling Coil Total Cooling Rate',
        'Heating Coil Heating Rate',
    ]

    if TempCtrl.lower() == 'pmv':
        additionaloutputs.extend([
            'Zone Thermal Comfort Fanger Model PMV',
            'Zone Thermal Comfort Fanger Model PPD'
        ])

    for freq in Outputs_freq:
        for addittionaloutput in additionaloutputs:
            self.idf1.newidfobject(
                'Output:Variable',
                Key_Value='*',
                Variable_Name=addittionaloutput,
                Reporting_Frequency=freq.capitalize(),
                Schedule_Name=''
                )
            if verboseMode:
                print('Added - '+addittionaloutput+' Output:Variable data')

    del additionaloutputs


def addOutputVariablesStandard(
        self,
        Outputs_freq: any = None,
        ScriptType: str = None,
        TempCtrl: str = None,
        verboseMode: bool = True):
    """Add Output:Variable objects for accim."""

    EMSoutputvariablenamelist = ([outputvariable.Name
                           for outputvariable
                           in self.idf1.idfobjects['EnergyManagementSystem:OutputVariable']])
    addittionaloutputs = [
        # 'Zone Thermostat Operative Temperature',
        'Zone Operative Temperature',
        'Zone Thermal Comfort CEN 15251 Adaptive Model Running Average Outdoor Air Temperature',
        'Zone Thermal Comfort ASHRAE 55 Adaptive Model Running Average Outdoor Air Temperature',
        'Cooling Coil Total Cooling Rate',
        'Heating Coil Heating Rate',
        'Facility Total HVAC Electric Demand Power',
        'Facility Total HVAC Electricity Demand Rate',
        # todo maybe create a new output type to include this variable, to be used in case of tests
        'AFN Surface Venting Window or Door Opening Factor',
        'AFN Zone Infiltration Air Change Rate',
        'AFN Zone Infiltration Volume',
        'AFN Zone Ventilation Air Change Rate',
        'AFN Zone Ventilation Volume',
    ]
    if TempCtrl.lower() == 'pmv':
        addittionaloutputs.extend([
            'Zone Thermal Comfort Fanger Model PMV',
            'Zone Thermal Comfort Fanger Model PPD'
        ])

    for freq in Outputs_freq:
        outputnamelist = (
            [
                output.Variable_Name
                for output
                in self.idf1.idfobjects['Output:Variable']
                if output.Reporting_Frequency == freq.capitalize()
            ]
        )
        for outputvariable in EMSoutputvariablenamelist:
            if outputvariable in outputnamelist:
                if verboseMode:
                    print('Not added - '+outputvariable+' Reporting Frequency'+freq.capitalize()+' Output:Variable data')
            elif outputvariable.startswith("WIP"):
                if verboseMode:
                    print('Not added - '+outputvariable+' Output:Variable data because its WIP')
            elif outputvariable.startswith('Adaptive Thermal Comfort Cost Index'):
                if verboseMode:
                    print('Not added - '+outputvariable+' Output:Variable data because its ATCCI')
            else:
                self.idf1.newidfobject(
                    'Output:Variable',
                    Key_Value='*',
                    Variable_Name=outputvariable,
                    Reporting_Frequency=freq.capitalize(),
                    Schedule_Name=''
                    )
                if verboseMode:
                    print('Added - '+outputvariable+' Reporting Frequency'+freq.capitalize()+' Output:Variable data')
        #        print([output for output in self.idf1.idfobjects['Output:Variable'] if output.Variable_Name == outputvariable])

        for addittionaloutput in addittionaloutputs:
            if addittionaloutput in outputnamelist:
                if verboseMode:
                    print('Not added - '+addittionaloutput+' Reporting Frequency'+freq.capitalize()+' Output:Variable data')
            else:
                self.idf1.newidfobject(
                    'Output:Variable',
                    Key_Value='*',
                    Variable_Name=addittionaloutput,
                    Reporting_Frequency=freq.capitalize(),
                    Schedule_Name=''
                    )
                if verboseMode:
                    print('Added - '+addittionaloutput+' Reporting Frequency'+freq.capitalize()+' Output:Variable data')

        outputlist = (
            [
                output
                for output
                in self.idf1.idfobjects['Output:Variable']
                if output.Reporting_Frequency == freq.capitalize()
            ]
        )
        for i in outputlist:
            for addittionaloutput in addittionaloutputs:
                if addittionaloutput in i.Variable_Name:
                    i.Schedule_Name = ''

        siteAddOutputs = [
            'Site Outdoor Air Drybulb Temperature',
            'Site Wind Speed',
            'Site Outdoor Air Relative Humidity'
        ]

        # other_site_outputs = [
        #     'Site Outdoor Air Drybulb Temperature [C]',
        #     'Site Outdoor Air Dewpoint Temperature [C]',
        #     'Site Outdoor Air Wetbulb Temperature [C]',
        #     'Site Outdoor Air Humidity Ratio [kgWater/kgAir]',
        #     'Site Outdoor Air Relative Humidity [%]',
        #     'Site Outdoor Air Barometric Pressure [Pa]',
        #     'Site Wind Speed [m/s]',
        #     'Site Wind Direction [deg]',
        #     'Site Sky Temperature [C]',
        #     'Site Horizontal Infrared Radiation Rate per Area [W/m2]',
        #     'Site Difuse Solar Radiation Rate per Area [W/m2]',
        #     'Site Direct Solar Radiation Rate per Area [W/m2]',
        #     'Site Total Sky Cover []',
        #     'Site Opaque Sky Cover []',
        #     'Site Precipitation Depth [m]',
        #     'Site Ground Refected Solar Radiation Rate per Area [W/m2]',
        #     'Site Ground Temperature [C]',
        #     'Site Surface Ground Temperature [C]',
        #     'Site Deep Ground Temperature [C]',
        #     'Site Simple Factor Model Ground Temperature [C]',
        #     'Site Outdoor Air Enthalpy [J/kg]',
        #     'Site Outdoor Air Density [kg/m3]',
        #     'Site Solar Azimuth Angle [deg]',
        #     'Site Solar Altitude Angle [deg]',
        #     'Site Solar Hour Angle [deg]',
        #     'Site Rain Status []',
        #     'Site Snow on Ground Status []',
        #     'Site Exterior Horizontal Sky Illuminance [lux]',
        #     'Site Exterior Horizontal Beam Illuminance [lux]',
        #     'Site Exterior Beam Normal Illuminance [lux]',
        #     'Site Sky Difuse Solar Radiation Luminous Eﬀcacy [lum/W]',
        #     'Site Beam Solar Radiation Luminous Eﬀcacy [lum/W]',
        #     'Site Daylighting Model Sky Clearness []',
        #     'Sky Brightness for Daylighting Calculation []',
        #     'Site Daylight Saving Time Status []',
        #     'Site Day Type Index []',
        #     'Site Mains Water Temperature [C]',
        # ]

        for addittionaloutput in siteAddOutputs:
            if addittionaloutput in outputnamelist:
                if verboseMode:
                    print('Not added - '+addittionaloutput+' Reporting Frequency'+freq.capitalize()+' Output:Variable data')
            else:
                self.idf1.newidfobject(
                    'Output:Variable',
                    Key_Value='Environment',
                    Variable_Name=addittionaloutput,
                    Reporting_Frequency=freq.capitalize(),
                    Schedule_Name=''
                    )
                if verboseMode:
                    print('Added - '+addittionaloutput+' Reporting Frequency'+freq.capitalize()+' Output:Variable data')

        for zonename in self.zonenames:
            self.idf1.newidfobject(
                'Output:Variable',
                Key_Value='AHST_Sch_'+zonename,
                Variable_Name='Schedule Value',
                Reporting_Frequency=freq.capitalize(),
                Schedule_Name=''
                )
            if verboseMode:
                print('Added - AHST_Sch_'+zonename+' Reporting Frequency'+freq.capitalize()+' Output:Variable data')

            self.idf1.newidfobject(
                'Output:Variable',
                Key_Value='ACST_Sch_'+zonename,
                Variable_Name='Schedule Value',
                Reporting_Frequency=freq.capitalize(),
                Schedule_Name=''
                )
            if verboseMode:
                print('Added - ACST_Sch_'+zonename+' Reporting Frequency'+freq.capitalize()+' Output:Variable data')

        # for zonename in self.zonenames_orig:
        #     self.idf1.newidfobject(
        #         'Output:Variable',
        #         Key_Value=zonename,
        #         Variable_Name='Zone Operative Temperature',
        #         Reporting_Frequency=freq.capitalize(),
        #         Schedule_Name=''
        #         )
        #     if verboseMode:
        #         print('Added - '+zonename+' Reporting Frequency'+freq.capitalize()+' Zone Operative Temperature Output:Variable data')

        if 'vrf' in ScriptType.lower():
            VRFoutputs = [
                'VRF Heat Pump Cooling Electricity Energy',
                'VRF Heat Pump Heating Electricity Energy',
            ]

            for addittionaloutput in VRFoutputs:
                self.idf1.newidfobject(
                    'Output:Variable',
                    Key_Value='*',
                    Variable_Name=addittionaloutput,
                    Reporting_Frequency=freq.capitalize(),
                    Schedule_Name=''
                )
                if verboseMode:
                    print('Added - ' + addittionaloutput +' Reporting Frequency'+freq.capitalize() + ' Output:Variable data')

            for zonename in self.zonenames:
                self.idf1.newidfobject(
                    'Output:Variable',
                    Key_Value=zonename + ' VRF Indoor Unit DX Cooling Coil',
                    Variable_Name='Cooling Coil Total Cooling Rate',
                    Reporting_Frequency=freq.capitalize(),
                    Schedule_Name=''
                )
                if verboseMode:
                    print('Added - ' + zonename + ' VRF Indoor Unit DX Cooling Coil'+' Reporting Frequency'+freq.capitalize() + ' Output:Variable data')

                self.idf1.newidfobject(
                    'Output:Variable',
                    Key_Value=zonename + ' VRF Indoor Unit DX Heating Coil',
                    Variable_Name='Heating Coil Heating Rate',
                    Reporting_Frequency=freq.capitalize(),
                    Schedule_Name=''
                )
                if verboseMode:
                    print('Added - ' + zonename + ' VRF Indoor Unit DX Heating Coil'+' Reporting Frequency'+freq.capitalize()+' Output:Variable data')

    del EMSoutputvariablenamelist, outputnamelist, addittionaloutputs,


def addOutputVariablesDetailed(
        self,
        Outputs_freq: any = None,
        verboseMode: bool = True):
    """Add Output:Variable objects for accim."""

    addittionaloutputs = [
        'AFN Surface Venting Window or Door Opening Factor',
    ]

    for freq in Outputs_freq:
        outputnamelist = (
            [
                output.Variable_Name
                for output
                in self.idf1.idfobjects['Output:Variable']
                if output.Reporting_Frequency == freq.capitalize()
            ]
        )

        for addittionaloutput in addittionaloutputs:
            if addittionaloutput in outputnamelist:
                if verboseMode:
                    print('Not added - '+addittionaloutput+' Reporting Frequency'+freq.capitalize()+' Output:Variable data')
            else:
                self.idf1.newidfobject(
                    'Output:Variable',
                    Key_Value='*',
                    Variable_Name=addittionaloutput,
                    Reporting_Frequency=freq.capitalize(),
                    Schedule_Name=''
                    )
                if verboseMode:
                    print('Added - '+addittionaloutput+' Reporting Frequency'+freq.capitalize()+' Output:Variable data')

def addEMSSensorsBase(self, ScriptType: str = None, verboseMode: bool = True):
    """Add EMS sensors for accim."""
    sensorlist = ([sensor.Name for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor']])

    if len([i.Name for i in self.idf1.idfobjects['zonelist']]) > 0:
        ppl_key_name = self.occupiedZones_orig[0] + ' People'
    else:
        ppl_key_name = [i for i in self.idf1.idfobjects['PEOPLE']][0].Name

    # spacelist = [i for i in self.idf1.idfobjects['spacelist']]

    if 'RMOT' in sensorlist:
        if verboseMode:
            print('Not added - RMOT Sensor')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Sensor',
            Name='RMOT',
            OutputVariable_or_OutputMeter_Index_Key_Name=ppl_key_name,
            OutputVariable_or_OutputMeter_Name='Zone Thermal Comfort CEN 15251 Adaptive Model Running Average Outdoor Air Temperature'
            )
        if verboseMode:
            print('Added - RMOT Sensor')
    #    print([sensor for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor'] if sensor.Name=='RMOT'])

    if 'PMOT' in sensorlist:
        if verboseMode:
            print('Not added - PMOT Sensor')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Sensor',
            Name='PMOT',
            OutputVariable_or_OutputMeter_Index_Key_Name=ppl_key_name,
            OutputVariable_or_OutputMeter_Name='Zone Thermal Comfort ASHRAE 55 Adaptive Model Running Average Outdoor Air Temperature'
            )
        if verboseMode:
            print('Added - PMOT Sensor')
    #    print([sensor for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor'] if sensor.Name=='PMOT'])

    for i in range(len(self.zonenames)):
        if self.zonenames[i]+'_OpT' in sensorlist:
            if verboseMode:
                print('Not added - '+self.zonenames[i]+'_OpT Sensor')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Sensor',
                Name=self.zonenames[i]+'_OpT',
                OutputVariable_or_OutputMeter_Index_Key_Name=self.zonenames_orig[i],
                OutputVariable_or_OutputMeter_Name='Zone Operative Temperature'
                )
            if verboseMode:
                print('Added - '+self.zonenames[i]+'_OpT Sensor')
    #        print([sensor for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor'] if sensor.Name==self.zonenames[i]+'_OpT'])
        if ScriptType.lower() == 'vrf_mm' or ScriptType.lower() == 'ex_mm':
            if self.zonenames[i]+'_WindSpeed' in sensorlist:
                if verboseMode:
                    print('Not added - '+self.zonenames[i]+'_WindSpeed Sensor')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Sensor',
                    Name=self.zonenames[i]+'_WindSpeed',
                    OutputVariable_or_OutputMeter_Index_Key_Name=self.zonenames_orig[i],
                    OutputVariable_or_OutputMeter_Name='Zone Outdoor Air Wind Speed'
                    )
                if verboseMode:
                    print('Added - '+self.zonenames[i]+'_WindSpeed Sensor')
        #        print([sensor for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor'] if sensor.Name==self.zonenames[i]+'_WindSpeed'])
            if self.zonenames[i]+'_OutT' in sensorlist:
                if verboseMode:
                    print('Not added - '+self.zonenames[i]+'_OutT Sensor')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Sensor',
                    Name=self.zonenames[i]+'_OutT',
                    OutputVariable_or_OutputMeter_Index_Key_Name=self.zonenames_orig[i],
                    OutputVariable_or_OutputMeter_Name='Zone Outdoor Air Drybulb Temperature'
                    )
                if verboseMode:
                    print('Added - '+self.zonenames[i]+'_OutT Sensor')
        #        print([sensor for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor'] if sensor.Name==self.zonenames[i]+'_OutT']

    if ScriptType.lower() == 'vrf_mm' or ScriptType.lower() == 'ex_mm':
        for i in range(len(self.windownamelist)):
            if self.windownamelist[i]+'_OpT' in sensorlist:
                if verboseMode:
                    print('Not added - '+self.windownamelist[i]+'_OpT Sensor')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Sensor',
                    Name=self.windownamelist[i]+'_OpT',
                    OutputVariable_or_OutputMeter_Index_Key_Name=self.windownamelist_orig_split[i][0],
                    OutputVariable_or_OutputMeter_Name='Zone Operative Temperature'
                )
                if verboseMode:
                    print('Added - '+self.windownamelist[i]+'_OpT Sensor')

            if self.windownamelist[i]+'_WindSpeed' in sensorlist:
                if verboseMode:
                    print('Not added - '+self.windownamelist[i]+'_WindSpeed Sensor')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Sensor',
                    Name=self.windownamelist[i]+'_WindSpeed',
                    OutputVariable_or_OutputMeter_Index_Key_Name=self.windownamelist_orig_split[i][0],
                    OutputVariable_or_OutputMeter_Name='Zone Outdoor Air Wind Speed'
                    )
                if verboseMode:
                    print('Added - '+self.windownamelist[i]+'_WindSpeed Sensor')

            if self.windownamelist[i]+'_OutT' in sensorlist:
                if verboseMode:
                    print('Not added - '+self.windownamelist[i]+'_WindSpeed Sensor')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Sensor',
                    Name=self.windownamelist[i]+'_OutT',
                    OutputVariable_or_OutputMeter_Index_Key_Name=self.windownamelist_orig_split[i][0],
                    OutputVariable_or_OutputMeter_Name='Zone Outdoor Air Drybulb Temperature'
                    )
                if verboseMode:
                    print('Added - '+self.windownamelist[i]+'_OutT Sensor')

    if 'OutT' in sensorlist:
        if verboseMode:
            print('Not added - OutT Sensor')
    else:
        self.idf1.newidfobject(
            'EnergyManagementSystem:Sensor',
            Name='OutT',
            OutputVariable_or_OutputMeter_Index_Key_Name='Environment',
            OutputVariable_or_OutputMeter_Name='Site Outdoor Air Drybulb Temperature'
            )
        if verboseMode:
            print('Added - OutT Sensor')

    # if 'HVACConsump' in sensorlist:
    #     print('Not added - HVACConsump Sensor')
    # else:
    #     self.idf1.newidfobject(
    #         'EnergyManagementSystem:Sensor',
    #         Name='HVACConsump',
    #         OutputVariable_or_OutputMeter_Index_Key_Name='Whole Building',
    #         OutputVariable_or_OutputMeter_Name='Facility Total HVAC Electric Demand Power'
    #         )
    #     print('Added - HVACConsump Sensor')
    #     print([sensor for sensor in self.idf1.idfobjects['EnergyManagementSystem:Sensor'] if sensor.Name=='HVACConsump'])


    del sensorlist


def addEMSActuatorsBase(self, ScriptType: str = None, verboseMode: bool = True):
    """Add EMS actuators for accim."""
    actuatorlist = ([actuator.Name for actuator in self.idf1.idfobjects['EnergyManagementSystem:Actuator']])

    for zonename in self.zonenames:
        if 'AHST_Act_'+zonename in actuatorlist:
            if verboseMode:
                print('Not added - AHST_Act_'+zonename+' Actuator')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Actuator',
                Name='AHST_Act_'+zonename,
                Actuated_Component_Unique_Name='AHST_Sch_'+zonename,
                Actuated_Component_Type='Schedule:Compact',
                Actuated_Component_Control_Type='Schedule Value'
                )
            if verboseMode:
                print('Added - AHST_Act_'+zonename+' Actuator')
        #    print([actuator for actuator in self.idf1.idfobjects['EnergyManagementSystem:Actuator'] if actuator.Name=='AHST_Act_'+zonename])

        if 'ACST_Act_'+zonename in actuatorlist:
            if verboseMode:
                print('Not added - ACST_Act_'+zonename+' Actuator')
        else:
            self.idf1.newidfobject(
                'EnergyManagementSystem:Actuator',
                Name='ACST_Act_'+zonename,
                Actuated_Component_Unique_Name='ACST_Sch_'+zonename,
                Actuated_Component_Type='Schedule:Compact',
                Actuated_Component_Control_Type='Schedule Value'
                )
            if verboseMode:
                print('Added - ACST_Act_'+zonename+' Actuator')
        #    print([actuator for actuator in self.idf1.idfobjects['EnergyManagementSystem:Actuator'] if actuator.Name=='ACST_Act_'+zonename])

    if ScriptType.lower() == 'vrf_mm' or ScriptType.lower() == 'ex_mm':
        for i in range(len(self.windownamelist)):
            if self.windownamelist[i]+'_VentOpenFact' in actuatorlist:
                if verboseMode:
                    print('Not added - '+self.windownamelist[i]+'_OpT Actuator')
            else:
                self.idf1.newidfobject(
                    'EnergyManagementSystem:Actuator',
                    Name=self.windownamelist[i]+'_VentOpenFact',
                    Actuated_Component_Unique_Name=self.windownamelist_orig[i],
                    Actuated_Component_Type='AirFlow Network Window/Door Opening',
                    Actuated_Component_Control_Type='Venting Opening Factor'
                    )
                if verboseMode:
                    print('Added - '+self.windownamelist[i]+'_VentOpenFact Actuator')
    del actuatorlist


