<?xml version="1.0"?>
<VOTABLE version="1.1" xsi:schemaLocation="http://www.ivoa.net/xml/VOTable/v1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
  <INFO name="QUERY_STATUS" value="OK"/>
  <RESOURCE type="results">
    <TABLE utype="photdm:PhotometryFilter.transmissionCurve.spectrum">
    <PARAM name="FilterProfileService" value="ivo://svo/fps" ucd="meta.ref.ivorn" utype="PhotometryFilter.fpsIdentifier" datatype="char" arraysize="*"/>
    <PARAM name="filterID" value="CFHT/Wircam.Y" ucd="meta.id" utype="photdm:PhotometryFilter.identifier" datatype="char" arraysize="*"/>
    <PARAM name="WavelengthUnit" value="Angstrom" ucd="meta.unit" utype="PhotometryFilter.SpectralAxis.unit" datatype="char" arraysize="*"/>
    <PARAM name="WavelengthUCD" value="em.wl" ucd="meta.ucd" utype="PhotometryFilter.SpectralAxis.UCD" datatype="char" arraysize="*"/>
    <PARAM name="Description" value="Wircam Y" ucd="meta.note" utype="photdm:PhotometryFilter.description" datatype="char" arraysize="*"/>
    <PARAM name="PhotSystem" value="Wircam" utype="photdm:PhotometricSystem.description" datatype="char" arraysize="*">
       <DESCRIPTION>Photometric system</DESCRIPTION>
    </PARAM>
    <PARAM name="Instrument" value="Wircam" ucd="instr" datatype="char" arraysize="*">
       <DESCRIPTION>Instrument</DESCRIPTION>
    </PARAM>
    <PARAM name="Facility" value="CFHT" ucd="instr.obsty" datatype="char" arraysize="*">
       <DESCRIPTION>Observational facility</DESCRIPTION>
    </PARAM>
    <PARAM name="ProfileReference" value="http://cfht.hawaii.edu/Instruments/Filters/wircam.html" datatype="char" arraysize="*"/>
    <PARAM name="Description" value="Wircam Y" ucd="meta.note" utype="photdm:PhotometryFilter.description" datatype="char" arraysize="*"/>
    <PARAM name="WavelengthMean" value="10258.797618" unit="Angstrom" ucd="em.wl" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Location.Value" datatype="float" >
       <DESCRIPTION>Mean wavelength. Defined as integ[x*filter(x) dx]/integ[filter(x) dx]</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthEff" value="10221.2555307" unit="Angstrom" ucd="em.wl.effective" datatype="float" >
       <DESCRIPTION>Effective wavelength. Defined as integ[x*filter(x)*vega(x) dx]/integ[filter(x)*vega(x) dx]</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthMin" value="9386" unit="Angstrom" ucd="em.wl;stat.min" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Bounds.Start" datatype="float" >
       <DESCRIPTION>Minimum filter wavelength. Defined as the first lambda value with a transmission at least 1% of maximum transmission</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthMax" value="11134" unit="Angstrom" ucd="em.wl;stat.max" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Bounds.Stop" datatype="float" >
       <DESCRIPTION>Maximum filter wavelength. Defined as the last lambda value with a transmission at least 1% of maximum transmission</DESCRIPTION>
    </PARAM>
    <PARAM name="WidthEff" value="1084.17063834" unit="Angstrom" ucd="instr.bandwidth" utype="photdm:PhotometryFilter.SpectralAxis.Coverage.Bounds.Extent" datatype="float" >
       <DESCRIPTION>Effective width. Defined as integ[x*filter(x) dx].\nEquivalent to the horizontal size of a rectangle with height equal to maximum transmission and with the same area that the one covered by the filter transmission curve.</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthCen" value="10253.5056354" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Central wavelength. Defined as the central wavelength between the two points defining FWMH</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthPivot" value="10253.0327335" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Peak wavelength. Defined as sqrt{integ[x*filter(x) dx]/integ[filter(x) dx/x]}</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthPeak" value="10322" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Peak wavelength. Defined as the lambda value with larger transmission</DESCRIPTION>
    </PARAM>
    <PARAM name="WavelengthPhot" value="10232.7564133" unit="Angstrom" ucd="em.wl" datatype="float" >
       <DESCRIPTION>Photon distribution based effective wavelength. Defined as integ[x^2*filter(x)*vega(x) dx]/integ[x*filter(x)*vega(x) dx]</DESCRIPTION>
    </PARAM>
    <PARAM name="FWHM" value="1105.32902776" unit="Angstrom" ucd="instr.bandwidth" datatype="float" >
       <DESCRIPTION>Full width at half maximum. Defined as the difference between the two wavelengths for which filter transmission is half maximum</DESCRIPTION>
    </PARAM>
    <PARAM name="PhotCalID" value="CFHT/Wircam.Y/Vega" ucd="meta.id" utype="photdm:PhotCal.identifier" datatype="char" arraysize="*"/>
    <PARAM name="MagSys" value="Vega" ucd="meta.code" utype="photdm:PhotCal.MagnitudeSystem.type" datatype="char" arraysize="*"/>
    <PARAM name="ZeroPoint" value="2073.32476156" unit="Jy" ucd="phot.flux.density" utype="photdm:PhotCal.ZeroPoint.Flux.value" datatype="float" />
    <PARAM name="ZeroPointUnit" value="Jy" ucd="meta.unit" utype="photdm:PhotCal.ZeroPoint.Flux.unit" datatype="char" arraysize="*"/>
    <PARAM name="ZeroPointType" value="Pogson" ucd="meta.code" utype="photdm:PhotCal.ZeroPoint.type" datatype="char" arraysize="*"/>
      <FIELD name="Wavelength" utype="spec:Data.SpectralAxis.Value" ucd="em.wl" unit="Angstrom" datatype="float"/>
      <FIELD name="Transmission" utype="spec:Data.FluxAxis.Value" ucd="phys.transmission" unit="" datatype="float"/>
      <DATA>
        <TABLEDATA>
          <TR>
            <TD>9386.0</TD>
            <TD>0.0099600000</TD>
          </TR>
          <TR>
            <TD>9388.0</TD>
            <TD>0.0100300000</TD>
          </TR>
          <TR>
            <TD>9390.0</TD>
            <TD>0.0102800000</TD>
          </TR>
          <TR>
            <TD>9392.0</TD>
            <TD>0.0106000000</TD>
          </TR>
          <TR>
            <TD>9394.0</TD>
            <TD>0.0107400000</TD>
          </TR>
          <TR>
            <TD>9396.0</TD>
            <TD>0.0109600000</TD>
          </TR>
          <TR>
            <TD>9398.0</TD>
            <TD>0.0111500000</TD>
          </TR>
          <TR>
            <TD>9400.0</TD>
            <TD>0.0113200000</TD>
          </TR>
          <TR>
            <TD>9402.0</TD>
            <TD>0.0114100000</TD>
          </TR>
          <TR>
            <TD>9404.0</TD>
            <TD>0.0117000000</TD>
          </TR>
          <TR>
            <TD>9406.0</TD>
            <TD>0.0120200000</TD>
          </TR>
          <TR>
            <TD>9408.0</TD>
            <TD>0.0123000000</TD>
          </TR>
          <TR>
            <TD>9410.0</TD>
            <TD>0.0125000000</TD>
          </TR>
          <TR>
            <TD>9412.0</TD>
            <TD>0.0127100000</TD>
          </TR>
          <TR>
            <TD>9414.0</TD>
            <TD>0.0128600000</TD>
          </TR>
          <TR>
            <TD>9416.0</TD>
            <TD>0.0131400000</TD>
          </TR>
          <TR>
            <TD>9418.0</TD>
            <TD>0.0134100000</TD>
          </TR>
          <TR>
            <TD>9420.0</TD>
            <TD>0.0137900000</TD>
          </TR>
          <TR>
            <TD>9422.0</TD>
            <TD>0.0140400000</TD>
          </TR>
          <TR>
            <TD>9424.0</TD>
            <TD>0.0142400000</TD>
          </TR>
          <TR>
            <TD>9426.0</TD>
            <TD>0.0145700000</TD>
          </TR>
          <TR>
            <TD>9428.0</TD>
            <TD>0.0148800000</TD>
          </TR>
          <TR>
            <TD>9430.0</TD>
            <TD>0.0151100000</TD>
          </TR>
          <TR>
            <TD>9432.0</TD>
            <TD>0.0154600000</TD>
          </TR>
          <TR>
            <TD>9434.0</TD>
            <TD>0.0158700000</TD>
          </TR>
          <TR>
            <TD>9436.0</TD>
            <TD>0.0162400000</TD>
          </TR>
          <TR>
            <TD>9438.0</TD>
            <TD>0.0164200000</TD>
          </TR>
          <TR>
            <TD>9440.0</TD>
            <TD>0.0166900000</TD>
          </TR>
          <TR>
            <TD>9442.0</TD>
            <TD>0.0170600000</TD>
          </TR>
          <TR>
            <TD>9444.0</TD>
            <TD>0.0172900000</TD>
          </TR>
          <TR>
            <TD>9446.0</TD>
            <TD>0.0176100000</TD>
          </TR>
          <TR>
            <TD>9448.0</TD>
            <TD>0.0179400000</TD>
          </TR>
          <TR>
            <TD>9450.0</TD>
            <TD>0.0183700000</TD>
          </TR>
          <TR>
            <TD>9452.0</TD>
            <TD>0.0186600000</TD>
          </TR>
          <TR>
            <TD>9454.0</TD>
            <TD>0.0190600000</TD>
          </TR>
          <TR>
            <TD>9456.0</TD>
            <TD>0.0195300000</TD>
          </TR>
          <TR>
            <TD>9458.0</TD>
            <TD>0.0198800000</TD>
          </TR>
          <TR>
            <TD>9460.0</TD>
            <TD>0.0204200000</TD>
          </TR>
          <TR>
            <TD>9462.0</TD>
            <TD>0.0209500000</TD>
          </TR>
          <TR>
            <TD>9464.0</TD>
            <TD>0.0214200000</TD>
          </TR>
          <TR>
            <TD>9466.0</TD>
            <TD>0.0217700000</TD>
          </TR>
          <TR>
            <TD>9468.0</TD>
            <TD>0.0222300000</TD>
          </TR>
          <TR>
            <TD>9470.0</TD>
            <TD>0.0227200000</TD>
          </TR>
          <TR>
            <TD>9472.0</TD>
            <TD>0.0233200000</TD>
          </TR>
          <TR>
            <TD>9474.0</TD>
            <TD>0.0238000000</TD>
          </TR>
          <TR>
            <TD>9476.0</TD>
            <TD>0.0244300000</TD>
          </TR>
          <TR>
            <TD>9478.0</TD>
            <TD>0.0249900000</TD>
          </TR>
          <TR>
            <TD>9480.0</TD>
            <TD>0.0255700000</TD>
          </TR>
          <TR>
            <TD>9482.0</TD>
            <TD>0.0261400000</TD>
          </TR>
          <TR>
            <TD>9484.0</TD>
            <TD>0.0267200000</TD>
          </TR>
          <TR>
            <TD>9486.0</TD>
            <TD>0.0273100000</TD>
          </TR>
          <TR>
            <TD>9488.0</TD>
            <TD>0.0279400000</TD>
          </TR>
          <TR>
            <TD>9490.0</TD>
            <TD>0.0284900000</TD>
          </TR>
          <TR>
            <TD>9492.0</TD>
            <TD>0.0290700000</TD>
          </TR>
          <TR>
            <TD>9494.0</TD>
            <TD>0.0297900000</TD>
          </TR>
          <TR>
            <TD>9496.0</TD>
            <TD>0.0305600000</TD>
          </TR>
          <TR>
            <TD>9498.0</TD>
            <TD>0.0313700000</TD>
          </TR>
          <TR>
            <TD>9500.0</TD>
            <TD>0.0320400000</TD>
          </TR>
          <TR>
            <TD>9502.0</TD>
            <TD>0.0328200000</TD>
          </TR>
          <TR>
            <TD>9504.0</TD>
            <TD>0.0335500000</TD>
          </TR>
          <TR>
            <TD>9506.0</TD>
            <TD>0.0344100000</TD>
          </TR>
          <TR>
            <TD>9508.0</TD>
            <TD>0.0353100000</TD>
          </TR>
          <TR>
            <TD>9510.0</TD>
            <TD>0.0361300000</TD>
          </TR>
          <TR>
            <TD>9512.0</TD>
            <TD>0.0369300000</TD>
          </TR>
          <TR>
            <TD>9514.0</TD>
            <TD>0.0378400000</TD>
          </TR>
          <TR>
            <TD>9516.0</TD>
            <TD>0.0387300000</TD>
          </TR>
          <TR>
            <TD>9518.0</TD>
            <TD>0.0397000000</TD>
          </TR>
          <TR>
            <TD>9520.0</TD>
            <TD>0.0407400000</TD>
          </TR>
          <TR>
            <TD>9522.0</TD>
            <TD>0.0418500000</TD>
          </TR>
          <TR>
            <TD>9524.0</TD>
            <TD>0.0429400000</TD>
          </TR>
          <TR>
            <TD>9526.0</TD>
            <TD>0.0439300000</TD>
          </TR>
          <TR>
            <TD>9528.0</TD>
            <TD>0.0450000000</TD>
          </TR>
          <TR>
            <TD>9530.0</TD>
            <TD>0.0461300000</TD>
          </TR>
          <TR>
            <TD>9532.0</TD>
            <TD>0.0474200000</TD>
          </TR>
          <TR>
            <TD>9534.0</TD>
            <TD>0.0487100000</TD>
          </TR>
          <TR>
            <TD>9536.0</TD>
            <TD>0.0499900000</TD>
          </TR>
          <TR>
            <TD>9538.0</TD>
            <TD>0.0513800000</TD>
          </TR>
          <TR>
            <TD>9540.0</TD>
            <TD>0.0527300000</TD>
          </TR>
          <TR>
            <TD>9542.0</TD>
            <TD>0.0542000000</TD>
          </TR>
          <TR>
            <TD>9544.0</TD>
            <TD>0.0557100000</TD>
          </TR>
          <TR>
            <TD>9546.0</TD>
            <TD>0.0572500000</TD>
          </TR>
          <TR>
            <TD>9548.0</TD>
            <TD>0.0589000000</TD>
          </TR>
          <TR>
            <TD>9550.0</TD>
            <TD>0.0605000000</TD>
          </TR>
          <TR>
            <TD>9552.0</TD>
            <TD>0.0621600000</TD>
          </TR>
          <TR>
            <TD>9554.0</TD>
            <TD>0.0639600000</TD>
          </TR>
          <TR>
            <TD>9556.0</TD>
            <TD>0.0657800000</TD>
          </TR>
          <TR>
            <TD>9558.0</TD>
            <TD>0.0677200000</TD>
          </TR>
          <TR>
            <TD>9560.0</TD>
            <TD>0.0696000000</TD>
          </TR>
          <TR>
            <TD>9562.0</TD>
            <TD>0.0715200000</TD>
          </TR>
          <TR>
            <TD>9564.0</TD>
            <TD>0.0733200000</TD>
          </TR>
          <TR>
            <TD>9566.0</TD>
            <TD>0.0752600000</TD>
          </TR>
          <TR>
            <TD>9568.0</TD>
            <TD>0.0773500000</TD>
          </TR>
          <TR>
            <TD>9570.0</TD>
            <TD>0.0794200000</TD>
          </TR>
          <TR>
            <TD>9572.0</TD>
            <TD>0.0814700000</TD>
          </TR>
          <TR>
            <TD>9574.0</TD>
            <TD>0.0836200000</TD>
          </TR>
          <TR>
            <TD>9576.0</TD>
            <TD>0.0858600000</TD>
          </TR>
          <TR>
            <TD>9578.0</TD>
            <TD>0.0880900000</TD>
          </TR>
          <TR>
            <TD>9580.0</TD>
            <TD>0.0904700000</TD>
          </TR>
          <TR>
            <TD>9582.0</TD>
            <TD>0.0929100000</TD>
          </TR>
          <TR>
            <TD>9584.0</TD>
            <TD>0.0952900000</TD>
          </TR>
          <TR>
            <TD>9586.0</TD>
            <TD>0.0978700000</TD>
          </TR>
          <TR>
            <TD>9588.0</TD>
            <TD>0.1004500000</TD>
          </TR>
          <TR>
            <TD>9590.0</TD>
            <TD>0.1030100000</TD>
          </TR>
          <TR>
            <TD>9592.0</TD>
            <TD>0.1057600000</TD>
          </TR>
          <TR>
            <TD>9594.0</TD>
            <TD>0.1086300000</TD>
          </TR>
          <TR>
            <TD>9596.0</TD>
            <TD>0.1116200000</TD>
          </TR>
          <TR>
            <TD>9598.0</TD>
            <TD>0.1146100000</TD>
          </TR>
          <TR>
            <TD>9600.0</TD>
            <TD>0.1176100000</TD>
          </TR>
          <TR>
            <TD>9602.0</TD>
            <TD>0.1207300000</TD>
          </TR>
          <TR>
            <TD>9604.0</TD>
            <TD>0.1240200000</TD>
          </TR>
          <TR>
            <TD>9606.0</TD>
            <TD>0.1272900000</TD>
          </TR>
          <TR>
            <TD>9608.0</TD>
            <TD>0.1307200000</TD>
          </TR>
          <TR>
            <TD>9610.0</TD>
            <TD>0.1341700000</TD>
          </TR>
          <TR>
            <TD>9612.0</TD>
            <TD>0.1376200000</TD>
          </TR>
          <TR>
            <TD>9614.0</TD>
            <TD>0.1413300000</TD>
          </TR>
          <TR>
            <TD>9616.0</TD>
            <TD>0.1450200000</TD>
          </TR>
          <TR>
            <TD>9618.0</TD>
            <TD>0.1486800000</TD>
          </TR>
          <TR>
            <TD>9620.0</TD>
            <TD>0.1525400000</TD>
          </TR>
          <TR>
            <TD>9622.0</TD>
            <TD>0.1564800000</TD>
          </TR>
          <TR>
            <TD>9624.0</TD>
            <TD>0.1604600000</TD>
          </TR>
          <TR>
            <TD>9626.0</TD>
            <TD>0.1645200000</TD>
          </TR>
          <TR>
            <TD>9628.0</TD>
            <TD>0.1686400000</TD>
          </TR>
          <TR>
            <TD>9630.0</TD>
            <TD>0.1729300000</TD>
          </TR>
          <TR>
            <TD>9632.0</TD>
            <TD>0.1773100000</TD>
          </TR>
          <TR>
            <TD>9634.0</TD>
            <TD>0.1817900000</TD>
          </TR>
          <TR>
            <TD>9636.0</TD>
            <TD>0.1863300000</TD>
          </TR>
          <TR>
            <TD>9638.0</TD>
            <TD>0.1909900000</TD>
          </TR>
          <TR>
            <TD>9640.0</TD>
            <TD>0.1955700000</TD>
          </TR>
          <TR>
            <TD>9642.0</TD>
            <TD>0.2003900000</TD>
          </TR>
          <TR>
            <TD>9644.0</TD>
            <TD>0.2054100000</TD>
          </TR>
          <TR>
            <TD>9646.0</TD>
            <TD>0.2102100000</TD>
          </TR>
          <TR>
            <TD>9648.0</TD>
            <TD>0.2153300000</TD>
          </TR>
          <TR>
            <TD>9650.0</TD>
            <TD>0.2205700000</TD>
          </TR>
          <TR>
            <TD>9652.0</TD>
            <TD>0.2257800000</TD>
          </TR>
          <TR>
            <TD>9654.0</TD>
            <TD>0.2310500000</TD>
          </TR>
          <TR>
            <TD>9656.0</TD>
            <TD>0.2364700000</TD>
          </TR>
          <TR>
            <TD>9658.0</TD>
            <TD>0.2418700000</TD>
          </TR>
          <TR>
            <TD>9660.0</TD>
            <TD>0.2474800000</TD>
          </TR>
          <TR>
            <TD>9662.0</TD>
            <TD>0.2531400000</TD>
          </TR>
          <TR>
            <TD>9664.0</TD>
            <TD>0.2587400000</TD>
          </TR>
          <TR>
            <TD>9666.0</TD>
            <TD>0.2643700000</TD>
          </TR>
          <TR>
            <TD>9668.0</TD>
            <TD>0.2700700000</TD>
          </TR>
          <TR>
            <TD>9670.0</TD>
            <TD>0.2759400000</TD>
          </TR>
          <TR>
            <TD>9672.0</TD>
            <TD>0.2818600000</TD>
          </TR>
          <TR>
            <TD>9674.0</TD>
            <TD>0.2878000000</TD>
          </TR>
          <TR>
            <TD>9676.0</TD>
            <TD>0.2937500000</TD>
          </TR>
          <TR>
            <TD>9678.0</TD>
            <TD>0.2998700000</TD>
          </TR>
          <TR>
            <TD>9680.0</TD>
            <TD>0.3058300000</TD>
          </TR>
          <TR>
            <TD>9682.0</TD>
            <TD>0.3119500000</TD>
          </TR>
          <TR>
            <TD>9684.0</TD>
            <TD>0.3181200000</TD>
          </TR>
          <TR>
            <TD>9686.0</TD>
            <TD>0.3244900000</TD>
          </TR>
          <TR>
            <TD>9688.0</TD>
            <TD>0.3306700000</TD>
          </TR>
          <TR>
            <TD>9690.0</TD>
            <TD>0.3369800000</TD>
          </TR>
          <TR>
            <TD>9692.0</TD>
            <TD>0.3432600000</TD>
          </TR>
          <TR>
            <TD>9694.0</TD>
            <TD>0.3495500000</TD>
          </TR>
          <TR>
            <TD>9696.0</TD>
            <TD>0.3559600000</TD>
          </TR>
          <TR>
            <TD>9698.0</TD>
            <TD>0.3623500000</TD>
          </TR>
          <TR>
            <TD>9700.0</TD>
            <TD>0.3688200000</TD>
          </TR>
          <TR>
            <TD>9702.0</TD>
            <TD>0.3752400000</TD>
          </TR>
          <TR>
            <TD>9704.0</TD>
            <TD>0.3816100000</TD>
          </TR>
          <TR>
            <TD>9706.0</TD>
            <TD>0.3880000000</TD>
          </TR>
          <TR>
            <TD>9708.0</TD>
            <TD>0.3943300000</TD>
          </TR>
          <TR>
            <TD>9710.0</TD>
            <TD>0.4006800000</TD>
          </TR>
          <TR>
            <TD>9712.0</TD>
            <TD>0.4070000000</TD>
          </TR>
          <TR>
            <TD>9714.0</TD>
            <TD>0.4131900000</TD>
          </TR>
          <TR>
            <TD>9716.0</TD>
            <TD>0.4194200000</TD>
          </TR>
          <TR>
            <TD>9718.0</TD>
            <TD>0.4255500000</TD>
          </TR>
          <TR>
            <TD>9720.0</TD>
            <TD>0.4317200000</TD>
          </TR>
          <TR>
            <TD>9722.0</TD>
            <TD>0.4378700000</TD>
          </TR>
          <TR>
            <TD>9724.0</TD>
            <TD>0.4439200000</TD>
          </TR>
          <TR>
            <TD>9726.0</TD>
            <TD>0.4499800000</TD>
          </TR>
          <TR>
            <TD>9728.0</TD>
            <TD>0.4559900000</TD>
          </TR>
          <TR>
            <TD>9730.0</TD>
            <TD>0.4618700000</TD>
          </TR>
          <TR>
            <TD>9732.0</TD>
            <TD>0.4676800000</TD>
          </TR>
          <TR>
            <TD>9734.0</TD>
            <TD>0.4735000000</TD>
          </TR>
          <TR>
            <TD>9736.0</TD>
            <TD>0.4792800000</TD>
          </TR>
          <TR>
            <TD>9738.0</TD>
            <TD>0.4848500000</TD>
          </TR>
          <TR>
            <TD>9740.0</TD>
            <TD>0.4905100000</TD>
          </TR>
          <TR>
            <TD>9742.0</TD>
            <TD>0.4960000000</TD>
          </TR>
          <TR>
            <TD>9744.0</TD>
            <TD>0.5014600000</TD>
          </TR>
          <TR>
            <TD>9746.0</TD>
            <TD>0.5067900000</TD>
          </TR>
          <TR>
            <TD>9748.0</TD>
            <TD>0.5120200000</TD>
          </TR>
          <TR>
            <TD>9750.0</TD>
            <TD>0.5170600000</TD>
          </TR>
          <TR>
            <TD>9752.0</TD>
            <TD>0.5222500000</TD>
          </TR>
          <TR>
            <TD>9754.0</TD>
            <TD>0.5271800000</TD>
          </TR>
          <TR>
            <TD>9756.0</TD>
            <TD>0.5320900000</TD>
          </TR>
          <TR>
            <TD>9758.0</TD>
            <TD>0.5369000000</TD>
          </TR>
          <TR>
            <TD>9760.0</TD>
            <TD>0.5415800000</TD>
          </TR>
          <TR>
            <TD>9762.0</TD>
            <TD>0.5461900000</TD>
          </TR>
          <TR>
            <TD>9764.0</TD>
            <TD>0.5506100000</TD>
          </TR>
          <TR>
            <TD>9766.0</TD>
            <TD>0.5548400000</TD>
          </TR>
          <TR>
            <TD>9768.0</TD>
            <TD>0.5590700000</TD>
          </TR>
          <TR>
            <TD>9770.0</TD>
            <TD>0.5631900000</TD>
          </TR>
          <TR>
            <TD>9772.0</TD>
            <TD>0.5669900000</TD>
          </TR>
          <TR>
            <TD>9774.0</TD>
            <TD>0.5708500000</TD>
          </TR>
          <TR>
            <TD>9776.0</TD>
            <TD>0.5746600000</TD>
          </TR>
          <TR>
            <TD>9778.0</TD>
            <TD>0.5783800000</TD>
          </TR>
          <TR>
            <TD>9780.0</TD>
            <TD>0.5819200000</TD>
          </TR>
          <TR>
            <TD>9782.0</TD>
            <TD>0.5854900000</TD>
          </TR>
          <TR>
            <TD>9784.0</TD>
            <TD>0.5887600000</TD>
          </TR>
          <TR>
            <TD>9786.0</TD>
            <TD>0.5919800000</TD>
          </TR>
          <TR>
            <TD>9788.0</TD>
            <TD>0.5951500000</TD>
          </TR>
          <TR>
            <TD>9790.0</TD>
            <TD>0.5981300000</TD>
          </TR>
          <TR>
            <TD>9792.0</TD>
            <TD>0.6010900000</TD>
          </TR>
          <TR>
            <TD>9794.0</TD>
            <TD>0.6038800000</TD>
          </TR>
          <TR>
            <TD>9796.0</TD>
            <TD>0.6066600000</TD>
          </TR>
          <TR>
            <TD>9798.0</TD>
            <TD>0.6093300000</TD>
          </TR>
          <TR>
            <TD>9800.0</TD>
            <TD>0.6119200000</TD>
          </TR>
          <TR>
            <TD>9802.0</TD>
            <TD>0.6144300000</TD>
          </TR>
          <TR>
            <TD>9804.0</TD>
            <TD>0.6169300000</TD>
          </TR>
          <TR>
            <TD>9806.0</TD>
            <TD>0.6192600000</TD>
          </TR>
          <TR>
            <TD>9808.0</TD>
            <TD>0.6215200000</TD>
          </TR>
          <TR>
            <TD>9810.0</TD>
            <TD>0.6237000000</TD>
          </TR>
          <TR>
            <TD>9812.0</TD>
            <TD>0.6258200000</TD>
          </TR>
          <TR>
            <TD>9814.0</TD>
            <TD>0.6278200000</TD>
          </TR>
          <TR>
            <TD>9816.0</TD>
            <TD>0.6297800000</TD>
          </TR>
          <TR>
            <TD>9818.0</TD>
            <TD>0.6317100000</TD>
          </TR>
          <TR>
            <TD>9820.0</TD>
            <TD>0.6334400000</TD>
          </TR>
          <TR>
            <TD>9822.0</TD>
            <TD>0.6351300000</TD>
          </TR>
          <TR>
            <TD>9824.0</TD>
            <TD>0.6368000000</TD>
          </TR>
          <TR>
            <TD>9826.0</TD>
            <TD>0.6384100000</TD>
          </TR>
          <TR>
            <TD>9828.0</TD>
            <TD>0.6399800000</TD>
          </TR>
          <TR>
            <TD>9830.0</TD>
            <TD>0.6414600000</TD>
          </TR>
          <TR>
            <TD>9832.0</TD>
            <TD>0.6428400000</TD>
          </TR>
          <TR>
            <TD>9834.0</TD>
            <TD>0.6443000000</TD>
          </TR>
          <TR>
            <TD>9836.0</TD>
            <TD>0.6456000000</TD>
          </TR>
          <TR>
            <TD>9838.0</TD>
            <TD>0.6469300000</TD>
          </TR>
          <TR>
            <TD>9840.0</TD>
            <TD>0.6481600000</TD>
          </TR>
          <TR>
            <TD>9842.0</TD>
            <TD>0.6494300000</TD>
          </TR>
          <TR>
            <TD>9844.0</TD>
            <TD>0.6507000000</TD>
          </TR>
          <TR>
            <TD>9846.0</TD>
            <TD>0.6519300000</TD>
          </TR>
          <TR>
            <TD>9848.0</TD>
            <TD>0.6530600000</TD>
          </TR>
          <TR>
            <TD>9850.0</TD>
            <TD>0.6542200000</TD>
          </TR>
          <TR>
            <TD>9852.0</TD>
            <TD>0.6553300000</TD>
          </TR>
          <TR>
            <TD>9854.0</TD>
            <TD>0.6563300000</TD>
          </TR>
          <TR>
            <TD>9856.0</TD>
            <TD>0.6573800000</TD>
          </TR>
          <TR>
            <TD>9858.0</TD>
            <TD>0.6583900000</TD>
          </TR>
          <TR>
            <TD>9860.0</TD>
            <TD>0.6593800000</TD>
          </TR>
          <TR>
            <TD>9862.0</TD>
            <TD>0.6604800000</TD>
          </TR>
          <TR>
            <TD>9864.0</TD>
            <TD>0.6615300000</TD>
          </TR>
          <TR>
            <TD>9866.0</TD>
            <TD>0.6624900000</TD>
          </TR>
          <TR>
            <TD>9868.0</TD>
            <TD>0.6635300000</TD>
          </TR>
          <TR>
            <TD>9870.0</TD>
            <TD>0.6645200000</TD>
          </TR>
          <TR>
            <TD>9872.0</TD>
            <TD>0.6655300000</TD>
          </TR>
          <TR>
            <TD>9874.0</TD>
            <TD>0.6665200000</TD>
          </TR>
          <TR>
            <TD>9876.0</TD>
            <TD>0.6674200000</TD>
          </TR>
          <TR>
            <TD>9878.0</TD>
            <TD>0.6683500000</TD>
          </TR>
          <TR>
            <TD>9880.0</TD>
            <TD>0.6693300000</TD>
          </TR>
          <TR>
            <TD>9882.0</TD>
            <TD>0.6701800000</TD>
          </TR>
          <TR>
            <TD>9884.0</TD>
            <TD>0.6710200000</TD>
          </TR>
          <TR>
            <TD>9886.0</TD>
            <TD>0.6720300000</TD>
          </TR>
          <TR>
            <TD>9888.0</TD>
            <TD>0.6728500000</TD>
          </TR>
          <TR>
            <TD>9890.0</TD>
            <TD>0.6737800000</TD>
          </TR>
          <TR>
            <TD>9892.0</TD>
            <TD>0.6745600000</TD>
          </TR>
          <TR>
            <TD>9894.0</TD>
            <TD>0.6753700000</TD>
          </TR>
          <TR>
            <TD>9896.0</TD>
            <TD>0.6762100000</TD>
          </TR>
          <TR>
            <TD>9898.0</TD>
            <TD>0.6770800000</TD>
          </TR>
          <TR>
            <TD>9900.0</TD>
            <TD>0.6779200000</TD>
          </TR>
          <TR>
            <TD>9902.0</TD>
            <TD>0.6787700000</TD>
          </TR>
          <TR>
            <TD>9904.0</TD>
            <TD>0.6796300000</TD>
          </TR>
          <TR>
            <TD>9906.0</TD>
            <TD>0.6804200000</TD>
          </TR>
          <TR>
            <TD>9908.0</TD>
            <TD>0.6812300000</TD>
          </TR>
          <TR>
            <TD>9910.0</TD>
            <TD>0.6821100000</TD>
          </TR>
          <TR>
            <TD>9912.0</TD>
            <TD>0.6829500000</TD>
          </TR>
          <TR>
            <TD>9914.0</TD>
            <TD>0.6838700000</TD>
          </TR>
          <TR>
            <TD>9916.0</TD>
            <TD>0.6848100000</TD>
          </TR>
          <TR>
            <TD>9918.0</TD>
            <TD>0.6856500000</TD>
          </TR>
          <TR>
            <TD>9920.0</TD>
            <TD>0.6866100000</TD>
          </TR>
          <TR>
            <TD>9922.0</TD>
            <TD>0.6874800000</TD>
          </TR>
          <TR>
            <TD>9924.0</TD>
            <TD>0.6885500000</TD>
          </TR>
          <TR>
            <TD>9926.0</TD>
            <TD>0.6894700000</TD>
          </TR>
          <TR>
            <TD>9928.0</TD>
            <TD>0.6903400000</TD>
          </TR>
          <TR>
            <TD>9930.0</TD>
            <TD>0.6912700000</TD>
          </TR>
          <TR>
            <TD>9932.0</TD>
            <TD>0.6922000000</TD>
          </TR>
          <TR>
            <TD>9934.0</TD>
            <TD>0.6929900000</TD>
          </TR>
          <TR>
            <TD>9936.0</TD>
            <TD>0.6937900000</TD>
          </TR>
          <TR>
            <TD>9938.0</TD>
            <TD>0.6946000000</TD>
          </TR>
          <TR>
            <TD>9940.0</TD>
            <TD>0.6955000000</TD>
          </TR>
          <TR>
            <TD>9942.0</TD>
            <TD>0.6962100000</TD>
          </TR>
          <TR>
            <TD>9944.0</TD>
            <TD>0.6970100000</TD>
          </TR>
          <TR>
            <TD>9946.0</TD>
            <TD>0.6977200000</TD>
          </TR>
          <TR>
            <TD>9948.0</TD>
            <TD>0.6984900000</TD>
          </TR>
          <TR>
            <TD>9950.0</TD>
            <TD>0.6991900000</TD>
          </TR>
          <TR>
            <TD>9952.0</TD>
            <TD>0.6999100000</TD>
          </TR>
          <TR>
            <TD>9954.0</TD>
            <TD>0.7006400000</TD>
          </TR>
          <TR>
            <TD>9956.0</TD>
            <TD>0.7012600000</TD>
          </TR>
          <TR>
            <TD>9958.0</TD>
            <TD>0.7018900000</TD>
          </TR>
          <TR>
            <TD>9960.0</TD>
            <TD>0.7025900000</TD>
          </TR>
          <TR>
            <TD>9962.0</TD>
            <TD>0.7031700000</TD>
          </TR>
          <TR>
            <TD>9964.0</TD>
            <TD>0.7037700000</TD>
          </TR>
          <TR>
            <TD>9966.0</TD>
            <TD>0.7043800000</TD>
          </TR>
          <TR>
            <TD>9968.0</TD>
            <TD>0.7049400000</TD>
          </TR>
          <TR>
            <TD>9970.0</TD>
            <TD>0.7054900000</TD>
          </TR>
          <TR>
            <TD>9972.0</TD>
            <TD>0.7059900000</TD>
          </TR>
          <TR>
            <TD>9974.0</TD>
            <TD>0.7065300000</TD>
          </TR>
          <TR>
            <TD>9976.0</TD>
            <TD>0.7070000000</TD>
          </TR>
          <TR>
            <TD>9978.0</TD>
            <TD>0.7074600000</TD>
          </TR>
          <TR>
            <TD>9980.0</TD>
            <TD>0.7079500000</TD>
          </TR>
          <TR>
            <TD>9982.0</TD>
            <TD>0.7084400000</TD>
          </TR>
          <TR>
            <TD>9984.0</TD>
            <TD>0.7088900000</TD>
          </TR>
          <TR>
            <TD>9986.0</TD>
            <TD>0.7092100000</TD>
          </TR>
          <TR>
            <TD>9988.0</TD>
            <TD>0.7096300000</TD>
          </TR>
          <TR>
            <TD>9990.0</TD>
            <TD>0.7100500000</TD>
          </TR>
          <TR>
            <TD>9992.0</TD>
            <TD>0.7103100000</TD>
          </TR>
          <TR>
            <TD>9994.0</TD>
            <TD>0.7106300000</TD>
          </TR>
          <TR>
            <TD>9996.0</TD>
            <TD>0.7110000000</TD>
          </TR>
          <TR>
            <TD>9998.0</TD>
            <TD>0.7113500000</TD>
          </TR>
          <TR>
            <TD>10000.0</TD>
            <TD>0.7117500000</TD>
          </TR>
          <TR>
            <TD>10002.0</TD>
            <TD>0.7120400000</TD>
          </TR>
          <TR>
            <TD>10004.0</TD>
            <TD>0.7122700000</TD>
          </TR>
          <TR>
            <TD>10006.0</TD>
            <TD>0.7125100000</TD>
          </TR>
          <TR>
            <TD>10008.0</TD>
            <TD>0.7127100000</TD>
          </TR>
          <TR>
            <TD>10010.0</TD>
            <TD>0.7129400000</TD>
          </TR>
          <TR>
            <TD>10012.0</TD>
            <TD>0.7130300000</TD>
          </TR>
          <TR>
            <TD>10014.0</TD>
            <TD>0.7131300000</TD>
          </TR>
          <TR>
            <TD>10016.0</TD>
            <TD>0.7132000000</TD>
          </TR>
          <TR>
            <TD>10018.0</TD>
            <TD>0.7132600000</TD>
          </TR>
          <TR>
            <TD>10020.0</TD>
            <TD>0.7133000000</TD>
          </TR>
          <TR>
            <TD>10022.0</TD>
            <TD>0.7133500000</TD>
          </TR>
          <TR>
            <TD>10024.0</TD>
            <TD>0.7134200000</TD>
          </TR>
          <TR>
            <TD>10026.0</TD>
            <TD>0.7134700000</TD>
          </TR>
          <TR>
            <TD>10028.0</TD>
            <TD>0.7135000000</TD>
          </TR>
          <TR>
            <TD>10030.0</TD>
            <TD>0.7135000000</TD>
          </TR>
          <TR>
            <TD>10032.0</TD>
            <TD>0.7133600000</TD>
          </TR>
          <TR>
            <TD>10034.0</TD>
            <TD>0.7133600000</TD>
          </TR>
          <TR>
            <TD>10036.0</TD>
            <TD>0.7133800000</TD>
          </TR>
          <TR>
            <TD>10038.0</TD>
            <TD>0.7133200000</TD>
          </TR>
          <TR>
            <TD>10040.0</TD>
            <TD>0.7133300000</TD>
          </TR>
          <TR>
            <TD>10042.0</TD>
            <TD>0.7131800000</TD>
          </TR>
          <TR>
            <TD>10044.0</TD>
            <TD>0.7131200000</TD>
          </TR>
          <TR>
            <TD>10046.0</TD>
            <TD>0.7130700000</TD>
          </TR>
          <TR>
            <TD>10048.0</TD>
            <TD>0.7130100000</TD>
          </TR>
          <TR>
            <TD>10050.0</TD>
            <TD>0.7130100000</TD>
          </TR>
          <TR>
            <TD>10052.0</TD>
            <TD>0.7128400000</TD>
          </TR>
          <TR>
            <TD>10054.0</TD>
            <TD>0.7126900000</TD>
          </TR>
          <TR>
            <TD>10056.0</TD>
            <TD>0.7126600000</TD>
          </TR>
          <TR>
            <TD>10058.0</TD>
            <TD>0.7125900000</TD>
          </TR>
          <TR>
            <TD>10060.0</TD>
            <TD>0.7123400000</TD>
          </TR>
          <TR>
            <TD>10062.0</TD>
            <TD>0.7121700000</TD>
          </TR>
          <TR>
            <TD>10064.0</TD>
            <TD>0.7120200000</TD>
          </TR>
          <TR>
            <TD>10066.0</TD>
            <TD>0.7118700000</TD>
          </TR>
          <TR>
            <TD>10068.0</TD>
            <TD>0.7116700000</TD>
          </TR>
          <TR>
            <TD>10070.0</TD>
            <TD>0.7114600000</TD>
          </TR>
          <TR>
            <TD>10072.0</TD>
            <TD>0.7112600000</TD>
          </TR>
          <TR>
            <TD>10074.0</TD>
            <TD>0.7111500000</TD>
          </TR>
          <TR>
            <TD>10076.0</TD>
            <TD>0.7110000000</TD>
          </TR>
          <TR>
            <TD>10078.0</TD>
            <TD>0.7107100000</TD>
          </TR>
          <TR>
            <TD>10080.0</TD>
            <TD>0.7104800000</TD>
          </TR>
          <TR>
            <TD>10082.0</TD>
            <TD>0.7102700000</TD>
          </TR>
          <TR>
            <TD>10084.0</TD>
            <TD>0.7100500000</TD>
          </TR>
          <TR>
            <TD>10086.0</TD>
            <TD>0.7098100000</TD>
          </TR>
          <TR>
            <TD>10088.0</TD>
            <TD>0.7095600000</TD>
          </TR>
          <TR>
            <TD>10090.0</TD>
            <TD>0.7092600000</TD>
          </TR>
          <TR>
            <TD>10092.0</TD>
            <TD>0.7090500000</TD>
          </TR>
          <TR>
            <TD>10094.0</TD>
            <TD>0.7087900000</TD>
          </TR>
          <TR>
            <TD>10096.0</TD>
            <TD>0.7086300000</TD>
          </TR>
          <TR>
            <TD>10098.0</TD>
            <TD>0.7083700000</TD>
          </TR>
          <TR>
            <TD>10100.0</TD>
            <TD>0.7081100000</TD>
          </TR>
          <TR>
            <TD>10102.0</TD>
            <TD>0.7078700000</TD>
          </TR>
          <TR>
            <TD>10104.0</TD>
            <TD>0.7076600000</TD>
          </TR>
          <TR>
            <TD>10106.0</TD>
            <TD>0.7074400000</TD>
          </TR>
          <TR>
            <TD>10108.0</TD>
            <TD>0.7072900000</TD>
          </TR>
          <TR>
            <TD>10110.0</TD>
            <TD>0.7071800000</TD>
          </TR>
          <TR>
            <TD>10112.0</TD>
            <TD>0.7070300000</TD>
          </TR>
          <TR>
            <TD>10114.0</TD>
            <TD>0.7068800000</TD>
          </TR>
          <TR>
            <TD>10116.0</TD>
            <TD>0.7068000000</TD>
          </TR>
          <TR>
            <TD>10118.0</TD>
            <TD>0.7067100000</TD>
          </TR>
          <TR>
            <TD>10120.0</TD>
            <TD>0.7065400000</TD>
          </TR>
          <TR>
            <TD>10122.0</TD>
            <TD>0.7064800000</TD>
          </TR>
          <TR>
            <TD>10124.0</TD>
            <TD>0.7064800000</TD>
          </TR>
          <TR>
            <TD>10126.0</TD>
            <TD>0.7064700000</TD>
          </TR>
          <TR>
            <TD>10128.0</TD>
            <TD>0.7063800000</TD>
          </TR>
          <TR>
            <TD>10130.0</TD>
            <TD>0.7064100000</TD>
          </TR>
          <TR>
            <TD>10132.0</TD>
            <TD>0.7064400000</TD>
          </TR>
          <TR>
            <TD>10134.0</TD>
            <TD>0.7065400000</TD>
          </TR>
          <TR>
            <TD>10136.0</TD>
            <TD>0.7065900000</TD>
          </TR>
          <TR>
            <TD>10138.0</TD>
            <TD>0.7066300000</TD>
          </TR>
          <TR>
            <TD>10140.0</TD>
            <TD>0.7065700000</TD>
          </TR>
          <TR>
            <TD>10142.0</TD>
            <TD>0.7066200000</TD>
          </TR>
          <TR>
            <TD>10144.0</TD>
            <TD>0.7067000000</TD>
          </TR>
          <TR>
            <TD>10146.0</TD>
            <TD>0.7067400000</TD>
          </TR>
          <TR>
            <TD>10148.0</TD>
            <TD>0.7068600000</TD>
          </TR>
          <TR>
            <TD>10150.0</TD>
            <TD>0.7070000000</TD>
          </TR>
          <TR>
            <TD>10152.0</TD>
            <TD>0.7071800000</TD>
          </TR>
          <TR>
            <TD>10154.0</TD>
            <TD>0.7073400000</TD>
          </TR>
          <TR>
            <TD>10156.0</TD>
            <TD>0.7074600000</TD>
          </TR>
          <TR>
            <TD>10158.0</TD>
            <TD>0.7076600000</TD>
          </TR>
          <TR>
            <TD>10160.0</TD>
            <TD>0.7079200000</TD>
          </TR>
          <TR>
            <TD>10162.0</TD>
            <TD>0.7081500000</TD>
          </TR>
          <TR>
            <TD>10164.0</TD>
            <TD>0.7084400000</TD>
          </TR>
          <TR>
            <TD>10166.0</TD>
            <TD>0.7087600000</TD>
          </TR>
          <TR>
            <TD>10168.0</TD>
            <TD>0.7090300000</TD>
          </TR>
          <TR>
            <TD>10170.0</TD>
            <TD>0.7094000000</TD>
          </TR>
          <TR>
            <TD>10172.0</TD>
            <TD>0.7098700000</TD>
          </TR>
          <TR>
            <TD>10174.0</TD>
            <TD>0.7103100000</TD>
          </TR>
          <TR>
            <TD>10176.0</TD>
            <TD>0.7107100000</TD>
          </TR>
          <TR>
            <TD>10178.0</TD>
            <TD>0.7111500000</TD>
          </TR>
          <TR>
            <TD>10180.0</TD>
            <TD>0.7115300000</TD>
          </TR>
          <TR>
            <TD>10182.0</TD>
            <TD>0.7120200000</TD>
          </TR>
          <TR>
            <TD>10184.0</TD>
            <TD>0.7124900000</TD>
          </TR>
          <TR>
            <TD>10186.0</TD>
            <TD>0.7130300000</TD>
          </TR>
          <TR>
            <TD>10188.0</TD>
            <TD>0.7136200000</TD>
          </TR>
          <TR>
            <TD>10190.0</TD>
            <TD>0.7142200000</TD>
          </TR>
          <TR>
            <TD>10192.0</TD>
            <TD>0.7147400000</TD>
          </TR>
          <TR>
            <TD>10194.0</TD>
            <TD>0.7152700000</TD>
          </TR>
          <TR>
            <TD>10196.0</TD>
            <TD>0.7157900000</TD>
          </TR>
          <TR>
            <TD>10198.0</TD>
            <TD>0.7163700000</TD>
          </TR>
          <TR>
            <TD>10200.0</TD>
            <TD>0.7170400000</TD>
          </TR>
          <TR>
            <TD>10202.0</TD>
            <TD>0.7175900000</TD>
          </TR>
          <TR>
            <TD>10204.0</TD>
            <TD>0.7182500000</TD>
          </TR>
          <TR>
            <TD>10206.0</TD>
            <TD>0.7188000000</TD>
          </TR>
          <TR>
            <TD>10208.0</TD>
            <TD>0.7194400000</TD>
          </TR>
          <TR>
            <TD>10210.0</TD>
            <TD>0.7200300000</TD>
          </TR>
          <TR>
            <TD>10212.0</TD>
            <TD>0.7206600000</TD>
          </TR>
          <TR>
            <TD>10214.0</TD>
            <TD>0.7212700000</TD>
          </TR>
          <TR>
            <TD>10216.0</TD>
            <TD>0.7218300000</TD>
          </TR>
          <TR>
            <TD>10218.0</TD>
            <TD>0.7224400000</TD>
          </TR>
          <TR>
            <TD>10220.0</TD>
            <TD>0.7230400000</TD>
          </TR>
          <TR>
            <TD>10222.0</TD>
            <TD>0.7235600000</TD>
          </TR>
          <TR>
            <TD>10224.0</TD>
            <TD>0.7241700000</TD>
          </TR>
          <TR>
            <TD>10226.0</TD>
            <TD>0.7247800000</TD>
          </TR>
          <TR>
            <TD>10228.0</TD>
            <TD>0.7253900000</TD>
          </TR>
          <TR>
            <TD>10230.0</TD>
            <TD>0.7259500000</TD>
          </TR>
          <TR>
            <TD>10232.0</TD>
            <TD>0.7265000000</TD>
          </TR>
          <TR>
            <TD>10234.0</TD>
            <TD>0.7271600000</TD>
          </TR>
          <TR>
            <TD>10236.0</TD>
            <TD>0.7276800000</TD>
          </TR>
          <TR>
            <TD>10238.0</TD>
            <TD>0.7282900000</TD>
          </TR>
          <TR>
            <TD>10240.0</TD>
            <TD>0.7288500000</TD>
          </TR>
          <TR>
            <TD>10242.0</TD>
            <TD>0.7295400000</TD>
          </TR>
          <TR>
            <TD>10244.0</TD>
            <TD>0.7301300000</TD>
          </TR>
          <TR>
            <TD>10246.0</TD>
            <TD>0.7307100000</TD>
          </TR>
          <TR>
            <TD>10248.0</TD>
            <TD>0.7313500000</TD>
          </TR>
          <TR>
            <TD>10250.0</TD>
            <TD>0.7319200000</TD>
          </TR>
          <TR>
            <TD>10252.0</TD>
            <TD>0.7325000000</TD>
          </TR>
          <TR>
            <TD>10254.0</TD>
            <TD>0.7331200000</TD>
          </TR>
          <TR>
            <TD>10256.0</TD>
            <TD>0.7337500000</TD>
          </TR>
          <TR>
            <TD>10258.0</TD>
            <TD>0.7343400000</TD>
          </TR>
          <TR>
            <TD>10260.0</TD>
            <TD>0.7349400000</TD>
          </TR>
          <TR>
            <TD>10262.0</TD>
            <TD>0.7354600000</TD>
          </TR>
          <TR>
            <TD>10264.0</TD>
            <TD>0.7359900000</TD>
          </TR>
          <TR>
            <TD>10266.0</TD>
            <TD>0.7365100000</TD>
          </TR>
          <TR>
            <TD>10268.0</TD>
            <TD>0.7369800000</TD>
          </TR>
          <TR>
            <TD>10270.0</TD>
            <TD>0.7374700000</TD>
          </TR>
          <TR>
            <TD>10272.0</TD>
            <TD>0.7379300000</TD>
          </TR>
          <TR>
            <TD>10274.0</TD>
            <TD>0.7383100000</TD>
          </TR>
          <TR>
            <TD>10276.0</TD>
            <TD>0.7388000000</TD>
          </TR>
          <TR>
            <TD>10278.0</TD>
            <TD>0.7392100000</TD>
          </TR>
          <TR>
            <TD>10280.0</TD>
            <TD>0.7395900000</TD>
          </TR>
          <TR>
            <TD>10282.0</TD>
            <TD>0.7400100000</TD>
          </TR>
          <TR>
            <TD>10284.0</TD>
            <TD>0.7403600000</TD>
          </TR>
          <TR>
            <TD>10286.0</TD>
            <TD>0.7406300000</TD>
          </TR>
          <TR>
            <TD>10288.0</TD>
            <TD>0.7408800000</TD>
          </TR>
          <TR>
            <TD>10290.0</TD>
            <TD>0.7411200000</TD>
          </TR>
          <TR>
            <TD>10292.0</TD>
            <TD>0.7413200000</TD>
          </TR>
          <TR>
            <TD>10294.0</TD>
            <TD>0.7415800000</TD>
          </TR>
          <TR>
            <TD>10296.0</TD>
            <TD>0.7417800000</TD>
          </TR>
          <TR>
            <TD>10298.0</TD>
            <TD>0.7419700000</TD>
          </TR>
          <TR>
            <TD>10300.0</TD>
            <TD>0.7421700000</TD>
          </TR>
          <TR>
            <TD>10302.0</TD>
            <TD>0.7423700000</TD>
          </TR>
          <TR>
            <TD>10304.0</TD>
            <TD>0.7425700000</TD>
          </TR>
          <TR>
            <TD>10306.0</TD>
            <TD>0.7427200000</TD>
          </TR>
          <TR>
            <TD>10308.0</TD>
            <TD>0.7428100000</TD>
          </TR>
          <TR>
            <TD>10310.0</TD>
            <TD>0.7428700000</TD>
          </TR>
          <TR>
            <TD>10312.0</TD>
            <TD>0.7429700000</TD>
          </TR>
          <TR>
            <TD>10314.0</TD>
            <TD>0.7429700000</TD>
          </TR>
          <TR>
            <TD>10316.0</TD>
            <TD>0.7429700000</TD>
          </TR>
          <TR>
            <TD>10318.0</TD>
            <TD>0.7429800000</TD>
          </TR>
          <TR>
            <TD>10320.0</TD>
            <TD>0.7430000000</TD>
          </TR>
          <TR>
            <TD>10322.0</TD>
            <TD>0.7430400000</TD>
          </TR>
          <TR>
            <TD>10324.0</TD>
            <TD>0.7430300000</TD>
          </TR>
          <TR>
            <TD>10326.0</TD>
            <TD>0.7430000000</TD>
          </TR>
          <TR>
            <TD>10328.0</TD>
            <TD>0.7429500000</TD>
          </TR>
          <TR>
            <TD>10330.0</TD>
            <TD>0.7428400000</TD>
          </TR>
          <TR>
            <TD>10332.0</TD>
            <TD>0.7427500000</TD>
          </TR>
          <TR>
            <TD>10334.0</TD>
            <TD>0.7425500000</TD>
          </TR>
          <TR>
            <TD>10336.0</TD>
            <TD>0.7422800000</TD>
          </TR>
          <TR>
            <TD>10338.0</TD>
            <TD>0.7420800000</TD>
          </TR>
          <TR>
            <TD>10340.0</TD>
            <TD>0.7418200000</TD>
          </TR>
          <TR>
            <TD>10342.0</TD>
            <TD>0.7416200000</TD>
          </TR>
          <TR>
            <TD>10344.0</TD>
            <TD>0.7413600000</TD>
          </TR>
          <TR>
            <TD>10346.0</TD>
            <TD>0.7411300000</TD>
          </TR>
          <TR>
            <TD>10348.0</TD>
            <TD>0.7408300000</TD>
          </TR>
          <TR>
            <TD>10350.0</TD>
            <TD>0.7405500000</TD>
          </TR>
          <TR>
            <TD>10352.0</TD>
            <TD>0.7402300000</TD>
          </TR>
          <TR>
            <TD>10354.0</TD>
            <TD>0.7398400000</TD>
          </TR>
          <TR>
            <TD>10356.0</TD>
            <TD>0.7395000000</TD>
          </TR>
          <TR>
            <TD>10358.0</TD>
            <TD>0.7391400000</TD>
          </TR>
          <TR>
            <TD>10360.0</TD>
            <TD>0.7387400000</TD>
          </TR>
          <TR>
            <TD>10362.0</TD>
            <TD>0.7384000000</TD>
          </TR>
          <TR>
            <TD>10364.0</TD>
            <TD>0.7380100000</TD>
          </TR>
          <TR>
            <TD>10366.0</TD>
            <TD>0.7376900000</TD>
          </TR>
          <TR>
            <TD>10368.0</TD>
            <TD>0.7373500000</TD>
          </TR>
          <TR>
            <TD>10370.0</TD>
            <TD>0.7370000000</TD>
          </TR>
          <TR>
            <TD>10372.0</TD>
            <TD>0.7366300000</TD>
          </TR>
          <TR>
            <TD>10374.0</TD>
            <TD>0.7362700000</TD>
          </TR>
          <TR>
            <TD>10376.0</TD>
            <TD>0.7358600000</TD>
          </TR>
          <TR>
            <TD>10378.0</TD>
            <TD>0.7354400000</TD>
          </TR>
          <TR>
            <TD>10380.0</TD>
            <TD>0.7350600000</TD>
          </TR>
          <TR>
            <TD>10382.0</TD>
            <TD>0.7346500000</TD>
          </TR>
          <TR>
            <TD>10384.0</TD>
            <TD>0.7341900000</TD>
          </TR>
          <TR>
            <TD>10386.0</TD>
            <TD>0.7338000000</TD>
          </TR>
          <TR>
            <TD>10388.0</TD>
            <TD>0.7333800000</TD>
          </TR>
          <TR>
            <TD>10390.0</TD>
            <TD>0.7329600000</TD>
          </TR>
          <TR>
            <TD>10392.0</TD>
            <TD>0.7325600000</TD>
          </TR>
          <TR>
            <TD>10394.0</TD>
            <TD>0.7320900000</TD>
          </TR>
          <TR>
            <TD>10396.0</TD>
            <TD>0.7316400000</TD>
          </TR>
          <TR>
            <TD>10398.0</TD>
            <TD>0.7311600000</TD>
          </TR>
          <TR>
            <TD>10400.0</TD>
            <TD>0.7307300000</TD>
          </TR>
          <TR>
            <TD>10402.0</TD>
            <TD>0.7302100000</TD>
          </TR>
          <TR>
            <TD>10404.0</TD>
            <TD>0.7296800000</TD>
          </TR>
          <TR>
            <TD>10406.0</TD>
            <TD>0.7292000000</TD>
          </TR>
          <TR>
            <TD>10408.0</TD>
            <TD>0.7287400000</TD>
          </TR>
          <TR>
            <TD>10410.0</TD>
            <TD>0.7282300000</TD>
          </TR>
          <TR>
            <TD>10412.0</TD>
            <TD>0.7276900000</TD>
          </TR>
          <TR>
            <TD>10414.0</TD>
            <TD>0.7272300000</TD>
          </TR>
          <TR>
            <TD>10416.0</TD>
            <TD>0.7267800000</TD>
          </TR>
          <TR>
            <TD>10418.0</TD>
            <TD>0.7262700000</TD>
          </TR>
          <TR>
            <TD>10420.0</TD>
            <TD>0.7257500000</TD>
          </TR>
          <TR>
            <TD>10422.0</TD>
            <TD>0.7252500000</TD>
          </TR>
          <TR>
            <TD>10424.0</TD>
            <TD>0.7247300000</TD>
          </TR>
          <TR>
            <TD>10426.0</TD>
            <TD>0.7241800000</TD>
          </TR>
          <TR>
            <TD>10428.0</TD>
            <TD>0.7237400000</TD>
          </TR>
          <TR>
            <TD>10430.0</TD>
            <TD>0.7232700000</TD>
          </TR>
          <TR>
            <TD>10432.0</TD>
            <TD>0.7227200000</TD>
          </TR>
          <TR>
            <TD>10434.0</TD>
            <TD>0.7222700000</TD>
          </TR>
          <TR>
            <TD>10436.0</TD>
            <TD>0.7217700000</TD>
          </TR>
          <TR>
            <TD>10438.0</TD>
            <TD>0.7212100000</TD>
          </TR>
          <TR>
            <TD>10440.0</TD>
            <TD>0.7206600000</TD>
          </TR>
          <TR>
            <TD>10442.0</TD>
            <TD>0.7201200000</TD>
          </TR>
          <TR>
            <TD>10444.0</TD>
            <TD>0.7196000000</TD>
          </TR>
          <TR>
            <TD>10446.0</TD>
            <TD>0.7190700000</TD>
          </TR>
          <TR>
            <TD>10448.0</TD>
            <TD>0.7185200000</TD>
          </TR>
          <TR>
            <TD>10450.0</TD>
            <TD>0.7179600000</TD>
          </TR>
          <TR>
            <TD>10452.0</TD>
            <TD>0.7173300000</TD>
          </TR>
          <TR>
            <TD>10454.0</TD>
            <TD>0.7167200000</TD>
          </TR>
          <TR>
            <TD>10456.0</TD>
            <TD>0.7161100000</TD>
          </TR>
          <TR>
            <TD>10458.0</TD>
            <TD>0.7154800000</TD>
          </TR>
          <TR>
            <TD>10460.0</TD>
            <TD>0.7148600000</TD>
          </TR>
          <TR>
            <TD>10462.0</TD>
            <TD>0.7142500000</TD>
          </TR>
          <TR>
            <TD>10464.0</TD>
            <TD>0.7135800000</TD>
          </TR>
          <TR>
            <TD>10466.0</TD>
            <TD>0.7128800000</TD>
          </TR>
          <TR>
            <TD>10468.0</TD>
            <TD>0.7122500000</TD>
          </TR>
          <TR>
            <TD>10470.0</TD>
            <TD>0.7115800000</TD>
          </TR>
          <TR>
            <TD>10472.0</TD>
            <TD>0.7109200000</TD>
          </TR>
          <TR>
            <TD>10474.0</TD>
            <TD>0.7102400000</TD>
          </TR>
          <TR>
            <TD>10476.0</TD>
            <TD>0.7095200000</TD>
          </TR>
          <TR>
            <TD>10478.0</TD>
            <TD>0.7088300000</TD>
          </TR>
          <TR>
            <TD>10480.0</TD>
            <TD>0.7081000000</TD>
          </TR>
          <TR>
            <TD>10482.0</TD>
            <TD>0.7074100000</TD>
          </TR>
          <TR>
            <TD>10484.0</TD>
            <TD>0.7067300000</TD>
          </TR>
          <TR>
            <TD>10486.0</TD>
            <TD>0.7060100000</TD>
          </TR>
          <TR>
            <TD>10488.0</TD>
            <TD>0.7052900000</TD>
          </TR>
          <TR>
            <TD>10490.0</TD>
            <TD>0.7046200000</TD>
          </TR>
          <TR>
            <TD>10492.0</TD>
            <TD>0.7038600000</TD>
          </TR>
          <TR>
            <TD>10494.0</TD>
            <TD>0.7030800000</TD>
          </TR>
          <TR>
            <TD>10496.0</TD>
            <TD>0.7023600000</TD>
          </TR>
          <TR>
            <TD>10498.0</TD>
            <TD>0.7016800000</TD>
          </TR>
          <TR>
            <TD>10500.0</TD>
            <TD>0.7009400000</TD>
          </TR>
          <TR>
            <TD>10502.0</TD>
            <TD>0.7001600000</TD>
          </TR>
          <TR>
            <TD>10504.0</TD>
            <TD>0.6994200000</TD>
          </TR>
          <TR>
            <TD>10506.0</TD>
            <TD>0.6986700000</TD>
          </TR>
          <TR>
            <TD>10508.0</TD>
            <TD>0.6979700000</TD>
          </TR>
          <TR>
            <TD>10510.0</TD>
            <TD>0.6971600000</TD>
          </TR>
          <TR>
            <TD>10512.0</TD>
            <TD>0.6964100000</TD>
          </TR>
          <TR>
            <TD>10514.0</TD>
            <TD>0.6956500000</TD>
          </TR>
          <TR>
            <TD>10516.0</TD>
            <TD>0.6948900000</TD>
          </TR>
          <TR>
            <TD>10518.0</TD>
            <TD>0.6940900000</TD>
          </TR>
          <TR>
            <TD>10520.0</TD>
            <TD>0.6933400000</TD>
          </TR>
          <TR>
            <TD>10522.0</TD>
            <TD>0.6925500000</TD>
          </TR>
          <TR>
            <TD>10524.0</TD>
            <TD>0.6918000000</TD>
          </TR>
          <TR>
            <TD>10526.0</TD>
            <TD>0.6910900000</TD>
          </TR>
          <TR>
            <TD>10528.0</TD>
            <TD>0.6903500000</TD>
          </TR>
          <TR>
            <TD>10530.0</TD>
            <TD>0.6896400000</TD>
          </TR>
          <TR>
            <TD>10532.0</TD>
            <TD>0.6889200000</TD>
          </TR>
          <TR>
            <TD>10534.0</TD>
            <TD>0.6882600000</TD>
          </TR>
          <TR>
            <TD>10536.0</TD>
            <TD>0.6875300000</TD>
          </TR>
          <TR>
            <TD>10538.0</TD>
            <TD>0.6868400000</TD>
          </TR>
          <TR>
            <TD>10540.0</TD>
            <TD>0.6861400000</TD>
          </TR>
          <TR>
            <TD>10542.0</TD>
            <TD>0.6855200000</TD>
          </TR>
          <TR>
            <TD>10544.0</TD>
            <TD>0.6849100000</TD>
          </TR>
          <TR>
            <TD>10546.0</TD>
            <TD>0.6843000000</TD>
          </TR>
          <TR>
            <TD>10548.0</TD>
            <TD>0.6836400000</TD>
          </TR>
          <TR>
            <TD>10550.0</TD>
            <TD>0.6830700000</TD>
          </TR>
          <TR>
            <TD>10552.0</TD>
            <TD>0.6824800000</TD>
          </TR>
          <TR>
            <TD>10554.0</TD>
            <TD>0.6819200000</TD>
          </TR>
          <TR>
            <TD>10556.0</TD>
            <TD>0.6813000000</TD>
          </TR>
          <TR>
            <TD>10558.0</TD>
            <TD>0.6806900000</TD>
          </TR>
          <TR>
            <TD>10560.0</TD>
            <TD>0.6801900000</TD>
          </TR>
          <TR>
            <TD>10562.0</TD>
            <TD>0.6796600000</TD>
          </TR>
          <TR>
            <TD>10564.0</TD>
            <TD>0.6791700000</TD>
          </TR>
          <TR>
            <TD>10566.0</TD>
            <TD>0.6786500000</TD>
          </TR>
          <TR>
            <TD>10568.0</TD>
            <TD>0.6782200000</TD>
          </TR>
          <TR>
            <TD>10570.0</TD>
            <TD>0.6777300000</TD>
          </TR>
          <TR>
            <TD>10572.0</TD>
            <TD>0.6772900000</TD>
          </TR>
          <TR>
            <TD>10574.0</TD>
            <TD>0.6768500000</TD>
          </TR>
          <TR>
            <TD>10576.0</TD>
            <TD>0.6764200000</TD>
          </TR>
          <TR>
            <TD>10578.0</TD>
            <TD>0.6759900000</TD>
          </TR>
          <TR>
            <TD>10580.0</TD>
            <TD>0.6756600000</TD>
          </TR>
          <TR>
            <TD>10582.0</TD>
            <TD>0.6753200000</TD>
          </TR>
          <TR>
            <TD>10584.0</TD>
            <TD>0.6750200000</TD>
          </TR>
          <TR>
            <TD>10586.0</TD>
            <TD>0.6747100000</TD>
          </TR>
          <TR>
            <TD>10588.0</TD>
            <TD>0.6744800000</TD>
          </TR>
          <TR>
            <TD>10590.0</TD>
            <TD>0.6742600000</TD>
          </TR>
          <TR>
            <TD>10592.0</TD>
            <TD>0.6740000000</TD>
          </TR>
          <TR>
            <TD>10594.0</TD>
            <TD>0.6737500000</TD>
          </TR>
          <TR>
            <TD>10596.0</TD>
            <TD>0.6735500000</TD>
          </TR>
          <TR>
            <TD>10598.0</TD>
            <TD>0.6733400000</TD>
          </TR>
          <TR>
            <TD>10600.0</TD>
            <TD>0.6731700000</TD>
          </TR>
          <TR>
            <TD>10602.0</TD>
            <TD>0.6730000000</TD>
          </TR>
          <TR>
            <TD>10604.0</TD>
            <TD>0.6728500000</TD>
          </TR>
          <TR>
            <TD>10606.0</TD>
            <TD>0.6727100000</TD>
          </TR>
          <TR>
            <TD>10608.0</TD>
            <TD>0.6725800000</TD>
          </TR>
          <TR>
            <TD>10610.0</TD>
            <TD>0.6724900000</TD>
          </TR>
          <TR>
            <TD>10612.0</TD>
            <TD>0.6724200000</TD>
          </TR>
          <TR>
            <TD>10614.0</TD>
            <TD>0.6723300000</TD>
          </TR>
          <TR>
            <TD>10616.0</TD>
            <TD>0.6722600000</TD>
          </TR>
          <TR>
            <TD>10618.0</TD>
            <TD>0.6721600000</TD>
          </TR>
          <TR>
            <TD>10620.0</TD>
            <TD>0.6721300000</TD>
          </TR>
          <TR>
            <TD>10622.0</TD>
            <TD>0.6721000000</TD>
          </TR>
          <TR>
            <TD>10624.0</TD>
            <TD>0.6720900000</TD>
          </TR>
          <TR>
            <TD>10626.0</TD>
            <TD>0.6720900000</TD>
          </TR>
          <TR>
            <TD>10628.0</TD>
            <TD>0.6721200000</TD>
          </TR>
          <TR>
            <TD>10630.0</TD>
            <TD>0.6721600000</TD>
          </TR>
          <TR>
            <TD>10632.0</TD>
            <TD>0.6721000000</TD>
          </TR>
          <TR>
            <TD>10634.0</TD>
            <TD>0.6721300000</TD>
          </TR>
          <TR>
            <TD>10636.0</TD>
            <TD>0.6722000000</TD>
          </TR>
          <TR>
            <TD>10638.0</TD>
            <TD>0.6722300000</TD>
          </TR>
          <TR>
            <TD>10640.0</TD>
            <TD>0.6722400000</TD>
          </TR>
          <TR>
            <TD>10642.0</TD>
            <TD>0.6722900000</TD>
          </TR>
          <TR>
            <TD>10644.0</TD>
            <TD>0.6722900000</TD>
          </TR>
          <TR>
            <TD>10646.0</TD>
            <TD>0.6722700000</TD>
          </TR>
          <TR>
            <TD>10648.0</TD>
            <TD>0.6722600000</TD>
          </TR>
          <TR>
            <TD>10650.0</TD>
            <TD>0.6722300000</TD>
          </TR>
          <TR>
            <TD>10652.0</TD>
            <TD>0.6721500000</TD>
          </TR>
          <TR>
            <TD>10654.0</TD>
            <TD>0.6720700000</TD>
          </TR>
          <TR>
            <TD>10656.0</TD>
            <TD>0.6719100000</TD>
          </TR>
          <TR>
            <TD>10658.0</TD>
            <TD>0.6717400000</TD>
          </TR>
          <TR>
            <TD>10660.0</TD>
            <TD>0.6714800000</TD>
          </TR>
          <TR>
            <TD>10662.0</TD>
            <TD>0.6711900000</TD>
          </TR>
          <TR>
            <TD>10664.0</TD>
            <TD>0.6709100000</TD>
          </TR>
          <TR>
            <TD>10666.0</TD>
            <TD>0.6705600000</TD>
          </TR>
          <TR>
            <TD>10668.0</TD>
            <TD>0.6700600000</TD>
          </TR>
          <TR>
            <TD>10670.0</TD>
            <TD>0.6695100000</TD>
          </TR>
          <TR>
            <TD>10672.0</TD>
            <TD>0.6688700000</TD>
          </TR>
          <TR>
            <TD>10674.0</TD>
            <TD>0.6681800000</TD>
          </TR>
          <TR>
            <TD>10676.0</TD>
            <TD>0.6674200000</TD>
          </TR>
          <TR>
            <TD>10678.0</TD>
            <TD>0.6665600000</TD>
          </TR>
          <TR>
            <TD>10680.0</TD>
            <TD>0.6656000000</TD>
          </TR>
          <TR>
            <TD>10682.0</TD>
            <TD>0.6646100000</TD>
          </TR>
          <TR>
            <TD>10684.0</TD>
            <TD>0.6635100000</TD>
          </TR>
          <TR>
            <TD>10686.0</TD>
            <TD>0.6622800000</TD>
          </TR>
          <TR>
            <TD>10688.0</TD>
            <TD>0.6610100000</TD>
          </TR>
          <TR>
            <TD>10690.0</TD>
            <TD>0.6596100000</TD>
          </TR>
          <TR>
            <TD>10692.0</TD>
            <TD>0.6581300000</TD>
          </TR>
          <TR>
            <TD>10694.0</TD>
            <TD>0.6565100000</TD>
          </TR>
          <TR>
            <TD>10696.0</TD>
            <TD>0.6547200000</TD>
          </TR>
          <TR>
            <TD>10698.0</TD>
            <TD>0.6528000000</TD>
          </TR>
          <TR>
            <TD>10700.0</TD>
            <TD>0.6507600000</TD>
          </TR>
          <TR>
            <TD>10702.0</TD>
            <TD>0.6486400000</TD>
          </TR>
          <TR>
            <TD>10704.0</TD>
            <TD>0.6463200000</TD>
          </TR>
          <TR>
            <TD>10706.0</TD>
            <TD>0.6438600000</TD>
          </TR>
          <TR>
            <TD>10708.0</TD>
            <TD>0.6412800000</TD>
          </TR>
          <TR>
            <TD>10710.0</TD>
            <TD>0.6385500000</TD>
          </TR>
          <TR>
            <TD>10712.0</TD>
            <TD>0.6357000000</TD>
          </TR>
          <TR>
            <TD>10714.0</TD>
            <TD>0.6326800000</TD>
          </TR>
          <TR>
            <TD>10716.0</TD>
            <TD>0.6294900000</TD>
          </TR>
          <TR>
            <TD>10718.0</TD>
            <TD>0.6261300000</TD>
          </TR>
          <TR>
            <TD>10720.0</TD>
            <TD>0.6226200000</TD>
          </TR>
          <TR>
            <TD>10722.0</TD>
            <TD>0.6190000000</TD>
          </TR>
          <TR>
            <TD>10724.0</TD>
            <TD>0.6151700000</TD>
          </TR>
          <TR>
            <TD>10726.0</TD>
            <TD>0.6111900000</TD>
          </TR>
          <TR>
            <TD>10728.0</TD>
            <TD>0.6071900000</TD>
          </TR>
          <TR>
            <TD>10730.0</TD>
            <TD>0.6030600000</TD>
          </TR>
          <TR>
            <TD>10732.0</TD>
            <TD>0.5988500000</TD>
          </TR>
          <TR>
            <TD>10734.0</TD>
            <TD>0.5944100000</TD>
          </TR>
          <TR>
            <TD>10736.0</TD>
            <TD>0.5899000000</TD>
          </TR>
          <TR>
            <TD>10738.0</TD>
            <TD>0.5852700000</TD>
          </TR>
          <TR>
            <TD>10740.0</TD>
            <TD>0.5804600000</TD>
          </TR>
          <TR>
            <TD>10742.0</TD>
            <TD>0.5755300000</TD>
          </TR>
          <TR>
            <TD>10744.0</TD>
            <TD>0.5704700000</TD>
          </TR>
          <TR>
            <TD>10746.0</TD>
            <TD>0.5652600000</TD>
          </TR>
          <TR>
            <TD>10748.0</TD>
            <TD>0.5599100000</TD>
          </TR>
          <TR>
            <TD>10750.0</TD>
            <TD>0.5544700000</TD>
          </TR>
          <TR>
            <TD>10752.0</TD>
            <TD>0.5489300000</TD>
          </TR>
          <TR>
            <TD>10754.0</TD>
            <TD>0.5432100000</TD>
          </TR>
          <TR>
            <TD>10756.0</TD>
            <TD>0.5374300000</TD>
          </TR>
          <TR>
            <TD>10758.0</TD>
            <TD>0.5315400000</TD>
          </TR>
          <TR>
            <TD>10760.0</TD>
            <TD>0.5255300000</TD>
          </TR>
          <TR>
            <TD>10762.0</TD>
            <TD>0.5194200000</TD>
          </TR>
          <TR>
            <TD>10764.0</TD>
            <TD>0.5132000000</TD>
          </TR>
          <TR>
            <TD>10766.0</TD>
            <TD>0.5068500000</TD>
          </TR>
          <TR>
            <TD>10768.0</TD>
            <TD>0.5004700000</TD>
          </TR>
          <TR>
            <TD>10770.0</TD>
            <TD>0.4939300000</TD>
          </TR>
          <TR>
            <TD>10772.0</TD>
            <TD>0.4873700000</TD>
          </TR>
          <TR>
            <TD>10774.0</TD>
            <TD>0.4807700000</TD>
          </TR>
          <TR>
            <TD>10776.0</TD>
            <TD>0.4741100000</TD>
          </TR>
          <TR>
            <TD>10778.0</TD>
            <TD>0.4674400000</TD>
          </TR>
          <TR>
            <TD>10780.0</TD>
            <TD>0.4607500000</TD>
          </TR>
          <TR>
            <TD>10782.0</TD>
            <TD>0.4540100000</TD>
          </TR>
          <TR>
            <TD>10784.0</TD>
            <TD>0.4471600000</TD>
          </TR>
          <TR>
            <TD>10786.0</TD>
            <TD>0.4403200000</TD>
          </TR>
          <TR>
            <TD>10788.0</TD>
            <TD>0.4334600000</TD>
          </TR>
          <TR>
            <TD>10790.0</TD>
            <TD>0.4266100000</TD>
          </TR>
          <TR>
            <TD>10792.0</TD>
            <TD>0.4197200000</TD>
          </TR>
          <TR>
            <TD>10794.0</TD>
            <TD>0.4128600000</TD>
          </TR>
          <TR>
            <TD>10796.0</TD>
            <TD>0.4059900000</TD>
          </TR>
          <TR>
            <TD>10798.0</TD>
            <TD>0.3991700000</TD>
          </TR>
          <TR>
            <TD>10800.0</TD>
            <TD>0.3923000000</TD>
          </TR>
          <TR>
            <TD>10802.0</TD>
            <TD>0.3855600000</TD>
          </TR>
          <TR>
            <TD>10804.0</TD>
            <TD>0.3788500000</TD>
          </TR>
          <TR>
            <TD>10806.0</TD>
            <TD>0.3720900000</TD>
          </TR>
          <TR>
            <TD>10808.0</TD>
            <TD>0.3653900000</TD>
          </TR>
          <TR>
            <TD>10810.0</TD>
            <TD>0.3586600000</TD>
          </TR>
          <TR>
            <TD>10812.0</TD>
            <TD>0.3520200000</TD>
          </TR>
          <TR>
            <TD>10814.0</TD>
            <TD>0.3453700000</TD>
          </TR>
          <TR>
            <TD>10816.0</TD>
            <TD>0.3388700000</TD>
          </TR>
          <TR>
            <TD>10818.0</TD>
            <TD>0.3324000000</TD>
          </TR>
          <TR>
            <TD>10820.0</TD>
            <TD>0.3259700000</TD>
          </TR>
          <TR>
            <TD>10822.0</TD>
            <TD>0.3196300000</TD>
          </TR>
          <TR>
            <TD>10824.0</TD>
            <TD>0.3133400000</TD>
          </TR>
          <TR>
            <TD>10826.0</TD>
            <TD>0.3071600000</TD>
          </TR>
          <TR>
            <TD>10828.0</TD>
            <TD>0.3010900000</TD>
          </TR>
          <TR>
            <TD>10830.0</TD>
            <TD>0.2950400000</TD>
          </TR>
          <TR>
            <TD>10832.0</TD>
            <TD>0.2891100000</TD>
          </TR>
          <TR>
            <TD>10834.0</TD>
            <TD>0.2832200000</TD>
          </TR>
          <TR>
            <TD>10836.0</TD>
            <TD>0.2773900000</TD>
          </TR>
          <TR>
            <TD>10838.0</TD>
            <TD>0.2717300000</TD>
          </TR>
          <TR>
            <TD>10840.0</TD>
            <TD>0.2661400000</TD>
          </TR>
          <TR>
            <TD>10842.0</TD>
            <TD>0.2606500000</TD>
          </TR>
          <TR>
            <TD>10844.0</TD>
            <TD>0.2551900000</TD>
          </TR>
          <TR>
            <TD>10846.0</TD>
            <TD>0.2498800000</TD>
          </TR>
          <TR>
            <TD>10848.0</TD>
            <TD>0.2446300000</TD>
          </TR>
          <TR>
            <TD>10850.0</TD>
            <TD>0.2394900000</TD>
          </TR>
          <TR>
            <TD>10852.0</TD>
            <TD>0.2344500000</TD>
          </TR>
          <TR>
            <TD>10854.0</TD>
            <TD>0.2295100000</TD>
          </TR>
          <TR>
            <TD>10856.0</TD>
            <TD>0.2246900000</TD>
          </TR>
          <TR>
            <TD>10858.0</TD>
            <TD>0.2198800000</TD>
          </TR>
          <TR>
            <TD>10860.0</TD>
            <TD>0.2151900000</TD>
          </TR>
          <TR>
            <TD>10862.0</TD>
            <TD>0.2106500000</TD>
          </TR>
          <TR>
            <TD>10864.0</TD>
            <TD>0.2061200000</TD>
          </TR>
          <TR>
            <TD>10866.0</TD>
            <TD>0.2017500000</TD>
          </TR>
          <TR>
            <TD>10868.0</TD>
            <TD>0.1974200000</TD>
          </TR>
          <TR>
            <TD>10870.0</TD>
            <TD>0.1931500000</TD>
          </TR>
          <TR>
            <TD>10872.0</TD>
            <TD>0.1889600000</TD>
          </TR>
          <TR>
            <TD>10874.0</TD>
            <TD>0.1849100000</TD>
          </TR>
          <TR>
            <TD>10876.0</TD>
            <TD>0.1809500000</TD>
          </TR>
          <TR>
            <TD>10878.0</TD>
            <TD>0.1771400000</TD>
          </TR>
          <TR>
            <TD>10880.0</TD>
            <TD>0.1733700000</TD>
          </TR>
          <TR>
            <TD>10882.0</TD>
            <TD>0.1696800000</TD>
          </TR>
          <TR>
            <TD>10884.0</TD>
            <TD>0.1661100000</TD>
          </TR>
          <TR>
            <TD>10886.0</TD>
            <TD>0.1625800000</TD>
          </TR>
          <TR>
            <TD>10888.0</TD>
            <TD>0.1591200000</TD>
          </TR>
          <TR>
            <TD>10890.0</TD>
            <TD>0.1557300000</TD>
          </TR>
          <TR>
            <TD>10892.0</TD>
            <TD>0.1524000000</TD>
          </TR>
          <TR>
            <TD>10894.0</TD>
            <TD>0.1491400000</TD>
          </TR>
          <TR>
            <TD>10896.0</TD>
            <TD>0.1459700000</TD>
          </TR>
          <TR>
            <TD>10898.0</TD>
            <TD>0.1428400000</TD>
          </TR>
          <TR>
            <TD>10900.0</TD>
            <TD>0.1398300000</TD>
          </TR>
          <TR>
            <TD>10902.0</TD>
            <TD>0.1369300000</TD>
          </TR>
          <TR>
            <TD>10904.0</TD>
            <TD>0.1340600000</TD>
          </TR>
          <TR>
            <TD>10906.0</TD>
            <TD>0.1312700000</TD>
          </TR>
          <TR>
            <TD>10908.0</TD>
            <TD>0.1285200000</TD>
          </TR>
          <TR>
            <TD>10910.0</TD>
            <TD>0.1258100000</TD>
          </TR>
          <TR>
            <TD>10912.0</TD>
            <TD>0.1231800000</TD>
          </TR>
          <TR>
            <TD>10914.0</TD>
            <TD>0.1206200000</TD>
          </TR>
          <TR>
            <TD>10916.0</TD>
            <TD>0.1181300000</TD>
          </TR>
          <TR>
            <TD>10918.0</TD>
            <TD>0.1157100000</TD>
          </TR>
          <TR>
            <TD>10920.0</TD>
            <TD>0.1133000000</TD>
          </TR>
          <TR>
            <TD>10922.0</TD>
            <TD>0.1110100000</TD>
          </TR>
          <TR>
            <TD>10924.0</TD>
            <TD>0.1087300000</TD>
          </TR>
          <TR>
            <TD>10926.0</TD>
            <TD>0.1065400000</TD>
          </TR>
          <TR>
            <TD>10928.0</TD>
            <TD>0.1043700000</TD>
          </TR>
          <TR>
            <TD>10930.0</TD>
            <TD>0.1022600000</TD>
          </TR>
          <TR>
            <TD>10932.0</TD>
            <TD>0.1002700000</TD>
          </TR>
          <TR>
            <TD>10934.0</TD>
            <TD>0.0982500000</TD>
          </TR>
          <TR>
            <TD>10936.0</TD>
            <TD>0.0962700000</TD>
          </TR>
          <TR>
            <TD>10938.0</TD>
            <TD>0.0943500000</TD>
          </TR>
          <TR>
            <TD>10940.0</TD>
            <TD>0.0924500000</TD>
          </TR>
          <TR>
            <TD>10942.0</TD>
            <TD>0.0906200000</TD>
          </TR>
          <TR>
            <TD>10944.0</TD>
            <TD>0.0888500000</TD>
          </TR>
          <TR>
            <TD>10946.0</TD>
            <TD>0.0871100000</TD>
          </TR>
          <TR>
            <TD>10948.0</TD>
            <TD>0.0853600000</TD>
          </TR>
          <TR>
            <TD>10950.0</TD>
            <TD>0.0836600000</TD>
          </TR>
          <TR>
            <TD>10952.0</TD>
            <TD>0.0820000000</TD>
          </TR>
          <TR>
            <TD>10954.0</TD>
            <TD>0.0804100000</TD>
          </TR>
          <TR>
            <TD>10956.0</TD>
            <TD>0.0788400000</TD>
          </TR>
          <TR>
            <TD>10958.0</TD>
            <TD>0.0773200000</TD>
          </TR>
          <TR>
            <TD>10960.0</TD>
            <TD>0.0758700000</TD>
          </TR>
          <TR>
            <TD>10962.0</TD>
            <TD>0.0744300000</TD>
          </TR>
          <TR>
            <TD>10964.0</TD>
            <TD>0.0729800000</TD>
          </TR>
          <TR>
            <TD>10966.0</TD>
            <TD>0.0716100000</TD>
          </TR>
          <TR>
            <TD>10968.0</TD>
            <TD>0.0702800000</TD>
          </TR>
          <TR>
            <TD>10970.0</TD>
            <TD>0.0689700000</TD>
          </TR>
          <TR>
            <TD>10972.0</TD>
            <TD>0.0677200000</TD>
          </TR>
          <TR>
            <TD>10974.0</TD>
            <TD>0.0665000000</TD>
          </TR>
          <TR>
            <TD>10976.0</TD>
            <TD>0.0652500000</TD>
          </TR>
          <TR>
            <TD>10978.0</TD>
            <TD>0.0640600000</TD>
          </TR>
          <TR>
            <TD>10980.0</TD>
            <TD>0.0629000000</TD>
          </TR>
          <TR>
            <TD>10982.0</TD>
            <TD>0.0618000000</TD>
          </TR>
          <TR>
            <TD>10984.0</TD>
            <TD>0.0606800000</TD>
          </TR>
          <TR>
            <TD>10986.0</TD>
            <TD>0.0595900000</TD>
          </TR>
          <TR>
            <TD>10988.0</TD>
            <TD>0.0585500000</TD>
          </TR>
          <TR>
            <TD>10990.0</TD>
            <TD>0.0575100000</TD>
          </TR>
          <TR>
            <TD>10992.0</TD>
            <TD>0.0564900000</TD>
          </TR>
          <TR>
            <TD>10994.0</TD>
            <TD>0.0554800000</TD>
          </TR>
          <TR>
            <TD>10996.0</TD>
            <TD>0.0545200000</TD>
          </TR>
          <TR>
            <TD>10998.0</TD>
            <TD>0.0535400000</TD>
          </TR>
          <TR>
            <TD>11000.0</TD>
            <TD>0.0525800000</TD>
          </TR>
          <TR>
            <TD>11002.0</TD>
            <TD>0.0516700000</TD>
          </TR>
          <TR>
            <TD>11004.0</TD>
            <TD>0.0508000000</TD>
          </TR>
          <TR>
            <TD>11006.0</TD>
            <TD>0.0498700000</TD>
          </TR>
          <TR>
            <TD>11008.0</TD>
            <TD>0.0490300000</TD>
          </TR>
          <TR>
            <TD>11010.0</TD>
            <TD>0.0482300000</TD>
          </TR>
          <TR>
            <TD>11012.0</TD>
            <TD>0.0474200000</TD>
          </TR>
          <TR>
            <TD>11014.0</TD>
            <TD>0.0466000000</TD>
          </TR>
          <TR>
            <TD>11016.0</TD>
            <TD>0.0457900000</TD>
          </TR>
          <TR>
            <TD>11018.0</TD>
            <TD>0.0449700000</TD>
          </TR>
          <TR>
            <TD>11020.0</TD>
            <TD>0.0442400000</TD>
          </TR>
          <TR>
            <TD>11022.0</TD>
            <TD>0.0434900000</TD>
          </TR>
          <TR>
            <TD>11024.0</TD>
            <TD>0.0427400000</TD>
          </TR>
          <TR>
            <TD>11026.0</TD>
            <TD>0.0420500000</TD>
          </TR>
          <TR>
            <TD>11028.0</TD>
            <TD>0.0413100000</TD>
          </TR>
          <TR>
            <TD>11030.0</TD>
            <TD>0.0406200000</TD>
          </TR>
          <TR>
            <TD>11032.0</TD>
            <TD>0.0400100000</TD>
          </TR>
          <TR>
            <TD>11034.0</TD>
            <TD>0.0393400000</TD>
          </TR>
          <TR>
            <TD>11036.0</TD>
            <TD>0.0386800000</TD>
          </TR>
          <TR>
            <TD>11038.0</TD>
            <TD>0.0380700000</TD>
          </TR>
          <TR>
            <TD>11040.0</TD>
            <TD>0.0374800000</TD>
          </TR>
          <TR>
            <TD>11042.0</TD>
            <TD>0.0368800000</TD>
          </TR>
          <TR>
            <TD>11044.0</TD>
            <TD>0.0362900000</TD>
          </TR>
          <TR>
            <TD>11046.0</TD>
            <TD>0.0356900000</TD>
          </TR>
          <TR>
            <TD>11048.0</TD>
            <TD>0.0351600000</TD>
          </TR>
          <TR>
            <TD>11050.0</TD>
            <TD>0.0346400000</TD>
          </TR>
          <TR>
            <TD>11052.0</TD>
            <TD>0.0340900000</TD>
          </TR>
          <TR>
            <TD>11054.0</TD>
            <TD>0.0335800000</TD>
          </TR>
          <TR>
            <TD>11056.0</TD>
            <TD>0.0331300000</TD>
          </TR>
          <TR>
            <TD>11058.0</TD>
            <TD>0.0326100000</TD>
          </TR>
          <TR>
            <TD>11060.0</TD>
            <TD>0.0321500000</TD>
          </TR>
          <TR>
            <TD>11062.0</TD>
            <TD>0.0317100000</TD>
          </TR>
          <TR>
            <TD>11064.0</TD>
            <TD>0.0311600000</TD>
          </TR>
          <TR>
            <TD>11066.0</TD>
            <TD>0.0307500000</TD>
          </TR>
          <TR>
            <TD>11068.0</TD>
            <TD>0.0302400000</TD>
          </TR>
          <TR>
            <TD>11070.0</TD>
            <TD>0.0297700000</TD>
          </TR>
          <TR>
            <TD>11072.0</TD>
            <TD>0.0293000000</TD>
          </TR>
          <TR>
            <TD>11074.0</TD>
            <TD>0.0288500000</TD>
          </TR>
          <TR>
            <TD>11076.0</TD>
            <TD>0.0284300000</TD>
          </TR>
          <TR>
            <TD>11078.0</TD>
            <TD>0.0280200000</TD>
          </TR>
          <TR>
            <TD>11080.0</TD>
            <TD>0.0275900000</TD>
          </TR>
          <TR>
            <TD>11082.0</TD>
            <TD>0.0272200000</TD>
          </TR>
          <TR>
            <TD>11084.0</TD>
            <TD>0.0267900000</TD>
          </TR>
          <TR>
            <TD>11086.0</TD>
            <TD>0.0263800000</TD>
          </TR>
          <TR>
            <TD>11088.0</TD>
            <TD>0.0259700000</TD>
          </TR>
          <TR>
            <TD>11090.0</TD>
            <TD>0.0256300000</TD>
          </TR>
          <TR>
            <TD>11092.0</TD>
            <TD>0.0252500000</TD>
          </TR>
          <TR>
            <TD>11094.0</TD>
            <TD>0.0248900000</TD>
          </TR>
          <TR>
            <TD>11096.0</TD>
            <TD>0.0245700000</TD>
          </TR>
          <TR>
            <TD>11098.0</TD>
            <TD>0.0241900000</TD>
          </TR>
          <TR>
            <TD>11100.0</TD>
            <TD>0.0239000000</TD>
          </TR>
          <TR>
            <TD>11102.0</TD>
            <TD>0.0235600000</TD>
          </TR>
          <TR>
            <TD>11104.0</TD>
            <TD>0.0232400000</TD>
          </TR>
          <TR>
            <TD>11106.0</TD>
            <TD>0.0228900000</TD>
          </TR>
          <TR>
            <TD>11108.0</TD>
            <TD>0.0226000000</TD>
          </TR>
          <TR>
            <TD>11110.0</TD>
            <TD>0.0223100000</TD>
          </TR>
          <TR>
            <TD>11112.0</TD>
            <TD>0.0220600000</TD>
          </TR>
          <TR>
            <TD>11114.0</TD>
            <TD>0.0217300000</TD>
          </TR>
          <TR>
            <TD>11116.0</TD>
            <TD>0.0213900000</TD>
          </TR>
          <TR>
            <TD>11118.0</TD>
            <TD>0.0210700000</TD>
          </TR>
          <TR>
            <TD>11120.0</TD>
            <TD>0.0208000000</TD>
          </TR>
          <TR>
            <TD>11122.0</TD>
            <TD>0.0204300000</TD>
          </TR>
          <TR>
            <TD>11124.0</TD>
            <TD>0.0201900000</TD>
          </TR>
          <TR>
            <TD>11126.0</TD>
            <TD>0.0199100000</TD>
          </TR>
          <TR>
            <TD>11128.0</TD>
            <TD>0.0196500000</TD>
          </TR>
          <TR>
            <TD>11130.0</TD>
            <TD>0.0193800000</TD>
          </TR>
          <TR>
            <TD>11132.0</TD>
            <TD>0.0191500000</TD>
          </TR>
          <TR>
            <TD>11134.0</TD>
            <TD>0.0188900000</TD>
          </TR>
        </TABLEDATA>
      </DATA>
    </TABLE>
  </RESOURCE>
</VOTABLE>
