# coding: utf-8

"""
    Pure Storage FlashBlade REST 1.11 Python SDK

    Pure Storage FlashBlade REST 1.11 Python SDK. Compatible with REST API versions 1.0 - 1.11. Developed by [Pure Storage, Inc](http://www.purestorage.com/). Documentations can be found at [purity-fb.readthedocs.io](http://purity-fb.readthedocs.io/).

    OpenAPI spec version: 1.11
    Contact: info@purestorage.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class PoliciesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def create_policies(self, policy, **kwargs):
        """
        Create a new policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_policies(policy, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Policy policy: The attribute map used to create the policy. (required)
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :return: PolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_policies_with_http_info(policy, **kwargs)
        else:
            (data) = self.create_policies_with_http_info(policy, **kwargs)
            return data

    def create_policies_with_http_info(self, policy, **kwargs):
        """
        Create a new policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_policies_with_http_info(policy, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Policy policy: The attribute map used to create the policy. (required)
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :return: PolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy', 'names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_policies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'policy' is set
        if ('policy' not in params) or (params['policy'] is None):
            raise ValueError("Missing the required parameter `policy` when calling `create_policies`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'names' in params:
            query_params.append(('names', params['names']))
            collection_formats['names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'policy' in params:
            body_params = params['policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolicyResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_policy_file_system_replica_links(self, **kwargs):
        """
        Create a connection between a file system replica link and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_policy_file_system_replica_links(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with the `local_file_system_ids` query parameter.
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :return: PolicyMemberWithRemoteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_policy_file_system_replica_links_with_http_info(**kwargs)
        else:
            (data) = self.create_policy_file_system_replica_links_with_http_info(**kwargs)
            return data

    def create_policy_file_system_replica_links_with_http_info(self, **kwargs):
        """
        Create a connection between a file system replica link and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_policy_file_system_replica_links_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with the `local_file_system_ids` query parameter.
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :return: PolicyMemberWithRemoteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['local_file_system_names', 'local_file_system_ids', 'policy_ids', 'policy_names', 'member_ids', 'remote_ids', 'remote_names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_policy_file_system_replica_links" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'local_file_system_names' in params:
            query_params.append(('local_file_system_names', params['local_file_system_names']))
            collection_formats['local_file_system_names'] = 'csv'
        if 'local_file_system_ids' in params:
            query_params.append(('local_file_system_ids', params['local_file_system_ids']))
            collection_formats['local_file_system_ids'] = 'csv'
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'remote_ids' in params:
            query_params.append(('remote_ids', params['remote_ids']))
            collection_formats['remote_ids'] = 'csv'
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))
            collection_formats['remote_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies/file-system-replica-links', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolicyMemberWithRemoteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def create_policy_filesystems(self, **kwargs):
        """
        Create a connection between a file system and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_policy_filesystems(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :return: PolicyMemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.create_policy_filesystems_with_http_info(**kwargs)
        else:
            (data) = self.create_policy_filesystems_with_http_info(**kwargs)
            return data

    def create_policy_filesystems_with_http_info(self, **kwargs):
        """
        Create a connection between a file system and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_policy_filesystems_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :return: PolicyMemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_ids', 'policy_names', 'member_ids', 'member_names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_policy_filesystems" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'member_names' in params:
            query_params.append(('member_names', params['member_names']))
            collection_formats['member_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies/file-systems', 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolicyMemberResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_policies(self, **kwargs):
        """
        Delete a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_policies(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_policies_with_http_info(**kwargs)
        else:
            (data) = self.delete_policies_with_http_info(**kwargs)
            return data

    def delete_policies_with_http_info(self, **kwargs):
        """
        Delete a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_policies_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids', 'names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_policies" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'names' in params:
            query_params.append(('names', params['names']))
            collection_formats['names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_policy_file_system_replica_links(self, **kwargs):
        """
        Delete a connection betwwen a file system replica link and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_policy_file_system_replica_links(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with the `local_file_system_ids` query parameter.
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_policy_file_system_replica_links_with_http_info(**kwargs)
        else:
            (data) = self.delete_policy_file_system_replica_links_with_http_info(**kwargs)
            return data

    def delete_policy_file_system_replica_links_with_http_info(self, **kwargs):
        """
        Delete a connection betwwen a file system replica link and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_policy_file_system_replica_links_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with the `local_file_system_ids` query parameter.
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['local_file_system_names', 'local_file_system_ids', 'policy_ids', 'policy_names', 'member_ids', 'remote_ids', 'remote_names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_policy_file_system_replica_links" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'local_file_system_names' in params:
            query_params.append(('local_file_system_names', params['local_file_system_names']))
            collection_formats['local_file_system_names'] = 'csv'
        if 'local_file_system_ids' in params:
            query_params.append(('local_file_system_ids', params['local_file_system_ids']))
            collection_formats['local_file_system_ids'] = 'csv'
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'remote_ids' in params:
            query_params.append(('remote_ids', params['remote_ids']))
            collection_formats['remote_ids'] = 'csv'
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))
            collection_formats['remote_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies/file-system-replica-links', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_policy_filesystem_snapshots(self, **kwargs):
        """
        Delete a connection betwwen a file system snapshot and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_policy_filesystem_snapshots(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_policy_filesystem_snapshots_with_http_info(**kwargs)
        else:
            (data) = self.delete_policy_filesystem_snapshots_with_http_info(**kwargs)
            return data

    def delete_policy_filesystem_snapshots_with_http_info(self, **kwargs):
        """
        Delete a connection betwwen a file system snapshot and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_policy_filesystem_snapshots_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_ids', 'policy_names', 'member_ids', 'member_names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_policy_filesystem_snapshots" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'member_names' in params:
            query_params.append(('member_names', params['member_names']))
            collection_formats['member_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies/file-system-snapshots', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def delete_policy_filesystems(self, **kwargs):
        """
        Delete a connection betwwen a file system and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_policy_filesystems(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.delete_policy_filesystems_with_http_info(**kwargs)
        else:
            (data) = self.delete_policy_filesystems_with_http_info(**kwargs)
            return data

    def delete_policy_filesystems_with_http_info(self, **kwargs):
        """
        Delete a connection betwwen a file system and a policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_policy_filesystems_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_ids', 'policy_names', 'member_ids', 'member_names']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_policy_filesystems" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'member_names' in params:
            query_params.append(('member_names', params['member_names']))
            collection_formats['member_names'] = 'csv'

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies/file-systems', 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_policies(self, **kwargs):
        """
        List policies.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_policies(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: The filter to be used for query.
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param int limit: limit, should be >= 0
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: PolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_policies_with_http_info(**kwargs)
        else:
            (data) = self.list_policies_with_http_info(**kwargs)
            return data

    def list_policies_with_http_info(self, **kwargs):
        """
        List policies.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_policies_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str filter: The filter to be used for query.
        :param list[str] ids: A comma-separated list of resource IDs. This cannot be provided together with the name or names query parameters.
        :param int limit: limit, should be >= 0
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: PolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'ids', 'limit', 'names', 'sort', 'start', 'token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_policies" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'ids' in params:
            query_params.append(('ids', params['ids']))
            collection_formats['ids'] = 'csv'
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'names' in params:
            query_params.append(('names', params['names']))
            collection_formats['names'] = 'csv'
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'token' in params:
            query_params.append(('token', params['token']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolicyResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_policy_file_system_replica_links(self, **kwargs):
        """
        List policy attached to file system replica links.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_policy_file_system_replica_links(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with the `local_file_system_ids` query parameter.
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :param list[str] remote_file_system_names: A comma-separated list of remote file system names. This cannot be provided together with `remote_file_system_ids` query parameter.
        :param list[str] remote_file_system_ids: A comma-separated list of remote file system IDs. This cannot be provided together with `remote_file_system_names` query parameter.
        :param str filter: The filter to be used for query.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param int limit: limit, should be >= 0
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: PolicyMemberWithRemoteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_policy_file_system_replica_links_with_http_info(**kwargs)
        else:
            (data) = self.list_policy_file_system_replica_links_with_http_info(**kwargs)
            return data

    def list_policy_file_system_replica_links_with_http_info(self, **kwargs):
        """
        List policy attached to file system replica links.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_policy_file_system_replica_links_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] local_file_system_names: A comma-separated list of local file system names. This cannot be provided together with the `local_file_system_ids` query parameter.
        :param list[str] local_file_system_ids: A comma-separated list of local file system IDs. This cannot be provided together with the `local_file_system_names` query parameter.
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] remote_ids: A comma-separated list of remote array IDs. This cannot be provided together with the `remote_names` query parameter.
        :param list[str] remote_names: A comma-separated list of remote array names. This cannot be provided together with `remote_ids` query parameter.
        :param list[str] remote_file_system_names: A comma-separated list of remote file system names. This cannot be provided together with `remote_file_system_ids` query parameter.
        :param list[str] remote_file_system_ids: A comma-separated list of remote file system IDs. This cannot be provided together with `remote_file_system_names` query parameter.
        :param str filter: The filter to be used for query.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param int limit: limit, should be >= 0
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: PolicyMemberWithRemoteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['local_file_system_names', 'local_file_system_ids', 'policy_ids', 'policy_names', 'member_ids', 'remote_ids', 'remote_names', 'remote_file_system_names', 'remote_file_system_ids', 'filter', 'sort', 'start', 'limit', 'token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_policy_file_system_replica_links" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'local_file_system_names' in params:
            query_params.append(('local_file_system_names', params['local_file_system_names']))
            collection_formats['local_file_system_names'] = 'csv'
        if 'local_file_system_ids' in params:
            query_params.append(('local_file_system_ids', params['local_file_system_ids']))
            collection_formats['local_file_system_ids'] = 'csv'
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'remote_ids' in params:
            query_params.append(('remote_ids', params['remote_ids']))
            collection_formats['remote_ids'] = 'csv'
        if 'remote_names' in params:
            query_params.append(('remote_names', params['remote_names']))
            collection_formats['remote_names'] = 'csv'
        if 'remote_file_system_names' in params:
            query_params.append(('remote_file_system_names', params['remote_file_system_names']))
            collection_formats['remote_file_system_names'] = 'csv'
        if 'remote_file_system_ids' in params:
            query_params.append(('remote_file_system_ids', params['remote_file_system_ids']))
            collection_formats['remote_file_system_ids'] = 'csv'
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'token' in params:
            query_params.append(('token', params['token']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies/file-system-replica-links', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolicyMemberWithRemoteResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_policy_filesystem_snapshots(self, **kwargs):
        """
        List policy attached to filesystem snapshots
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_policy_filesystem_snapshots(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :param str filter: The filter to be used for query.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param int limit: limit, should be >= 0
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: PolicyMemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_policy_filesystem_snapshots_with_http_info(**kwargs)
        else:
            (data) = self.list_policy_filesystem_snapshots_with_http_info(**kwargs)
            return data

    def list_policy_filesystem_snapshots_with_http_info(self, **kwargs):
        """
        List policy attached to filesystem snapshots
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_policy_filesystem_snapshots_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :param str filter: The filter to be used for query.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param int limit: limit, should be >= 0
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: PolicyMemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_ids', 'policy_names', 'member_ids', 'member_names', 'filter', 'sort', 'start', 'limit', 'token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_policy_filesystem_snapshots" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'member_names' in params:
            query_params.append(('member_names', params['member_names']))
            collection_formats['member_names'] = 'csv'
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'token' in params:
            query_params.append(('token', params['token']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies/file-system-snapshots', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolicyMemberResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_policy_filesystems(self, **kwargs):
        """
        List policy attached to filesystems.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_policy_filesystems(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :param str filter: The filter to be used for query.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param int limit: limit, should be >= 0
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: PolicyMemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_policy_filesystems_with_http_info(**kwargs)
        else:
            (data) = self.list_policy_filesystems_with_http_info(**kwargs)
            return data

    def list_policy_filesystems_with_http_info(self, **kwargs):
        """
        List policy attached to filesystems.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_policy_filesystems_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :param str filter: The filter to be used for query.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param int limit: limit, should be >= 0
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: PolicyMemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_ids', 'policy_names', 'member_ids', 'member_names', 'filter', 'sort', 'start', 'limit', 'token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_policy_filesystems" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'member_names' in params:
            query_params.append(('member_names', params['member_names']))
            collection_formats['member_names'] = 'csv'
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'token' in params:
            query_params.append(('token', params['token']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies/file-systems', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolicyMemberResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def list_policy_members(self, **kwargs):
        """
        List policy attached to filesystems and filesystem snapshots.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_policy_members(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :param list[str] member_types: A list of member types.
        :param str filter: The filter to be used for query.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param int limit: limit, should be >= 0
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: PolicyMemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.list_policy_members_with_http_info(**kwargs)
        else:
            (data) = self.list_policy_members_with_http_info(**kwargs)
            return data

    def list_policy_members_with_http_info(self, **kwargs):
        """
        List policy attached to filesystems and filesystem snapshots.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_policy_members_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] policy_ids: A comma-separated list of policy IDs. This cannot be provided together with the policy names query parameters.
        :param list[str] policy_names: A comma-separated list of policy names. This cannot be provided together with the policy ids query parameters.
        :param list[str] member_ids: A comma-separated list of member ids. This cannot be provided together with the member names query parameters.
        :param list[str] member_names: A comma-separated list of member names. This cannot be provided together with the member ids query parameters.
        :param list[str] member_types: A list of member types.
        :param str filter: The filter to be used for query.
        :param str sort: Sort the response by the specified fields (in descending order if '-' is appended to the field name).
        :param int start: The offset of the first resource to return from a collection.
        :param int limit: limit, should be >= 0
        :param str token: An opaque token used to iterate over a collection. The token to use on the next request is returned in the `continuation_token` field of the result.
        :return: PolicyMemberResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_ids', 'policy_names', 'member_ids', 'member_names', 'member_types', 'filter', 'sort', 'start', 'limit', 'token']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_policy_members" % key
                )
            params[key] = val
        del params['kwargs']


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'policy_ids' in params:
            query_params.append(('policy_ids', params['policy_ids']))
            collection_formats['policy_ids'] = 'csv'
        if 'policy_names' in params:
            query_params.append(('policy_names', params['policy_names']))
            collection_formats['policy_names'] = 'csv'
        if 'member_ids' in params:
            query_params.append(('member_ids', params['member_ids']))
            collection_formats['member_ids'] = 'csv'
        if 'member_names' in params:
            query_params.append(('member_names', params['member_names']))
            collection_formats['member_names'] = 'csv'
        if 'member_types' in params:
            query_params.append(('member_types', params['member_types']))
            collection_formats['member_types'] = 'csv'
        if 'filter' in params:
            query_params.append(('filter', params['filter']))
        if 'sort' in params:
            query_params.append(('sort', params['sort']))
        if 'start' in params:
            query_params.append(('start', params['start']))
        if 'limit' in params:
            query_params.append(('limit', params['limit']))
        if 'token' in params:
            query_params.append(('token', params['token']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies/members', 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolicyMemberResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def update_policies(self, policy_patch, **kwargs):
        """
        Update an existing policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_policies(policy_patch, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PolicyPatch policy_patch: The attribute map used to update the policy. (required)
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :param bool destroy_snapshots: This parameter must be set to `true` in order to remove rules from policy. Setting this parameter to `true` is acknowledgement that some of the snapshots managed by this policy will be destroyed.
        :return: PolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.update_policies_with_http_info(policy_patch, **kwargs)
        else:
            (data) = self.update_policies_with_http_info(policy_patch, **kwargs)
            return data

    def update_policies_with_http_info(self, policy_patch, **kwargs):
        """
        Update an existing policy.
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.update_policies_with_http_info(policy_patch, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PolicyPatch policy_patch: The attribute map used to update the policy. (required)
        :param list[str] names: A comma-separated list of resource names. This cannot be provided together with the ids query parameters.
        :param bool destroy_snapshots: This parameter must be set to `true` in order to remove rules from policy. Setting this parameter to `true` is acknowledgement that some of the snapshots managed by this policy will be destroyed.
        :return: PolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['policy_patch', 'names', 'destroy_snapshots']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_policies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'policy_patch' is set
        if ('policy_patch' not in params) or (params['policy_patch'] is None):
            raise ValueError("Missing the required parameter `policy_patch` when calling `update_policies`")


        collection_formats = {}

        path_params = {}

        query_params = []
        if 'names' in params:
            query_params.append(('names', params['names']))
            collection_formats['names'] = 'csv'
        if 'destroy_snapshots' in params:
            query_params.append(('destroy_snapshots', params['destroy_snapshots']))

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'policy_patch' in params:
            body_params = params['policy_patch']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['AuthTokenHeader']

        return self.api_client.call_api('/1.11/policies', 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='PolicyResponse',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
