/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Arrays;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLLiteralImpl
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLLiteral {
    private static final long serialVersionUID = 40000L;
    private static final int COMPRESSION_LIMIT = 160;
    private final LiteralWrapper literal;
    @Nonnull
    private static final OWLDatatype RDF_PLAIN_LITERAL = new OWL2DatatypeImpl(OWL2Datatype.RDF_PLAIN_LITERAL);
    @Nonnull
    private final OWLDatatype datatype;
    @Nonnull
    private final String language;
    private final int hashcode;

    @Override
    protected int index() {
        return 4008;
    }

    public OWLLiteralImpl(@Nonnull String literal, @Nullable String lang, @Nullable OWLDatatype datatype) {
        this.literal = new LiteralWrapper((String)OWLAPIPreconditions.checkNotNull((Object)literal, (String)"literal cannot be null"));
        if (lang == null || lang.isEmpty()) {
            this.language = "";
            this.datatype = datatype == null ? RDF_PLAIN_LITERAL : datatype;
        } else {
            if (datatype != null && !datatype.isRDFPlainLiteral()) {
                throw new OWLRuntimeException("Error: cannot build a literal with type: " + datatype.getIRI() + " and language: " + lang);
            }
            this.language = lang;
            this.datatype = RDF_PLAIN_LITERAL;
        }
        this.hashcode = this.getHashCode();
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this.datatype);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    public String getLiteral() {
        return this.literal.get();
    }

    public boolean isRDFPlainLiteral() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.RDF_PLAIN_LITERAL.getIRI());
    }

    public boolean hasLang() {
        return !this.language.isEmpty();
    }

    public boolean isInteger() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.XSD_INTEGER.getIRI());
    }

    public int parseInteger() {
        return Integer.parseInt(this.literal.get());
    }

    public boolean isBoolean() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.XSD_BOOLEAN.getIRI());
    }

    public boolean parseBoolean() {
        if (this.literal.get().equals("0")) {
            return false;
        }
        if (this.literal.get().equals("1")) {
            return true;
        }
        if (this.literal.get().equals("true")) {
            return true;
        }
        if (this.literal.get().equals("false")) {
            return false;
        }
        return false;
    }

    public boolean isDouble() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.XSD_DOUBLE.getIRI());
    }

    public double parseDouble() {
        return Double.parseDouble(this.literal.get());
    }

    public boolean isFloat() {
        return this.datatype.getIRI().equals((Object)OWL2Datatype.XSD_FLOAT.getIRI());
    }

    public float parseFloat() {
        return Float.parseFloat(this.literal.get());
    }

    public String getLang() {
        return this.language;
    }

    public boolean hasLang(String lang) {
        if (lang == null) {
            return this.language.isEmpty();
        }
        return this.language.equalsIgnoreCase(lang.trim());
    }

    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private final int getHashCode() {
        int code = 277;
        code = code * 37 + this.getDatatype().hashCode();
        code *= 37;
        code = this.literal.l != null ? (code += this.literal.l.hashCode()) : (code += Arrays.hashCode(this.literal.bytes));
        if (this.hasLang()) {
            code = code * 37 + this.getLang().hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLLiteral)) {
            return false;
        }
        OWLLiteral other = (OWLLiteral)obj;
        return this.literal.get().equals(other.getLiteral()) && this.datatype.equals(other.getDatatype()) && this.language.equals(other.getLang());
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.literal.get().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        diff = this.datatype.compareTo((Object)other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.language.compareTo(other.getLang());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public Optional<IRI> asIRI() {
        return Optional.absent();
    }

    public Optional<OWLAnonymousIndividual> asAnonymousIndividual() {
        return Optional.absent();
    }

    public Optional<OWLLiteral> asLiteral() {
        return Optional.of((Object)this);
    }

    private static class LiteralWrapper
    implements Serializable {
        private static final long serialVersionUID = 40000L;
        String l;
        byte[] bytes;
        private static final String COMPRESSED_ENCODING = "UTF-16";

        LiteralWrapper(String s) {
            if (s.length() > 160) {
                try {
                    this.bytes = LiteralWrapper.compress(s);
                    this.l = null;
                }
                catch (IOException e) {
                    this.l = s;
                    this.bytes = null;
                }
            } else {
                this.bytes = null;
                this.l = s;
            }
        }

        @Nonnull
        String get() {
            if (this.l != null) {
                return (String)OWLAPIPreconditions.verifyNotNull((Object)this.l);
            }
            try {
                return LiteralWrapper.decompress(this.bytes);
            }
            catch (IOException e) {
                throw new OWLRuntimeException((Throwable)e);
            }
        }

        @Nonnull
        static byte[] compress(String s) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream zipout = new GZIPOutputStream(out);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipout, COMPRESSED_ENCODING);
            writer.write(s);
            ((Writer)writer).flush();
            zipout.finish();
            zipout.flush();
            return out.toByteArray();
        }

        @Nonnull
        static String decompress(byte[] result) throws IOException {
            ByteArrayInputStream in = new ByteArrayInputStream(result);
            GZIPInputStream zipin = new GZIPInputStream(in);
            InputStreamReader reader = new InputStreamReader((InputStream)zipin, COMPRESSED_ENCODING);
            StringBuilder b = new StringBuilder();
            int c = ((Reader)reader).read();
            while (c > -1) {
                b.append((char)c);
                c = ((Reader)reader).read();
            }
            return b.toString();
        }
    }
}

