/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.AbstractAxiomLoader;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.owlapi.wrapper.OwlConverter;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;

public class OwlOntologyLoader
extends AbstractAxiomLoader
implements AxiomLoader {
    private static final Logger LOGGER_ = Logger.getLogger(OwlOntologyLoader.class);
    private static final OwlConverter OWL_CONVERTER_ = OwlConverter.getInstance();
    private final OWLOntology owlOntology_;
    private final ProgressMonitor progressMonitor_;
    private String status;
    private Iterator<OWLOntology> importsClosureIterator_;
    private int importsClosureCount_;
    private int importsClosureProcessed_;
    private Iterator<OWLAxiom> axiomsIterator_;
    private int axiomsCount_;
    private int axiomsProcessed_;

    public OwlOntologyLoader(OWLOntology owlOntology, ProgressMonitor progressMonitor) {
        this.owlOntology_ = owlOntology;
        this.progressMonitor_ = progressMonitor;
        this.initImportsClosure();
    }

    public void load(ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) {
        this.progressMonitor_.start(this.status);
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace((Object)this.status);
        }
        while (!this.isInterrupted()) {
            if (!this.axiomsIterator_.hasNext()) {
                ++this.importsClosureProcessed_;
                if (!this.importsClosureIterator_.hasNext()) break;
                this.progressMonitor_.finish();
                this.updateStatus();
                this.progressMonitor_.start(this.status);
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace((Object)this.status);
                }
                this.initAxioms(this.importsClosureIterator_.next());
                continue;
            }
            OWLAxiom axiom = this.axiomsIterator_.next();
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace((Object)("loading " + axiom));
            }
            if (OWL_CONVERTER_.isRelevantAxiom(axiom)) {
                axiomInserter.visit(OWL_CONVERTER_.convert(axiom));
            }
            ++this.axiomsProcessed_;
            this.progressMonitor_.report(this.axiomsProcessed_, this.axiomsCount_);
        }
        this.progressMonitor_.finish();
    }

    public boolean isLoadingFinished() {
        return this.axiomsIterator_ == null && this.importsClosureIterator_ == null;
    }

    public void dispose() {
        this.importsClosureIterator_ = null;
        this.importsClosureProcessed_ = 0;
        this.axiomsIterator_ = null;
        this.axiomsProcessed_ = 0;
    }

    private void initImportsClosure() {
        Set importsClosure = this.owlOntology_.getImportsClosure();
        this.importsClosureIterator_ = importsClosure.iterator();
        this.importsClosureCount_ = importsClosure.size();
        this.importsClosureProcessed_ = 0;
        this.updateStatus();
        if (this.importsClosureIterator_.hasNext()) {
            this.initAxioms(this.importsClosureIterator_.next());
        } else {
            this.axiomsIterator_ = Collections.emptySet().iterator();
        }
    }

    private void initAxioms(OWLOntology ontology) {
        Set axioms = ontology.getAxioms();
        this.axiomsIterator_ = axioms.iterator();
        this.axiomsCount_ = axioms.size();
        this.axiomsProcessed_ = 0;
    }

    private void updateStatus() {
        this.status = this.importsClosureCount_ == 1 ? "Loading" : "Loading " + (this.importsClosureProcessed_ + 1) + " of " + this.importsClosureCount_;
    }
}

