/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap_lite;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.parameters.Imports;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public class OntologyLoader {
    protected OWLDataFactory dataFactory;
    protected OWLOntologyManager managerOnto;
    protected OWLOntology onto;
    protected String iri_onto_str;
    protected int size_signature;
    protected int size_classes;
    protected Set<OWLAxiom> axiomSet = new HashSet<OWLAxiom>();

    public OntologyLoader(String phy_iri_onto) throws OWLOntologyCreationException {
        this.managerOnto = SynchronizedOWLManager.createOWLOntologyManager();
        this.dataFactory = this.managerOnto.getOWLDataFactory();
        OWLOntologyLoaderConfiguration config = new OWLOntologyLoaderConfiguration();
        config = config.setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT);
        this.managerOnto.setOntologyLoaderConfiguration(config);
        this.loadOWLOntology(phy_iri_onto);
    }

    private String getURIFromClasses() {
        Iterator iterator = this.onto.getClassesInSignature().iterator();
        if (iterator.hasNext()) {
            OWLClass cls = (OWLClass)iterator.next();
            return Utilities.getNameSpaceFromURI(cls.getIRI().toString());
        }
        return "http://logmap.cs.ox.ac.uk/ontology.owl";
    }

    public void loadOWLOntology(String phy_iri_onto) throws OWLOntologyCreationException {
        try {
            this.onto = this.managerOnto.loadOntology(IRI.create((String)phy_iri_onto));
            this.iri_onto_str = this.onto.getOntologyID().getOntologyIRI() != null ? this.onto.getOntologyID().getOntologyIRI().toString() : this.getURIFromClasses();
            LogOutput.print("IRI: " + this.iri_onto_str);
            this.size_signature = this.onto.getSignature(Imports.INCLUDED).size();
            this.size_classes = this.onto.getClassesInSignature(Imports.INCLUDED).size();
        }
        catch (Exception e) {
            System.err.println("Error loading OWL ontology: " + e.getMessage());
            e.printStackTrace();
            throw new OWLOntologyCreationException();
        }
    }

    public void createAxiomSet() {
        this.axiomSet.addAll(this.onto.getAxioms());
    }

    public void clearAxiomSet() {
        this.axiomSet.clear();
    }

    public Set<OWLAxiom> getAxiomSet() {
        return this.axiomSet;
    }

    public void clearOntology() {
        this.managerOnto.removeOntology(this.onto);
        this.onto = null;
        this.managerOnto = null;
    }

    public OWLOntology getOWLOntology() {
        return this.onto;
    }

    public String getOntologyIRIStr() {
        return this.iri_onto_str;
    }

    public IRI getOntologyIRI() {
        return IRI.create((String)this.iri_onto_str);
    }

    public Set<OWLClass> getClassesInSignature() {
        return this.onto.getClassesInSignature();
    }

    public int getSignatureSize() {
        return this.size_signature;
    }

    public int getClassesInSignatureSize() {
        return this.size_classes;
    }

    public void applyChanges(List<OWLOntologyChange> listchanges) {
        this.managerOnto.applyChanges(listchanges);
    }

    public OWLDataFactory getDataFactory() {
        return this.dataFactory;
    }

    public void saveOntology(String phy_iri_onto) throws Exception {
        this.managerOnto.saveOntology(this.onto, (OWLDocumentFormat)new RDFXMLDocumentFormat(), IRI.create((String)phy_iri_onto));
    }
}

