/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.utilities;

import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import uk.ac.ox.krr.logmap2.mappings.objects.MappingObjectStr;
import uk.ac.ox.krr.logmap2.utilities.Relation;

public class HashAlignment {
    private HashMap<String, HashMap<String, Vector<Relation>>> alignment = new HashMap();
    private int size = 0;

    public HashAlignment() {
    }

    public HashAlignment(HashAlignment other) {
        this();
        for (String source : other.alignment.keySet()) {
            for (String target : other.alignment.get(source).keySet()) {
                for (Relation r : other.alignment.get(source).get(target)) {
                    this.add(source, target, r);
                }
            }
        }
    }

    public HashAlignment(Set<MappingObjectStr> mappings) {
        this();
        for (MappingObjectStr mapping : mappings) {
            if (mapping.getMappingDirection() == -2) {
                this.add(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), Relation.EQUIVALENCE);
                continue;
            }
            if (mapping.getMappingDirection() == 0) {
                this.add(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), Relation.SUBSUMED_BY);
                continue;
            }
            if (mapping.getMappingDirection() == -1) {
                this.add(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), Relation.SUBSUMES);
                continue;
            }
            this.add(mapping.getIRIStrEnt1(), mapping.getIRIStrEnt2(), Relation.UNKNOWN);
        }
    }

    public void add(String uri1, String uri2, Relation r) {
        if (this.contains(uri1, uri2, r)) {
            return;
        }
        ++this.size;
        if (this.contains(uri1, uri2)) {
            this.alignment.get(uri1).get(uri2).add(r);
        } else if (this.contains(uri2, uri1)) {
            this.alignment.get(uri2).get(uri1).add(r.reverse());
        } else {
            Vector<Relation> rel = new Vector<Relation>();
            rel.add(r);
            if (this.alignment.containsKey(uri1)) {
                this.alignment.get(uri1).put(uri2, rel);
            } else {
                HashMap<String, Vector<Relation>> map = new HashMap<String, Vector<Relation>>();
                map.put(uri2, rel);
                this.alignment.put(uri1, map);
            }
        }
    }

    public void add(HashAlignment other) {
        for (String source : other.alignment.keySet()) {
            for (String target : other.alignment.get(source).keySet()) {
                for (Relation r : other.alignment.get(source).get(target)) {
                    this.add(source, target, r);
                }
            }
        }
    }

    public boolean contains(String uri1, String uri2) {
        return this.alignment.containsKey(uri1) && this.alignment.get(uri1).containsKey(uri2);
    }

    public boolean contains(String uri1, String uri2, Relation r) {
        return this.alignment.containsKey(uri1) && this.alignment.get(uri1).containsKey(uri2) && this.alignment.get(uri1).get(uri2).contains((Object)r) || this.alignment.containsKey(uri2) && this.alignment.get(uri2).containsKey(uri1) && this.alignment.get(uri2).get(uri1).contains((Object)r.reverse());
    }

    public int[] evaluation(HashAlignment other) {
        int[] eval = new int[]{0, other.size(), 0};
        for (String source : this.alignment.keySet()) {
            for (String target : this.alignment.get(source).keySet()) {
                if (this.alignment.get(source).get(target).contains((Object)Relation.UNKNOWN)) {
                    if (!other.contains(source, target)) continue;
                    eval[1] = eval[1] - 1;
                    continue;
                }
                for (Relation r : this.alignment.get(source).get(target)) {
                    if (other.contains(source, target, r)) {
                        eval[0] = eval[0] + 1;
                        continue;
                    }
                    eval[2] = eval[2] + 1;
                }
            }
        }
        eval[1] = eval[1] - eval[0];
        return eval;
    }

    public Set<String> getSources() {
        return this.alignment.keySet();
    }

    public Set<String> getTargets(String source) {
        if (this.alignment.containsKey(source)) {
            return this.alignment.get(source).keySet();
        }
        return null;
    }

    public Vector<Relation> getRelations(String source, String target) {
        if (this.alignment.containsKey(source) && this.alignment.get(source).containsKey(target)) {
            return this.alignment.get(source).get(target);
        }
        return null;
    }

    public void remove(String uri1, String uri2, Relation r) {
        if (this.alignment.containsKey(uri1) && this.alignment.get(uri1).containsKey(uri2) && this.alignment.get(uri1).get(uri2).contains((Object)r)) {
            if (r != Relation.UNKNOWN) {
                --this.size;
            }
            this.alignment.get(uri1).get(uri2).remove((Object)r);
            if (this.alignment.get(uri1).get(uri2).isEmpty()) {
                this.alignment.get(uri1).remove(uri2);
            }
            if (this.alignment.get(uri1).isEmpty()) {
                this.alignment.remove(uri1);
            }
        } else if (this.alignment.containsKey(uri2) && this.alignment.get(uri2).containsKey(uri1) && this.alignment.get(uri2).get(uri1).contains((Object)r.reverse())) {
            if (r != Relation.UNKNOWN) {
                --this.size;
            }
            this.alignment.get(uri2).get(uri1).remove((Object)r.reverse());
            if (this.alignment.get(uri2).get(uri1).isEmpty()) {
                this.alignment.get(uri2).remove(uri1);
            }
            if (this.alignment.get(uri2).isEmpty()) {
                this.alignment.remove(uri2);
            }
        }
    }

    public int size() {
        return this.size;
    }
}

