/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.repair.hornSAT;

import java.util.HashSet;
import java.util.Set;

public class HornClause {
    private int labelh;
    private int labelh_pair = -1;
    private Set<Integer> leftHandSideSet = new HashSet<Integer>();
    private int leftHandSide1;
    private int leftHandSide2;
    private int rightHandSide;
    private int origin;
    private int dirImplication;
    public static final int MAP = 0;
    public static final int ONTO = 1;
    public static final int FIXEDMAP = 3;
    public static final int L2R = 0;
    public static final int R2L = -1;
    private int TRUE = -1;
    private int FALSE = -2;

    public HornClause(int leftHS1, int rightHS, int label, int type) {
        this(leftHS1, rightHS, label, type, 0);
    }

    public HornClause(int leftHS1, int rightHS, int label, int type, int dir) {
        this.labelh = label;
        this.leftHandSide1 = leftHS1;
        this.leftHandSide2 = this.TRUE;
        this.rightHandSide = rightHS;
        this.origin = type;
        this.dirImplication = dir;
    }

    public HornClause(int leftHS1, int leftHS2, int rightHS, int label, int type, int dir) {
        this.labelh = label;
        this.leftHandSide1 = leftHS1;
        this.leftHandSide2 = leftHS2;
        this.rightHandSide = rightHS;
        this.origin = type;
        this.dirImplication = dir;
    }

    public HornClause(Set<Integer> leftHS_set, int rightHS, int label, int type, int dir) {
        this.labelh = label;
        this.leftHandSideSet = leftHS_set;
        this.rightHandSide = rightHS;
        this.origin = type;
        this.dirImplication = dir;
    }

    public int getLabel() {
        return this.labelh;
    }

    public int getLabelPair() {
        return this.labelh_pair;
    }

    public void setLabelPair(int label) {
        this.labelh_pair = label;
    }

    public Set<Integer> getLeftHSSet() {
        return this.leftHandSideSet;
    }

    public int getLeftHS1() {
        return this.leftHandSide1;
    }

    public int getLeftHS2() {
        return this.leftHandSide2;
    }

    public int getRightHS() {
        return this.rightHandSide;
    }

    public int getOrigin() {
        return this.origin;
    }

    public int getDirImplication() {
        return this.dirImplication;
    }

    public String toString() {
        String str = "";
        int LHS2 = this.TRUE;
        int RHS = this.FALSE;
        if (this.leftHandSideSet.size() > 0) {
            RHS = this.rightHandSide;
            for (int lhs : this.leftHandSideSet) {
                str = str + lhs + "^";
            }
        } else {
            int LHS1 = this.leftHandSide1;
            if (this.origin == 1) {
                LHS2 = this.leftHandSide2;
                RHS = this.rightHandSide;
            } else if ((this.origin == 0 || this.origin == 3) && this.rightHandSide > this.FALSE) {
                RHS = this.rightHandSide;
            }
            str = String.valueOf(LHS1);
            if (LHS2 > this.TRUE) {
                str = str + "^" + LHS2;
            }
        }
        str = this.dirImplication == 0 ? str + " -> " + RHS + " (" + this.origin + ") (" + this.labelh + ")" : str + " <- " + RHS + " (" + this.origin + ") (" + this.labelh + ")";
        return str;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof HornClause)) {
            return false;
        }
        HornClause hc = (HornClause)o;
        return this.equals(hc);
    }

    public boolean equals(HornClause hc) {
        return !(this.leftHandSideSet.size() > 0 ? this.leftHandSideSet.equals(hc.getLeftHSSet()) || this.rightHandSide != hc.getRightHS() || this.dirImplication != hc.getDirImplication() : this.leftHandSide1 != hc.getLeftHS1() || this.leftHandSide2 != hc.getLeftHS2() || this.rightHandSide != hc.getRightHS() || this.dirImplication != hc.getDirImplication());
    }

    public int hashCode() {
        int code = 10;
        if (this.leftHandSideSet.size() > 0) {
            code = 50 * code + this.leftHandSideSet.hashCode();
        } else {
            code = 50 * code + this.leftHandSide1;
            code = 60 * code + this.leftHandSide2;
        }
        code = 70 * code + this.rightHandSide;
        code = 90 * code + this.dirImplication;
        return code;
    }

    public static void main(String[] args) {
        HashSet<HornClause> set1 = new HashSet<HornClause>();
        HashSet<HornClause> set2 = new HashSet<HornClause>();
        HornClause h1 = new HornClause(45, 1902, 1, 0, 0);
        HornClause h2 = new HornClause(45, 1902, 3, 0, 0);
        set1.add(h1);
        set2.add(h2);
        System.out.println(h1.equals(h2));
        System.out.println(h2.equals(h1));
        System.out.println(set2.contains(h1));
        System.out.println(set1.contains(h2));
    }
}

