/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.multilingual;

import java.io.FileNotFoundException;
import java.util.Vector;
import uk.ac.ox.krr.logmap2.Parameters;
import uk.ac.ox.krr.logmap2.multilingual.GoogleBasedTranslator;
import uk.ac.ox.krr.logmap2.multilingual.MicrosoftBasedTranslator;
import uk.ac.ox.krr.logmap2.multilingual.Translator;

public class TranslatorManager {
    public static final int GOOGLE_BASED_TRANSLATOR = 0;
    public static final int MICROSOFT_BASED_TRANSLATOR = 1;
    public static final int ALL_TRANSLATORS = 9;
    public static int CURRENT_TRANSLATOR = 0;
    private Vector<Translator> translators = new Vector();

    public TranslatorManager() {
        this(9);
    }

    public TranslatorManager(int translator_id) {
        switch (translator_id) {
            case 0: {
                this.translators.add(new GoogleBasedTranslator());
                break;
            }
            case 1: {
                this.translators.add(new MicrosoftBasedTranslator());
                break;
            }
            default: {
                this.translators.add(new GoogleBasedTranslator());
                this.translators.add(new MicrosoftBasedTranslator());
            }
        }
    }

    public void loadDictionary(String language) throws FileNotFoundException {
        for (Translator translator : this.translators) {
            translator.loadDictionary(language);
        }
    }

    public void storeDictionary(String language) {
        for (Translator translator : this.translators) {
            translator.storeDictionary(language);
        }
    }

    public void reverseDictionary(String originLang, String targetLang) {
        for (Translator translator : this.translators) {
            translator.reverseDictionary(originLang, targetLang);
        }
    }

    public int getNumberOfTranslatedCharacters() {
        int translated_chars = 0;
        for (Translator translator : this.translators) {
            translated_chars += translator.getNumberOfTranslatedCharacters();
        }
        return translated_chars;
    }

    public int getNumberOfTranslateCalls() {
        int num_calls = 0;
        for (Translator translator : this.translators) {
            num_calls += translator.getNumberOfTranslateCalls();
        }
        return num_calls;
    }

    public String getTranslation(String label, String originLang) {
        StringBuilder translation = new StringBuilder();
        for (Translator translator : this.translators) {
            if (translation.toString().length() > 0) {
                translation.append("|");
            }
            translation.append(translator.getTranslation(label, originLang, Parameters.target_lang));
        }
        return translation.toString();
    }

    public static Translator getTranslatorObject(int translator_id) {
        switch (translator_id) {
            case 0: {
                return new GoogleBasedTranslator();
            }
            case 1: {
                return new MicrosoftBasedTranslator();
            }
        }
        return new GoogleBasedTranslator();
    }

    public static Translator getCurrentTranslatorObject() {
        return TranslatorManager.getTranslatorObject(CURRENT_TRANSLATOR);
    }

    public static void setCurrentTranslator(int translator) {
        CURRENT_TRANSLATOR = translator;
    }

    public static void main(String[] args) {
        TranslatorManager manager = new TranslatorManager();
        manager.reverseDictionary("en", "it");
    }
}

