/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.indexing;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import uk.ac.ox.krr.logmap2.indexing.Comparator4String2Int;
import uk.ac.ox.krr.logmap2.indexing.entities.ClassIndex;
import uk.ac.ox.krr.logmap2.indexing.entities.DataPropertyIndex;
import uk.ac.ox.krr.logmap2.indexing.entities.IndividualIndex;
import uk.ac.ox.krr.logmap2.indexing.entities.ObjectPropertyIndex;
import uk.ac.ox.krr.logmap2.indexing.labelling_schema.Interval;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;
import uk.ac.ox.krr.logmap2.reasoning.ReasonerAccess;
import uk.ac.ox.krr.logmap2.utilities.Lib;
import uk.ac.ox.krr.logmap2.utilities.Pair;
import uk.ac.ox.krr.logmap2.utilities.Utilities;

public abstract class IndexManager {
    protected Map<String, Set<Integer>> singleWordInvertedIndex = new HashMap<String, Set<Integer>>();
    protected int calls_tax_question = 0;
    protected int calls_disj_question = 0;
    protected int unknown_disj_question = 0;
    protected double time_tax_question = 0.0;
    protected double time_disj_question = 0.0;
    protected long init;
    protected long fin;
    protected Map<Integer, ClassIndex> identifier2ClassIndex = new HashMap<Integer, ClassIndex>();
    protected Map<Integer, DataPropertyIndex> identifier2DataPropIndex = new HashMap<Integer, DataPropertyIndex>();
    protected Map<Integer, ObjectPropertyIndex> identifier2ObjPropIndex = new HashMap<Integer, ObjectPropertyIndex>();
    protected Map<Integer, IndividualIndex> identifier2IndividualIndex = new HashMap<Integer, IndividualIndex>();
    protected Set<Integer> identifiersInModule = new HashSet<Integer>();
    protected Map<Integer, Integer> preOrderAnc2Identifier = new HashMap<Integer, Integer>();
    protected Map<Integer, Integer> preOrderDesc2Identifier = new HashMap<Integer, Integer>();
    protected Map<Interval, Set<Interval>> interval2disjointIntervals = new HashMap<Interval, Set<Interval>>();
    protected Set<Integer> unsatisfiableClassesILS = new HashSet<Integer>();
    protected Map<Integer, String> identifier2IRIOnto = new HashMap<Integer, String>();
    protected OWLDataFactory factory = SynchronizedOWLManager.createOWLDataFactory();
    protected Set<Integer> RootIdentifiers = new HashSet<Integer>();
    protected Set<Integer> representativeNodes = new HashSet<Integer>();
    protected Map<Set<Integer>, Integer> generalHornAxioms = new HashMap<Set<Integer>, Integer>();
    public Set<Integer> dangerousClasses = new HashSet<Integer>();
    private Set<Integer> allowedInstanceTypes = new HashSet<Integer>();
    private int class_indiv_ident = 0;
    private int dprop_ident = 0;
    private int oprop_ident = 0;
    private int onto_ident = 0;
    protected HashMap<Integer, Set<Integer>> ident2DirectSubClasses_integration;
    protected Set<Integer> representativesFromMappings;
    private Map<Integer, Set<Integer>> ident2equivalents = new HashMap<Integer, Set<Integer>>();
    private Map<Integer, Set<Integer>> ident2subclasses_module = new HashMap<Integer, Set<Integer>>();
    private Map<Integer, Set<Integer>> ident2superclasses_module = new HashMap<Integer, Set<Integer>>();
    private Map<Integer, Set<Integer>> ident2subclasses = new HashMap<Integer, Set<Integer>>();
    private Map<Integer, Set<Integer>> ident2superclasses = new HashMap<Integer, Set<Integer>>();
    private Map<Integer, Set<Integer>> individual2classTypes = new HashMap<Integer, Set<Integer>>();
    private Map<Integer, Set<Integer>> ident2disjointclasses = new HashMap<Integer, Set<Integer>>();

    public int getNumberOfTaxCalls() {
        return this.calls_tax_question;
    }

    public int getNumberOfDisjCalls() {
        return this.calls_disj_question;
    }

    public int getNumberOfUnknownDisjCalls() {
        return this.unknown_disj_question;
    }

    public double getTime4TaxCalls() {
        return this.time_tax_question;
    }

    public double getTime4DisjCalls() {
        return this.time_disj_question;
    }

    public double getAvgTime4TaxCalls() {
        return Utilities.getRoundValue(this.time_tax_question / (double)this.calls_tax_question, 4);
    }

    public double getAvgTime4DisjCalls() {
        return Utilities.getRoundValue(this.time_disj_question / (double)this.calls_tax_question, 4);
    }

    public void addWordOccurrence(String word, int ident) {
        Set<Integer> temp;
        if (this.singleWordInvertedIndex.containsKey(word)) {
            temp = this.singleWordInvertedIndex.get(word);
        } else {
            temp = new HashSet<Integer>();
            this.singleWordInvertedIndex.put(word, temp);
        }
        temp.add(ident);
    }

    public void printWordDistribution() {
        ArrayList<Pair<String, Integer>> word2frequency = new ArrayList<Pair<String, Integer>>();
        for (String word : this.singleWordInvertedIndex.keySet()) {
            int frequency = this.singleWordInvertedIndex.get(word).size();
            word2frequency.add(new Pair<String, Integer>(word, frequency));
        }
        Collections.sort(word2frequency, new Comparator4String2Int());
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("/auto/users/yzhou/word_distribution.txt")));
            writer.write(this.identifier2ClassIndex.size() + "\n");
            for (Pair pair : word2frequency) {
                writer.write((String)pair.getKey() + " " + pair.getValue() + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Lib.debuginfo("finished word distribution");
    }

    public Set<Integer> getCooccurrenceOfWords(Set<String> words) {
        Set<Integer> classList = null;
        Set<Integer> classList_temp = null;
        for (String word : words) {
            if (!this.singleWordInvertedIndex.containsKey(word)) continue;
            if (classList == null) {
                classList = new HashSet<Integer>();
                for (Integer ind : this.singleWordInvertedIndex.get(word)) {
                    classList.add(ind);
                }
                continue;
            }
            classList_temp = this.singleWordInvertedIndex.get(word);
            classList = this.intersectSet(classList, classList_temp);
        }
        return classList;
    }

    public Set<Integer> intersectSet(Set<Integer> list1, Set<Integer> list2) {
        if (list1 == null) {
            return list2;
        }
        if (list2 == null) {
            return list1;
        }
        HashSet<Integer> list = new HashSet<Integer>();
        for (Integer i : list1) {
            if (!list2.contains(i)) continue;
            list.add(i);
        }
        return list;
    }

    public void clearSingleWordInvertedIndex() {
        this.singleWordInvertedIndex.clear();
    }

    public void clearAlternativeLabels4Classes() {
        for (int ident : this.identifier2ClassIndex.keySet()) {
            if (!this.identifier2ClassIndex.get(ident).hasAlternativeLabels()) continue;
            this.identifier2ClassIndex.get(ident).deleteAltLabels();
        }
    }

    public void clearStemmedAlternativeLabels4Classes() {
        for (int ident : this.identifier2ClassIndex.keySet()) {
            if (!this.identifier2ClassIndex.get(ident).hasStemmedAlternativeLabels()) continue;
            this.identifier2ClassIndex.get(ident).deleteAltStemmedLabels();
        }
    }

    public void clearTaxonomicalStructures() {
        this.identifier2ClassIndex.clear();
        this.identifier2DataPropIndex.clear();
        this.identifier2ObjPropIndex.clear();
        this.identifier2IndividualIndex.clear();
        this.identifiersInModule.clear();
        this.interval2disjointIntervals.clear();
        this.unsatisfiableClassesILS.clear();
        this.preOrderAnc2Identifier.clear();
        this.preOrderDesc2Identifier.clear();
        this.RootIdentifiers.clear();
        this.generalHornAxioms.clear();
        this.representativeNodes.clear();
        this.ident2disjointclasses.clear();
        this.ident2equivalents.clear();
        this.ident2subclasses.clear();
        this.ident2subclasses_module.clear();
        this.ident2superclasses.clear();
        this.ident2superclasses_module.clear();
        this.ident2DirectSubClasses_integration.clear();
        this.individual2classTypes.clear();
    }

    public HashMap<Integer, Set<Integer>> getIdent2DirectSubClasses_Integration() {
        return this.ident2DirectSubClasses_integration;
    }

    public Set<Integer> getRepresentativesFromMappings() {
        return this.representativesFromMappings;
    }

    public void clearAuxStructuresforLabellingSchema() {
        this.ident2DirectSubClasses_integration.clear();
        this.representativesFromMappings.clear();
    }

    public Set<Integer> getDangerousClasses() {
        return this.dangerousClasses;
    }

    public void addDangerousClasses(int ide) {
        this.dangerousClasses.add(ide);
    }

    public Set<Integer> getAllowedInstanceTypes() {
        return this.allowedInstanceTypes;
    }

    public void setAllowedInstanceTypes(Set<Integer> allowedInstanceTypes) {
        this.allowedInstanceTypes = allowedInstanceTypes;
    }

    public void addAllowedInstanceType(int type_id) {
        this.allowedInstanceTypes.add(type_id);
    }

    public void printDirectDisjointness() {
        for (int icls : this.identifier2ClassIndex.keySet()) {
            if (!this.identifier2ClassIndex.get(icls).hasDirectDisjointClasses()) continue;
            LogOutput.print(this.identifier2ClassIndex.get(icls).getEntityName() + ": " + this.identifier2ClassIndex.get(icls).getNode().getDescIntervals());
            for (int disjcls : this.identifier2ClassIndex.get(icls).getDisjointClasses()) {
                LogOutput.print("\t" + this.identifier2ClassIndex.get(disjcls).getEntityName() + ": " + this.identifier2ClassIndex.get(disjcls).getNode().getDescIntervals());
            }
        }
    }

    public abstract void setIntervalLabellingIndex(Map<Integer, Set<Integer>> var1);

    public void setJointReasoner(ReasonerAccess jointreasoner) {
    }

    public String getIRIStrOnto4Id(int id) {
        return this.identifier2IRIOnto.get(id);
    }

    public OWLDataFactory getFactory() {
        return this.factory;
    }

    public int addNewOntologyEntry(String iristr) {
        this.identifier2IRIOnto.put(this.onto_ident, iristr);
        ++this.onto_ident;
        return this.onto_ident - 1;
    }

    public int addNewClassEntry() {
        this.identifier2ClassIndex.put(this.class_indiv_ident, new ClassIndex(this.class_indiv_ident));
        ++this.class_indiv_ident;
        return this.class_indiv_ident - 1;
    }

    public void setOntologyId4Class(int ident, int id) {
        this.identifier2ClassIndex.get(ident).setOntologyId(id);
    }

    public void setClassName(int ident, String name) {
        this.identifier2ClassIndex.get(ident).setEntityName(name);
    }

    public void setClassNamespace(int ident, String ns_ent) {
        this.identifier2ClassIndex.get(ident).setNamespace(ns_ent);
    }

    public void setClassLabel(int ident, String label) {
        this.identifier2ClassIndex.get(ident).setLabel(label);
    }

    public void addAlternativeClassLabel(int ident, String altlabel) {
        this.identifier2ClassIndex.get(ident).addAlternativeLabel(altlabel);
    }

    public void addStemmedAltClassLabel(int ident, String label) {
        this.identifier2ClassIndex.get(ident).addStemmedAltLabel(label);
    }

    public void addRoot2Structure(int ide_root) {
        this.RootIdentifiers.add(ide_root);
    }

    public Set<Integer> getRootIdentifiers() {
        return this.RootIdentifiers;
    }

    public void addRepresentativeNode(int ide_rep) {
        this.representativeNodes.add(ide_rep);
    }

    public Set<Integer> getRepresentativeNodes() {
        return this.representativeNodes;
    }

    public void addGeneralHornAxiom2Structure(Set<Integer> body, int head) {
        if (!this.generalHornAxioms.containsKey(body)) {
            this.generalHornAxioms.put(new HashSet<Integer>(body), head);
        }
    }

    public Map<Set<Integer>, Integer> getGeneralHornAxiom() {
        return this.generalHornAxioms;
    }

    public int addNewIndividualEntry() {
        this.identifier2IndividualIndex.put(this.class_indiv_ident, new IndividualIndex(this.class_indiv_ident));
        ++this.class_indiv_ident;
        return this.class_indiv_ident - 1;
    }

    public void setOntologyId4Individual(int ident, int id) {
        this.identifier2IndividualIndex.get(ident).setOntologyId(id);
    }

    public void setIndividualName(int ident, String name) {
        this.identifier2IndividualIndex.get(ident).setEntityName(name);
    }

    public void setIndividualNamespace(int ident, String ns_ent) {
        this.identifier2IndividualIndex.get(ident).setNamespace(ns_ent);
    }

    public void setIndividualLabel(int ident, String label) {
        this.identifier2IndividualIndex.get(ident).setLabel(label);
    }

    public void addAlternativeIndividualLabel(int ident, String altlabel) {
        this.identifier2IndividualIndex.get(ident).addAlternativeLabel(altlabel);
    }

    public int addNewDataPropertyEntry() {
        this.identifier2DataPropIndex.put(this.dprop_ident, new DataPropertyIndex(this.dprop_ident));
        ++this.dprop_ident;
        return this.dprop_ident - 1;
    }

    public void setOntologyId4DataProp(int ident, int id) {
        this.identifier2DataPropIndex.get(ident).setOntologyId(id);
    }

    public void setDataPropName(int ident, String name) {
        this.identifier2DataPropIndex.get(ident).setEntityName(name);
    }

    public void setDataPropNamespace(int ident, String ns_ent) {
        this.identifier2DataPropIndex.get(ident).setNamespace(ns_ent);
    }

    public void setDataPropLabel(int ident, String label) {
        this.identifier2DataPropIndex.get(ident).setLabel(label);
    }

    public void addDomainClass4DataProperty(int ident, int domain_ident) {
        this.identifier2DataPropIndex.get(ident).addDomainClassIndex(domain_ident);
    }

    public void addRangeType4DataProperty(int ident, String range) {
        this.identifier2DataPropIndex.get(ident).addRangeType(range);
    }

    public void addAlternativeDataPropertyLabel(int ident, String altlabel) {
        this.identifier2DataPropIndex.get(ident).addAlternativeLabel(altlabel);
    }

    public void addType4Individual(int ident, int type_class) {
        this.identifier2IndividualIndex.get(ident).addClassTypeIndex(type_class);
    }

    public void addCategory4Individual(int ident, String cat) {
        this.identifier2IndividualIndex.get(ident).addCategory(cat);
    }

    public void setShowInOutput4Individual(int ident, boolean showInOutput) {
        this.identifier2IndividualIndex.get(ident).setShowInOutput(showInOutput);
    }

    public void addReferencedIndividual4Individual(int ident, int ref_ident) {
        this.identifier2IndividualIndex.get(ident).addReferencedIndividuals(ref_ident);
    }

    public Set<Integer> getReferencedIndividuals4Individual(int ident) {
        return this.identifier2IndividualIndex.get(ident).getReferencedIndividuals();
    }

    public List<Integer> getCharactersitics4Individual(int ident) {
        return this.identifier2IndividualIndex.get(ident).getCharacteristics();
    }

    public void addCharactersitic4Individual(int ident, int value) {
        this.identifier2IndividualIndex.get(ident).addCharacteristic(value);
    }

    public int addNewObjectPropertyEntry() {
        this.identifier2ObjPropIndex.put(this.oprop_ident, new ObjectPropertyIndex(this.oprop_ident));
        ++this.oprop_ident;
        return this.oprop_ident - 1;
    }

    public void setOntologyId4ObjectProp(int ident, int id) {
        this.identifier2ObjPropIndex.get(ident).setOntologyId(id);
    }

    public void setObjectPropName(int ident, String name) {
        this.identifier2ObjPropIndex.get(ident).setEntityName(name);
    }

    public void setObjectPropNamespace(int ident, String ns_ent) {
        this.identifier2ObjPropIndex.get(ident).setNamespace(ns_ent);
    }

    public void setObjectPropLabel(int ident, String label) {
        this.identifier2ObjPropIndex.get(ident).setLabel(label);
    }

    public void addDomainClass4ObjectProperty(int ident, int domain_ident) {
        this.identifier2ObjPropIndex.get(ident).addDomainClassIndex(domain_ident);
    }

    public void addRangeClass4ObjectProperty(int ident, int range_ident) {
        this.identifier2ObjPropIndex.get(ident).addRangeClassIndex(range_ident);
    }

    public void addAlternativeObjectPropertyLabel(int ident, String altlabel) {
        this.identifier2ObjPropIndex.get(ident).addAlternativeLabel(altlabel);
    }

    public Map<Integer, ClassIndex> getIdentifier2ClassIndexMap() {
        return this.identifier2ClassIndex;
    }

    public Map<Integer, DataPropertyIndex> getIdentifier2DataPropIndexMap() {
        return this.identifier2DataPropIndex;
    }

    public Map<Integer, ObjectPropertyIndex> getIdentifier2ObjectPropIndexMap() {
        return this.identifier2ObjPropIndex;
    }

    public Map<Integer, IndividualIndex> getIdentifier2IndividualIndexMap() {
        return this.identifier2IndividualIndex;
    }

    public ClassIndex getClassIndex(int ident) {
        return this.identifier2ClassIndex.get(ident);
    }

    public DataPropertyIndex getDataPropertyIndex(int ident) {
        return this.identifier2DataPropIndex.get(ident);
    }

    public ObjectPropertyIndex getObjectPropertyIndex(int ident) {
        return this.identifier2ObjPropIndex.get(ident);
    }

    public IndividualIndex getIndividualIndex(int ident) {
        return this.identifier2IndividualIndex.get(ident);
    }

    public int getSizeIndexClasses() {
        return this.identifier2ClassIndex.size();
    }

    public int getSizeDataProperties() {
        return this.identifier2DataPropIndex.size();
    }

    public int getSizeObjectProperties() {
        return this.identifier2ObjPropIndex.size();
    }

    public int getSizeIndexIndividuals() {
        return this.identifier2IndividualIndex.size();
    }

    public Set<Integer> getDomainDataProp4Identifier(int index) {
        return this.identifier2DataPropIndex.get(index).getDomainClassIndexes();
    }

    public Set<Integer> getDomainObjProp4Identifier(int index) {
        return this.identifier2ObjPropIndex.get(index).getDomainClassIndexes();
    }

    public Set<String> getRangeDataProp4Identifier(int index) {
        return this.identifier2DataPropIndex.get(index).getRangeTypes();
    }

    public Set<Integer> getRangeObjProp4Identifier(int index) {
        return this.identifier2ObjPropIndex.get(index).getRangeClassIndexes();
    }

    public Set<Integer> getIndividualClassTypes4Identifier(int ident) {
        return this.identifier2IndividualIndex.get(ident).getClassTypes();
    }

    public Set<String> getIndividualCategory4Identifier(int ident) {
        return this.identifier2IndividualIndex.get(ident).getCategories();
    }

    public Set<Integer> getClassIdentifierSet() {
        return this.identifier2ClassIndex.keySet();
    }

    public Set<Integer> getDataPropIdentifierSet() {
        return this.identifier2DataPropIndex.keySet();
    }

    public Set<Integer> getObjectPropIdentifierSet() {
        return this.identifier2ObjPropIndex.keySet();
    }

    public Set<Integer> getIndividuaIdentifierSet() {
        return this.identifier2IndividualIndex.keySet();
    }

    public int getIdentifier4PreorderDesc(int preDesc) {
        if (this.preOrderDesc2Identifier.containsKey(preDesc)) {
            return this.preOrderDesc2Identifier.get(preDesc);
        }
        return -1;
    }

    public int getIdentifier4PreorderAnc(int preAnc) {
        if (this.preOrderAnc2Identifier.containsKey(preAnc)) {
            return this.preOrderAnc2Identifier.get(preAnc);
        }
        return -1;
    }

    public String getProcessedName4ConceptIndex(int index) {
        String name = this.getName4ConceptIndex(index).toLowerCase();
        if (name.indexOf("_") > 0) {
            return name.replaceAll("_", "");
        }
        if (name.indexOf(" ") > 0) {
            return name.replaceAll(" ", "");
        }
        return name;
    }

    public String getName4ConceptIndex(int index) {
        return this.identifier2ClassIndex.get(index).getEntityName();
    }

    public String getName4DataPropIndex(int index) {
        return this.identifier2DataPropIndex.get(index).getEntityName();
    }

    public String getName4ObjPropIndex(int index) {
        return this.identifier2ObjPropIndex.get(index).getEntityName();
    }

    public String getName4IndividualIndex(int index) {
        return this.identifier2IndividualIndex.get(index).getEntityName();
    }

    public String getIRIStr4ConceptIndex(int index) {
        int onto_id = this.identifier2ClassIndex.get(index).getOntologyId();
        return this.identifier2ClassIndex.get(index).getIRI(this.getIRIStrOnto4Id(onto_id));
    }

    public String getNameSpace4ConceptIndex(int index) {
        int onto_id = this.identifier2ClassIndex.get(index).getOntologyId();
        if (this.identifier2ClassIndex.get(index).hasDifferentNamespace()) {
            return this.identifier2ClassIndex.get(index).getNamespace();
        }
        return "";
    }

    public String getIRIStr4DataPropIndex(int index) {
        int onto_id = this.identifier2DataPropIndex.get(index).getOntologyId();
        return this.identifier2DataPropIndex.get(index).getIRI(this.getIRIStrOnto4Id(onto_id));
    }

    public String getIRIStr4ObjPropIndex(int index) {
        int onto_id = this.identifier2ObjPropIndex.get(index).getOntologyId();
        return this.identifier2ObjPropIndex.get(index).getIRI(this.getIRIStrOnto4Id(onto_id));
    }

    public String getIRIStr4IndividualIndex(int index) {
        int onto_id = this.identifier2IndividualIndex.get(index).getOntologyId();
        return this.identifier2IndividualIndex.get(index).getIRI(this.getIRIStrOnto4Id(onto_id));
    }

    public IRI getIRI4ConceptIndex(int index) {
        return IRI.create((String)this.getIRIStr4ConceptIndex(index));
    }

    public IRI getIRI4DataProptIndex(int index) {
        return IRI.create((String)this.getIRIStr4DataPropIndex(index));
    }

    public IRI getIRI4ObjPropIndex(int index) {
        return IRI.create((String)this.getIRIStr4ObjPropIndex(index));
    }

    public IRI getIRI4IndividualIndex(int index) {
        return IRI.create((String)this.getIRIStr4IndividualIndex(index));
    }

    public String getLabel4ConceptIndex(int index) {
        return this.identifier2ClassIndex.get(index).getLabel();
    }

    public String getLabel4DataPropIndex(int index) {
        return this.identifier2DataPropIndex.get(index).getLabel();
    }

    public String getLabel4ObjPropIndex(int index) {
        return this.identifier2ObjPropIndex.get(index).getLabel();
    }

    public String getLabel4IndividualIndex(int index) {
        return this.identifier2IndividualIndex.get(index).getLabel();
    }

    public Set<String> getAlternativeLabels4ConceptIndex(int index) {
        if (this.identifier2ClassIndex.get(index).hasAlternativeLabels()) {
            return this.identifier2ClassIndex.get(index).getAlternativeLabels();
        }
        HashSet<String> set = new HashSet<String>();
        set.add(this.getLabel4ConceptIndex(index));
        return set;
    }

    public Set<String> getAlternativeLabels4IndividualIndex(int index) {
        if (this.identifier2IndividualIndex.get(index).hasAlternativeLabels()) {
            return this.identifier2IndividualIndex.get(index).getAlternativeLabels();
        }
        HashSet<String> set = new HashSet<String>();
        set.add(this.getLabel4IndividualIndex(index));
        return set;
    }

    public Set<String> getAlternativeLabels4ObjectPropertyIndex(int index) {
        if (this.identifier2ObjPropIndex.get(index).hasAlternativeLabels()) {
            return this.identifier2ObjPropIndex.get(index).getAlternativeLabels();
        }
        HashSet<String> set = new HashSet<String>();
        set.add(this.getLabel4ObjPropIndex(index));
        return set;
    }

    public Set<String> getAlternativeLabels4DataPropertyIndex(int index) {
        if (this.identifier2DataPropIndex.get(index).hasAlternativeLabels()) {
            return this.identifier2DataPropIndex.get(index).getAlternativeLabels();
        }
        HashSet<String> set = new HashSet<String>();
        set.add(this.getLabel4DataPropIndex(index));
        return set;
    }

    public boolean hasObjectPropertyAlternativeLabels(int index) {
        return this.identifier2ObjPropIndex.get(index).hasAlternativeLabels();
    }

    public boolean hasDataPropertyAlternativeLabels(int index) {
        return this.identifier2DataPropIndex.get(index).hasAlternativeLabels();
    }

    public boolean hasIndividualAlternativeLabels(int index) {
        return this.identifier2IndividualIndex.get(index).hasAlternativeLabels();
    }

    public OWLClass getOWLClass4ConceptIndex(int index) {
        return this.factory.getOWLClass(this.getIRI4ConceptIndex(index));
    }

    public OWLDataProperty getOWLDataProperty4PropertyIndex(int index) {
        return this.factory.getOWLDataProperty(this.getIRI4DataProptIndex(index));
    }

    public OWLObjectProperty getOWLObjectProperty4PropertyIndex(int index) {
        return this.factory.getOWLObjectProperty(this.getIRI4ObjPropIndex(index));
    }

    public OWLNamedIndividual getOWLNamedIndividual4IndividualIndex(int index) {
        return this.factory.getOWLNamedIndividual(this.getIRI4IndividualIndex(index));
    }

    public int getPreOrderNumber(int conceptIdentifier) {
        return this.identifier2ClassIndex.get(conceptIdentifier).getNode().getDescOrder();
    }

    public int getPreOrderNumberReversed(int conceptIdentifier) {
        return this.identifier2ClassIndex.get(conceptIdentifier).getNode().getAscOrder();
    }

    public int getTopologicalOrder(int conceptIdentifier) {
        return this.identifier2ClassIndex.get(conceptIdentifier).getHierarchyLevel();
    }

    public Set<Interval> getIntervalsDescendants(int conceptIdentifier) {
        return this.identifier2ClassIndex.get(conceptIdentifier).getNode().getDescIntervals();
    }

    public Set<Interval> getIntervalsAncestors(int conceptIdentifier) {
        return this.identifier2ClassIndex.get(conceptIdentifier).getNode().getAscIntervals();
    }

    public Set<Integer> getDirectDisjointClasses4Identifier(int conceptIdentifier) {
        if (this.identifier2ClassIndex.get(conceptIdentifier).hasDirectDisjointClasses()) {
            return this.identifier2ClassIndex.get(conceptIdentifier).getDisjointClasses();
        }
        return Collections.emptySet();
    }

    public Set<Integer> getDirectSuperClasses4Identifier(int conceptIdentifier, boolean module) {
        if (module) {
            return this.getDirectSuperClassesModule4Identifier(conceptIdentifier);
        }
        return this.getDirectSuperClassesOnto4Identifier(conceptIdentifier);
    }

    public Set<Integer> getDirectSubClasses4Identifier(int conceptIdentifier, boolean module) {
        if (module) {
            return this.getDirectSubClassesModule4Identifier(conceptIdentifier);
        }
        return this.getDirectSubClassesOnto4Identifier(conceptIdentifier);
    }

    private Set<Integer> getDirectSubClassesOnto4Identifier(int conceptIdentifier) {
        if (this.identifier2ClassIndex.get(conceptIdentifier).hasDirectSubClasses()) {
            return this.identifier2ClassIndex.get(conceptIdentifier).getDirectSubclasses();
        }
        return Collections.emptySet();
    }

    private Set<Integer> getDirectSuperClassesOnto4Identifier(int conceptIdentifier) {
        if (this.identifier2ClassIndex.get(conceptIdentifier).hasDirectSuperClasses()) {
            return this.identifier2ClassIndex.get(conceptIdentifier).getDirectSuperclasses();
        }
        return Collections.emptySet();
    }

    private Set<Integer> getDirectSubClassesModule4Identifier(int conceptIdentifier) {
        if (this.identifiersInModule.contains(conceptIdentifier)) {
            return this.getDirectSubClassesOnto4Identifier(conceptIdentifier);
        }
        return Collections.emptySet();
    }

    private Set<Integer> getDirectSuperClassesModule4Identifier(int conceptIdentifier) {
        if (this.identifiersInModule.contains(conceptIdentifier)) {
            return this.getDirectSuperClassesOnto4Identifier(conceptIdentifier);
        }
        return Collections.emptySet();
    }

    public Set<Integer> getRoots4Identifier(int conceptIdentifier) {
        if (this.identifier2ClassIndex.get(conceptIdentifier).hasRoots()) {
            return this.identifier2ClassIndex.get(conceptIdentifier).getRoots();
        }
        return Collections.emptySet();
    }

    public Map<Integer, Set<Integer>> getEquivalentClasses() {
        if (this.ident2equivalents.size() > 0) {
            return this.ident2equivalents;
        }
        for (int ident : this.identifier2ClassIndex.keySet()) {
            if (!this.identifier2ClassIndex.get(ident).hasEquivalentClasses()) continue;
            this.ident2equivalents.put(ident, this.identifier2ClassIndex.get(ident).getEquivalentClasses());
        }
        return this.ident2equivalents;
    }

    private Map<Integer, Set<Integer>> getDirectSubClassesModule() {
        if (this.ident2subclasses_module.size() > 0) {
            return this.ident2subclasses_module;
        }
        for (int ident : this.identifiersInModule) {
            if (!this.identifier2ClassIndex.get(ident).hasDirectSubClasses()) continue;
            this.ident2subclasses_module.put(ident, this.identifier2ClassIndex.get(ident).getDirectSubclasses());
        }
        return this.ident2subclasses_module;
    }

    private Map<Integer, Set<Integer>> getDirectSuperClassesModule() {
        if (this.ident2superclasses_module.size() > 0) {
            return this.ident2superclasses_module;
        }
        for (int ident : this.identifiersInModule) {
            if (!this.identifier2ClassIndex.get(ident).hasDirectSuperClasses()) continue;
            this.ident2superclasses_module.put(ident, this.identifier2ClassIndex.get(ident).getDirectSuperclasses());
        }
        return this.ident2superclasses_module;
    }

    private Map<Integer, Set<Integer>> getDirectSubClassesOnto() {
        if (this.ident2subclasses.size() > 0) {
            return this.ident2subclasses;
        }
        for (int ident : this.identifier2ClassIndex.keySet()) {
            if (!this.identifier2ClassIndex.get(ident).hasDirectSubClasses()) continue;
            this.ident2subclasses.put(ident, this.identifier2ClassIndex.get(ident).getDirectSubclasses());
        }
        return this.ident2subclasses;
    }

    private Map<Integer, Set<Integer>> getDirectSuperClassesOnto() {
        if (this.ident2superclasses.size() > 0) {
            return this.ident2superclasses;
        }
        for (int ident : this.identifier2ClassIndex.keySet()) {
            if (!this.identifier2ClassIndex.get(ident).hasDirectSuperClasses()) continue;
            this.ident2superclasses.put(ident, this.identifier2ClassIndex.get(ident).getDirectSuperclasses());
        }
        return this.ident2superclasses;
    }

    public Map<Integer, Set<Integer>> getDirectIndividualClassTypes() {
        if (this.individual2classTypes.size() > 0) {
            return this.individual2classTypes;
        }
        for (int ident : this.identifier2IndividualIndex.keySet()) {
            if (!this.identifier2IndividualIndex.get(ident).hasDirectClassTypes()) continue;
            this.individual2classTypes.put(ident, this.identifier2IndividualIndex.get(ident).getClassTypes());
        }
        return this.individual2classTypes;
    }

    public Map<Integer, Set<Integer>> getDirectSubClasses(boolean module) {
        if (module) {
            return this.getDirectSubClassesModule();
        }
        return this.getDirectSubClassesOnto();
    }

    public Map<Integer, Set<Integer>> getDirectSuperClasses(boolean module) {
        if (module) {
            return this.getDirectSuperClassesModule();
        }
        return this.getDirectSuperClassesOnto();
    }

    public Map<Integer, Set<Integer>> getDirectDisjointClasses() {
        if (this.ident2disjointclasses.size() > 0) {
            return this.ident2disjointclasses;
        }
        for (int ident : this.identifier2ClassIndex.keySet()) {
            if (!this.identifier2ClassIndex.get(ident).hasDirectDisjointClasses()) continue;
            this.ident2disjointclasses.put(ident, this.identifier2ClassIndex.get(ident).getDisjointClasses());
        }
        return this.ident2disjointclasses;
    }

    public void setBigProjection4entities(Set<Integer> mapped_entities_identifiers) {
        this.identifiersInModule.clear();
        this.identifiersInModule.addAll(mapped_entities_identifiers);
        int topo_max = 0;
        for (int ent_ident : mapped_entities_identifiers) {
            if (this.getTopologicalOrder(ent_ident) <= topo_max) continue;
            topo_max = this.getTopologicalOrder(ent_ident);
        }
        float topo2extract = topo_max / 3;
        int maxsubclasses2extract = 75;
        for (int ent_ident : mapped_entities_identifiers) {
            int pre;
            for (Interval interv : this.getIntervalsAncestors(ent_ident)) {
                for (pre = interv.getLeftBound(); pre <= interv.getRightBound(); ++pre) {
                    this.identifiersInModule.add(this.getIdentifier4PreorderAnc(pre));
                }
            }
            if ((float)this.getTopologicalOrder(ent_ident) >= topo2extract || this.getNumOfSubClasses4identifier(ent_ident) < maxsubclasses2extract) {
                for (Interval interv : this.getIntervalsDescendants(ent_ident)) {
                    for (pre = interv.getLeftBound(); pre <= interv.getRightBound(); ++pre) {
                        this.identifiersInModule.add(this.getIdentifier4PreorderDesc(pre));
                    }
                }
                continue;
            }
            Iterator<Object> iterator = this.getDirectSubClasses4Identifier(ent_ident, false).iterator();
            while (iterator.hasNext()) {
                int ide = (Integer)iterator.next();
                this.identifiersInModule.add(ide);
            }
        }
        LogOutput.print("\t" + topo_max + "  " + topo2extract);
        LogOutput.print("\tProjection size: " + this.identifiersInModule.size());
    }

    public void setSmallProjection4entities(Set<Integer> mapped_entities_identifiers) {
        this.identifiersInModule.clear();
        this.identifiersInModule.addAll(mapped_entities_identifiers);
        for (int ent_ident : mapped_entities_identifiers) {
            for (Interval interv : this.getIntervalsAncestors(ent_ident)) {
                for (int pre = interv.getLeftBound(); pre <= interv.getRightBound(); ++pre) {
                    int ident_parent = this.getIdentifier4PreorderAnc(pre);
                    if (ident_parent <= -1) continue;
                    this.identifiersInModule.add(ident_parent);
                }
            }
            Iterator<Object> iterator = this.getDirectSubClasses4Identifier(ent_ident, false).iterator();
            while (iterator.hasNext()) {
                int ide = (Integer)iterator.next();
                this.identifiersInModule.add(ide);
            }
        }
        LogOutput.print("\tProjection size: " + this.identifiersInModule.size());
    }

    public int getNumOfSubClasses4identifier(int cIdent) {
        int numsubclasses = 0;
        for (Interval i : this.getIntervalsDescendants(cIdent)) {
            numsubclasses += i.getRightBound() - i.getLeftBound();
        }
        return numsubclasses;
    }

    public boolean isSubClassOf(int cIdent1, int cIdent2) {
        ++this.calls_tax_question;
        this.init = Calendar.getInstance().getTimeInMillis();
        int preorder1 = this.getPreOrderNumber(cIdent1);
        for (Interval i2 : this.getIntervalsDescendants(cIdent2)) {
            if (!i2.containsIndex(preorder1)) continue;
            this.fin = Calendar.getInstance().getTimeInMillis();
            this.time_tax_question += (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
            return true;
        }
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.time_tax_question += (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
        return false;
    }

    private boolean isSubClassOfInverseTax(int cIdent1, int cIdent2) {
        ++this.calls_tax_question;
        this.init = Calendar.getInstance().getTimeInMillis();
        int preorder1 = this.getPreOrderNumberReversed(cIdent1);
        for (Interval i2 : this.getIntervalsAncestors(cIdent2)) {
            if (!i2.containsIndex(preorder1)) continue;
            this.fin = Calendar.getInstance().getTimeInMillis();
            this.time_tax_question += (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
            return true;
        }
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.time_tax_question += (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
        return false;
    }

    public boolean isSuperClassOf(int cIdent1, int cIdent2) {
        return this.isSubClassOfInverseTax(cIdent1, cIdent2);
    }

    public boolean areEquivalentClasses(int cIdent1, int cIdent2) {
        return this.getPreOrderNumber(cIdent1) == this.getPreOrderNumber(cIdent2);
    }

    public boolean areSiblings(int cIdent1, int cIdent2) {
        for (int parent1 : this.getDirectSuperClassesOnto4Identifier(cIdent1)) {
            if (!this.getDirectSuperClassesOnto4Identifier(cIdent2).contains(parent1)) continue;
            return true;
        }
        return false;
    }

    public boolean areDisjoint(int cIdent1, int cIdent2) {
        ++this.calls_disj_question;
        this.init = Calendar.getInstance().getTimeInMillis();
        int preorder1 = this.getPreOrderNumber(cIdent1);
        int preorder2 = this.getPreOrderNumber(cIdent2);
        for (Interval disj_int1 : this.interval2disjointIntervals.keySet()) {
            if (!disj_int1.containsIndex(preorder1)) continue;
            for (Interval disj_int2 : this.interval2disjointIntervals.get(disj_int1)) {
                if (!disj_int2.containsIndex(preorder2)) continue;
                this.fin = Calendar.getInstance().getTimeInMillis();
                this.time_disj_question += (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
                return true;
            }
        }
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.time_disj_question += (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
        return false;
    }

    public boolean isDisjointWithDescendants(int cIdent1, int cIdent2) {
        ++this.calls_disj_question;
        this.init = Calendar.getInstance().getTimeInMillis();
        int preorder1 = this.getPreOrderNumber(cIdent1);
        Set<Interval> descendants = this.getIntervalsDescendants(cIdent2);
        for (Interval disj_int1 : this.interval2disjointIntervals.keySet()) {
            for (Interval desc : descendants) {
                if (!disj_int1.hasNonEmptyIntersectionWith(desc)) continue;
                for (Interval disj_int2 : this.interval2disjointIntervals.get(disj_int1)) {
                    if (!disj_int2.containsIndex(preorder1)) continue;
                    this.fin = Calendar.getInstance().getTimeInMillis();
                    this.time_disj_question += (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
                    return true;
                }
            }
        }
        for (Interval disj_int1 : this.interval2disjointIntervals.keySet()) {
            if (!disj_int1.containsIndex(preorder1)) continue;
            for (Interval disj_int2 : this.interval2disjointIntervals.get(disj_int1)) {
                for (Interval desc : descendants) {
                    if (!disj_int2.hasNonEmptyIntersectionWith(desc)) continue;
                    this.fin = Calendar.getInstance().getTimeInMillis();
                    this.time_disj_question += (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
                    return true;
                }
            }
        }
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.time_disj_question += (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
        return false;
    }

    public boolean arePartiallyDisjoint(int cIdent1, int cIdent2) {
        ++this.calls_disj_question;
        this.init = Calendar.getInstance().getTimeInMillis();
        Set<Interval> descendants1 = this.getIntervalsDescendants(cIdent1);
        Set<Interval> descendants2 = this.getIntervalsDescendants(cIdent2);
        block0: for (Interval disj_int1 : this.interval2disjointIntervals.keySet()) {
            for (Interval desc1 : descendants1) {
                if (!disj_int1.hasNonEmptyIntersectionWith(desc1)) continue;
                for (Interval disj_int2 : this.interval2disjointIntervals.get(disj_int1)) {
                    for (Interval desc2 : descendants2) {
                        if (!disj_int2.hasNonEmptyIntersectionWith(desc2)) continue;
                        return true;
                    }
                }
                continue block0;
            }
        }
        this.fin = Calendar.getInstance().getTimeInMillis();
        this.time_disj_question += (double)((float)((double)this.fin - (double)this.init)) / 1000.0;
        return false;
    }

    public Set<Integer> getUnsatisfiableClassesILS() {
        return this.unsatisfiableClassesILS;
    }

    public boolean areConceptsSharingDescendants(int cIdent1, int cIdent2) {
        for (Interval i1 : this.getIntervalsDescendants(cIdent1)) {
            for (Interval i2 : this.getIntervalsDescendants(cIdent2)) {
                if (!i1.hasNonEmptyIntersectionWith(i2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean areConceptsSharingAncestors(int cIdent1, int cIdent2) {
        for (Interval i1 : this.getIntervalsAncestors(cIdent1)) {
            for (Interval i2 : this.getIntervalsAncestors(cIdent2)) {
                if (!i1.hasNonEmptyIntersectionWith(i2)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract Set<Integer> getScope4Identifier_Big(int var1);

    public abstract Set<Integer> getScope4Identifier_Condifence(int var1);

    public abstract Set<Integer> getScope4Identifier_Expansion(int var1);

    public abstract void setSmallProjection4MappedEntities(Set<Integer> var1);

    public abstract Set<Integer> getSubsetOfSuperClasses4Identifier(int var1);

    public abstract Set<Integer> getSubsetOfSubClasses4Identifier(int var1);
}

