/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.division;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.parameters.Imports;
import uk.ac.ox.krr.logmap2.owlapi.SynchronizedOWLManager;

public class MatchingTask {
    private OWLOntology sourceOntology;
    private OWLOntology targetOntology;
    private Set<String> signatureSourceOntology;
    private Set<String> signatureTargetOntology;

    public MatchingTask() {
    }

    public MatchingTask(OWLOntology sourceOntology, OWLOntology targetOntology) {
        this.sourceOntology = sourceOntology;
        this.targetOntology = targetOntology;
        this.signatureSourceOntology = this.createSignatureStrOntology(sourceOntology);
        this.signatureTargetOntology = this.createSignatureStrOntology(targetOntology);
        sourceOntology.getOWLOntologyManager().removeOntology(sourceOntology);
        targetOntology.getOWLOntologyManager().removeOntology(targetOntology);
        sourceOntology = null;
        targetOntology = null;
    }

    public void clear() {
        this.signatureSourceOntology.clear();
        this.signatureTargetOntology.clear();
        this.sourceOntology.getOWLOntologyManager().removeOntology(this.sourceOntology);
        this.targetOntology.getOWLOntologyManager().removeOntology(this.targetOntology);
        this.sourceOntology = null;
        this.targetOntology = null;
    }

    public OWLOntology getSourceOntology() {
        return this.sourceOntology;
    }

    public void setSourceOntology(OWLOntology onto1) {
        this.sourceOntology = onto1;
        this.signatureSourceOntology = this.createSignatureStrOntology(this.sourceOntology);
    }

    public OWLOntology getTargetOntology() {
        return this.targetOntology;
    }

    public void setTargetOntology(OWLOntology onto2) {
        this.targetOntology = onto2;
        this.signatureTargetOntology = this.createSignatureStrOntology(this.targetOntology);
    }

    public Set<String> getSignatureSourceOntology() {
        return this.signatureSourceOntology;
    }

    public void setSignatureSourceOntology(Set<String> signatureSourceOntology) {
        this.signatureSourceOntology = signatureSourceOntology;
    }

    public Set<String> getSignatureTargetOntology() {
        return this.signatureTargetOntology;
    }

    public void setSignatureTargetOntology(Set<String> signatureTargetOntology) {
        this.signatureTargetOntology = signatureTargetOntology;
    }

    public Set<String> createSignatureStrOntology(OWLOntology ont) {
        HashSet<String> signature = new HashSet<String>();
        for (OWLEntity ent : ont.getSignature(Imports.INCLUDED)) {
            signature.add(ent.toStringID());
        }
        return signature;
    }

    public void saveMatchingTask(String path) throws OWLOntologyStorageException {
        String prefix = "";
        if (!path.startsWith("/")) {
            prefix = "/";
        }
        String sufix = "";
        if (!path.endsWith("/")) {
            sufix = "/";
        }
        String uri_file1 = "file:" + prefix + path + sufix + "source.owl";
        String uri_file2 = "file:" + prefix + path + sufix + "target.owl";
        OWLOntologyManager manager = SynchronizedOWLManager.createOWLOntologyManager();
        manager.saveOntology(this.sourceOntology, (OWLDocumentFormat)new RDFXMLDocumentFormat(), IRI.create((String)uri_file1));
        manager.saveOntology(this.targetOntology, (OWLDocumentFormat)new RDFXMLDocumentFormat(), IRI.create((String)uri_file2));
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof MatchingTask)) {
            return false;
        }
        MatchingTask i = (MatchingTask)o;
        return this.equals(i);
    }

    public boolean equals(MatchingTask m) {
        return this.sourceOntology.equals(m.getSourceOntology()) && this.targetOntology.equals(m.getTargetOntology());
    }

    public String toString() {
        return "Matching task between : <" + this.sourceOntology.getOntologyID().getOntologyIRI() + "> and <" + this.targetOntology.getOntologyID().getOntologyIRI() + ">";
    }

    public int hashCode() {
        int code = 10;
        code = 40 * code + this.sourceOntology.hashCode();
        code = 50 * code + this.targetOntology.hashCode();
        return code;
    }
}

