/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;
import org.semanticweb.owlapi.util.OWLObjectWalker;

public class OWLClassLiteralCollector
extends OWLObjectWalker<OWLObject> {
    protected final Set<OWLClass> pos = new HashSet<OWLClass>();
    protected final Set<OWLClass> neg = new HashSet<OWLClass>();
    private boolean processed = false;

    public OWLClassLiteralCollector(@Nonnull Set<OWLObject> objects) {
        super(objects);
    }

    public OWLClassLiteralCollector(@Nonnull Set<OWLObject> objects, boolean visitDuplicates) {
        super(objects, visitDuplicates);
    }

    private void process() {
        if (!this.processed) {
            this.processed = true;
            this.walkStructure(new OWLClassLiteralCollectorVisitor());
        }
    }

    public Set<OWLClass> getPositiveLiterals() {
        this.process();
        return new HashSet<OWLClass>(this.pos);
    }

    public Set<OWLClass> getNegativeLiterals() {
        this.process();
        return new HashSet<OWLClass>(this.neg);
    }

    private class OWLClassLiteralCollectorVisitor
    extends OWLObjectVisitorAdapter {
        OWLClassLiteralCollectorVisitor() {
        }

        @Override
        public void visit(OWLClass ce) {
            List<OWLClassExpression> path = OWLClassLiteralCollector.this.getClassExpressionPath();
            if (path.size() > 1) {
                OWLClassExpression prev = path.get(path.size() - 2);
                if (prev instanceof OWLObjectComplementOf) {
                    OWLClassLiteralCollector.this.neg.add(ce);
                } else {
                    OWLClassLiteralCollector.this.pos.add(ce);
                }
            } else {
                OWLClassLiteralCollector.this.pos.add(ce);
            }
        }
    }
}

