/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi;

import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.multibindings.Multibinder;
import java.util.HashSet;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.inject.Provider;
import org.semanticweb.owlapi.OWLAPIConfigProvider;
import org.semanticweb.owlapi.annotations.OwlapiModule;
import org.semanticweb.owlapi.io.LegacyOWLParserFactory;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManagerFactory;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLStorer;
import org.semanticweb.owlapi.model.OWLStorerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OwlapiModule
public class OWLAPIServiceLoaderModule
extends AbstractModule {
    private static Logger logger = LoggerFactory.getLogger(OWLAPIServiceLoaderModule.class);

    protected void configure() {
        this.loadInstancesFromServiceLoader(OWLParser.class);
        this.loadInstancesFromServiceLoader(OWLStorer.class);
        this.loadInstancesFromServiceLoader(OWLOntologyFactory.class);
        this.loadInstancesFromServiceLoader(OWLOntologyIRIMapper.class);
        this.loadFactories(OWLDocumentFormatFactory.class, OWLDocumentFormatFactory.class, OWLDocumentFormat.class);
        this.loadFactories(OWLParserFactory.class, OWLParserFactory.class, OWLParser.class);
        this.loadFactories(OWLParserFactory.class, LegacyOWLParserFactory.class, OWLParser.class);
        this.loadFactories(OWLStorerFactory.class, OWLStorerFactory.class, OWLStorer.class);
        this.loadOntologyManagerFactory();
        this.bind(OWLOntologyLoaderConfiguration.class).toProvider(OWLAPIConfigProvider.class);
    }

    protected <T> void loadInstancesFromServiceLoader(Class<T> type) {
        try {
            Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), type);
            for (T o : this.load(type)) {
                binder.addBinding().toInstance(o);
            }
        }
        catch (ServiceConfigurationError e) {
            throw new OWLRuntimeException("Injection failed for " + type, e);
        }
    }

    protected <T> Iterable<T> load(Class<T> type) {
        HashSet result = new HashSet();
        try {
            Iterables.addAll(result, ServiceLoader.load(type));
        }
        catch (ServiceConfigurationError e) {
            logger.debug("ServiceLoading: ", (Throwable)e);
        }
        if (result.isEmpty()) {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            Iterables.addAll(result, ServiceLoader.load(type, classLoader));
        }
        return result;
    }

    protected <T, F extends Provider<T>> void loadFactories(Class<F> factory, Class<? extends F> factorySubType, Class<T> type) {
        try {
            Multibinder factoryBinder = Multibinder.newSetBinder((Binder)this.binder(), factory);
            Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), type);
            for (Provider o : this.load(factorySubType)) {
                factoryBinder.addBinding().toInstance((Object)o);
                binder.addBinding().toInstance(o.get());
            }
        }
        catch (ServiceConfigurationError e) {
            throw new OWLRuntimeException("Injection failed for factory: " + factory + " type: " + type, e);
        }
    }

    protected void loadOntologyManagerFactory() {
        try {
            Multibinder binder = Multibinder.newSetBinder((Binder)this.binder(), OWLOntologyManagerFactory.class);
            for (OWLOntologyManagerFactory o : this.load(OWLOntologyManagerFactory.class)) {
                binder.addBinding().toInstance((Object)o);
            }
        }
        catch (ServiceConfigurationError e) {
            throw new OWLRuntimeException("Injection failed for OWLOntologyManager factory", e);
        }
    }
}

