dnl
dnl Macro to genarte common generic layer Makfiles and its sources.mk
dnl Christophe LACOMBE <clacombe@amadeus.com>, August 2009
dnl
dnl AM_GEN_COMMON_LAYER_MAKEFILE:
dnl =============================
dnl This macro will generate the Makefile.am in the path given in first agument
dnl If a sources.mk file does not exist or has been just generated by this lib
dnl without beeing modified, then it will be generated with files (.h .hpp .c .cpp)
dnl present in the layer directory. This file can then be kept (and then regenerated
dnl if file list change) or be custumized.
dnl The macro can have as parameter(s):
dnl     1 - The relative path to the layer where to generate files (Mandatory)
dnl     2 - The name of the lib to generate for this layer
dnl       If not specified, it will be the path to the layer without /
dnl     3 - Additional cxxflags to add for the compilation of the layer
dnl     4 - Additional ldflags to add for the link of the layer
dnl     5 - Additional libadd to add for the link of the layer
dnl     6 - Additional cxxflags to add for the debug compilation of the layer (set to non-debug value if empty)
dnl     7 - Additional ldflags to add for the debug link of the layer (set to non-debug value if empty)
dnl     8 - Additional libadd to add for the debug link of the layer (set to non-debug value if empty)
dnl sources.mk can defined variable:
dnl     - <layer_lib_name>_h_sources
dnl     - <layer_lib_name>_cc_sources

AC_DEFUN([AM_GEN_COMMON_LAYER_MAKEFILE],
[
	dnl #############################
	dnl Here we use a syscmd in order to generate the files (Makefile.am and sources.mk)
	dnl under the autoconf step, in order to have them when automake is called by autoconf
	dnl #############################
	syscmd([
		layer_dir="$1"
		layer_lib_name="$2"
		layer_lib_cxxflags="$3"
		layer_lib_ldflags="$4"
		layer_lib_libflags="$5"
		layer_lib_debug_cxxflags="$6"
		layer_lib_debug_ldflags="$7"
		layer_lib_debug_libflags="$8"

		#layer_dir is mandatory
		[ -d "${layer_dir}" ] || exit 11

		# If layer_lib_name is not defined, use the layer_dir without /
		[ -z "${layer_lib_name}" ] && layer_lib_name=$(echo ${layer_dir} | tr -d '/')

		#Set debug vqriqble to non-debug one if not specified
		[ -z "${layer_lib_debug_cxxflags}" ] && layer_lib_debug_cxxflags=${layer_lib_cxxflags}
		[ -z "${layer_lib_debug_ldflags}" ] && layer_lib_debug_ldflags=${layer_lib_ldflags}
		[ -z "${layer_lib_debug_libflags}" ] && layer_lib_debug_libflags=${layer_lib_libflags}

		#Compute the list of direct sub-layer - it is the list of sub-folders that have a Makefile.am
		layer_sub_layer=$(find ${layer_dir} -mindepth 2 -maxdepth 2 -name Makefile.am -exec dirname {} \; | xargs -rn1 basename)

		#For each sub-layer get the list of sub-lib and compute the relative path - the variable will contain libs separated by new-line
		layer_sub_lib=$(for l in $(echo ${layer_sub_layer}); do grep 'noinst_LTLIBRARIES.*=' ${layer_dir}/$l/Makefile.am | cut -d'=' -f2 | xargs -rn1 echo $l/ | tr -d ' '; done)

		# #############################
		# if it does not exist generate a default sources.mk from all files in the layer directory
		# in case the file exist but has not been modified since it has been generated, then it will
		# be regenerated
		# to know if the file has been modified, we compare the date printed in the file with the last
		# modified date of this file - they must be equal or differ just by 1
		# #############################
		# we add a 0 in front of the result of the second date operation as it might return nothing if the file
		# has been modified and the date is not detected
		if [ ! -r ${layer_dir}/sources.mk ] || [ $(( \
				$(date '+%s' -r ${layer_dir}/sources.mk) \
				- \
				$(date '+%s' -d "$(head -1 ${layer_dir}/sources.mk | cut -d'@' -f2)" 2>/dev/null) \
			+0)) -le 1 \
		]; then {
				echo "## Generate by AM""_GEN_COMMON_LAYER_MAKEFILE @ $(date)"
				echo -n "${layer_lib_name}_h_sources ="
				for f in $(cd ${layer_dir} 2>/dev/null && ls *.h *.hpp 2>/dev/null); do echo " \\"; echo -n "   $(basename $f)"; done
				echo
				echo -n "${layer_lib_name}_cc_sources ="
				for f in $(cd ${layer_dir} 2>/dev/null && ls *.c *.cpp 2>/dev/null); do echo " \\"; echo -n '   $(srcdir)/'"$f"; done
				echo
			} > ${layer_dir}/sources.mk || exit 12
		fi

		# #############################
		# generate the makefile.am for the given layer
		# #############################
		echo '## Generate by AM'"_GEN_COMMON_LAYER_MAKEFILE @ $(date)
## This file should not be modified as it will be regenerated at each autoreconf

include \$(top_srcdir)/Makefile.common
include \$(srcdir)/sources.mk

MAINTAINERCLEANFILES = Makefile.in

SUBDIRS = $(echo ${layer_sub_layer} | tr '\n' ' ')

noinst_LTLIBRARIES = lib${layer_lib_name}.la
if ENABLE_DEBUG
noinst_LTLIBRARIES += lib${layer_lib_name}_debug.la
endif

lib${layer_lib_name}_la_SOURCES = \$(${layer_lib_name}_h_sources) \$(${layer_lib_name}_cc_sources)
lib${layer_lib_name}_la_CXXFLAGS = ${layer_lib_cxxflags}
lib${layer_lib_name}_la_LDFLAGS = ${layer_lib_ldflags}
lib${layer_lib_name}_la_LIBADD = ${layer_lib_libflags}$(echo "${layer_sub_lib}" | grep -v _debug | xargs -rn1 echo -n ' \
    ')

lib${layer_lib_name}_debug_la_SOURCES = \$(${layer_lib_name}_h_sources) \$(${layer_lib_name}_cc_sources)
lib${layer_lib_name}_debug_la_CXXFLAGS = ${layer_lib_debug_cxxflags}
lib${layer_lib_name}_debug_la_LDFLAGS = ${layer_lib_debug_ldflags}
lib${layer_lib_name}_debug_la_LIBADD = ${layer_lib_debug_libflags}$(echo "${layer_sub_lib}" | grep _debug | xargs -rn1 echo -n ' \
    ')
" > ${layer_dir}/Makefile.am || exit 13
	])

	dnl #############################
	dnl If error, print error message else print ok message and 
	dnl return the Makefile to be generated by AC_CONFIG_FILES
	dnl like that the macro AM_GEN_COMMON_LAYER_MAKEFILE is to be taken 
	dnl as an agument of AC_CONFIG_FILES
	dnl #############################
	ifelse(sysval, [0], [$1/Makefile], [errprint([cannot generate Makefile.am for layer $1 : error ]sysval[
])	])

])
