"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrepayDBInstance = exports.PrepayDBInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "PrepayDBInstanceProperty", { enumerable: true, get: function () { return rds_generated_1.RosPrepayDBInstance; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::PrepayDBInstance`
 */
class PrepayDBInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::PrepayDBInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPrepayDBInstance = new rds_generated_1.RosPrepayDBInstance(this, id, {
            periodType: props.periodType ? props.periodType : 'Month',
            resourceGroupId: props.resourceGroupId,
            archiveBackupRetentionPeriod: props.archiveBackupRetentionPeriod,
            dbTimeZone: props.dbTimeZone,
            port: props.port,
            archiveBackupKeepCount: props.archiveBackupKeepCount,
            logBackupRetentionPeriod: props.logBackupRetentionPeriod,
            dbInstanceStorage: props.dbInstanceStorage,
            dbMappings: props.dbMappings,
            connectionStringPrefix: props.connectionStringPrefix,
            multiAz: props.multiAz ? props.multiAz : false,
            engine: props.engine,
            tags: props.tags,
            dbInstanceDescription: props.dbInstanceDescription,
            targetDedicatedHostIdForMaster: props.targetDedicatedHostIdForMaster,
            engineVersion: props.engineVersion,
            dbInstanceClass: props.dbInstanceClass,
            archiveBackupKeepPolicy: props.archiveBackupKeepPolicy,
            vSwitchId: props.vSwitchId,
            backupPolicyMode: props.backupPolicyMode,
            period: props.period ? props.period : 1,
            localLogRetentionHours: props.localLogRetentionHours,
            highSpaceUsageProtection: props.highSpaceUsageProtection,
            roleArn: props.roleArn,
            masterUserPassword: props.masterUserPassword,
            vpcId: props.vpcId,
            sslSetting: props.sslSetting ? props.sslSetting : 'Disabled',
            masterUsername: props.masterUsername,
            connectionMode: props.connectionMode,
            localLogRetentionSpace: props.localLogRetentionSpace,
            category: props.category,
            privateIpAddress: props.privateIpAddress,
            targetDedicatedHostIdForSlave: props.targetDedicatedHostIdForSlave,
            dbInstanceNetType: props.dbInstanceNetType ? props.dbInstanceNetType : 'Intranet',
            releasedKeepPolicy: props.releasedKeepPolicy,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            autoRenew: props.autoRenew ? props.autoRenew : false,
            encryptionKey: props.encryptionKey,
            preferredBackupPeriod: props.preferredBackupPeriod,
            logBackupLocalRetentionNumber: props.logBackupLocalRetentionNumber,
            slaveZoneIds: props.slaveZoneIds,
            dbIsIgnoreCase: props.dbIsIgnoreCase,
            commodityCode: props.commodityCode ? props.commodityCode : 'rds',
            maintainTime: props.maintainTime,
            dbParamGroupId: props.dbParamGroupId,
            zoneId: props.zoneId,
            targetDedicatedHostIdForLog: props.targetDedicatedHostIdForLog,
            allocatePublicConnection: props.allocatePublicConnection,
            securityGroupId: props.securityGroupId,
            preferredBackupTime: props.preferredBackupTime,
            quantity: props.quantity ? props.quantity : 1,
            autoPay: props.autoPay ? props.autoPay : false,
            dbInstanceStorageType: props.dbInstanceStorageType,
            backUpCategory: props.backUpCategory,
            compressType: props.compressType,
            connectionStringType: props.connectionStringType ? props.connectionStringType : 'Inner',
            logBackupFrequency: props.logBackupFrequency,
            couponCode: props.couponCode,
            masterUserType: props.masterUserType ? props.masterUserType : 'Normal',
            enableBackupLog: props.enableBackupLog,
            sqlCollectorStatus: props.sqlCollectorStatus,
            backupRetentionPeriod: props.backupRetentionPeriod ? props.backupRetentionPeriod : 7,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPrepayDBInstance;
        this.attrDbInstanceId = rosPrepayDBInstance.attrDbInstanceId;
        this.attrInnerConnectionString = rosPrepayDBInstance.attrInnerConnectionString;
        this.attrInnerIpAddress = rosPrepayDBInstance.attrInnerIpAddress;
        this.attrInnerPort = rosPrepayDBInstance.attrInnerPort;
        this.attrOrderId = rosPrepayDBInstance.attrOrderId;
        this.attrPublicConnectionString = rosPrepayDBInstance.attrPublicConnectionString;
        this.attrPublicIpAddress = rosPrepayDBInstance.attrPublicIpAddress;
        this.attrPublicPort = rosPrepayDBInstance.attrPublicPort;
    }
}
exports.PrepayDBInstance = PrepayDBInstance;
//# sourceMappingURL=data:application/json;base64,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