"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstanceParameterGroup = exports.DBInstanceParameterGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DBInstanceParameterGroupProperty", { enumerable: true, get: function () { return rds_generated_1.RosDBInstanceParameterGroup; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::DBInstanceParameterGroup`
 */
class DBInstanceParameterGroup extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::RDS::DBInstanceParameterGroup`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstanceParameterGroup = new rds_generated_1.RosDBInstanceParameterGroup(this, id, {
            parameters: props.parameters,
            dbInstanceId: props.dbInstanceId,
            forcerestart: props.forcerestart ? props.forcerestart : 'false',
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstanceParameterGroup;
    }
}
exports.DBInstanceParameterGroup = DBInstanceParameterGroup;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGJpbnN0YW5jZXBhcmFtZXRlcmdyb3VwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZGJpbnN0YW5jZXBhcmFtZXRlcmdyb3VwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDhDQUE4QztBQUM5QyxtREFBOEQ7QUFFdEIsaUhBRi9CLDJDQUEyQixPQUVvQztBQXVCeEU7O0dBRUc7QUFDSCxNQUFhLHdCQUF5QixTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBRXREOzs7T0FHRztJQUVIOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBb0MsRUFBRSxtQ0FBMkMsSUFBSTtRQUMvSCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sMkJBQTJCLEdBQUcsSUFBSSwyQ0FBMkIsQ0FBQyxJQUFJLEVBQUUsRUFBRSxFQUFHO1lBQzNFLFVBQVUsRUFBRSxLQUFLLENBQUMsVUFBVTtZQUM1QixZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLE9BQU87U0FDbEUsRUFBRSxnQ0FBZ0MsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDcEYsSUFBSSxDQUFDLFFBQVEsR0FBRywyQkFBMkIsQ0FBQztJQUNoRCxDQUFDO0NBQ0o7QUF4QkQsNERBd0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuaW1wb3J0IHsgUm9zREJJbnN0YW5jZVBhcmFtZXRlckdyb3VwIH0gZnJvbSAnLi9yZHMuZ2VuZXJhdGVkJztcbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBbGlDbG91ZCBST1MgUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuZXhwb3J0IHsgUm9zREJJbnN0YW5jZVBhcmFtZXRlckdyb3VwIGFzIERCSW5zdGFuY2VQYXJhbWV0ZXJHcm91cFByb3BlcnR5IH07XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQUxJWVVOOjpSRFM6OkRCSW5zdGFuY2VQYXJhbWV0ZXJHcm91cGBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEQkluc3RhbmNlUGFyYW1ldGVyR3JvdXBQcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBkYkluc3RhbmNlSWQ6IERhdGFiYXNlIEluc3RhbmNlSWQgdG8gdXBkYXRlIHByb3BlcnRpZXMuXG4gICAgICovXG4gICAgcmVhZG9ubHkgZGJJbnN0YW5jZUlkOiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBwYXJhbWV0ZXJzOiBQYXJhbWV0ZXJzIHRvIHVwZGF0ZSBmb3Igc2VsZWN0ZWQgZGF0YWJhc2UgaW5zdGFuY2UuXG4gICAgICovXG4gICAgcmVhZG9ubHkgcGFyYW1ldGVyczogQXJyYXk8Um9zREJJbnN0YW5jZVBhcmFtZXRlckdyb3VwLlBhcmFtZXRlcnNQcm9wZXJ0eSB8IHJvcy5JUmVzb2x2YWJsZT4gfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBmb3JjZXJlc3RhcnQ6IHdoZXRoZXIgcmVzdGFydCBkYXRhYmFzZSBpbnN0YW5jZS5cbiAgICAgKi9cbiAgICByZWFkb25seSBmb3JjZXJlc3RhcnQ/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG59XG5cbi8qKlxuICogQSBST1MgcmVzb3VyY2UgdHlwZTogIGBBTElZVU46OlJEUzo6REJJbnN0YW5jZVBhcmFtZXRlckdyb3VwYFxuICovXG5leHBvcnQgY2xhc3MgREJJbnN0YW5jZVBhcmFtZXRlckdyb3VwIGV4dGVuZHMgcm9zLlJlc291cmNlIHtcblxuICAgIC8qKlxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcbiAgICAgKiBjb250YWluaW5nIHRoZSBwcm9wZXJ0aWVzIG9mIHRoaXMgUk9TIHJlc291cmNlLCB3aGljaCB3aWxsIGJlIGFzc2lnbmVkIHRvIFJPUyByZXNvdXJjZS5cbiAgICAgKi9cblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpSRFM6OkRCSW5zdGFuY2VQYXJhbWV0ZXJHcm91cGAuXG4gICAgICpcbiAgICAgKiBQYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIFBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgICAqIFBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xuICAgICAqL1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiByb3MuQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogREJJbnN0YW5jZVBhcmFtZXRlckdyb3VwUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OmJvb2xlYW4gPSB0cnVlKSB7XG4gICAgICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAgICAgY29uc3Qgcm9zREJJbnN0YW5jZVBhcmFtZXRlckdyb3VwID0gbmV3IFJvc0RCSW5zdGFuY2VQYXJhbWV0ZXJHcm91cCh0aGlzLCBpZCwgIHtcbiAgICAgICAgICAgIHBhcmFtZXRlcnM6IHByb3BzLnBhcmFtZXRlcnMsXG4gICAgICAgICAgICBkYkluc3RhbmNlSWQ6IHByb3BzLmRiSW5zdGFuY2VJZCxcbiAgICAgICAgICAgIGZvcmNlcmVzdGFydDogcHJvcHMuZm9yY2VyZXN0YXJ0ID8gcHJvcHMuZm9yY2VyZXN0YXJ0IDogJ2ZhbHNlJyxcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NEQkluc3RhbmNlUGFyYW1ldGVyR3JvdXA7XG4gICAgfVxufVxuIl19