"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBInstanceClone = exports.DBInstanceCloneProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const rds_generated_1 = require("./rds.generated");
Object.defineProperty(exports, "DBInstanceCloneProperty", { enumerable: true, get: function () { return rds_generated_1.RosDBInstanceClone; } });
/**
 * A ROS resource type:  `ALIYUN::RDS::DBInstanceClone`
 */
class DBInstanceClone extends ros.Resource {
    /**
     * Create a new `ALIYUN::RDS::DBInstanceClone`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDBInstanceClone = new rds_generated_1.RosDBInstanceClone(this, id, {
            periodType: props.periodType ? props.periodType : 'Month',
            category: props.category,
            privateIpAddress: props.privateIpAddress,
            dedicatedHostGroupId: props.dedicatedHostGroupId,
            port: props.port,
            backupId: props.backupId,
            instanceNetworkType: props.instanceNetworkType,
            restoreTime: props.restoreTime,
            dbNames: props.dbNames,
            preferredBackupPeriod: props.preferredBackupPeriod,
            slaveZoneIds: props.slaveZoneIds,
            dbInstanceId: props.dbInstanceId,
            securityIpList: props.securityIpList,
            dbInstanceStorage: props.dbInstanceStorage,
            backupType: props.backupType,
            dbMappings: props.dbMappings,
            connectionStringPrefix: props.connectionStringPrefix,
            maintainTime: props.maintainTime,
            tags: props.tags,
            dbInstanceDescription: props.dbInstanceDescription,
            zoneId: props.zoneId,
            dbInstanceClass: props.dbInstanceClass,
            allocatePublicConnection: props.allocatePublicConnection,
            preferredBackupTime: props.preferredBackupTime,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            period: props.period ? props.period : 1,
            payType: props.payType ? props.payType : 'Postpaid',
            dbInstanceStorageType: props.dbInstanceStorageType,
            connectionStringType: props.connectionStringType ? props.connectionStringType : 'Inner',
            restoreTable: props.restoreTable,
            masterUserPassword: props.masterUserPassword,
            masterUserType: props.masterUserType ? props.masterUserType : 'Normal',
            vpcId: props.vpcId,
            sslSetting: props.sslSetting ? props.sslSetting : 'Disabled',
            masterUsername: props.masterUsername,
            sqlCollectorStatus: props.sqlCollectorStatus,
            backupRetentionPeriod: props.backupRetentionPeriod ? props.backupRetentionPeriod : 7,
            tableMeta: props.tableMeta,
            timeoutInMinutes: props.timeoutInMinutes ? props.timeoutInMinutes : 120,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBInstanceClone;
        this.attrDbInstanceId = rosDBInstanceClone.attrDbInstanceId;
        this.attrInnerConnectionString = rosDBInstanceClone.attrInnerConnectionString;
        this.attrInnerIpAddress = rosDBInstanceClone.attrInnerIpAddress;
        this.attrInnerPort = rosDBInstanceClone.attrInnerPort;
        this.attrPublicConnectionString = rosDBInstanceClone.attrPublicConnectionString;
        this.attrPublicIpAddress = rosDBInstanceClone.attrPublicIpAddress;
        this.attrPublicPort = rosDBInstanceClone.attrPublicPort;
    }
}
exports.DBInstanceClone = DBInstanceClone;
//# sourceMappingURL=data:application/json;base64,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