"""
    Pinterest REST API

    Pinterest's REST API  # noqa: E501

    The version of the OpenAPI document: 5.3.0
    Contact: blah@cliffano.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pinterestsdk.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from pinterestsdk.exceptions import ApiAttributeError


def lazy_import():
    from pinterestsdk.model.ad_group_summary_status import AdGroupSummaryStatus
    from pinterestsdk.model.ads_analytics_create_async_request_all_of import AdsAnalyticsCreateAsyncRequestAllOf
    from pinterestsdk.model.ads_analytics_create_async_request_all_of1 import AdsAnalyticsCreateAsyncRequestAllOf1
    from pinterestsdk.model.ads_analytics_metrics_filter import AdsAnalyticsMetricsFilter
    from pinterestsdk.model.ads_analytics_targeting_type import AdsAnalyticsTargetingType
    from pinterestsdk.model.campaign_summary_status import CampaignSummaryStatus
    from pinterestsdk.model.conversion_attribution_window_days import ConversionAttributionWindowDays
    from pinterestsdk.model.conversion_report_attribution_type import ConversionReportAttributionType
    from pinterestsdk.model.conversion_report_time_type import ConversionReportTimeType
    from pinterestsdk.model.data_output_format import DataOutputFormat
    from pinterestsdk.model.granularity import Granularity
    from pinterestsdk.model.metrics_reporting_level import MetricsReportingLevel
    from pinterestsdk.model.objective_type import ObjectiveType
    from pinterestsdk.model.pin_promotion_summary_status import PinPromotionSummaryStatus
    from pinterestsdk.model.product_group_summary_status import ProductGroupSummaryStatus
    from pinterestsdk.model.reporting_column_async import ReportingColumnAsync
    globals()['AdGroupSummaryStatus'] = AdGroupSummaryStatus
    globals()['AdsAnalyticsCreateAsyncRequestAllOf'] = AdsAnalyticsCreateAsyncRequestAllOf
    globals()['AdsAnalyticsCreateAsyncRequestAllOf1'] = AdsAnalyticsCreateAsyncRequestAllOf1
    globals()['AdsAnalyticsMetricsFilter'] = AdsAnalyticsMetricsFilter
    globals()['AdsAnalyticsTargetingType'] = AdsAnalyticsTargetingType
    globals()['CampaignSummaryStatus'] = CampaignSummaryStatus
    globals()['ConversionAttributionWindowDays'] = ConversionAttributionWindowDays
    globals()['ConversionReportAttributionType'] = ConversionReportAttributionType
    globals()['ConversionReportTimeType'] = ConversionReportTimeType
    globals()['DataOutputFormat'] = DataOutputFormat
    globals()['Granularity'] = Granularity
    globals()['MetricsReportingLevel'] = MetricsReportingLevel
    globals()['ObjectiveType'] = ObjectiveType
    globals()['PinPromotionSummaryStatus'] = PinPromotionSummaryStatus
    globals()['ProductGroupSummaryStatus'] = ProductGroupSummaryStatus
    globals()['ReportingColumnAsync'] = ReportingColumnAsync


class AdsAnalyticsCreateAsyncRequest(ModelComposed):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('start_date',): {
            'regex': {
                'pattern': r'^(\d{4})-(\d{2})-(\d{2})$',  # noqa: E501
            },
        },
        ('end_date',): {
            'regex': {
                'pattern': r'^(\d{4})-(\d{2})-(\d{2})$',  # noqa: E501
            },
        },
        ('campaign_ids',): {
            'max_items': 500,
            'min_items': 1,
        },
        ('campaign_statuses',): {
            'max_items': 6,
            'min_items': 1,
        },
        ('campaign_objective_types',): {
            'max_items': 6,
            'min_items': 1,
        },
        ('ad_group_ids',): {
            'max_items': 500,
            'min_items': 1,
        },
        ('ad_group_statuses',): {
            'max_items': 6,
            'min_items': 1,
        },
        ('ad_ids',): {
            'max_items': 500,
            'min_items': 1,
        },
        ('ad_statuses',): {
            'max_items': 6,
            'min_items': 1,
        },
        ('product_group_ids',): {
            'max_items': 500,
            'min_items': 1,
        },
        ('product_group_statuses',): {
            'max_items': 6,
            'min_items': 1,
        },
        ('product_item_ids',): {
            'max_items': 500,
            'min_items': 1,
        },
        ('targeting_types',): {
            'max_items': 5,
            'min_items': 1,
        },
        ('metrics_filters',): {
            'min_items': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'start_date': (str,),  # noqa: E501
            'end_date': (str,),  # noqa: E501
            'granularity': (str,),  # noqa: E501
            'columns': ([ReportingColumnAsync],),  # noqa: E501
            'level': (str,),  # noqa: E501
            'click_window_days': (int,),  # noqa: E501
            'engagement_window_days': (int,),  # noqa: E501
            'view_window_days': (int,),  # noqa: E501
            'conversion_report_time': (str,),  # noqa: E501
            'attribution_types': ([ConversionReportAttributionType],),  # noqa: E501
            'report_format': (str,),  # noqa: E501
            'campaign_ids': ([str],),  # noqa: E501
            'campaign_statuses': ([CampaignSummaryStatus],),  # noqa: E501
            'campaign_objective_types': ([ObjectiveType],),  # noqa: E501
            'ad_group_ids': ([str],),  # noqa: E501
            'ad_group_statuses': ([AdGroupSummaryStatus],),  # noqa: E501
            'ad_ids': ([str],),  # noqa: E501
            'ad_statuses': ([PinPromotionSummaryStatus],),  # noqa: E501
            'product_group_ids': ([str],),  # noqa: E501
            'product_group_statuses': ([ProductGroupSummaryStatus],),  # noqa: E501
            'product_item_ids': ([str],),  # noqa: E501
            'targeting_types': ([AdsAnalyticsTargetingType],),  # noqa: E501
            'metrics_filters': ([AdsAnalyticsMetricsFilter],),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'start_date': 'start_date',  # noqa: E501
        'end_date': 'end_date',  # noqa: E501
        'granularity': 'granularity',  # noqa: E501
        'columns': 'columns',  # noqa: E501
        'level': 'level',  # noqa: E501
        'click_window_days': 'click_window_days',  # noqa: E501
        'engagement_window_days': 'engagement_window_days',  # noqa: E501
        'view_window_days': 'view_window_days',  # noqa: E501
        'conversion_report_time': 'conversion_report_time',  # noqa: E501
        'attribution_types': 'attribution_types',  # noqa: E501
        'report_format': 'report_format',  # noqa: E501
        'campaign_ids': 'campaign_ids',  # noqa: E501
        'campaign_statuses': 'campaign_statuses',  # noqa: E501
        'campaign_objective_types': 'campaign_objective_types',  # noqa: E501
        'ad_group_ids': 'ad_group_ids',  # noqa: E501
        'ad_group_statuses': 'ad_group_statuses',  # noqa: E501
        'ad_ids': 'ad_ids',  # noqa: E501
        'ad_statuses': 'ad_statuses',  # noqa: E501
        'product_group_ids': 'product_group_ids',  # noqa: E501
        'product_group_statuses': 'product_group_statuses',  # noqa: E501
        'product_item_ids': 'product_item_ids',  # noqa: E501
        'targeting_types': 'targeting_types',  # noqa: E501
        'metrics_filters': 'metrics_filters',  # noqa: E501
    }

    read_only_vars = {
    }

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """AdsAnalyticsCreateAsyncRequest - a model defined in OpenAPI

        Keyword Args:
            start_date (str): Metric report start date (UTC). Format: YYYY-MM-DD
            end_date (str): Metric report end date (UTC). Format: YYYY-MM-DD
            granularity (str): TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
            columns ([ReportingColumnAsync]): Metric and entity columns
            level (str): Level of the report
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            click_window_days (int): Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30  # noqa: E501
            engagement_window_days (int): Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30  # noqa: E501
            view_window_days (int): Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.. [optional] if omitted the server will use the default value of 1  # noqa: E501
            conversion_report_time (str): The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.. [optional] if omitted the server will use the default value of "TIME_OF_AD_ACTION"  # noqa: E501
            attribution_types ([ConversionReportAttributionType]): List of types of attribution for the conversion report. [optional]  # noqa: E501
            report_format (str): Specification for formatting report data. [optional] if omitted the server will use the default value of "JSON"  # noqa: E501
            campaign_ids ([str]): List of campaign ids. [optional]  # noqa: E501
            campaign_statuses ([CampaignSummaryStatus]): List of status values for filtering. [optional]  # noqa: E501
            campaign_objective_types ([ObjectiveType]): List of values for filtering. [optional]  # noqa: E501
            ad_group_ids ([str]): List of ad group ids. [optional]  # noqa: E501
            ad_group_statuses ([AdGroupSummaryStatus]): List of values for filtering. [optional]  # noqa: E501
            ad_ids ([str]): List of ad ids. [optional]  # noqa: E501
            ad_statuses ([PinPromotionSummaryStatus]): List of values for filtering. [optional]  # noqa: E501
            product_group_ids ([str]): List of product group ids. [optional]  # noqa: E501
            product_group_statuses ([ProductGroupSummaryStatus]): List of values for filtering. [optional]  # noqa: E501
            product_item_ids ([str]): List of product item ids. [optional]  # noqa: E501
            targeting_types ([AdsAnalyticsTargetingType]): List of targeting types. [optional]  # noqa: E501
            metrics_filters ([AdsAnalyticsMetricsFilter]): List of metrics filters. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)

        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
        '_composed_instances',
        '_var_name_to_model_instances',
        '_additional_properties_model_instances',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """AdsAnalyticsCreateAsyncRequest - a model defined in OpenAPI

        Keyword Args:
            start_date (str): Metric report start date (UTC). Format: YYYY-MM-DD
            end_date (str): Metric report end date (UTC). Format: YYYY-MM-DD
            granularity (str): TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
            columns ([ReportingColumnAsync]): Metric and entity columns
            level (str): Level of the report
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            click_window_days (int): Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30  # noqa: E501
            engagement_window_days (int): Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30  # noqa: E501
            view_window_days (int): Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.. [optional] if omitted the server will use the default value of 1  # noqa: E501
            conversion_report_time (str): The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.. [optional] if omitted the server will use the default value of "TIME_OF_AD_ACTION"  # noqa: E501
            attribution_types ([ConversionReportAttributionType]): List of types of attribution for the conversion report. [optional]  # noqa: E501
            report_format (str): Specification for formatting report data. [optional] if omitted the server will use the default value of "JSON"  # noqa: E501
            campaign_ids ([str]): List of campaign ids. [optional]  # noqa: E501
            campaign_statuses ([CampaignSummaryStatus]): List of status values for filtering. [optional]  # noqa: E501
            campaign_objective_types ([ObjectiveType]): List of values for filtering. [optional]  # noqa: E501
            ad_group_ids ([str]): List of ad group ids. [optional]  # noqa: E501
            ad_group_statuses ([AdGroupSummaryStatus]): List of values for filtering. [optional]  # noqa: E501
            ad_ids ([str]): List of ad ids. [optional]  # noqa: E501
            ad_statuses ([PinPromotionSummaryStatus]): List of values for filtering. [optional]  # noqa: E501
            product_group_ids ([str]): List of product group ids. [optional]  # noqa: E501
            product_group_statuses ([ProductGroupSummaryStatus]): List of values for filtering. [optional]  # noqa: E501
            product_item_ids ([str]): List of product item ids. [optional]  # noqa: E501
            targeting_types ([AdsAnalyticsTargetingType]): List of targeting types. [optional]  # noqa: E501
            metrics_filters ([AdsAnalyticsMetricsFilter]): List of metrics filters. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        constant_args = {
            '_check_type': _check_type,
            '_path_to_item': _path_to_item,
            '_spec_property_naming': _spec_property_naming,
            '_configuration': _configuration,
            '_visited_composed_classes': self._visited_composed_classes,
        }
        composed_info = validate_get_composed_info(
            constant_args, kwargs, self)
        self._composed_instances = composed_info[0]
        self._var_name_to_model_instances = composed_info[1]
        self._additional_properties_model_instances = composed_info[2]
        discarded_args = composed_info[3]

        for var_name, var_value in kwargs.items():
            if var_name in discarded_args and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self._additional_properties_model_instances:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

    @cached_property
    def _composed_schemas():
        # we need this here to make our import statements work
        # we must store _composed_schemas in here so the code is only run
        # when we invoke this method. If we kept this at the class
        # level we would get an error because the class level
        # code would be run when this module is imported, and these composed
        # classes don't exist yet because their module has not finished
        # loading
        lazy_import()
        return {
          'anyOf': [
          ],
          'allOf': [
              AdsAnalyticsCreateAsyncRequestAllOf,
              AdsAnalyticsCreateAsyncRequestAllOf1,
          ],
          'oneOf': [
          ],
        }
