"""
    Pinterest REST API

    Pinterest's REST API  # noqa: E501

    The version of the OpenAPI document: 5.3.0
    Contact: blah@cliffano.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pinterestsdk.api_client import ApiClient, Endpoint as _Endpoint
from pinterestsdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from pinterestsdk.model.board import Board
from pinterestsdk.model.board_section import BoardSection
from pinterestsdk.model.board_update import BoardUpdate
from pinterestsdk.model.error import Error
from pinterestsdk.model.paginated import Paginated


class BoardsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.board_sections_create_endpoint = _Endpoint(
            settings={
                'response_type': (BoardSection,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/boards/{board_id}/sections',
                'operation_id': 'board_sections_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'board_id',
                    'board_section',
                ],
                'required': [
                    'board_id',
                    'board_section',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'board_id',
                ]
            },
            root_map={
                'validations': {
                    ('board_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'board_id':
                        (str,),
                    'board_section':
                        (BoardSection,),
                },
                'attribute_map': {
                    'board_id': 'board_id',
                },
                'location_map': {
                    'board_id': 'path',
                    'board_section': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.board_sections_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/boards/{board_id}/sections/{section_id}',
                'operation_id': 'board_sections_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'board_id',
                    'section_id',
                ],
                'required': [
                    'board_id',
                    'section_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'board_id',
                    'section_id',
                ]
            },
            root_map={
                'validations': {
                    ('board_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('section_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'board_id':
                        (str,),
                    'section_id':
                        (str,),
                },
                'attribute_map': {
                    'board_id': 'board_id',
                    'section_id': 'section_id',
                },
                'location_map': {
                    'board_id': 'path',
                    'section_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.board_sections_list_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/boards/{board_id}/sections',
                'operation_id': 'board_sections_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'board_id',
                    'bookmark',
                    'page_size',
                ],
                'required': [
                    'board_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'board_id',
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('board_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'board_id':
                        (str,),
                    'bookmark':
                        (str,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'board_id': 'board_id',
                    'bookmark': 'bookmark',
                    'page_size': 'page_size',
                },
                'location_map': {
                    'board_id': 'path',
                    'bookmark': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.board_sections_list_pins_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/boards/{board_id}/sections/{section_id}/pins',
                'operation_id': 'board_sections_list_pins',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'board_id',
                    'section_id',
                    'bookmark',
                    'page_size',
                ],
                'required': [
                    'board_id',
                    'section_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'board_id',
                    'section_id',
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('board_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('section_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'board_id':
                        (str,),
                    'section_id':
                        (str,),
                    'bookmark':
                        (str,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'board_id': 'board_id',
                    'section_id': 'section_id',
                    'bookmark': 'bookmark',
                    'page_size': 'page_size',
                },
                'location_map': {
                    'board_id': 'path',
                    'section_id': 'path',
                    'bookmark': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.board_sections_update_endpoint = _Endpoint(
            settings={
                'response_type': (BoardSection,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/boards/{board_id}/sections/{section_id}',
                'operation_id': 'board_sections_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'board_id',
                    'section_id',
                    'board_section',
                ],
                'required': [
                    'board_id',
                    'section_id',
                    'board_section',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'board_id',
                    'section_id',
                ]
            },
            root_map={
                'validations': {
                    ('board_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('section_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'board_id':
                        (str,),
                    'section_id':
                        (str,),
                    'board_section':
                        (BoardSection,),
                },
                'attribute_map': {
                    'board_id': 'board_id',
                    'section_id': 'section_id',
                },
                'location_map': {
                    'board_id': 'path',
                    'section_id': 'path',
                    'board_section': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.boards_create_endpoint = _Endpoint(
            settings={
                'response_type': (Board,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/boards',
                'operation_id': 'boards_create',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'board',
                ],
                'required': [
                    'board',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'board':
                        (Board,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'board': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.boards_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/boards/{board_id}',
                'operation_id': 'boards_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'board_id',
                ],
                'required': [
                    'board_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'board_id',
                ]
            },
            root_map={
                'validations': {
                    ('board_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'board_id':
                        (str,),
                },
                'attribute_map': {
                    'board_id': 'board_id',
                },
                'location_map': {
                    'board_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.boards_get_endpoint = _Endpoint(
            settings={
                'response_type': (Board,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/boards/{board_id}',
                'operation_id': 'boards_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'board_id',
                ],
                'required': [
                    'board_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'board_id',
                ]
            },
            root_map={
                'validations': {
                    ('board_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'board_id':
                        (str,),
                },
                'attribute_map': {
                    'board_id': 'board_id',
                },
                'location_map': {
                    'board_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.boards_list_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/boards',
                'operation_id': 'boards_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'bookmark',
                    'page_size',
                    'privacy',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'privacy',
                ],
                'validation': [
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('privacy',): {

                        "PUBLIC": "PUBLIC",
                        "PROTECTED": "PROTECTED",
                        "SECRET": "SECRET"
                    },
                },
                'openapi_types': {
                    'bookmark':
                        (str,),
                    'page_size':
                        (int,),
                    'privacy':
                        (str,),
                },
                'attribute_map': {
                    'bookmark': 'bookmark',
                    'page_size': 'page_size',
                    'privacy': 'privacy',
                },
                'location_map': {
                    'bookmark': 'query',
                    'page_size': 'query',
                    'privacy': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.boards_list_pins_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/boards/{board_id}/pins',
                'operation_id': 'boards_list_pins',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'board_id',
                    'bookmark',
                    'page_size',
                ],
                'required': [
                    'board_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'board_id',
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('board_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'board_id':
                        (str,),
                    'bookmark':
                        (str,),
                    'page_size':
                        (int,),
                },
                'attribute_map': {
                    'board_id': 'board_id',
                    'bookmark': 'bookmark',
                    'page_size': 'page_size',
                },
                'location_map': {
                    'board_id': 'path',
                    'bookmark': 'query',
                    'page_size': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.boards_update_endpoint = _Endpoint(
            settings={
                'response_type': (Board,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/boards/{board_id}',
                'operation_id': 'boards_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'board_id',
                    'board_update',
                ],
                'required': [
                    'board_id',
                    'board_update',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'board_id',
                ]
            },
            root_map={
                'validations': {
                    ('board_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'board_id':
                        (str,),
                    'board_update':
                        (BoardUpdate,),
                },
                'attribute_map': {
                    'board_id': 'board_id',
                },
                'location_map': {
                    'board_id': 'path',
                    'board_update': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def board_sections_create(
        self,
        board_id,
        board_section,
        **kwargs
    ):
        """Create board section  # noqa: E501

        Create a board section on a board owned by the \"operation user_account\" - or on a group board that has been shared with this account. - By default, the \"operation user_account\" is the token user_account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.board_sections_create(board_id, board_section, async_req=True)
        >>> result = thread.get()

        Args:
            board_id (str): Unique identifier of a board.
            board_section (BoardSection): Create a board section.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            BoardSection
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['board_id'] = \
            board_id
        kwargs['board_section'] = \
            board_section
        return self.board_sections_create_endpoint.call_with_http_info(**kwargs)

    def board_sections_delete(
        self,
        board_id,
        section_id,
        **kwargs
    ):
        """Delete board section  # noqa: E501

        Delete a board section on a board owned by the \"operation user_account\" - or on a group board that has been shared with this account. - By default, the \"operation user_account\" is the token user_account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.board_sections_delete(board_id, section_id, async_req=True)
        >>> result = thread.get()

        Args:
            board_id (str): Unique identifier of a board.
            section_id (str): Unique identifier of a board section.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['board_id'] = \
            board_id
        kwargs['section_id'] = \
            section_id
        return self.board_sections_delete_endpoint.call_with_http_info(**kwargs)

    def board_sections_list(
        self,
        board_id,
        **kwargs
    ):
        """List board sections  # noqa: E501

        Get a list of all board sections from a board owned by the \"operation user_account\" - or a group board that has been shared with this account. - By default, the \"operation user_account\" is the token user_account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.board_sections_list(board_id, async_req=True)
        >>> result = thread.get()

        Args:
            board_id (str): Unique identifier of a board.

        Keyword Args:
            bookmark (str): Cursor used to fetch the next page of items. [optional]
            page_size (int): Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/api/v5/#tag/Pagination'>Pagination</a> for more information.. [optional] if omitted the server will use the default value of 25
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['board_id'] = \
            board_id
        return self.board_sections_list_endpoint.call_with_http_info(**kwargs)

    def board_sections_list_pins(
        self,
        board_id,
        section_id,
        **kwargs
    ):
        """List Pins on board section  # noqa: E501

        Get a list of the Pins on a board section of a board owned by the \"operation user_account\" - or on a group board that has been shared with this account. - By default, the \"operation user_account\" is the token user_account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.board_sections_list_pins(board_id, section_id, async_req=True)
        >>> result = thread.get()

        Args:
            board_id (str): Unique identifier of a board.
            section_id (str): Unique identifier of a board section.

        Keyword Args:
            bookmark (str): Cursor used to fetch the next page of items. [optional]
            page_size (int): Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/api/v5/#tag/Pagination'>Pagination</a> for more information.. [optional] if omitted the server will use the default value of 25
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['board_id'] = \
            board_id
        kwargs['section_id'] = \
            section_id
        return self.board_sections_list_pins_endpoint.call_with_http_info(**kwargs)

    def board_sections_update(
        self,
        board_id,
        section_id,
        board_section,
        **kwargs
    ):
        """Update board section  # noqa: E501

        Update a board section on a board owned by the \"operation user_account\" - or on a group board that has been shared with this account. - By default, the \"operation user_account\" is the token user_account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.board_sections_update(board_id, section_id, board_section, async_req=True)
        >>> result = thread.get()

        Args:
            board_id (str): Unique identifier of a board.
            section_id (str): Unique identifier of a board section.
            board_section (BoardSection): Update a board section.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            BoardSection
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['board_id'] = \
            board_id
        kwargs['section_id'] = \
            section_id
        kwargs['board_section'] = \
            board_section
        return self.board_sections_update_endpoint.call_with_http_info(**kwargs)

    def boards_create(
        self,
        board,
        **kwargs
    ):
        """Create board  # noqa: E501

        Create a board owned by the \"operation user_account\". - By default, the \"operation user_account\" is the token user_account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.boards_create(board, async_req=True)
        >>> result = thread.get()

        Args:
            board (Board): Create a board using a single board json object.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Board
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['board'] = \
            board
        return self.boards_create_endpoint.call_with_http_info(**kwargs)

    def boards_delete(
        self,
        board_id,
        **kwargs
    ):
        """Delete board  # noqa: E501

        Delete a board owned by the \"operation user_account\". - By default, the \"operation user_account\" is the token user_account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.boards_delete(board_id, async_req=True)
        >>> result = thread.get()

        Args:
            board_id (str): Unique identifier of a board.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['board_id'] = \
            board_id
        return self.boards_delete_endpoint.call_with_http_info(**kwargs)

    def boards_get(
        self,
        board_id,
        **kwargs
    ):
        """Get board  # noqa: E501

        Get a board owned by the operation user_account - or a group board that has been shared with this account. - By default, the \"operation user_account\" is the token user_account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.boards_get(board_id, async_req=True)
        >>> result = thread.get()

        Args:
            board_id (str): Unique identifier of a board.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Board
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['board_id'] = \
            board_id
        return self.boards_get_endpoint.call_with_http_info(**kwargs)

    def boards_list(
        self,
        **kwargs
    ):
        """List boards  # noqa: E501

        Get a list of the boards owned by the \"operation user_account\" + group boards where this account is a collaborator  Optional: Specify a privacy type (public, protected, or secret) to indicate which boards to return. - If no privacy is specified, all boards that can be returned (based on the scopes of the token and ad_account role if applicable) will be returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.boards_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            bookmark (str): Cursor used to fetch the next page of items. [optional]
            page_size (int): Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/api/v5/#tag/Pagination'>Pagination</a> for more information.. [optional] if omitted the server will use the default value of 25
            privacy (str): Privacy setting for a board.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.boards_list_endpoint.call_with_http_info(**kwargs)

    def boards_list_pins(
        self,
        board_id,
        **kwargs
    ):
        """List Pins on board  # noqa: E501

        Get a list of the Pins on a board owned by the \"operation user_account\" - or on a group board that has been shared with this account. - By default, the \"operation user_account\" is the token user_account.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.boards_list_pins(board_id, async_req=True)
        >>> result = thread.get()

        Args:
            board_id (str): Unique identifier of a board.

        Keyword Args:
            bookmark (str): Cursor used to fetch the next page of items. [optional]
            page_size (int): Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/api/v5/#tag/Pagination'>Pagination</a> for more information.. [optional] if omitted the server will use the default value of 25
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['board_id'] = \
            board_id
        return self.boards_list_pins_endpoint.call_with_http_info(**kwargs)

    def boards_update(
        self,
        board_id,
        board_update,
        **kwargs
    ):
        """Update board  # noqa: E501

        Update a board owned by the \"operating user_account\".  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.boards_update(board_id, board_update, async_req=True)
        >>> result = thread.get()

        Args:
            board_id (str): Unique identifier of a board.
            board_update (BoardUpdate): Update a board.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Board
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['board_id'] = \
            board_id
        kwargs['board_update'] = \
            board_update
        return self.boards_update_endpoint.call_with_http_info(**kwargs)

