"""
    Pinterest REST API

    Pinterest's REST API  # noqa: E501

    The version of the OpenAPI document: 5.3.0
    Contact: blah@cliffano.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pinterestsdk.api_client import ApiClient, Endpoint as _Endpoint
from pinterestsdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from pinterestsdk.model.ad_account_analytics_response import AdAccountAnalyticsResponse
from pinterestsdk.model.ad_groups_analytics_response import AdGroupsAnalyticsResponse
from pinterestsdk.model.ads_analytics_create_async_request import AdsAnalyticsCreateAsyncRequest
from pinterestsdk.model.ads_analytics_create_async_response import AdsAnalyticsCreateAsyncResponse
from pinterestsdk.model.ads_analytics_get_async_response import AdsAnalyticsGetAsyncResponse
from pinterestsdk.model.ads_analytics_response import AdsAnalyticsResponse
from pinterestsdk.model.campaigns_analytics_response import CampaignsAnalyticsResponse
from pinterestsdk.model.error import Error
from pinterestsdk.model.granularity import Granularity
from pinterestsdk.model.paginated import Paginated
from pinterestsdk.model.product_group_analytics_response import ProductGroupAnalyticsResponse


class AdAccountsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.ad_account_analytics_endpoint = _Endpoint(
            settings={
                'response_type': (AdAccountAnalyticsResponse,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/ad_accounts/{ad_account_id}/analytics',
                'operation_id': 'ad_account_analytics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ad_account_id',
                    'start_date',
                    'end_date',
                    'columns',
                    'granularity',
                    'click_window_days',
                    'engagement_window_days',
                    'view_window_days',
                    'conversion_report_time',
                ],
                'required': [
                    'ad_account_id',
                    'start_date',
                    'end_date',
                    'columns',
                    'granularity',
                ],
                'nullable': [
                ],
                'enum': [
                    'columns',
                    'click_window_days',
                    'engagement_window_days',
                    'view_window_days',
                    'conversion_report_time',
                ],
                'validation': [
                    'ad_account_id',
                ]
            },
            root_map={
                'validations': {
                    ('ad_account_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                    ('columns',): {

                        "AD_ACCOUNT_ID": "AD_ACCOUNT_ID",
                        "AD_GROUP_ENTITY_STATUS": "AD_GROUP_ENTITY_STATUS",
                        "AD_GROUP_ID": "AD_GROUP_ID",
                        "AD_ID": "AD_ID",
                        "CAMPAIGN_DAILY_SPEND_CAP": "CAMPAIGN_DAILY_SPEND_CAP",
                        "CAMPAIGN_ENTITY_STATUS": "CAMPAIGN_ENTITY_STATUS",
                        "CAMPAIGN_ID": "CAMPAIGN_ID",
                        "CAMPAIGN_LIFETIME_SPEND_CAP": "CAMPAIGN_LIFETIME_SPEND_CAP",
                        "CAMPAIGN_NAME": "CAMPAIGN_NAME",
                        "CHECKOUT_ROAS": "CHECKOUT_ROAS",
                        "CLICKTHROUGH_1": "CLICKTHROUGH_1",
                        "CLICKTHROUGH_1_GROSS": "CLICKTHROUGH_1_GROSS",
                        "CLICKTHROUGH_2": "CLICKTHROUGH_2",
                        "CPC_IN_MICRO_DOLLAR": "CPC_IN_MICRO_DOLLAR",
                        "CPM_IN_DOLLAR": "CPM_IN_DOLLAR",
                        "CPM_IN_MICRO_DOLLAR": "CPM_IN_MICRO_DOLLAR",
                        "CTR": "CTR",
                        "CTR_2": "CTR_2",
                        "ECPCV_IN_DOLLAR": "ECPCV_IN_DOLLAR",
                        "ECPCV_P95_IN_DOLLAR": "ECPCV_P95_IN_DOLLAR",
                        "ECPC_IN_DOLLAR": "ECPC_IN_DOLLAR",
                        "ECPC_IN_MICRO_DOLLAR": "ECPC_IN_MICRO_DOLLAR",
                        "ECPE_IN_DOLLAR": "ECPE_IN_DOLLAR",
                        "ECPM_IN_MICRO_DOLLAR": "ECPM_IN_MICRO_DOLLAR",
                        "ECPV_IN_DOLLAR": "ECPV_IN_DOLLAR",
                        "ECTR": "ECTR",
                        "EENGAGEMENT_RATE": "EENGAGEMENT_RATE",
                        "ENGAGEMENT_1": "ENGAGEMENT_1",
                        "ENGAGEMENT_2": "ENGAGEMENT_2",
                        "ENGAGEMENT_RATE": "ENGAGEMENT_RATE",
                        "IDEA_PIN_PRODUCT_TAG_VISIT_1": "IDEA_PIN_PRODUCT_TAG_VISIT_1",
                        "IDEA_PIN_PRODUCT_TAG_VISIT_2": "IDEA_PIN_PRODUCT_TAG_VISIT_2",
                        "IMPRESSION_1": "IMPRESSION_1",
                        "IMPRESSION_1_GROSS": "IMPRESSION_1_GROSS",
                        "IMPRESSION_2": "IMPRESSION_2",
                        "INAPP_CHECKOUT_COST_PER_ACTION": "INAPP_CHECKOUT_COST_PER_ACTION",
                        "OUTBOUND_CLICK_1": "OUTBOUND_CLICK_1",
                        "OUTBOUND_CLICK_2": "OUTBOUND_CLICK_2",
                        "PAGE_VISIT_COST_PER_ACTION": "PAGE_VISIT_COST_PER_ACTION",
                        "PAGE_VISIT_ROAS": "PAGE_VISIT_ROAS",
                        "PAID_IMPRESSION": "PAID_IMPRESSION",
                        "PIN_ID": "PIN_ID",
                        "REPIN_1": "REPIN_1",
                        "REPIN_2": "REPIN_2",
                        "REPIN_RATE": "REPIN_RATE",
                        "SPEND_IN_DOLLAR": "SPEND_IN_DOLLAR",
                        "SPEND_IN_MICRO_DOLLAR": "SPEND_IN_MICRO_DOLLAR",
                        "TOTAL_CHECKOUT": "TOTAL_CHECKOUT",
                        "TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CLICKTHROUGH": "TOTAL_CLICKTHROUGH",
                        "TOTAL_CLICK_CHECKOUT": "TOTAL_CLICK_CHECKOUT",
                        "TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CLICK_LEAD": "TOTAL_CLICK_LEAD",
                        "TOTAL_CLICK_SIGNUP": "TOTAL_CLICK_SIGNUP",
                        "TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CONVERSIONS": "TOTAL_CONVERSIONS",
                        "TOTAL_CUSTOM": "TOTAL_CUSTOM",
                        "TOTAL_ENGAGEMENT": "TOTAL_ENGAGEMENT",
                        "TOTAL_ENGAGEMENT_CHECKOUT": "TOTAL_ENGAGEMENT_CHECKOUT",
                        "TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_ENGAGEMENT_LEAD": "TOTAL_ENGAGEMENT_LEAD",
                        "TOTAL_ENGAGEMENT_SIGNUP": "TOTAL_ENGAGEMENT_SIGNUP",
                        "TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT": "TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT",
                        "TOTAL_IMPRESSION_FREQUENCY": "TOTAL_IMPRESSION_FREQUENCY",
                        "TOTAL_IMPRESSION_USER": "TOTAL_IMPRESSION_USER",
                        "TOTAL_LEAD": "TOTAL_LEAD",
                        "TOTAL_PAGE_VISIT": "TOTAL_PAGE_VISIT",
                        "TOTAL_REPIN_RATE": "TOTAL_REPIN_RATE",
                        "TOTAL_SIGNUP": "TOTAL_SIGNUP",
                        "TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_VIDEO_3SEC_VIEWS": "TOTAL_VIDEO_3SEC_VIEWS",
                        "TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND": "TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND",
                        "TOTAL_VIDEO_MRC_VIEWS": "TOTAL_VIDEO_MRC_VIEWS",
                        "TOTAL_VIDEO_P0_COMBINED": "TOTAL_VIDEO_P0_COMBINED",
                        "TOTAL_VIDEO_P100_COMPLETE": "TOTAL_VIDEO_P100_COMPLETE",
                        "TOTAL_VIDEO_P25_COMBINED": "TOTAL_VIDEO_P25_COMBINED",
                        "TOTAL_VIDEO_P50_COMBINED": "TOTAL_VIDEO_P50_COMBINED",
                        "TOTAL_VIDEO_P75_COMBINED": "TOTAL_VIDEO_P75_COMBINED",
                        "TOTAL_VIDEO_P95_COMBINED": "TOTAL_VIDEO_P95_COMBINED",
                        "TOTAL_VIEW_CHECKOUT": "TOTAL_VIEW_CHECKOUT",
                        "TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_VIEW_LEAD": "TOTAL_VIEW_LEAD",
                        "TOTAL_VIEW_SIGNUP": "TOTAL_VIEW_SIGNUP",
                        "TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_CHECKOUT": "TOTAL_WEB_CHECKOUT",
                        "TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_CLICK_CHECKOUT": "TOTAL_WEB_CLICK_CHECKOUT",
                        "TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_ENGAGEMENT_CHECKOUT": "TOTAL_WEB_ENGAGEMENT_CHECKOUT",
                        "TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_VIEW_CHECKOUT": "TOTAL_WEB_VIEW_CHECKOUT",
                        "TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "VIDEO_3SEC_VIEWS_2": "VIDEO_3SEC_VIEWS_2",
                        "VIDEO_LENGTH": "VIDEO_LENGTH",
                        "VIDEO_MRC_VIEWS_2": "VIDEO_MRC_VIEWS_2",
                        "VIDEO_P0_COMBINED_2": "VIDEO_P0_COMBINED_2",
                        "VIDEO_P100_COMPLETE_2": "VIDEO_P100_COMPLETE_2",
                        "VIDEO_P25_COMBINED_2": "VIDEO_P25_COMBINED_2",
                        "VIDEO_P50_COMBINED_2": "VIDEO_P50_COMBINED_2",
                        "VIDEO_P75_COMBINED_2": "VIDEO_P75_COMBINED_2",
                        "VIDEO_P95_COMBINED_2": "VIDEO_P95_COMBINED_2",
                        "WEB_CHECKOUT_COST_PER_ACTION": "WEB_CHECKOUT_COST_PER_ACTION",
                        "WEB_CHECKOUT_ROAS": "WEB_CHECKOUT_ROAS"
                    },
                    ('click_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('engagement_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('view_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('conversion_report_time',): {

                        "AD_ACTION": "TIME_OF_AD_ACTION",
                        "CONVERSION": "TIME_OF_CONVERSION"
                    },
                },
                'openapi_types': {
                    'ad_account_id':
                        (str,),
                    'start_date':
                        (date,),
                    'end_date':
                        (date,),
                    'columns':
                        ([str],),
                    'granularity':
                        (Granularity,),
                    'click_window_days':
                        (int,),
                    'engagement_window_days':
                        (int,),
                    'view_window_days':
                        (int,),
                    'conversion_report_time':
                        (str,),
                },
                'attribute_map': {
                    'ad_account_id': 'ad_account_id',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'columns': 'columns',
                    'granularity': 'granularity',
                    'click_window_days': 'click_window_days',
                    'engagement_window_days': 'engagement_window_days',
                    'view_window_days': 'view_window_days',
                    'conversion_report_time': 'conversion_report_time',
                },
                'location_map': {
                    'ad_account_id': 'path',
                    'start_date': 'query',
                    'end_date': 'query',
                    'columns': 'query',
                    'granularity': 'query',
                    'click_window_days': 'query',
                    'engagement_window_days': 'query',
                    'view_window_days': 'query',
                    'conversion_report_time': 'query',
                },
                'collection_format_map': {
                    'columns': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.ad_accounts_list_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/ad_accounts',
                'operation_id': 'ad_accounts_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'bookmark',
                    'page_size',
                    'include_shared_accounts',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'bookmark':
                        (str,),
                    'page_size':
                        (int,),
                    'include_shared_accounts':
                        (bool,),
                },
                'attribute_map': {
                    'bookmark': 'bookmark',
                    'page_size': 'page_size',
                    'include_shared_accounts': 'include_shared_accounts',
                },
                'location_map': {
                    'bookmark': 'query',
                    'page_size': 'query',
                    'include_shared_accounts': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.ad_groups_analytics_endpoint = _Endpoint(
            settings={
                'response_type': (AdGroupsAnalyticsResponse,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/ad_accounts/{ad_account_id}/ad_groups/analytics',
                'operation_id': 'ad_groups_analytics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ad_account_id',
                    'start_date',
                    'end_date',
                    'ad_group_ids',
                    'columns',
                    'granularity',
                    'click_window_days',
                    'engagement_window_days',
                    'view_window_days',
                    'conversion_report_time',
                ],
                'required': [
                    'ad_account_id',
                    'start_date',
                    'end_date',
                    'ad_group_ids',
                    'columns',
                    'granularity',
                ],
                'nullable': [
                ],
                'enum': [
                    'columns',
                    'click_window_days',
                    'engagement_window_days',
                    'view_window_days',
                    'conversion_report_time',
                ],
                'validation': [
                    'ad_account_id',
                    'ad_group_ids',
                ]
            },
            root_map={
                'validations': {
                    ('ad_account_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('ad_group_ids',): {

                        'max_items': 100,
                        'min_items': 1,
                    },
                },
                'allowed_values': {
                    ('columns',): {

                        "AD_ACCOUNT_ID": "AD_ACCOUNT_ID",
                        "AD_GROUP_ENTITY_STATUS": "AD_GROUP_ENTITY_STATUS",
                        "AD_GROUP_ID": "AD_GROUP_ID",
                        "AD_ID": "AD_ID",
                        "CAMPAIGN_DAILY_SPEND_CAP": "CAMPAIGN_DAILY_SPEND_CAP",
                        "CAMPAIGN_ENTITY_STATUS": "CAMPAIGN_ENTITY_STATUS",
                        "CAMPAIGN_ID": "CAMPAIGN_ID",
                        "CAMPAIGN_LIFETIME_SPEND_CAP": "CAMPAIGN_LIFETIME_SPEND_CAP",
                        "CAMPAIGN_NAME": "CAMPAIGN_NAME",
                        "CHECKOUT_ROAS": "CHECKOUT_ROAS",
                        "CLICKTHROUGH_1": "CLICKTHROUGH_1",
                        "CLICKTHROUGH_1_GROSS": "CLICKTHROUGH_1_GROSS",
                        "CLICKTHROUGH_2": "CLICKTHROUGH_2",
                        "CPC_IN_MICRO_DOLLAR": "CPC_IN_MICRO_DOLLAR",
                        "CPM_IN_DOLLAR": "CPM_IN_DOLLAR",
                        "CPM_IN_MICRO_DOLLAR": "CPM_IN_MICRO_DOLLAR",
                        "CTR": "CTR",
                        "CTR_2": "CTR_2",
                        "ECPCV_IN_DOLLAR": "ECPCV_IN_DOLLAR",
                        "ECPCV_P95_IN_DOLLAR": "ECPCV_P95_IN_DOLLAR",
                        "ECPC_IN_DOLLAR": "ECPC_IN_DOLLAR",
                        "ECPC_IN_MICRO_DOLLAR": "ECPC_IN_MICRO_DOLLAR",
                        "ECPE_IN_DOLLAR": "ECPE_IN_DOLLAR",
                        "ECPM_IN_MICRO_DOLLAR": "ECPM_IN_MICRO_DOLLAR",
                        "ECPV_IN_DOLLAR": "ECPV_IN_DOLLAR",
                        "ECTR": "ECTR",
                        "EENGAGEMENT_RATE": "EENGAGEMENT_RATE",
                        "ENGAGEMENT_1": "ENGAGEMENT_1",
                        "ENGAGEMENT_2": "ENGAGEMENT_2",
                        "ENGAGEMENT_RATE": "ENGAGEMENT_RATE",
                        "IDEA_PIN_PRODUCT_TAG_VISIT_1": "IDEA_PIN_PRODUCT_TAG_VISIT_1",
                        "IDEA_PIN_PRODUCT_TAG_VISIT_2": "IDEA_PIN_PRODUCT_TAG_VISIT_2",
                        "IMPRESSION_1": "IMPRESSION_1",
                        "IMPRESSION_1_GROSS": "IMPRESSION_1_GROSS",
                        "IMPRESSION_2": "IMPRESSION_2",
                        "INAPP_CHECKOUT_COST_PER_ACTION": "INAPP_CHECKOUT_COST_PER_ACTION",
                        "OUTBOUND_CLICK_1": "OUTBOUND_CLICK_1",
                        "OUTBOUND_CLICK_2": "OUTBOUND_CLICK_2",
                        "PAGE_VISIT_COST_PER_ACTION": "PAGE_VISIT_COST_PER_ACTION",
                        "PAGE_VISIT_ROAS": "PAGE_VISIT_ROAS",
                        "PAID_IMPRESSION": "PAID_IMPRESSION",
                        "PIN_ID": "PIN_ID",
                        "REPIN_1": "REPIN_1",
                        "REPIN_2": "REPIN_2",
                        "REPIN_RATE": "REPIN_RATE",
                        "SPEND_IN_DOLLAR": "SPEND_IN_DOLLAR",
                        "SPEND_IN_MICRO_DOLLAR": "SPEND_IN_MICRO_DOLLAR",
                        "TOTAL_CHECKOUT": "TOTAL_CHECKOUT",
                        "TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CLICKTHROUGH": "TOTAL_CLICKTHROUGH",
                        "TOTAL_CLICK_CHECKOUT": "TOTAL_CLICK_CHECKOUT",
                        "TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CLICK_LEAD": "TOTAL_CLICK_LEAD",
                        "TOTAL_CLICK_SIGNUP": "TOTAL_CLICK_SIGNUP",
                        "TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CONVERSIONS": "TOTAL_CONVERSIONS",
                        "TOTAL_CUSTOM": "TOTAL_CUSTOM",
                        "TOTAL_ENGAGEMENT": "TOTAL_ENGAGEMENT",
                        "TOTAL_ENGAGEMENT_CHECKOUT": "TOTAL_ENGAGEMENT_CHECKOUT",
                        "TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_ENGAGEMENT_LEAD": "TOTAL_ENGAGEMENT_LEAD",
                        "TOTAL_ENGAGEMENT_SIGNUP": "TOTAL_ENGAGEMENT_SIGNUP",
                        "TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT": "TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT",
                        "TOTAL_IMPRESSION_FREQUENCY": "TOTAL_IMPRESSION_FREQUENCY",
                        "TOTAL_IMPRESSION_USER": "TOTAL_IMPRESSION_USER",
                        "TOTAL_LEAD": "TOTAL_LEAD",
                        "TOTAL_PAGE_VISIT": "TOTAL_PAGE_VISIT",
                        "TOTAL_REPIN_RATE": "TOTAL_REPIN_RATE",
                        "TOTAL_SIGNUP": "TOTAL_SIGNUP",
                        "TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_VIDEO_3SEC_VIEWS": "TOTAL_VIDEO_3SEC_VIEWS",
                        "TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND": "TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND",
                        "TOTAL_VIDEO_MRC_VIEWS": "TOTAL_VIDEO_MRC_VIEWS",
                        "TOTAL_VIDEO_P0_COMBINED": "TOTAL_VIDEO_P0_COMBINED",
                        "TOTAL_VIDEO_P100_COMPLETE": "TOTAL_VIDEO_P100_COMPLETE",
                        "TOTAL_VIDEO_P25_COMBINED": "TOTAL_VIDEO_P25_COMBINED",
                        "TOTAL_VIDEO_P50_COMBINED": "TOTAL_VIDEO_P50_COMBINED",
                        "TOTAL_VIDEO_P75_COMBINED": "TOTAL_VIDEO_P75_COMBINED",
                        "TOTAL_VIDEO_P95_COMBINED": "TOTAL_VIDEO_P95_COMBINED",
                        "TOTAL_VIEW_CHECKOUT": "TOTAL_VIEW_CHECKOUT",
                        "TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_VIEW_LEAD": "TOTAL_VIEW_LEAD",
                        "TOTAL_VIEW_SIGNUP": "TOTAL_VIEW_SIGNUP",
                        "TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_CHECKOUT": "TOTAL_WEB_CHECKOUT",
                        "TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_CLICK_CHECKOUT": "TOTAL_WEB_CLICK_CHECKOUT",
                        "TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_ENGAGEMENT_CHECKOUT": "TOTAL_WEB_ENGAGEMENT_CHECKOUT",
                        "TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_VIEW_CHECKOUT": "TOTAL_WEB_VIEW_CHECKOUT",
                        "TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "VIDEO_3SEC_VIEWS_2": "VIDEO_3SEC_VIEWS_2",
                        "VIDEO_LENGTH": "VIDEO_LENGTH",
                        "VIDEO_MRC_VIEWS_2": "VIDEO_MRC_VIEWS_2",
                        "VIDEO_P0_COMBINED_2": "VIDEO_P0_COMBINED_2",
                        "VIDEO_P100_COMPLETE_2": "VIDEO_P100_COMPLETE_2",
                        "VIDEO_P25_COMBINED_2": "VIDEO_P25_COMBINED_2",
                        "VIDEO_P50_COMBINED_2": "VIDEO_P50_COMBINED_2",
                        "VIDEO_P75_COMBINED_2": "VIDEO_P75_COMBINED_2",
                        "VIDEO_P95_COMBINED_2": "VIDEO_P95_COMBINED_2",
                        "WEB_CHECKOUT_COST_PER_ACTION": "WEB_CHECKOUT_COST_PER_ACTION",
                        "WEB_CHECKOUT_ROAS": "WEB_CHECKOUT_ROAS"
                    },
                    ('click_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('engagement_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('view_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('conversion_report_time',): {

                        "AD_ACTION": "TIME_OF_AD_ACTION",
                        "CONVERSION": "TIME_OF_CONVERSION"
                    },
                },
                'openapi_types': {
                    'ad_account_id':
                        (str,),
                    'start_date':
                        (date,),
                    'end_date':
                        (date,),
                    'ad_group_ids':
                        ([str],),
                    'columns':
                        ([str],),
                    'granularity':
                        (Granularity,),
                    'click_window_days':
                        (int,),
                    'engagement_window_days':
                        (int,),
                    'view_window_days':
                        (int,),
                    'conversion_report_time':
                        (str,),
                },
                'attribute_map': {
                    'ad_account_id': 'ad_account_id',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'ad_group_ids': 'ad_group_ids',
                    'columns': 'columns',
                    'granularity': 'granularity',
                    'click_window_days': 'click_window_days',
                    'engagement_window_days': 'engagement_window_days',
                    'view_window_days': 'view_window_days',
                    'conversion_report_time': 'conversion_report_time',
                },
                'location_map': {
                    'ad_account_id': 'path',
                    'start_date': 'query',
                    'end_date': 'query',
                    'ad_group_ids': 'query',
                    'columns': 'query',
                    'granularity': 'query',
                    'click_window_days': 'query',
                    'engagement_window_days': 'query',
                    'view_window_days': 'query',
                    'conversion_report_time': 'query',
                },
                'collection_format_map': {
                    'ad_group_ids': 'multi',
                    'columns': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.ad_groups_list_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/ad_accounts/{ad_account_id}/ad_groups',
                'operation_id': 'ad_groups_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ad_account_id',
                    'campaign_ids',
                    'ad_group_ids',
                    'entity_statuses',
                    'page_size',
                    'order',
                    'bookmark',
                    'translate_interests_to_names',
                ],
                'required': [
                    'ad_account_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'entity_statuses',
                    'order',
                ],
                'validation': [
                    'ad_account_id',
                    'campaign_ids',
                    'ad_group_ids',
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('ad_account_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('campaign_ids',): {

                        'max_items': 100,
                        'min_items': 1,
                    },
                    ('ad_group_ids',): {

                        'max_items': 100,
                        'min_items': 1,
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('entity_statuses',): {

                        "ACTIVE": "ACTIVE",
                        "PAUSED": "PAUSED",
                        "ARCHIVED": "ARCHIVED"
                    },
                    ('order',): {

                        "ASCENDING": "ASCENDING",
                        "DESCENDING": "DESCENDING"
                    },
                },
                'openapi_types': {
                    'ad_account_id':
                        (str,),
                    'campaign_ids':
                        ([str],),
                    'ad_group_ids':
                        ([str],),
                    'entity_statuses':
                        ([str],),
                    'page_size':
                        (int,),
                    'order':
                        (str,),
                    'bookmark':
                        (str,),
                    'translate_interests_to_names':
                        (bool,),
                },
                'attribute_map': {
                    'ad_account_id': 'ad_account_id',
                    'campaign_ids': 'campaign_ids',
                    'ad_group_ids': 'ad_group_ids',
                    'entity_statuses': 'entity_statuses',
                    'page_size': 'page_size',
                    'order': 'order',
                    'bookmark': 'bookmark',
                    'translate_interests_to_names': 'translate_interests_to_names',
                },
                'location_map': {
                    'ad_account_id': 'path',
                    'campaign_ids': 'query',
                    'ad_group_ids': 'query',
                    'entity_statuses': 'query',
                    'page_size': 'query',
                    'order': 'query',
                    'bookmark': 'query',
                    'translate_interests_to_names': 'query',
                },
                'collection_format_map': {
                    'campaign_ids': 'multi',
                    'ad_group_ids': 'multi',
                    'entity_statuses': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.ads_analytics_endpoint = _Endpoint(
            settings={
                'response_type': (AdsAnalyticsResponse,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/ad_accounts/{ad_account_id}/ads/analytics',
                'operation_id': 'ads_analytics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ad_account_id',
                    'start_date',
                    'end_date',
                    'ad_ids',
                    'columns',
                    'granularity',
                    'click_window_days',
                    'engagement_window_days',
                    'view_window_days',
                    'conversion_report_time',
                ],
                'required': [
                    'ad_account_id',
                    'start_date',
                    'end_date',
                    'ad_ids',
                    'columns',
                    'granularity',
                ],
                'nullable': [
                ],
                'enum': [
                    'columns',
                    'click_window_days',
                    'engagement_window_days',
                    'view_window_days',
                    'conversion_report_time',
                ],
                'validation': [
                    'ad_account_id',
                    'ad_ids',
                ]
            },
            root_map={
                'validations': {
                    ('ad_account_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('ad_ids',): {

                        'max_items': 100,
                        'min_items': 1,
                    },
                },
                'allowed_values': {
                    ('columns',): {

                        "AD_ACCOUNT_ID": "AD_ACCOUNT_ID",
                        "AD_GROUP_ENTITY_STATUS": "AD_GROUP_ENTITY_STATUS",
                        "AD_GROUP_ID": "AD_GROUP_ID",
                        "AD_ID": "AD_ID",
                        "CAMPAIGN_DAILY_SPEND_CAP": "CAMPAIGN_DAILY_SPEND_CAP",
                        "CAMPAIGN_ENTITY_STATUS": "CAMPAIGN_ENTITY_STATUS",
                        "CAMPAIGN_ID": "CAMPAIGN_ID",
                        "CAMPAIGN_LIFETIME_SPEND_CAP": "CAMPAIGN_LIFETIME_SPEND_CAP",
                        "CAMPAIGN_NAME": "CAMPAIGN_NAME",
                        "CHECKOUT_ROAS": "CHECKOUT_ROAS",
                        "CLICKTHROUGH_1": "CLICKTHROUGH_1",
                        "CLICKTHROUGH_1_GROSS": "CLICKTHROUGH_1_GROSS",
                        "CLICKTHROUGH_2": "CLICKTHROUGH_2",
                        "CPC_IN_MICRO_DOLLAR": "CPC_IN_MICRO_DOLLAR",
                        "CPM_IN_DOLLAR": "CPM_IN_DOLLAR",
                        "CPM_IN_MICRO_DOLLAR": "CPM_IN_MICRO_DOLLAR",
                        "CTR": "CTR",
                        "CTR_2": "CTR_2",
                        "ECPCV_IN_DOLLAR": "ECPCV_IN_DOLLAR",
                        "ECPCV_P95_IN_DOLLAR": "ECPCV_P95_IN_DOLLAR",
                        "ECPC_IN_DOLLAR": "ECPC_IN_DOLLAR",
                        "ECPC_IN_MICRO_DOLLAR": "ECPC_IN_MICRO_DOLLAR",
                        "ECPE_IN_DOLLAR": "ECPE_IN_DOLLAR",
                        "ECPM_IN_MICRO_DOLLAR": "ECPM_IN_MICRO_DOLLAR",
                        "ECPV_IN_DOLLAR": "ECPV_IN_DOLLAR",
                        "ECTR": "ECTR",
                        "EENGAGEMENT_RATE": "EENGAGEMENT_RATE",
                        "ENGAGEMENT_1": "ENGAGEMENT_1",
                        "ENGAGEMENT_2": "ENGAGEMENT_2",
                        "ENGAGEMENT_RATE": "ENGAGEMENT_RATE",
                        "IDEA_PIN_PRODUCT_TAG_VISIT_1": "IDEA_PIN_PRODUCT_TAG_VISIT_1",
                        "IDEA_PIN_PRODUCT_TAG_VISIT_2": "IDEA_PIN_PRODUCT_TAG_VISIT_2",
                        "IMPRESSION_1": "IMPRESSION_1",
                        "IMPRESSION_1_GROSS": "IMPRESSION_1_GROSS",
                        "IMPRESSION_2": "IMPRESSION_2",
                        "INAPP_CHECKOUT_COST_PER_ACTION": "INAPP_CHECKOUT_COST_PER_ACTION",
                        "OUTBOUND_CLICK_1": "OUTBOUND_CLICK_1",
                        "OUTBOUND_CLICK_2": "OUTBOUND_CLICK_2",
                        "PAGE_VISIT_COST_PER_ACTION": "PAGE_VISIT_COST_PER_ACTION",
                        "PAGE_VISIT_ROAS": "PAGE_VISIT_ROAS",
                        "PAID_IMPRESSION": "PAID_IMPRESSION",
                        "PIN_ID": "PIN_ID",
                        "REPIN_1": "REPIN_1",
                        "REPIN_2": "REPIN_2",
                        "REPIN_RATE": "REPIN_RATE",
                        "SPEND_IN_DOLLAR": "SPEND_IN_DOLLAR",
                        "SPEND_IN_MICRO_DOLLAR": "SPEND_IN_MICRO_DOLLAR",
                        "TOTAL_CHECKOUT": "TOTAL_CHECKOUT",
                        "TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CLICKTHROUGH": "TOTAL_CLICKTHROUGH",
                        "TOTAL_CLICK_CHECKOUT": "TOTAL_CLICK_CHECKOUT",
                        "TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CLICK_LEAD": "TOTAL_CLICK_LEAD",
                        "TOTAL_CLICK_SIGNUP": "TOTAL_CLICK_SIGNUP",
                        "TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CONVERSIONS": "TOTAL_CONVERSIONS",
                        "TOTAL_CUSTOM": "TOTAL_CUSTOM",
                        "TOTAL_ENGAGEMENT": "TOTAL_ENGAGEMENT",
                        "TOTAL_ENGAGEMENT_CHECKOUT": "TOTAL_ENGAGEMENT_CHECKOUT",
                        "TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_ENGAGEMENT_LEAD": "TOTAL_ENGAGEMENT_LEAD",
                        "TOTAL_ENGAGEMENT_SIGNUP": "TOTAL_ENGAGEMENT_SIGNUP",
                        "TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT": "TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT",
                        "TOTAL_IMPRESSION_FREQUENCY": "TOTAL_IMPRESSION_FREQUENCY",
                        "TOTAL_IMPRESSION_USER": "TOTAL_IMPRESSION_USER",
                        "TOTAL_LEAD": "TOTAL_LEAD",
                        "TOTAL_PAGE_VISIT": "TOTAL_PAGE_VISIT",
                        "TOTAL_REPIN_RATE": "TOTAL_REPIN_RATE",
                        "TOTAL_SIGNUP": "TOTAL_SIGNUP",
                        "TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_VIDEO_3SEC_VIEWS": "TOTAL_VIDEO_3SEC_VIEWS",
                        "TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND": "TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND",
                        "TOTAL_VIDEO_MRC_VIEWS": "TOTAL_VIDEO_MRC_VIEWS",
                        "TOTAL_VIDEO_P0_COMBINED": "TOTAL_VIDEO_P0_COMBINED",
                        "TOTAL_VIDEO_P100_COMPLETE": "TOTAL_VIDEO_P100_COMPLETE",
                        "TOTAL_VIDEO_P25_COMBINED": "TOTAL_VIDEO_P25_COMBINED",
                        "TOTAL_VIDEO_P50_COMBINED": "TOTAL_VIDEO_P50_COMBINED",
                        "TOTAL_VIDEO_P75_COMBINED": "TOTAL_VIDEO_P75_COMBINED",
                        "TOTAL_VIDEO_P95_COMBINED": "TOTAL_VIDEO_P95_COMBINED",
                        "TOTAL_VIEW_CHECKOUT": "TOTAL_VIEW_CHECKOUT",
                        "TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_VIEW_LEAD": "TOTAL_VIEW_LEAD",
                        "TOTAL_VIEW_SIGNUP": "TOTAL_VIEW_SIGNUP",
                        "TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_CHECKOUT": "TOTAL_WEB_CHECKOUT",
                        "TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_CLICK_CHECKOUT": "TOTAL_WEB_CLICK_CHECKOUT",
                        "TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_ENGAGEMENT_CHECKOUT": "TOTAL_WEB_ENGAGEMENT_CHECKOUT",
                        "TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_VIEW_CHECKOUT": "TOTAL_WEB_VIEW_CHECKOUT",
                        "TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "VIDEO_3SEC_VIEWS_2": "VIDEO_3SEC_VIEWS_2",
                        "VIDEO_LENGTH": "VIDEO_LENGTH",
                        "VIDEO_MRC_VIEWS_2": "VIDEO_MRC_VIEWS_2",
                        "VIDEO_P0_COMBINED_2": "VIDEO_P0_COMBINED_2",
                        "VIDEO_P100_COMPLETE_2": "VIDEO_P100_COMPLETE_2",
                        "VIDEO_P25_COMBINED_2": "VIDEO_P25_COMBINED_2",
                        "VIDEO_P50_COMBINED_2": "VIDEO_P50_COMBINED_2",
                        "VIDEO_P75_COMBINED_2": "VIDEO_P75_COMBINED_2",
                        "VIDEO_P95_COMBINED_2": "VIDEO_P95_COMBINED_2",
                        "WEB_CHECKOUT_COST_PER_ACTION": "WEB_CHECKOUT_COST_PER_ACTION",
                        "WEB_CHECKOUT_ROAS": "WEB_CHECKOUT_ROAS"
                    },
                    ('click_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('engagement_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('view_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('conversion_report_time',): {

                        "AD_ACTION": "TIME_OF_AD_ACTION",
                        "CONVERSION": "TIME_OF_CONVERSION"
                    },
                },
                'openapi_types': {
                    'ad_account_id':
                        (str,),
                    'start_date':
                        (date,),
                    'end_date':
                        (date,),
                    'ad_ids':
                        ([str],),
                    'columns':
                        ([str],),
                    'granularity':
                        (Granularity,),
                    'click_window_days':
                        (int,),
                    'engagement_window_days':
                        (int,),
                    'view_window_days':
                        (int,),
                    'conversion_report_time':
                        (str,),
                },
                'attribute_map': {
                    'ad_account_id': 'ad_account_id',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'ad_ids': 'ad_ids',
                    'columns': 'columns',
                    'granularity': 'granularity',
                    'click_window_days': 'click_window_days',
                    'engagement_window_days': 'engagement_window_days',
                    'view_window_days': 'view_window_days',
                    'conversion_report_time': 'conversion_report_time',
                },
                'location_map': {
                    'ad_account_id': 'path',
                    'start_date': 'query',
                    'end_date': 'query',
                    'ad_ids': 'query',
                    'columns': 'query',
                    'granularity': 'query',
                    'click_window_days': 'query',
                    'engagement_window_days': 'query',
                    'view_window_days': 'query',
                    'conversion_report_time': 'query',
                },
                'collection_format_map': {
                    'ad_ids': 'multi',
                    'columns': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.ads_list_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/ad_accounts/{ad_account_id}/ads',
                'operation_id': 'ads_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ad_account_id',
                    'campaign_ids',
                    'ad_group_ids',
                    'ad_ids',
                    'entity_statuses',
                    'page_size',
                    'order',
                    'bookmark',
                ],
                'required': [
                    'ad_account_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'entity_statuses',
                    'order',
                ],
                'validation': [
                    'ad_account_id',
                    'campaign_ids',
                    'ad_group_ids',
                    'ad_ids',
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('ad_account_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('campaign_ids',): {

                        'max_items': 100,
                        'min_items': 1,
                    },
                    ('ad_group_ids',): {

                        'max_items': 100,
                        'min_items': 1,
                    },
                    ('ad_ids',): {

                        'max_items': 100,
                        'min_items': 1,
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('entity_statuses',): {

                        "ACTIVE": "ACTIVE",
                        "PAUSED": "PAUSED",
                        "ARCHIVED": "ARCHIVED"
                    },
                    ('order',): {

                        "ASCENDING": "ASCENDING",
                        "DESCENDING": "DESCENDING"
                    },
                },
                'openapi_types': {
                    'ad_account_id':
                        (str,),
                    'campaign_ids':
                        ([str],),
                    'ad_group_ids':
                        ([str],),
                    'ad_ids':
                        ([str],),
                    'entity_statuses':
                        ([str],),
                    'page_size':
                        (int,),
                    'order':
                        (str,),
                    'bookmark':
                        (str,),
                },
                'attribute_map': {
                    'ad_account_id': 'ad_account_id',
                    'campaign_ids': 'campaign_ids',
                    'ad_group_ids': 'ad_group_ids',
                    'ad_ids': 'ad_ids',
                    'entity_statuses': 'entity_statuses',
                    'page_size': 'page_size',
                    'order': 'order',
                    'bookmark': 'bookmark',
                },
                'location_map': {
                    'ad_account_id': 'path',
                    'campaign_ids': 'query',
                    'ad_group_ids': 'query',
                    'ad_ids': 'query',
                    'entity_statuses': 'query',
                    'page_size': 'query',
                    'order': 'query',
                    'bookmark': 'query',
                },
                'collection_format_map': {
                    'campaign_ids': 'multi',
                    'ad_group_ids': 'multi',
                    'ad_ids': 'multi',
                    'entity_statuses': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.analytics_create_report_endpoint = _Endpoint(
            settings={
                'response_type': (AdsAnalyticsCreateAsyncResponse,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/ad_accounts/{ad_account_id}/reports',
                'operation_id': 'analytics_create_report',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'ad_account_id',
                    'ads_analytics_create_async_request',
                ],
                'required': [
                    'ad_account_id',
                    'ads_analytics_create_async_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'ad_account_id',
                ]
            },
            root_map={
                'validations': {
                    ('ad_account_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ad_account_id':
                        (str,),
                    'ads_analytics_create_async_request':
                        (AdsAnalyticsCreateAsyncRequest,),
                },
                'attribute_map': {
                    'ad_account_id': 'ad_account_id',
                },
                'location_map': {
                    'ad_account_id': 'path',
                    'ads_analytics_create_async_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.analytics_get_report_endpoint = _Endpoint(
            settings={
                'response_type': (AdsAnalyticsGetAsyncResponse,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/ad_accounts/{ad_account_id}/reports',
                'operation_id': 'analytics_get_report',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ad_account_id',
                    'token',
                ],
                'required': [
                    'ad_account_id',
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'ad_account_id',
                ]
            },
            root_map={
                'validations': {
                    ('ad_account_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'ad_account_id':
                        (str,),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'ad_account_id': 'ad_account_id',
                    'token': 'token',
                },
                'location_map': {
                    'ad_account_id': 'path',
                    'token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.campaigns_analytics_endpoint = _Endpoint(
            settings={
                'response_type': (CampaignsAnalyticsResponse,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/ad_accounts/{ad_account_id}/campaigns/analytics',
                'operation_id': 'campaigns_analytics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ad_account_id',
                    'start_date',
                    'end_date',
                    'campaign_ids',
                    'columns',
                    'granularity',
                    'click_window_days',
                    'engagement_window_days',
                    'view_window_days',
                    'conversion_report_time',
                ],
                'required': [
                    'ad_account_id',
                    'start_date',
                    'end_date',
                    'campaign_ids',
                    'columns',
                    'granularity',
                ],
                'nullable': [
                ],
                'enum': [
                    'columns',
                    'click_window_days',
                    'engagement_window_days',
                    'view_window_days',
                    'conversion_report_time',
                ],
                'validation': [
                    'ad_account_id',
                    'campaign_ids',
                ]
            },
            root_map={
                'validations': {
                    ('ad_account_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('campaign_ids',): {

                        'max_items': 100,
                        'min_items': 1,
                    },
                },
                'allowed_values': {
                    ('columns',): {

                        "AD_ACCOUNT_ID": "AD_ACCOUNT_ID",
                        "AD_GROUP_ENTITY_STATUS": "AD_GROUP_ENTITY_STATUS",
                        "AD_GROUP_ID": "AD_GROUP_ID",
                        "AD_ID": "AD_ID",
                        "CAMPAIGN_DAILY_SPEND_CAP": "CAMPAIGN_DAILY_SPEND_CAP",
                        "CAMPAIGN_ENTITY_STATUS": "CAMPAIGN_ENTITY_STATUS",
                        "CAMPAIGN_ID": "CAMPAIGN_ID",
                        "CAMPAIGN_LIFETIME_SPEND_CAP": "CAMPAIGN_LIFETIME_SPEND_CAP",
                        "CAMPAIGN_NAME": "CAMPAIGN_NAME",
                        "CHECKOUT_ROAS": "CHECKOUT_ROAS",
                        "CLICKTHROUGH_1": "CLICKTHROUGH_1",
                        "CLICKTHROUGH_1_GROSS": "CLICKTHROUGH_1_GROSS",
                        "CLICKTHROUGH_2": "CLICKTHROUGH_2",
                        "CPC_IN_MICRO_DOLLAR": "CPC_IN_MICRO_DOLLAR",
                        "CPM_IN_DOLLAR": "CPM_IN_DOLLAR",
                        "CPM_IN_MICRO_DOLLAR": "CPM_IN_MICRO_DOLLAR",
                        "CTR": "CTR",
                        "CTR_2": "CTR_2",
                        "ECPCV_IN_DOLLAR": "ECPCV_IN_DOLLAR",
                        "ECPCV_P95_IN_DOLLAR": "ECPCV_P95_IN_DOLLAR",
                        "ECPC_IN_DOLLAR": "ECPC_IN_DOLLAR",
                        "ECPC_IN_MICRO_DOLLAR": "ECPC_IN_MICRO_DOLLAR",
                        "ECPE_IN_DOLLAR": "ECPE_IN_DOLLAR",
                        "ECPM_IN_MICRO_DOLLAR": "ECPM_IN_MICRO_DOLLAR",
                        "ECPV_IN_DOLLAR": "ECPV_IN_DOLLAR",
                        "ECTR": "ECTR",
                        "EENGAGEMENT_RATE": "EENGAGEMENT_RATE",
                        "ENGAGEMENT_1": "ENGAGEMENT_1",
                        "ENGAGEMENT_2": "ENGAGEMENT_2",
                        "ENGAGEMENT_RATE": "ENGAGEMENT_RATE",
                        "IDEA_PIN_PRODUCT_TAG_VISIT_1": "IDEA_PIN_PRODUCT_TAG_VISIT_1",
                        "IDEA_PIN_PRODUCT_TAG_VISIT_2": "IDEA_PIN_PRODUCT_TAG_VISIT_2",
                        "IMPRESSION_1": "IMPRESSION_1",
                        "IMPRESSION_1_GROSS": "IMPRESSION_1_GROSS",
                        "IMPRESSION_2": "IMPRESSION_2",
                        "INAPP_CHECKOUT_COST_PER_ACTION": "INAPP_CHECKOUT_COST_PER_ACTION",
                        "OUTBOUND_CLICK_1": "OUTBOUND_CLICK_1",
                        "OUTBOUND_CLICK_2": "OUTBOUND_CLICK_2",
                        "PAGE_VISIT_COST_PER_ACTION": "PAGE_VISIT_COST_PER_ACTION",
                        "PAGE_VISIT_ROAS": "PAGE_VISIT_ROAS",
                        "PAID_IMPRESSION": "PAID_IMPRESSION",
                        "PIN_ID": "PIN_ID",
                        "REPIN_1": "REPIN_1",
                        "REPIN_2": "REPIN_2",
                        "REPIN_RATE": "REPIN_RATE",
                        "SPEND_IN_DOLLAR": "SPEND_IN_DOLLAR",
                        "SPEND_IN_MICRO_DOLLAR": "SPEND_IN_MICRO_DOLLAR",
                        "TOTAL_CHECKOUT": "TOTAL_CHECKOUT",
                        "TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CLICKTHROUGH": "TOTAL_CLICKTHROUGH",
                        "TOTAL_CLICK_CHECKOUT": "TOTAL_CLICK_CHECKOUT",
                        "TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CLICK_LEAD": "TOTAL_CLICK_LEAD",
                        "TOTAL_CLICK_SIGNUP": "TOTAL_CLICK_SIGNUP",
                        "TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CONVERSIONS": "TOTAL_CONVERSIONS",
                        "TOTAL_CUSTOM": "TOTAL_CUSTOM",
                        "TOTAL_ENGAGEMENT": "TOTAL_ENGAGEMENT",
                        "TOTAL_ENGAGEMENT_CHECKOUT": "TOTAL_ENGAGEMENT_CHECKOUT",
                        "TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_ENGAGEMENT_LEAD": "TOTAL_ENGAGEMENT_LEAD",
                        "TOTAL_ENGAGEMENT_SIGNUP": "TOTAL_ENGAGEMENT_SIGNUP",
                        "TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT": "TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT",
                        "TOTAL_IMPRESSION_FREQUENCY": "TOTAL_IMPRESSION_FREQUENCY",
                        "TOTAL_IMPRESSION_USER": "TOTAL_IMPRESSION_USER",
                        "TOTAL_LEAD": "TOTAL_LEAD",
                        "TOTAL_PAGE_VISIT": "TOTAL_PAGE_VISIT",
                        "TOTAL_REPIN_RATE": "TOTAL_REPIN_RATE",
                        "TOTAL_SIGNUP": "TOTAL_SIGNUP",
                        "TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_VIDEO_3SEC_VIEWS": "TOTAL_VIDEO_3SEC_VIEWS",
                        "TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND": "TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND",
                        "TOTAL_VIDEO_MRC_VIEWS": "TOTAL_VIDEO_MRC_VIEWS",
                        "TOTAL_VIDEO_P0_COMBINED": "TOTAL_VIDEO_P0_COMBINED",
                        "TOTAL_VIDEO_P100_COMPLETE": "TOTAL_VIDEO_P100_COMPLETE",
                        "TOTAL_VIDEO_P25_COMBINED": "TOTAL_VIDEO_P25_COMBINED",
                        "TOTAL_VIDEO_P50_COMBINED": "TOTAL_VIDEO_P50_COMBINED",
                        "TOTAL_VIDEO_P75_COMBINED": "TOTAL_VIDEO_P75_COMBINED",
                        "TOTAL_VIDEO_P95_COMBINED": "TOTAL_VIDEO_P95_COMBINED",
                        "TOTAL_VIEW_CHECKOUT": "TOTAL_VIEW_CHECKOUT",
                        "TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_VIEW_LEAD": "TOTAL_VIEW_LEAD",
                        "TOTAL_VIEW_SIGNUP": "TOTAL_VIEW_SIGNUP",
                        "TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_CHECKOUT": "TOTAL_WEB_CHECKOUT",
                        "TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_CLICK_CHECKOUT": "TOTAL_WEB_CLICK_CHECKOUT",
                        "TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_ENGAGEMENT_CHECKOUT": "TOTAL_WEB_ENGAGEMENT_CHECKOUT",
                        "TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_VIEW_CHECKOUT": "TOTAL_WEB_VIEW_CHECKOUT",
                        "TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "VIDEO_3SEC_VIEWS_2": "VIDEO_3SEC_VIEWS_2",
                        "VIDEO_LENGTH": "VIDEO_LENGTH",
                        "VIDEO_MRC_VIEWS_2": "VIDEO_MRC_VIEWS_2",
                        "VIDEO_P0_COMBINED_2": "VIDEO_P0_COMBINED_2",
                        "VIDEO_P100_COMPLETE_2": "VIDEO_P100_COMPLETE_2",
                        "VIDEO_P25_COMBINED_2": "VIDEO_P25_COMBINED_2",
                        "VIDEO_P50_COMBINED_2": "VIDEO_P50_COMBINED_2",
                        "VIDEO_P75_COMBINED_2": "VIDEO_P75_COMBINED_2",
                        "VIDEO_P95_COMBINED_2": "VIDEO_P95_COMBINED_2",
                        "WEB_CHECKOUT_COST_PER_ACTION": "WEB_CHECKOUT_COST_PER_ACTION",
                        "WEB_CHECKOUT_ROAS": "WEB_CHECKOUT_ROAS"
                    },
                    ('click_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('engagement_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('view_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('conversion_report_time',): {

                        "AD_ACTION": "TIME_OF_AD_ACTION",
                        "CONVERSION": "TIME_OF_CONVERSION"
                    },
                },
                'openapi_types': {
                    'ad_account_id':
                        (str,),
                    'start_date':
                        (date,),
                    'end_date':
                        (date,),
                    'campaign_ids':
                        ([str],),
                    'columns':
                        ([str],),
                    'granularity':
                        (Granularity,),
                    'click_window_days':
                        (int,),
                    'engagement_window_days':
                        (int,),
                    'view_window_days':
                        (int,),
                    'conversion_report_time':
                        (str,),
                },
                'attribute_map': {
                    'ad_account_id': 'ad_account_id',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'campaign_ids': 'campaign_ids',
                    'columns': 'columns',
                    'granularity': 'granularity',
                    'click_window_days': 'click_window_days',
                    'engagement_window_days': 'engagement_window_days',
                    'view_window_days': 'view_window_days',
                    'conversion_report_time': 'conversion_report_time',
                },
                'location_map': {
                    'ad_account_id': 'path',
                    'start_date': 'query',
                    'end_date': 'query',
                    'campaign_ids': 'query',
                    'columns': 'query',
                    'granularity': 'query',
                    'click_window_days': 'query',
                    'engagement_window_days': 'query',
                    'view_window_days': 'query',
                    'conversion_report_time': 'query',
                },
                'collection_format_map': {
                    'campaign_ids': 'multi',
                    'columns': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.campaigns_list_endpoint = _Endpoint(
            settings={
                'response_type': (bool, date, datetime, dict, float, int, list, str, none_type,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/ad_accounts/{ad_account_id}/campaigns',
                'operation_id': 'campaigns_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ad_account_id',
                    'campaign_ids',
                    'entity_statuses',
                    'page_size',
                    'order',
                    'bookmark',
                ],
                'required': [
                    'ad_account_id',
                ],
                'nullable': [
                ],
                'enum': [
                    'entity_statuses',
                    'order',
                ],
                'validation': [
                    'ad_account_id',
                    'campaign_ids',
                    'page_size',
                ]
            },
            root_map={
                'validations': {
                    ('ad_account_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('campaign_ids',): {

                        'max_items': 100,
                        'min_items': 1,
                    },
                    ('page_size',): {

                        'inclusive_maximum': 100,
                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('entity_statuses',): {

                        "ACTIVE": "ACTIVE",
                        "PAUSED": "PAUSED",
                        "ARCHIVED": "ARCHIVED"
                    },
                    ('order',): {

                        "ASCENDING": "ASCENDING",
                        "DESCENDING": "DESCENDING"
                    },
                },
                'openapi_types': {
                    'ad_account_id':
                        (str,),
                    'campaign_ids':
                        ([str],),
                    'entity_statuses':
                        ([str],),
                    'page_size':
                        (int,),
                    'order':
                        (str,),
                    'bookmark':
                        (str,),
                },
                'attribute_map': {
                    'ad_account_id': 'ad_account_id',
                    'campaign_ids': 'campaign_ids',
                    'entity_statuses': 'entity_statuses',
                    'page_size': 'page_size',
                    'order': 'order',
                    'bookmark': 'bookmark',
                },
                'location_map': {
                    'ad_account_id': 'path',
                    'campaign_ids': 'query',
                    'entity_statuses': 'query',
                    'page_size': 'query',
                    'order': 'query',
                    'bookmark': 'query',
                },
                'collection_format_map': {
                    'campaign_ids': 'multi',
                    'entity_statuses': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.product_groups_analytics_endpoint = _Endpoint(
            settings={
                'response_type': (ProductGroupAnalyticsResponse,),
                'auth': [
                    'pinterest_oauth2'
                ],
                'endpoint_path': '/ad_accounts/{ad_account_id}/product_groups/analytics',
                'operation_id': 'product_groups_analytics',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'ad_account_id',
                    'start_date',
                    'end_date',
                    'product_group_ids',
                    'columns',
                    'granularity',
                    'click_window_days',
                    'engagement_window_days',
                    'view_window_days',
                    'conversion_report_time',
                ],
                'required': [
                    'ad_account_id',
                    'start_date',
                    'end_date',
                    'product_group_ids',
                    'columns',
                    'granularity',
                ],
                'nullable': [
                ],
                'enum': [
                    'columns',
                    'click_window_days',
                    'engagement_window_days',
                    'view_window_days',
                    'conversion_report_time',
                ],
                'validation': [
                    'ad_account_id',
                    'product_group_ids',
                ]
            },
            root_map={
                'validations': {
                    ('ad_account_id',): {

                        'regex': {
                            'pattern': r'^\d+$',  # noqa: E501
                        },
                    },
                    ('product_group_ids',): {

                        'max_items': 100,
                        'min_items': 1,
                    },
                },
                'allowed_values': {
                    ('columns',): {

                        "AD_ACCOUNT_ID": "AD_ACCOUNT_ID",
                        "AD_GROUP_ENTITY_STATUS": "AD_GROUP_ENTITY_STATUS",
                        "AD_GROUP_ID": "AD_GROUP_ID",
                        "AD_ID": "AD_ID",
                        "CAMPAIGN_DAILY_SPEND_CAP": "CAMPAIGN_DAILY_SPEND_CAP",
                        "CAMPAIGN_ENTITY_STATUS": "CAMPAIGN_ENTITY_STATUS",
                        "CAMPAIGN_ID": "CAMPAIGN_ID",
                        "CAMPAIGN_LIFETIME_SPEND_CAP": "CAMPAIGN_LIFETIME_SPEND_CAP",
                        "CAMPAIGN_NAME": "CAMPAIGN_NAME",
                        "CHECKOUT_ROAS": "CHECKOUT_ROAS",
                        "CLICKTHROUGH_1": "CLICKTHROUGH_1",
                        "CLICKTHROUGH_1_GROSS": "CLICKTHROUGH_1_GROSS",
                        "CLICKTHROUGH_2": "CLICKTHROUGH_2",
                        "CPC_IN_MICRO_DOLLAR": "CPC_IN_MICRO_DOLLAR",
                        "CPM_IN_DOLLAR": "CPM_IN_DOLLAR",
                        "CPM_IN_MICRO_DOLLAR": "CPM_IN_MICRO_DOLLAR",
                        "CTR": "CTR",
                        "CTR_2": "CTR_2",
                        "ECPCV_IN_DOLLAR": "ECPCV_IN_DOLLAR",
                        "ECPCV_P95_IN_DOLLAR": "ECPCV_P95_IN_DOLLAR",
                        "ECPC_IN_DOLLAR": "ECPC_IN_DOLLAR",
                        "ECPC_IN_MICRO_DOLLAR": "ECPC_IN_MICRO_DOLLAR",
                        "ECPE_IN_DOLLAR": "ECPE_IN_DOLLAR",
                        "ECPM_IN_MICRO_DOLLAR": "ECPM_IN_MICRO_DOLLAR",
                        "ECPV_IN_DOLLAR": "ECPV_IN_DOLLAR",
                        "ECTR": "ECTR",
                        "EENGAGEMENT_RATE": "EENGAGEMENT_RATE",
                        "ENGAGEMENT_1": "ENGAGEMENT_1",
                        "ENGAGEMENT_2": "ENGAGEMENT_2",
                        "ENGAGEMENT_RATE": "ENGAGEMENT_RATE",
                        "IDEA_PIN_PRODUCT_TAG_VISIT_1": "IDEA_PIN_PRODUCT_TAG_VISIT_1",
                        "IDEA_PIN_PRODUCT_TAG_VISIT_2": "IDEA_PIN_PRODUCT_TAG_VISIT_2",
                        "IMPRESSION_1": "IMPRESSION_1",
                        "IMPRESSION_1_GROSS": "IMPRESSION_1_GROSS",
                        "IMPRESSION_2": "IMPRESSION_2",
                        "INAPP_CHECKOUT_COST_PER_ACTION": "INAPP_CHECKOUT_COST_PER_ACTION",
                        "OUTBOUND_CLICK_1": "OUTBOUND_CLICK_1",
                        "OUTBOUND_CLICK_2": "OUTBOUND_CLICK_2",
                        "PAGE_VISIT_COST_PER_ACTION": "PAGE_VISIT_COST_PER_ACTION",
                        "PAGE_VISIT_ROAS": "PAGE_VISIT_ROAS",
                        "PAID_IMPRESSION": "PAID_IMPRESSION",
                        "PIN_ID": "PIN_ID",
                        "REPIN_1": "REPIN_1",
                        "REPIN_2": "REPIN_2",
                        "REPIN_RATE": "REPIN_RATE",
                        "SPEND_IN_DOLLAR": "SPEND_IN_DOLLAR",
                        "SPEND_IN_MICRO_DOLLAR": "SPEND_IN_MICRO_DOLLAR",
                        "TOTAL_CHECKOUT": "TOTAL_CHECKOUT",
                        "TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CLICKTHROUGH": "TOTAL_CLICKTHROUGH",
                        "TOTAL_CLICK_CHECKOUT": "TOTAL_CLICK_CHECKOUT",
                        "TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CLICK_LEAD": "TOTAL_CLICK_LEAD",
                        "TOTAL_CLICK_SIGNUP": "TOTAL_CLICK_SIGNUP",
                        "TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_CONVERSIONS": "TOTAL_CONVERSIONS",
                        "TOTAL_CUSTOM": "TOTAL_CUSTOM",
                        "TOTAL_ENGAGEMENT": "TOTAL_ENGAGEMENT",
                        "TOTAL_ENGAGEMENT_CHECKOUT": "TOTAL_ENGAGEMENT_CHECKOUT",
                        "TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_ENGAGEMENT_LEAD": "TOTAL_ENGAGEMENT_LEAD",
                        "TOTAL_ENGAGEMENT_SIGNUP": "TOTAL_ENGAGEMENT_SIGNUP",
                        "TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT": "TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT",
                        "TOTAL_IMPRESSION_FREQUENCY": "TOTAL_IMPRESSION_FREQUENCY",
                        "TOTAL_IMPRESSION_USER": "TOTAL_IMPRESSION_USER",
                        "TOTAL_LEAD": "TOTAL_LEAD",
                        "TOTAL_PAGE_VISIT": "TOTAL_PAGE_VISIT",
                        "TOTAL_REPIN_RATE": "TOTAL_REPIN_RATE",
                        "TOTAL_SIGNUP": "TOTAL_SIGNUP",
                        "TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_VIDEO_3SEC_VIEWS": "TOTAL_VIDEO_3SEC_VIEWS",
                        "TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND": "TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND",
                        "TOTAL_VIDEO_MRC_VIEWS": "TOTAL_VIDEO_MRC_VIEWS",
                        "TOTAL_VIDEO_P0_COMBINED": "TOTAL_VIDEO_P0_COMBINED",
                        "TOTAL_VIDEO_P100_COMPLETE": "TOTAL_VIDEO_P100_COMPLETE",
                        "TOTAL_VIDEO_P25_COMBINED": "TOTAL_VIDEO_P25_COMBINED",
                        "TOTAL_VIDEO_P50_COMBINED": "TOTAL_VIDEO_P50_COMBINED",
                        "TOTAL_VIDEO_P75_COMBINED": "TOTAL_VIDEO_P75_COMBINED",
                        "TOTAL_VIDEO_P95_COMBINED": "TOTAL_VIDEO_P95_COMBINED",
                        "TOTAL_VIEW_CHECKOUT": "TOTAL_VIEW_CHECKOUT",
                        "TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_VIEW_LEAD": "TOTAL_VIEW_LEAD",
                        "TOTAL_VIEW_SIGNUP": "TOTAL_VIEW_SIGNUP",
                        "TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR": "TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_CHECKOUT": "TOTAL_WEB_CHECKOUT",
                        "TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_CLICK_CHECKOUT": "TOTAL_WEB_CLICK_CHECKOUT",
                        "TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_ENGAGEMENT_CHECKOUT": "TOTAL_WEB_ENGAGEMENT_CHECKOUT",
                        "TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "TOTAL_WEB_VIEW_CHECKOUT": "TOTAL_WEB_VIEW_CHECKOUT",
                        "TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR": "TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR",
                        "VIDEO_3SEC_VIEWS_2": "VIDEO_3SEC_VIEWS_2",
                        "VIDEO_LENGTH": "VIDEO_LENGTH",
                        "VIDEO_MRC_VIEWS_2": "VIDEO_MRC_VIEWS_2",
                        "VIDEO_P0_COMBINED_2": "VIDEO_P0_COMBINED_2",
                        "VIDEO_P100_COMPLETE_2": "VIDEO_P100_COMPLETE_2",
                        "VIDEO_P25_COMBINED_2": "VIDEO_P25_COMBINED_2",
                        "VIDEO_P50_COMBINED_2": "VIDEO_P50_COMBINED_2",
                        "VIDEO_P75_COMBINED_2": "VIDEO_P75_COMBINED_2",
                        "VIDEO_P95_COMBINED_2": "VIDEO_P95_COMBINED_2",
                        "WEB_CHECKOUT_COST_PER_ACTION": "WEB_CHECKOUT_COST_PER_ACTION",
                        "WEB_CHECKOUT_ROAS": "WEB_CHECKOUT_ROAS"
                    },
                    ('click_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('engagement_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('view_window_days',): {

                        "1": 1,
                        "7": 7,
                        "30": 30,
                        "60": 60
                    },
                    ('conversion_report_time',): {

                        "AD_ACTION": "TIME_OF_AD_ACTION",
                        "CONVERSION": "TIME_OF_CONVERSION"
                    },
                },
                'openapi_types': {
                    'ad_account_id':
                        (str,),
                    'start_date':
                        (date,),
                    'end_date':
                        (date,),
                    'product_group_ids':
                        ([str],),
                    'columns':
                        ([str],),
                    'granularity':
                        (Granularity,),
                    'click_window_days':
                        (int,),
                    'engagement_window_days':
                        (int,),
                    'view_window_days':
                        (int,),
                    'conversion_report_time':
                        (str,),
                },
                'attribute_map': {
                    'ad_account_id': 'ad_account_id',
                    'start_date': 'start_date',
                    'end_date': 'end_date',
                    'product_group_ids': 'product_group_ids',
                    'columns': 'columns',
                    'granularity': 'granularity',
                    'click_window_days': 'click_window_days',
                    'engagement_window_days': 'engagement_window_days',
                    'view_window_days': 'view_window_days',
                    'conversion_report_time': 'conversion_report_time',
                },
                'location_map': {
                    'ad_account_id': 'path',
                    'start_date': 'query',
                    'end_date': 'query',
                    'product_group_ids': 'query',
                    'columns': 'query',
                    'granularity': 'query',
                    'click_window_days': 'query',
                    'engagement_window_days': 'query',
                    'view_window_days': 'query',
                    'conversion_report_time': 'query',
                },
                'collection_format_map': {
                    'product_group_ids': 'multi',
                    'columns': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def ad_account_analytics(
        self,
        ad_account_id,
        start_date,
        end_date,
        columns,
        granularity,
        **kwargs
    ):
        """Get ad account analytics  # noqa: E501

        Get analytics for the specified <code>ad_account_id</code>, filtered by the specified options. - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a>: Admin, Analyst, Campaign Manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ad_account_analytics(ad_account_id, start_date, end_date, columns, granularity, async_req=True)
        >>> result = thread.get()

        Args:
            ad_account_id (str): Unique identifier of an ad account.
            start_date (date): Metric report start date (UTC). Format: YYYY-MM-DD
            end_date (date): Metric report end date (UTC). Format: YYYY-MM-DD
            columns ([str]): Columns to retrieve. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
            granularity (Granularity): Granularity

        Keyword Args:
            click_window_days (int): Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30
            engagement_window_days (int): Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30
            view_window_days (int): Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.. [optional] if omitted the server will use the default value of 1
            conversion_report_time (str): The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.. [optional] if omitted the server will use the default value of "TIME_OF_AD_ACTION"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AdAccountAnalyticsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['ad_account_id'] = \
            ad_account_id
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['columns'] = \
            columns
        kwargs['granularity'] = \
            granularity
        return self.ad_account_analytics_endpoint.call_with_http_info(**kwargs)

    def ad_accounts_list(
        self,
        **kwargs
    ):
        """List ad accounts  # noqa: E501

        Get a list of the ad_accounts that the \"operation user_account\" has access to. - This includes ad_accounts they own and ad_accounts that are owned by others who have granted them <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ad_accounts_list(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            bookmark (str): Cursor used to fetch the next page of items. [optional]
            page_size (int): Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/api/v5/#tag/Pagination'>Pagination</a> for more information.. [optional] if omitted the server will use the default value of 25
            include_shared_accounts (bool): Include shared ad accounts. [optional] if omitted the server will use the default value of True
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        return self.ad_accounts_list_endpoint.call_with_http_info(**kwargs)

    def ad_groups_analytics(
        self,
        ad_account_id,
        start_date,
        end_date,
        ad_group_ids,
        columns,
        granularity,
        **kwargs
    ):
        """Get ad group analytics  # noqa: E501

        Get analytics for the specified ad groups in the specified <code>ad_account_id</code>, filtered by the specified options. - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a>: Admin, Analyst, Campaign Manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ad_groups_analytics(ad_account_id, start_date, end_date, ad_group_ids, columns, granularity, async_req=True)
        >>> result = thread.get()

        Args:
            ad_account_id (str): Unique identifier of an ad account.
            start_date (date): Metric report start date (UTC). Format: YYYY-MM-DD
            end_date (date): Metric report end date (UTC). Format: YYYY-MM-DD
            ad_group_ids ([str]): List of Ad group Ids to use to filter the results.
            columns ([str]): Columns to retrieve. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
            granularity (Granularity): Granularity

        Keyword Args:
            click_window_days (int): Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30
            engagement_window_days (int): Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30
            view_window_days (int): Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.. [optional] if omitted the server will use the default value of 1
            conversion_report_time (str): The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.. [optional] if omitted the server will use the default value of "TIME_OF_AD_ACTION"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AdGroupsAnalyticsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['ad_account_id'] = \
            ad_account_id
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['ad_group_ids'] = \
            ad_group_ids
        kwargs['columns'] = \
            columns
        kwargs['granularity'] = \
            granularity
        return self.ad_groups_analytics_endpoint.call_with_http_info(**kwargs)

    def ad_groups_list(
        self,
        ad_account_id,
        **kwargs
    ):
        """List ad groups  # noqa: E501

        Get a list of the ad groups in the specified <code>ad_account_id</code>, filtered by the specified options. - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a>: Admin, Analyst, Campaign Manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ad_groups_list(ad_account_id, async_req=True)
        >>> result = thread.get()

        Args:
            ad_account_id (str): Unique identifier of an ad account.

        Keyword Args:
            campaign_ids ([str]): List of Campaign Ids to use to filter the results.. [optional]
            ad_group_ids ([str]): List of Ad group Ids to use to filter the results.. [optional]
            entity_statuses ([str]): Entity status. [optional]
            page_size (int): Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/api/v5/#tag/Pagination'>Pagination</a> for more information.. [optional] if omitted the server will use the default value of 25
            order (str): The order in which to sort the items returned: “ASCENDING” or “DESCENDING” by ID. Note that higher-value IDs are associated with more-recently added items.. [optional]
            bookmark (str): Cursor used to fetch the next page of items. [optional]
            translate_interests_to_names (bool): Return interests as text names (if value is true) rather than topic IDs.. [optional] if omitted the server will use the default value of False
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['ad_account_id'] = \
            ad_account_id
        return self.ad_groups_list_endpoint.call_with_http_info(**kwargs)

    def ads_analytics(
        self,
        ad_account_id,
        start_date,
        end_date,
        ad_ids,
        columns,
        granularity,
        **kwargs
    ):
        """Get ad analytics  # noqa: E501

        Get analytics for the specified ads in the specified <code>ad_account_id</code>, filtered by the specified options. - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a>: Admin, Analyst, Campaign Manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ads_analytics(ad_account_id, start_date, end_date, ad_ids, columns, granularity, async_req=True)
        >>> result = thread.get()

        Args:
            ad_account_id (str): Unique identifier of an ad account.
            start_date (date): Metric report start date (UTC). Format: YYYY-MM-DD
            end_date (date): Metric report end date (UTC). Format: YYYY-MM-DD
            ad_ids ([str]): List of Ad Ids to use to filter the results.
            columns ([str]): Columns to retrieve. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
            granularity (Granularity): Granularity

        Keyword Args:
            click_window_days (int): Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30
            engagement_window_days (int): Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30
            view_window_days (int): Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.. [optional] if omitted the server will use the default value of 1
            conversion_report_time (str): The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.. [optional] if omitted the server will use the default value of "TIME_OF_AD_ACTION"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AdsAnalyticsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['ad_account_id'] = \
            ad_account_id
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['ad_ids'] = \
            ad_ids
        kwargs['columns'] = \
            columns
        kwargs['granularity'] = \
            granularity
        return self.ads_analytics_endpoint.call_with_http_info(**kwargs)

    def ads_list(
        self,
        ad_account_id,
        **kwargs
    ):
        """List ads  # noqa: E501

        Get a list of the ads in the specified <code>ad_account_id</code>, filtered by the specified options. - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a>: Admin, Analyst, Campaign Manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.ads_list(ad_account_id, async_req=True)
        >>> result = thread.get()

        Args:
            ad_account_id (str): Unique identifier of an ad account.

        Keyword Args:
            campaign_ids ([str]): List of Campaign Ids to use to filter the results.. [optional]
            ad_group_ids ([str]): List of Ad group Ids to use to filter the results.. [optional]
            ad_ids ([str]): List of Ad Ids to use to filter the results.. [optional]
            entity_statuses ([str]): Entity status. [optional]
            page_size (int): Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/api/v5/#tag/Pagination'>Pagination</a> for more information.. [optional] if omitted the server will use the default value of 25
            order (str): The order in which to sort the items returned: “ASCENDING” or “DESCENDING” by ID. Note that higher-value IDs are associated with more-recently added items.. [optional]
            bookmark (str): Cursor used to fetch the next page of items. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['ad_account_id'] = \
            ad_account_id
        return self.ads_list_endpoint.call_with_http_info(**kwargs)

    def analytics_create_report(
        self,
        ad_account_id,
        ads_analytics_create_async_request,
        **kwargs
    ):
        """Create async request for an account analytics report  # noqa: E501

        This returns a token that you can use to download the report when it is ready. Note that this endpoint requires the parameters to be passed as JSON-formatted in the request body. This endpoint does not support URL query parameters. - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a>: Admin, Analyst, Campaign Manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.analytics_create_report(ad_account_id, ads_analytics_create_async_request, async_req=True)
        >>> result = thread.get()

        Args:
            ad_account_id (str): Unique identifier of an ad account.
            ads_analytics_create_async_request (AdsAnalyticsCreateAsyncRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AdsAnalyticsCreateAsyncResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['ad_account_id'] = \
            ad_account_id
        kwargs['ads_analytics_create_async_request'] = \
            ads_analytics_create_async_request
        return self.analytics_create_report_endpoint.call_with_http_info(**kwargs)

    def analytics_get_report(
        self,
        ad_account_id,
        token,
        **kwargs
    ):
        """Get the account analytics report created by the async call  # noqa: E501

        This returns a URL to an analytics report given a token returned from the post request report creation call. You can use the URL to download the report and it's valid for an hour. - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a>: Admin, Analyst, Campaign Manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.analytics_get_report(ad_account_id, token, async_req=True)
        >>> result = thread.get()

        Args:
            ad_account_id (str): Unique identifier of an ad account.
            token (str): Token returned from the post request creation call

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            AdsAnalyticsGetAsyncResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['ad_account_id'] = \
            ad_account_id
        kwargs['token'] = \
            token
        return self.analytics_get_report_endpoint.call_with_http_info(**kwargs)

    def campaigns_analytics(
        self,
        ad_account_id,
        start_date,
        end_date,
        campaign_ids,
        columns,
        granularity,
        **kwargs
    ):
        """Get campaign analytics  # noqa: E501

        Get analytics for the specified campaigns in the specified <code>ad_account_id</code>, filtered by the specified options. - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a>: Admin, Analyst, Campaign Manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.campaigns_analytics(ad_account_id, start_date, end_date, campaign_ids, columns, granularity, async_req=True)
        >>> result = thread.get()

        Args:
            ad_account_id (str): Unique identifier of an ad account.
            start_date (date): Metric report start date (UTC). Format: YYYY-MM-DD
            end_date (date): Metric report end date (UTC). Format: YYYY-MM-DD
            campaign_ids ([str]): List of Campaign Ids to use to filter the results.
            columns ([str]): Columns to retrieve. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
            granularity (Granularity): Granularity

        Keyword Args:
            click_window_days (int): Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30
            engagement_window_days (int): Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30
            view_window_days (int): Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.. [optional] if omitted the server will use the default value of 1
            conversion_report_time (str): The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.. [optional] if omitted the server will use the default value of "TIME_OF_AD_ACTION"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            CampaignsAnalyticsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['ad_account_id'] = \
            ad_account_id
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['campaign_ids'] = \
            campaign_ids
        kwargs['columns'] = \
            columns
        kwargs['granularity'] = \
            granularity
        return self.campaigns_analytics_endpoint.call_with_http_info(**kwargs)

    def campaigns_list(
        self,
        ad_account_id,
        **kwargs
    ):
        """List campaigns  # noqa: E501

        Get a list of the campaigns in the specified <code>ad_account_id</code>, filtered by the specified options. - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a>: Admin, Analyst, Campaign Manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.campaigns_list(ad_account_id, async_req=True)
        >>> result = thread.get()

        Args:
            ad_account_id (str): Unique identifier of an ad account.

        Keyword Args:
            campaign_ids ([str]): List of Campaign Ids to use to filter the results.. [optional]
            entity_statuses ([str]): Entity status. [optional]
            page_size (int): Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/api/v5/#tag/Pagination'>Pagination</a> for more information.. [optional] if omitted the server will use the default value of 25
            order (str): The order in which to sort the items returned: “ASCENDING” or “DESCENDING” by ID. Note that higher-value IDs are associated with more-recently added items.. [optional]
            bookmark (str): Cursor used to fetch the next page of items. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            bool, date, datetime, dict, float, int, list, str, none_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['ad_account_id'] = \
            ad_account_id
        return self.campaigns_list_endpoint.call_with_http_info(**kwargs)

    def product_groups_analytics(
        self,
        ad_account_id,
        start_date,
        end_date,
        product_group_ids,
        columns,
        granularity,
        **kwargs
    ):
        """Get product group analytics  # noqa: E501

        Get analytics for the specified product groups in the specified <code>ad_account_id</code>, filtered by the specified options. - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href=\"https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts\">Business Access</a>: Admin, Analyst, Campaign Manager.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.product_groups_analytics(ad_account_id, start_date, end_date, product_group_ids, columns, granularity, async_req=True)
        >>> result = thread.get()

        Args:
            ad_account_id (str): Unique identifier of an ad account.
            start_date (date): Metric report start date (UTC). Format: YYYY-MM-DD
            end_date (date): Metric report end date (UTC). Format: YYYY-MM-DD
            product_group_ids ([str]): List of Product group Ids to use to filter the results.
            columns ([str]): Columns to retrieve. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
            granularity (Granularity): Granularity

        Keyword Args:
            click_window_days (int): Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30
            engagement_window_days (int): Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.. [optional] if omitted the server will use the default value of 30
            view_window_days (int): Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.. [optional] if omitted the server will use the default value of 1
            conversion_report_time (str): The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.. [optional] if omitted the server will use the default value of "TIME_OF_AD_ACTION"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            ProductGroupAnalyticsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['ad_account_id'] = \
            ad_account_id
        kwargs['start_date'] = \
            start_date
        kwargs['end_date'] = \
            end_date
        kwargs['product_group_ids'] = \
            product_group_ids
        kwargs['columns'] = \
            columns
        kwargs['granularity'] = \
            granularity
        return self.product_groups_analytics_endpoint.call_with_http_info(**kwargs)

