# Generated by Django 2.2.14 on 2020-07-30 02:58

from django.db import migrations

def fix_waterfall_status_from_vetted_status(apps, schema_editor):
    Observation = apps.get_model('base', 'Observation')
    observations_without_waterfall = Observation.objects.filter(waterfall='')
    for observation in observations_without_waterfall:
        observation.waterfall_status = None
        observation.save()

    observations_with_waterfall = Observation.objects.exclude(waterfall='')
    for observation in observations_with_waterfall:
        if observation.vetted_status == 'unknown':
            observation.waterfall_status = None
        elif observation.vetted_status == 'good':
            observation.waterfall_status = True
        elif observation.vetted_status == 'bad':
            observation.waterfall_status = False
        elif observation.vetted_status == 'failed':
            observation.waterfall_status = False
        observation.save()

def reverse_fix_waterfall_status_from_vetted_status(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0077_rename_observations_status_to_status'),
    ]

    operations = [
        migrations.RunPython(fix_waterfall_status_from_vetted_status, reverse_fix_waterfall_status_from_vetted_status),
    ]
