# Generated by Django 2.2.14 on 2020-07-21 23:22

from django.db import migrations, models

def vetted_status_to_waterfall_status(apps, schema_editor):
    Observation = apps.get_model('base', 'Observation')
    observations = Observation.objects.filter(waterfall='')
    for observation in observations:
        if observation.vetted_status == 'unknown':
            observation.waterfall_status = None
        elif observation.vetted_status == 'good':
            observation.waterfall_status = True
        elif observation.vetted_status == 'bad':
            observation.waterfall_status = False
        elif observation.vetted_status == 'failed':
            observation.waterfall_status = False
        observation.save()

def reverse_vetted_status_to_waterfall_status(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('base', '0073_add_observation_status'),
    ]

    operations = [
        migrations.AddField(
            model_name='observation',
            name='waterfall_status',
            field=models.BooleanField(blank=True, default=None, null=True),
        ),
        migrations.RunPython(vetted_status_to_waterfall_status, reverse_vetted_status_to_waterfall_status),
    ]
