# Generated by Django 2.2.14 on 2020-07-21 22:45

from django.db import migrations, models

def vetted_status_to_observation_status(apps, schema_editor):
    Observation = apps.get_model('base', 'Observation')
    observations = Observation.objects.all()
    for observation in observations:
        if observation.vetted_status == 'unknown':
            observation.observation_status = 0
        elif observation.vetted_status == 'good':
            observation.observation_status = 100
        elif observation.vetted_status == 'bad':
            observation.observation_status = -100
        elif observation.vetted_status == 'failed':
            observation.observation_status = -1000
        observation.save()

def reverse_vetted_status_to_observation_status(apps, schema_editor):
    pass

class Migration(migrations.Migration):

    dependencies = [
        ('base', '0072_change_station_antennas_related_name'),
    ]

    operations = [
        migrations.AddField(
            model_name='observation',
            name='observation_status',
            field=models.SmallIntegerField(default=0),
        ),
        migrations.RunPython(vetted_status_to_observation_status, reverse_vetted_status_to_observation_status),
    ]
