/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.transformer.at;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.spongepowered.server.launch.transformer.at.AccessModifier;
import org.spongepowered.server.launch.transformer.at.AccessTransformers;
import org.spongepowered.server.launch.transformer.at.ClassAccessModifiers;

public final class AccessTransformer
implements IClassTransformer {
    private final ImmutableMap<String, ClassAccessModifiers> modifiers = AccessTransformers.build();

    @Nullable
    public byte[] transform(String name, String transformedName, @Nullable byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassAccessModifiers modifiers = (ClassAccessModifiers)this.modifiers.get((Object)transformedName);
        if (modifiers == null) {
            return bytes;
        }
        ClassReader reader = new ClassReader(bytes);
        ClassWriter writer = new ClassWriter(reader, 0);
        reader.accept(new AccessTransformingClassAdapter(writer, modifiers), 0);
        return writer.toByteArray();
    }

    private static class AccessTransformingMethodAdapter
    extends MethodVisitor {
        private final AccessTransformingClassAdapter owner;

        public AccessTransformingMethodAdapter(MethodVisitor mv, AccessTransformingClassAdapter owner) {
            super(327680, mv);
            this.owner = owner;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            AccessModifier modifier;
            if (!itf && opcode == 183 && owner.equals(this.owner.name) && !name.equals("<init>") && (modifier = this.owner.modifiers.getMethod(name, desc)) != null && modifier.hasAccessChange()) {
                opcode = 182;
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private static class AccessTransformingClassAdapter
    extends ClassVisitor {
        private final ClassAccessModifiers modifiers;
        @Nullable
        private String name;

        public AccessTransformingClassAdapter(ClassVisitor cv, ClassAccessModifiers modifiers) {
            super(327680, cv);
            this.modifiers = modifiers;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
            if (this.modifiers.modifier != null) {
                access = this.modifiers.modifier.apply(access);
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            AccessModifier modifier = this.modifiers.getField(name);
            if (modifier != null) {
                access = modifier.apply(access);
            }
            return super.visitField(access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            AccessModifier modifier = this.modifiers.getMethod(name, desc);
            if (modifier != null) {
                access = modifier.apply(access);
            }
            return new AccessTransformingMethodAdapter(super.visitMethod(access, name, desc, signature, exceptions), this);
        }
    }
}

