/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import joptsimple.HelpFormatter;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public final class VanillaCommandLine {
    private static final OptionParser parser = new OptionParser();
    public static final OptionSpec<Void> HELP = parser.acceptsAll(Arrays.asList("help", "h", "?"), "Show this help text").forHelp();
    public static final OptionSpec<Void> VERSION = parser.acceptsAll(Arrays.asList("version", "v"), "Display the SpongeVanilla version");
    public static final OptionSpec<Void> NO_DOWNLOAD = parser.accepts("no-download", "Do not auto-download required dependencies");
    public static final OptionSpec<Void> NO_VERIFY_CLASSPATH = parser.accepts("no-verify-classpath", "Don't check the classpath for required dependencies");
    public static final OptionSpec<Void> NO_REDIRECT_STDOUT = parser.accepts("no-redirect-stdout", "Don't redirect standard output to the logger");
    public static final OptionSpec<String> TWEAK_CLASS = parser.accepts("tweakClass", "Tweak classes to load").withRequiredArg();
    public static final OptionSpec<String> ACCESS_TRANSFORMER = parser.accepts("at", "Additional access transformer files to apply").withRequiredArg();
    public static final OptionSpec<Void> SCAN_CLASSPATH = parser.accepts("scan-classpath", "Scan class directories in classpath for plugins");
    public static final OptionSpec<Void> SCAN_FULL_CLASSPATH = parser.accepts("scan-full-classpath", "Scan full classpath for plugins");
    public static final OptionSpec<Integer> PORT = parser.acceptsAll(Arrays.asList("port", "p"), "The port to launch the server on").withRequiredArg().ofType(Integer.class);
    public static final OptionSpec<File> WORLD_DIR = parser.accepts("universe", "The directory to store the world(s) in").withRequiredArg().ofType(File.class);
    public static final OptionSpec<String> WORLD_NAME = parser.acceptsAll(Arrays.asList("world", "w"), "The name of the main world for the server").withRequiredArg();
    public static final OptionSpec<Void> BONUS_CHEST = parser.accepts("bonusChest", "Spawn a bonus chest in the generated world");
    private static Optional<OptionSet> options = Optional.empty();

    private VanillaCommandLine() {
    }

    public static Optional<OptionSet> getOptions() {
        return options;
    }

    public static List<String> getUnrecognizedOptions() {
        return VanillaCommandLine.getOptions().get().nonOptionArguments();
    }

    public static OptionSet parse(String ... args) {
        if (options.isPresent()) {
            return options.get();
        }
        OptionSet parsed = parser.parse(args);
        options = Optional.of(parsed);
        return parsed;
    }

    public static OptionSet parse(Collection<String> args) {
        if (options.isPresent()) {
            return options.get();
        }
        OptionSet parsed = parser.parse(args.toArray(new String[args.size()]));
        options = Optional.of(parsed);
        return parsed;
    }

    public static void printHelp(OutputStream out) throws IOException {
        parser.printHelpOn(out);
    }

    public static void printHelp(HelpFormatter formatter, OutputStream out) throws IOException {
        parser.formatHelpWith(formatter);
        VanillaCommandLine.printHelp(out);
    }

    static {
        parser.accepts("mixin", "Additional Mixin configs to load").withRequiredArg();
        parser.allowsUnrecognizedOptions();
    }
}

